/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.security.code.img.config;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import org.shoulder.code.propertities.BaseValidateCodeProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(prefix="shoulder.security.validate-code.image")
public class ImageCodeProperties
extends BaseValidateCodeProperties {
    @Min(value=1L)
    private @Min(value=1L) int width = 120;
    @Min(value=1L)
    private @Min(value=1L) int height = 40;
    @NotEmpty
    private List<String> fonts = Arrays.asList("\u65b9\u6b63\u8212\u4f53", "\u534e\u6587\u5f69\u4e91", "\u534e\u6587\u7425\u73c0", "\u534e\u6587\u65b0\u9b4f", "\u5e7c\u5706", "\u5fae\u8f6f\u96c5\u9ed1", "\u6977\u4f53", "Agency FB", "Bradley Hand ITC", "Copperplate Gothic Light");

    ImageCodeProperties() {
        this.setLength(4);
        this.setParameterName("imageCode");
        LinkedList<String> defaultValidateUrls = new LinkedList<String>();
        defaultValidateUrls.add("/authentication/form");
        this.setUrls(defaultValidateUrls);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public List<String> getFonts() {
        return this.fonts;
    }

    public void setFonts(List<String> fonts) {
        this.fonts = fonts;
    }
}

