/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.security.code.sms;

import javax.servlet.ServletRequest;
import org.shoulder.code.dto.ValidateCodeDTO;
import org.shoulder.code.exception.ValidateCodeException;
import org.shoulder.code.generator.ValidateCodeGenerator;
import org.shoulder.code.processor.AbstractValidateCodeProcessor;
import org.shoulder.code.propertities.BaseValidateCodeProperties;
import org.shoulder.code.store.ValidateCodeStore;
import org.shoulder.security.code.sms.SmsCodeSender;
import org.shoulder.security.code.sms.SmsValidateCodeType;
import org.springframework.web.bind.ServletRequestUtils;
import org.springframework.web.context.request.ServletWebRequest;

public class SmsCodeProcessor
extends AbstractValidateCodeProcessor<ValidateCodeDTO>
implements SmsValidateCodeType {
    private final SmsCodeSender smsCodeSender;

    public SmsCodeProcessor(BaseValidateCodeProperties baseValidateCodeProperties, ValidateCodeGenerator validateCodeGenerator, ValidateCodeStore validateCodeStore, SmsCodeSender smsCodeSender) {
        super(baseValidateCodeProperties, validateCodeGenerator, validateCodeStore);
        this.smsCodeSender = smsCodeSender;
    }

    protected boolean isPostOnly() {
        return true;
    }

    public void send(ServletWebRequest request, ValidateCodeDTO validateCode) throws ValidateCodeException {
        try {
            String mobile = ServletRequestUtils.getRequiredStringParameter((ServletRequest)request.getRequest(), (String)"phoneNumber");
            this.smsCodeSender.send(mobile, validateCode.getCode());
        }
        catch (Exception e) {
            throw new ValidateCodeException("send smsCode fail", (Throwable)e);
        }
    }
}

