/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.delay.redis;

import cn.jdevelops.delay.core.entity.DelayQueueMessage;
import cn.jdevelops.delay.core.service.DelayService;
import cn.jdevelops.delay.redis.RedisDelayService;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.support.ResourceScriptSource;

@Configuration
public class EnableAutoRedisDelay {
    @ConditionalOnMissingBean(name={"delayRedisScript"})
    @Bean
    public DefaultRedisScript<List> delayRedisScript() {
        DefaultRedisScript defaultRedisScript = new DefaultRedisScript();
        defaultRedisScript.setResultType(List.class);
        defaultRedisScript.setScriptSource((ScriptSource)new ResourceScriptSource((Resource)new ClassPathResource("lua/delay.lua")));
        return defaultRedisScript;
    }

    @ConditionalOnMissingBean(name={"delayService"})
    @Bean
    public DelayService<DelayQueueMessage> delayService() {
        return new RedisDelayService();
    }
}

