/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.encryption.core;

import cn.jdevelops.encryption.util.RemarkUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class Base64Decoder {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final byte PADDING = -2;
    private static final byte[] DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, 62, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -2, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, 63, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};

    public static String decodeStr(CharSequence source) {
        return Base64Decoder.decodeStr(source, DEFAULT_CHARSET);
    }

    public static String decodeStr(CharSequence source, Charset charset) {
        return RemarkUtil.str(Base64Decoder.decode(source), charset);
    }

    public static byte[] decode(CharSequence source) {
        return Base64Decoder.decode(RemarkUtil.bytes(source, DEFAULT_CHARSET));
    }

    public static byte[] decode(byte[] in) {
        if (RemarkUtil.isEmpty(in)) {
            return in;
        }
        return Base64Decoder.decode(in, 0, in.length);
    }

    public static byte[] decode(byte[] in, int pos, int length) {
        if (RemarkUtil.isEmpty(in)) {
            return in;
        }
        IntWrapper offset = new IntWrapper(pos);
        int maxPos = pos + length - 1;
        int octetId = 0;
        byte[] octet = new byte[length * 3 / 4];
        while (offset.value <= maxPos) {
            byte sestet0 = Base64Decoder.getNextValidDecodeByte(in, offset, maxPos);
            byte sestet1 = Base64Decoder.getNextValidDecodeByte(in, offset, maxPos);
            byte sestet2 = Base64Decoder.getNextValidDecodeByte(in, offset, maxPos);
            byte sestet3 = Base64Decoder.getNextValidDecodeByte(in, offset, maxPos);
            if (-2 != sestet1) {
                octet[octetId++] = (byte)(sestet0 << 2 | sestet1 >>> 4);
            }
            if (-2 != sestet2) {
                octet[octetId++] = (byte)((sestet1 & 0xF) << 4 | sestet2 >>> 2);
            }
            if (-2 == sestet3) continue;
            octet[octetId++] = (byte)((sestet2 & 3) << 6 | sestet3);
        }
        if (octetId == octet.length) {
            return octet;
        }
        return (byte[])RemarkUtil.copy(octet, new byte[octetId], octetId);
    }

    private static byte getNextValidDecodeByte(byte[] in, IntWrapper pos, int maxPos) {
        while (pos.value <= maxPos) {
            byte decodeByte;
            byte base64Byte;
            if ((base64Byte = in[pos.value++]) <= -1 || (decodeByte = DECODE_TABLE[base64Byte]) <= -1) continue;
            return decodeByte;
        }
        return -2;
    }

    private static class IntWrapper {
        int value;

        IntWrapper(int value) {
            this.value = value;
        }
    }
}

