/*
 * Decompiled with CFR 0.152.
 */
package cn.jrack.action.core.aop;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.jrack.action.core.annotations.ActionLog;
import cn.jrack.action.core.entity.ActionLogEntity;
import cn.jrack.action.core.enums.ActionTypeEnum;
import cn.jrack.action.core.service.ActionLogFrameworkService;
import cn.jrack.core.exception.enums.GlobalErrorCodeConstants;
import cn.jrack.core.util.json.JsonUtil;
import cn.jrack.core.util.servlet.ServletUtil;
import cn.jrack.springboot.web.core.response.Result;
import cn.jrack.springboot.web.core.util.WebFrameworkUtils;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;

@Aspect
public class ActionLogAspect {
    private static final Logger log = LoggerFactory.getLogger(ActionLogAspect.class);
    private static final ThreadLocal<String> CONTENT = new ThreadLocal();
    private static final ThreadLocal<Map<String, Object>> EXTS = new ThreadLocal();
    @Resource
    private ActionLogFrameworkService actionLogFrameworkService;

    @Around(value="@annotation(apiOperation)")
    public Object around(ProceedingJoinPoint joinPoint, ApiOperation apiOperation) throws Throwable {
        ActionLog actionLog = ActionLogAspect.getMethodAnnotation(joinPoint, ActionLog.class);
        return this.around0(joinPoint, actionLog, apiOperation);
    }

    @Around(value="!@annotation(io.swagger.annotations.ApiOperation) && @annotation(actionLog)")
    public Object around(ProceedingJoinPoint joinPoint, ActionLog actionLog) throws Throwable {
        return this.around0(joinPoint, actionLog, null);
    }

    private Object around0(ProceedingJoinPoint joinPoint, ActionLog actionLog, ApiOperation apiOperation) throws Throwable {
        Date startTime = new Date();
        try {
            Object result = joinPoint.proceed();
            this.log(joinPoint, actionLog, apiOperation, startTime, result, null);
            Object object = result;
            return object;
        }
        catch (Throwable exception) {
            this.log(joinPoint, actionLog, apiOperation, startTime, null, exception);
            throw exception;
        }
        finally {
            ActionLogAspect.clearThreadLocal();
        }
    }

    public static void setContent(String content) {
        CONTENT.set(content);
    }

    public static void addExt(String key, Object value) {
        if (EXTS.get() == null) {
            EXTS.set(new HashMap());
        }
        EXTS.get().put(key, value);
    }

    private static void clearThreadLocal() {
        CONTENT.remove();
        EXTS.remove();
    }

    private void log(ProceedingJoinPoint joinPoint, ActionLog actionLog, ApiOperation apiOperation, Date startTime, Object result, Throwable exception) {
        try {
            if (!ActionLogAspect.isLogEnable(joinPoint, actionLog)) {
                return;
            }
            this.log0(joinPoint, actionLog, apiOperation, startTime, result, exception);
        }
        catch (Throwable ex) {
            log.error("[log][\u8bb0\u5f55\u64cd\u4f5c\u65e5\u5fd7\u65f6\uff0c\u53d1\u751f\u5f02\u5e38\uff0c\u5176\u4e2d\u53c2\u6570\u662f joinPoint({}) operateLog({}) apiOperation({}) result({}) exception({}) ]", new Object[]{joinPoint, actionLog, apiOperation, result, exception, ex});
        }
    }

    private void log0(ProceedingJoinPoint joinPoint, ActionLog actionLog, ApiOperation apiOperation, Date startTime, Object result, Throwable exception) {
        ActionLogEntity actionLogEntity = new ActionLogEntity();
        actionLogEntity.setStartTime(startTime);
        String userId = "";
        try {
            userId = WebFrameworkUtils.getLoginUserId().toString();
        }
        catch (Exception exception2) {
            // empty catch block
        }
        actionLogEntity.setUserId(userId);
        ActionLogAspect.fillUserFields(actionLogEntity);
        ActionLogAspect.fillModuleFields(actionLogEntity, joinPoint, actionLog, apiOperation);
        ActionLogAspect.fillRequestFields(actionLogEntity);
        ActionLogAspect.fillMethodFields(actionLogEntity, joinPoint, actionLog, startTime, result, exception);
        this.actionLogFrameworkService.createOperateLog(actionLogEntity);
    }

    private static void fillUserFields(ActionLogEntity actionLogEntity) {
    }

    private static void fillModuleFields(ActionLogEntity actionLogEntity, ProceedingJoinPoint joinPoint, ActionLog operateLog, ApiOperation apiOperation) {
        Api api;
        if (operateLog != null) {
            actionLogEntity.setModule(operateLog.module());
        }
        if (StrUtil.isEmpty((CharSequence)actionLogEntity.getModule()) && (api = ActionLogAspect.getClassAnnotation(joinPoint, Api.class)) != null) {
            if (StrUtil.isNotEmpty((CharSequence)api.value())) {
                actionLogEntity.setModule(api.value());
            }
            if (StrUtil.isEmpty((CharSequence)actionLogEntity.getModule()) && ArrayUtil.isNotEmpty((Object[])api.tags())) {
                actionLogEntity.setModule(api.tags()[0]);
            }
        }
        if (operateLog != null) {
            actionLogEntity.setName(operateLog.name());
        }
        if (StrUtil.isEmpty((CharSequence)actionLogEntity.getName()) && apiOperation != null) {
            actionLogEntity.setName(apiOperation.value());
        }
        if (operateLog != null && ArrayUtil.isNotEmpty((Object[])operateLog.type())) {
            actionLogEntity.setType(operateLog.type()[0].getType());
        }
        if (actionLogEntity.getType() == null) {
            RequestMethod requestMethod = ActionLogAspect.obtainFirstMatchRequestMethod(ActionLogAspect.obtainRequestMethod(joinPoint));
            ActionTypeEnum actionTypeEnum = ActionLogAspect.convertOperateLogType(requestMethod);
            actionLogEntity.setType(actionTypeEnum != null ? actionTypeEnum.getType() : null);
        }
        actionLogEntity.setContent(CONTENT.get());
        actionLogEntity.setExts(EXTS.get());
    }

    private static void fillRequestFields(ActionLogEntity operateLogObj) {
        HttpServletRequest request = ServletUtil.getRequest();
        if (request == null) {
            return;
        }
        operateLogObj.setRequestMethod(request.getMethod());
        operateLogObj.setRequestUrl(request.getRequestURI());
        operateLogObj.setUserIp(ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]));
        operateLogObj.setUserAgent(ServletUtil.getUserAgent((HttpServletRequest)request));
    }

    private static void fillMethodFields(ActionLogEntity actionLogEntity, ProceedingJoinPoint joinPoint, ActionLog operateLog, Date startTime, Object result, Throwable exception) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        actionLogEntity.setJavaMethod(methodSignature.toString());
        if (operateLog == null || operateLog.logArgs()) {
            actionLogEntity.setJavaMethodArgs(ActionLogAspect.obtainMethodArgs(joinPoint));
        }
        if (operateLog == null || operateLog.logResultData()) {
            actionLogEntity.setResultData(ActionLogAspect.obtainResultData(result));
        }
        actionLogEntity.setDuration((int)(System.currentTimeMillis() - startTime.getTime()));
        if (result instanceof Result) {
            Result commonResult = (Result)result;
            actionLogEntity.setResultCode(commonResult.getCode());
            actionLogEntity.setResultMsg(commonResult.getMsg());
        } else {
            actionLogEntity.setResultCode(GlobalErrorCodeConstants.SUCCESS.getCode());
        }
        if (exception != null) {
            actionLogEntity.setResultCode(GlobalErrorCodeConstants.INTERNAL_SERVER_ERROR.getCode());
            actionLogEntity.setResultMsg(ExceptionUtil.getRootCauseMessage((Throwable)exception));
        }
    }

    private static boolean isLogEnable(ProceedingJoinPoint joinPoint, ActionLog actionLog) {
        if (actionLog != null) {
            return actionLog.enable();
        }
        return ActionLogAspect.obtainFirstLogRequestMethod(ActionLogAspect.obtainRequestMethod(joinPoint)) != null;
    }

    private static RequestMethod obtainFirstLogRequestMethod(RequestMethod[] requestMethods) {
        if (ArrayUtil.isEmpty((Object[])requestMethods)) {
            return null;
        }
        return Arrays.stream(requestMethods).filter(requestMethod -> requestMethod == RequestMethod.POST || requestMethod == RequestMethod.PUT || requestMethod == RequestMethod.DELETE).findFirst().orElse(null);
    }

    private static RequestMethod obtainFirstMatchRequestMethod(RequestMethod[] requestMethods) {
        if (ArrayUtil.isEmpty((Object[])requestMethods)) {
            return null;
        }
        RequestMethod result = ActionLogAspect.obtainFirstLogRequestMethod(requestMethods);
        if (result != null) {
            return result;
        }
        result = Arrays.stream(requestMethods).filter(requestMethod -> requestMethod == RequestMethod.GET).findFirst().orElse(null);
        if (result != null) {
            return result;
        }
        return requestMethods[0];
    }

    private static ActionTypeEnum convertOperateLogType(RequestMethod requestMethod) {
        if (requestMethod == null) {
            return null;
        }
        switch (requestMethod) {
            case GET: {
                return ActionTypeEnum.GET;
            }
            case POST: {
                return ActionTypeEnum.CREATE;
            }
            case PUT: {
                return ActionTypeEnum.UPDATE;
            }
            case DELETE: {
                return ActionTypeEnum.DELETE;
            }
        }
        return ActionTypeEnum.OTHER;
    }

    private static RequestMethod[] obtainRequestMethod(ProceedingJoinPoint joinPoint) {
        RequestMapping requestMapping = (RequestMapping)AnnotationUtils.getAnnotation((Method)((MethodSignature)joinPoint.getSignature()).getMethod(), RequestMapping.class);
        return requestMapping != null ? requestMapping.method() : new RequestMethod[]{};
    }

    private static <T extends Annotation> T getMethodAnnotation(ProceedingJoinPoint joinPoint, Class<T> annotationClass) {
        return ((MethodSignature)joinPoint.getSignature()).getMethod().getAnnotation(annotationClass);
    }

    private static <T extends Annotation> T getClassAnnotation(ProceedingJoinPoint joinPoint, Class<T> annotationClass) {
        return ((MethodSignature)joinPoint.getSignature()).getMethod().getDeclaringClass().getAnnotation(annotationClass);
    }

    private static String obtainMethodArgs(ProceedingJoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        String[] argNames = methodSignature.getParameterNames();
        Object[] argValues = joinPoint.getArgs();
        HashMap args = Maps.newHashMapWithExpectedSize((int)argValues.length);
        for (int i = 0; i < argNames.length; ++i) {
            String argName = argNames[i];
            Object argValue = argValues[i];
            args.put(argName, !ActionLogAspect.isIgnoreArgs(argValue) ? argValue : "[ignore]");
        }
        return JsonUtil.toJsonString((Object)args);
    }

    private static String obtainResultData(Object result) {
        if (result instanceof Result) {
            result = ((Result)result).getData();
        }
        return JsonUtil.toJsonString((Object)result);
    }

    private static boolean isIgnoreArgs(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            return IntStream.range(0, Array.getLength(object)).anyMatch(index -> ActionLogAspect.isIgnoreArgs(Array.get(object, index)));
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return ((Collection)object).stream().anyMatch(ActionLogAspect::isIgnoreArgs);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return ActionLogAspect.isIgnoreArgs(((Map)object).values());
        }
        return object instanceof MultipartFile || object instanceof HttpServletRequest || object instanceof HttpServletResponse || object instanceof BindingResult;
    }
}

