/**
 * 版权所有(C) 晓祥工作室 2010-2020<br>
 * Copyright 2010-2020 XiaoXiang Workroom.<br>
 * 创建日期 2014-11-24
 */
package bee.cloud.cache;

import java.util.Timer;
import java.util.TimerTask;

import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

import bee.cloud.cache.Cache;
import bee.tool.log.Log;

/**
 * 功能说明：
 * 
 * @author chenxiang 2014-11-24
 */
public class TestCache
{
    static final long start = System.currentTimeMillis();
    static class UcacheThread implements Runnable
    {
        @Override
        public void run()
        {
         // TODO Auto-generated method stub
            for (int i = 0; i < 100; i++)
            {
                String tk = "" + System.currentTimeMillis() + ":" + i;
                UCache cache = UCache.instence(tk);
                // Cache cache = CacheManage.getCache("login");
                cache.set(tk, tk);
                // cache.expire("aa" + i, 50 * 1000);
                Log.info(tk + " is " + cache.exists(tk));
                Log.info(tk + "=" + cache.get(tk));
                // Log.info(cache.incr("incr"));
                Log.info("used:" + (System.currentTimeMillis() - start));
            }
        }
    }

    public static void testUcache()
    {
        Log.info("ok");
        UCache.init("login");
        // cache.get("aa1");
        // Log.info("sdf");
        // Log.info(cache.get("incr"));

        final long start = System.currentTimeMillis();

        for (int i = 0; i < 100; i++)
        {
//            new Timer().schedule(new TimerTask()
//            {
//                @Override
//                public void run()
//                {
//                    // TODO Auto-generated method stub
//                    for (int i = 0; i < 100; i++)
//                    {
//                        String tk = "" + System.currentTimeMillis() + ":" + i;
//                        UCache cache = UCache.instence(tk);
//                        // Cache cache = CacheManage.getCache("login");
//                        cache.set(tk, tk);
//                        // cache.expire("aa" + i, 50 * 1000);
//                        Log.info(tk + " is " + cache.exists(tk));
//                        Log.info(tk + "=" + cache.get(tk));
//                        // Log.info(cache.incr("incr"));
//                        Log.info("used:" + (System.currentTimeMillis() - start));
//                    }
//                }
//            }, 0, 1);
            Thread t1 = new Thread(new UcacheThread());
            t1.start();
        }

        Log.info("ok:" + (System.currentTimeMillis() - start));
    }

    public static void threadTest()
    {
        Log.info("ok");
        final Cache cache = CacheManage.getCache("kaoqin");
        cache.get("aa1");
        Log.info("sdf");
        Log.info(cache.get("incr"));

        final long start = System.currentTimeMillis();

        for (int i = 0; i < 100; i++)
        {
            new Timer().schedule(new TimerTask()
            {
                @Override
                public void run()
                {
                    // TODO Auto-generated method stub
                    for (int i = 0; i < 100; i++)
                    {
                        Cache cache = CacheManage.getCache("kaoqin");
                        cache.set("aa" + i, "" + i);
                        cache.expire("aa" + i, 50 * 1000);
                        Log.info("aa" + i + " is " + cache.exists("aa" + i));
                        Log.info("aa" + i + "=" + cache.get("aa" + i));
                        Log.info(cache.incr("incr"));
                        Log.info("used:" + (System.currentTimeMillis() - start));
                    }
                }
            }, 0, 60 * 1000 * 3);
        }

        Log.info("ok:" + (System.currentTimeMillis() - start));
    }

    public static void main(String[] args)
    {
        // threadTest();
        testUcache();
    }
}
