/*
 * Decompiled with CFR 0.152.
 */
package cn.m1c.frame.exception;

public abstract class M1CBaseRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = -7307961667791435686L;

    public M1CBaseRuntimeException(String message) {
        super(message);
    }

    public M1CBaseRuntimeException(String message, Throwable cause) {
        super(message, cause);
    }

    @Override
    public String getMessage() {
        return M1CBaseRuntimeException.buildMessage(super.getMessage(), this.getCause());
    }

    public static String buildMessage(String message, Throwable cause) {
        if (cause != null) {
            StringBuilder sb = new StringBuilder();
            if (message != null) {
                sb.append(message).append("; ");
            }
            sb.append("base exception is ").append(cause);
            return sb.toString();
        }
        return message;
    }

    public Throwable getRootCause() {
        Throwable rootCause = null;
        for (Throwable cause = this.getCause(); cause != null && cause != rootCause; cause = cause.getCause()) {
            rootCause = cause;
        }
        return rootCause == null ? this : rootCause;
    }

    public boolean contains(Class<?> exceptionClass) {
        if (exceptionClass == null) {
            return false;
        }
        if (exceptionClass.isInstance(this)) {
            return true;
        }
        Throwable cause = this.getCause();
        if (cause == this) {
            return false;
        }
        if (cause instanceof M1CBaseRuntimeException) {
            return ((M1CBaseRuntimeException)cause).contains(exceptionClass);
        }
        while (cause != null) {
            if (exceptionClass.isInstance(cause)) {
                return true;
            }
            if (cause.getCause() == cause) break;
            cause = cause.getCause();
        }
        return false;
    }
}

