/*
 * Decompiled with CFR 0.152.
 */
package cn.m1c.frame.mongodb;

import cn.m1c.frame.mongodb.OrderBean;
import cn.m1c.frame.page.PageM1C;
import cn.m1c.frame.utils.CollectionUtil;
import cn.m1c.frame.utils.StringUtil;
import com.mongodb.DBCollection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public abstract class MongoDaoUtil {
    public static final String REGEX_LIKE = "^.*%s.*$";

    public static void bindPaging(Class<?> entityName, MongoOperations mongoOperations, Query query, PageM1C page) {
        if (page == null) {
            return;
        }
        if (page.getTotalCount() == 0) {
            page.setTotalCount((int)mongoOperations.count(query, entityName));
        }
        query.skip(page.getStartNum()).limit(page.getPageSize());
    }

    public static void bindPaging(DBCollection dbCollection, MongoOperations mongoOperations, Query query, PageM1C page) {
        if (page == null) {
            return;
        }
        if (page.getTotalCount() == 0) {
            page.setTotalCount((int)dbCollection.getCount(query.getQueryObject()));
        }
        query.skip(page.getStartNum()).limit(page.getPageSize());
    }

    public static void bindOrders(Query query, OrderBean orderBean) {
        if (orderBean == null) {
            return;
        }
        LinkedHashMap<String, Boolean> ov = orderBean.getOrderValue();
        for (Map.Entry<String, Boolean> o : ov.entrySet()) {
            query.with(new Sort(o.getValue() != false ? Sort.Direction.ASC : Sort.Direction.DESC, new String[]{o.getKey()}));
        }
    }

    public static void bindFields(Query query, String fields) {
        if (StringUtil.hasLengthBytrim(fields) && !"*".equals(fields)) {
            String[] fs;
            for (String f : fs = fields.split(",")) {
                query.fields().include(f);
            }
        }
    }

    public static void bindFields(Query query, Set<String> fields) {
        if (CollectionUtil.isEmpty(fields) || "*".equals(fields.iterator().next())) {
            return;
        }
        for (String f : fields) {
            query.fields().include(f);
        }
    }

    public static void bindExcludeFields(Query query, Set<String> fields) {
        if (CollectionUtil.notEmpty(fields)) {
            for (String f : fields) {
                query.fields().exclude(f);
            }
        }
    }

    public static void bindUpdateFieldValue(Update update, Map<String, Object> values) {
        if (values == null || values.size() == 0) {
            return;
        }
        for (Map.Entry<String, Object> value : values.entrySet()) {
            update.set(value.getKey(), value.getValue());
        }
    }

    public static String regex(String name) {
        return String.format(REGEX_LIKE, name);
    }

    public static Query parseQuery(String id, Object value) {
        Criteria critera = Criteria.where((String)id).is(value);
        Query query = Query.query((CriteriaDefinition)critera);
        return query;
    }
}

