/*
 * Decompiled with CFR 0.152.
 */
package cn.m1c.frame.mongodb;

import cn.m1c.frame.mongodb.OrderBean;
import cn.m1c.frame.page.PageM1C;
import cn.m1c.frame.utils.CollectionUtil;
import cn.m1c.frame.utils.StringUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public class MongoDbUtil {
    public static Update toUpdate(Map<String, Object> values) {
        Update update = new Update();
        for (Map.Entry<String, Object> value : values.entrySet()) {
            update.set(value.getKey(), value.getValue());
        }
        return update;
    }

    public static void bindPaging(Class<?> entityName, MongoOperations mongoOperations, Query query, PageM1C page) {
        if (page == null) {
            return;
        }
        if (page.getTotalCount() == 0) {
            page.setTotalCount((int)mongoOperations.count(query, entityName));
        }
        query.skip(page.getStartNum()).limit(page.getPageSize());
    }

    public static void bindOrders(Query query, OrderBean orderBean) {
        if (orderBean == null) {
            return;
        }
        LinkedHashMap<String, Boolean> ov = orderBean.getOrderValue();
        for (Map.Entry<String, Boolean> o : ov.entrySet()) {
            query.with(new Sort(o.getValue() != false ? Sort.Direction.ASC : Sort.Direction.DESC, new String[]{o.getKey()}));
        }
    }

    public static void bindFields(Query query, String fields) {
        if (StringUtil.hasLengthBytrim(fields)) {
            String[] fs;
            for (String f : fs = fields.split("\\*")) {
                query.fields().include(f);
            }
        }
    }

    public static void bindFields(Query query, Set<String> fields) {
        if (CollectionUtil.isEmpty(fields) || "*".equals(fields.iterator().next())) {
            return;
        }
        for (String f : fields) {
            query.fields().include(f);
        }
    }
}

