/*
 * Decompiled with CFR 0.152.
 */
package cn.m1c.frame.utils;

import cn.m1c.frame.constants.StatusCode;
import cn.m1c.frame.exception.M1CRuntimeException;
import cn.m1c.frame.utils.CollectionUtil;
import cn.m1c.frame.utils.StringUtil;
import java.util.Collection;
import java.util.Map;

public class AssertUtil {
    public static void fail(StatusCode statusCode, String defaultMessage) {
        throw new M1CRuntimeException(statusCode, defaultMessage);
    }

    public static void hasLength(String text, StatusCode statusCode) {
        AssertUtil.hasLength(text, statusCode, null);
    }

    public static void hasLength(String text, StatusCode statusCode, String defaultMessage) {
        if (!StringUtil.hasLength(text)) {
            AssertUtil.fail(statusCode, defaultMessage);
        }
    }

    public static void hasLengthByTrim(String text, StatusCode statusCode) {
        if (text == null || text.trim().length() == 0) {
            AssertUtil.fail(statusCode, null);
        }
    }

    public static void hasLengthByTrim(String text, StatusCode statusCode, String defaultMessage) {
        if (text == null || text.trim().length() == 0) {
            AssertUtil.fail(statusCode, defaultMessage);
        }
    }

    public static void hasErrors(boolean expression, StatusCode statusCode) {
        if (expression) {
            AssertUtil.fail(statusCode, null);
        }
    }

    public static void hasErrors(boolean expression, StatusCode statusCode, String defaultMessage) {
        if (expression) {
            AssertUtil.fail(statusCode, defaultMessage);
        }
    }

    public static void isTrue(boolean expression, StatusCode statusCode) {
        if (!expression) {
            AssertUtil.fail(statusCode, null);
        }
    }

    public static void isTrue(boolean expression, StatusCode statusCode, String defaultMessage) {
        if (!expression) {
            AssertUtil.fail(statusCode, defaultMessage);
        }
    }

    public static void isFalse(boolean expression, StatusCode statusCode) {
        AssertUtil.isTrue(!expression, statusCode);
    }

    public static void isFalse(boolean expression, StatusCode statusCode, String defaultMessage) {
        AssertUtil.isTrue(!expression, statusCode, defaultMessage);
    }

    public static void isNotNull(Object object, StatusCode statusCode) {
        if (object == null) {
            AssertUtil.fail(statusCode, null);
        }
    }

    public static void isNull(Object object, StatusCode statusCode) {
        if (object != null) {
            AssertUtil.fail(statusCode, null);
        }
    }

    public static void isNull(Object object, StatusCode statusCode, String defaultMessage) {
        if (object != null) {
            AssertUtil.fail(statusCode, defaultMessage);
        }
    }

    public static void notNull(Object object, StatusCode statusCode) {
        if (object == null) {
            AssertUtil.fail(statusCode, null);
        }
    }

    public static void notNull(Object object, StatusCode statusCode, String defaultMessage) {
        if (object == null) {
            AssertUtil.fail(statusCode, defaultMessage);
        }
    }

    public static void notEmpty(Object[] array, StatusCode statusCode) {
        if (array == null || array.length == 0) {
            AssertUtil.fail(statusCode, null);
        }
    }

    public static void notEmpty(Collection<?> collection, StatusCode statusCode) {
        if (CollectionUtil.isEmpty(collection)) {
            AssertUtil.fail(statusCode, null);
        }
    }

    public static void notEmpty(Collection<?> collection, StatusCode statusCode, String defaultMessage) {
        if (CollectionUtil.isEmpty(collection)) {
            AssertUtil.fail(statusCode, defaultMessage);
        }
    }

    public static void notEmpty(Map<?, ?> map, StatusCode statusCode) {
        if (CollectionUtil.isEmpty(map)) {
            AssertUtil.fail(statusCode, null);
        }
    }

    public static void notEmpty(Map<?, ?> map, StatusCode statusCode, String defaultMessage) {
        if (CollectionUtil.isEmpty(map)) {
            AssertUtil.fail(statusCode, defaultMessage);
        }
    }

    public static void validate(boolean expression, StatusCode statusCode) {
        if (!expression) {
            AssertUtil.fail(statusCode, null);
        }
    }

    public static void validate(boolean expression, StatusCode statusCode, String defaultMessage) {
        if (!expression) {
            AssertUtil.fail(statusCode, defaultMessage);
        }
    }

    public static void regex(String text, String regex, StatusCode statusCode) {
        boolean result = text.matches(regex);
        AssertUtil.isTrue(result, statusCode);
    }

    public static void regex(String text, String regex, StatusCode statusCode, String defaultMessage) {
        boolean result = text.matches(regex);
        AssertUtil.isTrue(result, statusCode, defaultMessage);
    }
}

