/*
 * Decompiled with CFR 0.152.
 */
package cn.m1c.frame.utils;

import cn.m1c.frame.utils.StringUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;

public class DateUtil {
    public static final String PATTERN_YYYY_MM_DD = "yyyy-MM-dd";
    public static final String PATTERN_YYYY_MM_DD_P = "yyyy.MM.dd";
    public static final String PATTERN_YYYYMMDD = "yyyyMMdd";
    public static final String PATTERN_YYYYMMDD_X = "yyyy/MM/dd";
    public static final String PATTERN_MM_DD = "MM-dd";
    public static final String PATTERN_MM_DD_HH_MM = "MM-dd HH:mm";
    public static final String PATTERN_UNIT_YYYY_MM_DD = "yyyy\u5e74-MM\u6708-dd\u65e5";
    public static final String PATTERN_NEW_YYYY_MM_DD = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String PATTERN_UNIT_MM_DD = "MM\u6708-dd\u65e5";
    public static final String PATTERN_UNIT_MMDD = "MM\u6708dd\u65e5";
    public static final String PATTERN_YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String PATTERN_YYYY_MM_DD_HH_MM_SS_P = "yyyy.MM.dd HH:mm:ss";
    public static final String PATTERN_HH_MM_SS = "HH:mm:ss";
    public static final String PATTERN_HH_MM = "HH:mm";
    public static final String PATTERN_YYYY_MM_DD_HH_MM = "yyyy-MM-dd HH:mm";
    public static final String PATTERN_YYYY_MM_DD_HH = "yyyy-MM-dd HH";
    public static final String PATTERN_YYYYMMDDHHMMSSSSS = "yyyyMMddHHmmssSSS";
    public static final long UNIT_SECOND_TIME = 1000L;
    public static final long UNIT_MINUS_TIME = 60000L;
    public static final long UNIT_HOUR_TIME = 3600000L;
    public static final long UNIT_DAY_TIME = 86400000L;
    public static final String UNIT_SECOND_NAME = "\u79d2";
    public static final String UNIT_MINUS_NAME = "\u5206\u949f";
    public static final String UNIT_HOUR_NAME = "\u5c0f\u65f6";
    public static final String UNIT_DAY_NAME = "\u5929";
    public static final String PATTERN_MM_DD_HH = "MM\u6708dd\u65e5HH\u70b9";
    private static Calendar fromCal = Calendar.getInstance();

    public static boolean isValidDate(String source, String pattern) {
        boolean convertSuccess = true;
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        try {
            format.setLenient(false);
            format.parse(source);
        }
        catch (ParseException e) {
            convertSuccess = false;
        }
        return convertSuccess;
    }

    public static Date parse(String source, String pattern) throws ParseException {
        if (source == null || StringUtil.isEmpty(source)) {
            return null;
        }
        if (pattern == null) {
            pattern = PATTERN_YYYY_MM_DD_HH_MM_SS;
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.parse(source);
    }

    public static String format(Date source, String pattern) {
        if (source == null) {
            return null;
        }
        if (pattern == null) {
            pattern = PATTERN_YYYY_MM_DD_HH_MM_SS;
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(source);
    }

    public static String formatToDay(Date source) {
        return DateUtil.format(source, PATTERN_YYYY_MM_DD);
    }

    public static String formatToSecond(Date source) {
        return DateUtil.format(source, PATTERN_YYYY_MM_DD_HH_MM_SS);
    }

    public static String formatToMinute(Date source) {
        return DateUtil.format(source, PATTERN_YYYY_MM_DD_HH_MM);
    }

    public static String formatToHour(Date source) {
        return DateUtil.format(source, PATTERN_YYYY_MM_DD_HH);
    }

    public static String formatToMonthHour(Date source) {
        return DateUtil.format(source, PATTERN_MM_DD_HH);
    }

    public static Date getServerDate() {
        return new Date();
    }

    public static long millisecondsBeforeNow(Date source) {
        if (source == null) {
            return 0L;
        }
        return new Date().getTime() - source.getTime();
    }

    public static String formatToFront(Date source) {
        long d = DateUtil.millisecondsBeforeNow(source);
        String BERFORE = "\u524d";
        if (d < 60000L) {
            long unit = d / 1000L;
            return (unit == 0L ? 1L : unit) + UNIT_SECOND_NAME + "\u524d";
        }
        if (d < 3600000L) {
            return d / 60000L + UNIT_MINUS_NAME + "\u524d";
        }
        if (d < 86400000L) {
            return d / 3600000L + UNIT_HOUR_NAME + "\u524d";
        }
        return DateUtil.format(source, PATTERN_YYYY_MM_DD_HH_MM_SS);
    }

    public static long getTime(Date source) {
        if (source == null) {
            return -1L;
        }
        return source.getTime();
    }

    public static String formatToFront(Integer second) {
        long s = second % 60;
        int t = second / 60;
        return t + "\u5206 " + s + UNIT_SECOND_NAME;
    }

    public static int daysBeforeNow(Date source) {
        if (source == null) {
            return 0;
        }
        Calendar now = Calendar.getInstance();
        Calendar old = Calendar.getInstance();
        old.setTime(source);
        old.set(11, 0);
        old.set(12, 0);
        old.set(13, 0);
        now.set(11, 0);
        now.set(12, 0);
        now.set(13, 0);
        long l = old.getTimeInMillis() - now.getTimeInMillis();
        return BigDecimal.valueOf(l).divide(BigDecimal.valueOf(86400000L), RoundingMode.HALF_UP).intValue();
    }

    public static int daysBefore(Date source1, Date source2) {
        if (source1 == null || source2 == null) {
            return 0;
        }
        Calendar now = Calendar.getInstance();
        Calendar old = Calendar.getInstance();
        old.setTime(source1);
        old.set(11, 0);
        old.set(12, 0);
        old.set(13, 0);
        now.setTime(source2);
        now.set(11, 0);
        now.set(12, 0);
        now.set(13, 0);
        long l = old.getTimeInMillis() - now.getTimeInMillis();
        return BigDecimal.valueOf(l).divide(BigDecimal.valueOf(86400000L), RoundingMode.HALF_UP).intValue();
    }

    public static int daysBeforeSECOND(Date source1, Date source2) {
        if (source1 == null || source2 == null) {
            return 0;
        }
        Calendar now = Calendar.getInstance();
        Calendar old = Calendar.getInstance();
        old.setTime(source1);
        now.setTime(source2);
        long l = old.getTimeInMillis() - now.getTimeInMillis();
        return BigDecimal.valueOf(l).divide(BigDecimal.valueOf(86400000L), RoundingMode.DOWN).intValue();
    }

    public static Date getDateAfterDays(Date date, int days) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(6, days);
        return c.getTime();
    }

    public static int getTodayOfYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(6);
    }

    public static int getDayOfYear(String dateStr) {
        Calendar calendar = DateUtil.initCalendarByDateString(dateStr);
        return calendar.get(6);
    }

    public static Calendar initCalendarByDateString(String dateStr) {
        if (null != dateStr && !"".equals(dateStr.trim()) && dateStr.matches("\\d{4}-\\d{2}-\\d{2}")) {
            String[] date = dateStr.split("-");
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, Integer.parseInt(date[0]));
            calendar.set(2, Integer.parseInt(date[1]) - 1);
            calendar.set(5, Integer.parseInt(date[2]));
            return calendar;
        }
        throw new IllegalArgumentException("\u4f20\u5165\u7684\u65e5\u671f\u683c\u5f0f\u5b57\u7b26\u4e32\u975e\u6cd5\uff01\u63a5\u53d7\u7684\u65e5\u671f\u683c\u5f0f\u5b57\u7b26\u4e32\u4e3a\uff1ayyyy-MM-dd");
    }

    public static int getDaysOfThisYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.getMaximum(6);
    }

    public static Date addByCurrent(int type, int value) {
        return DateUtil.addByDate(new Date(), type, value);
    }

    public static Date addByDate(Date date, int type, int value) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.set(type, now.get(type) + value);
        return now.getTime();
    }

    public static String formatMediaTime(Integer second) {
        if (second == null) {
            second = 0;
        }
        Integer hour = second / 60 / 60;
        Integer mediaTime = second / 60 - hour * 60;
        Integer mediaSecond = second - hour * 60 * 60 - mediaTime * 60;
        StringBuilder sb = new StringBuilder();
        sb.append(hour < 10 ? hour : hour).append("\u65f6 ");
        sb.append(mediaTime < 10 ? "0" + mediaTime : mediaTime).append("\u5206 ");
        sb.append(mediaSecond < 10 ? "0" + mediaSecond : mediaSecond).append(UNIT_SECOND_NAME);
        return sb.toString();
    }

    public static String formatMediaTime(BigDecimal second) {
        if (second == null) {
            second = new BigDecimal(0);
        }
        return DateUtil.formatMediaTime(second.intValue());
    }

    public static int distance(Date before, Date after, int type) {
        if (before == null || after == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u503c\u9519\u8bef");
        }
        Calendar start = Calendar.getInstance();
        start.setTime(before);
        Calendar end = Calendar.getInstance();
        end.setTime(after);
        long unit = -1L;
        switch (type) {
            case 5: {
                end.set(11, 0);
                start.set(11, 0);
                unit = 86400000L;
                break;
            }
            case 11: {
                unit = 3600000L;
                end.set(13, 0);
                end.set(12, 0);
                start.set(13, 0);
                start.set(12, 0);
                break;
            }
            case 12: {
                unit = 60000L;
                end.set(13, 0);
                start.set(13, 0);
                break;
            }
            case 13: {
                unit = 1000L;
                break;
            }
            default: {
                throw new IllegalArgumentException("type = " + type + " no support !!!!");
            }
        }
        return BigDecimal.valueOf(start.getTimeInMillis() - end.getTimeInMillis()).divide(BigDecimal.valueOf(unit), RoundingMode.HALF_UP).intValue();
    }

    public static String formatMinuteSecond(Object second) {
        if (second == null) {
            return "\u2014";
        }
        try {
            int m = Integer.parseInt(second.toString()) / 60;
            int s = Integer.parseInt(second.toString()) % 60;
            return m + "\u5206" + s + UNIT_SECOND_NAME;
        }
        catch (NumberFormatException e) {
            return "\u2014";
        }
    }

    public static Date getCurrentDate(String pattern) throws ParseException {
        String sToday = DateUtil.format(new Date(), pattern);
        return DateUtil.parse(sToday, pattern);
    }

    public static String getTodayLastSecond() {
        String sToday = DateUtil.format(new Date(), PATTERN_YYYY_MM_DD);
        return sToday + " 23:59:59";
    }

    public static String getTodayFirstSecond() {
        String sToday = DateUtil.format(new Date(), PATTERN_YYYY_MM_DD);
        return sToday + " 00:00:00";
    }

    public static boolean isSameWeek(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        int subYear = cal1.get(1) - cal2.get(1);
        return subYear == 0 ? cal1.get(3) == cal2.get(3) : (subYear == 1 && cal2.get(2) == 11 ? cal1.get(3) == cal2.get(3) : subYear == -1 && cal1.get(2) == 11 && cal1.get(3) == cal2.get(3));
    }

    public static Date getFirstDayOfWeek(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setFirstDayOfWeek(2);
        c.setTime(date);
        c.set(7, c.getFirstDayOfWeek());
        return c.getTime();
    }

    public static Date getLastDayOfWeek(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setFirstDayOfWeek(2);
        c.setTime(date);
        ((Calendar)c).add(3, -1);
        c.set(7, c.getFirstDayOfWeek() + 6);
        return c.getTime();
    }

    public static Date getNextDate(Date source, int field, String pattern) {
        if (source == null || StringUtil.isEmpty(pattern)) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38");
        }
        Calendar c = Calendar.getInstance();
        c.setTime(source);
        c.set(field, c.get(field) + 1);
        source = c.getTime();
        try {
            source = DateUtil.parse(DateUtil.format(source, pattern), pattern);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
        return source;
    }

    public static Date getLastDayOfCurrentWeek(Date date) throws ParseException {
        GregorianCalendar c = new GregorianCalendar();
        c.setFirstDayOfWeek(2);
        c.setTime(date);
        c.set(7, c.getFirstDayOfWeek() + 6);
        String sToday = DateUtil.format(c.getTime(), PATTERN_YYYY_MM_DD) + " 23:59:59";
        date = DateUtil.parse(sToday, PATTERN_YYYY_MM_DD_HH_MM_SS);
        return date;
    }

    public static Date getFirstDayOfCurrentWeek(Date date) throws ParseException {
        GregorianCalendar c = new GregorianCalendar();
        c.setFirstDayOfWeek(2);
        c.setTime(date);
        c.set(7, c.getFirstDayOfWeek());
        String sToday = DateUtil.format(c.getTime(), PATTERN_YYYY_MM_DD) + "  00:00:00";
        date = DateUtil.parse(sToday, PATTERN_YYYY_MM_DD_HH_MM_SS);
        return date;
    }

    public static Date getBegTimeOfDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date start = calendar.getTime();
        return start;
    }

    public static Date getEndTimeOfDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.add(5, 1);
        calendar.add(13, -1);
        Date end = calendar.getTime();
        return end;
    }

    public static String getWeek(Date date) {
        String[] weeks = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int week_index = cal.get(7) - 1;
        if (week_index < 0) {
            week_index = 0;
        }
        return weeks[week_index];
    }

    public static String getServiceLimitDate(Object dayNum) {
        if (dayNum == null) {
            return null;
        }
        fromCal.setTime(new Date());
        fromCal.add(5, Integer.parseInt(dayNum.toString()));
        String limitDate = DateUtil.format(fromCal.getTime(), PATTERN_YYYY_MM_DD_HH_MM_SS);
        return limitDate;
    }

    public static int getWeekDistance(Date start, Date end) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(start);
        int weekStart = cal1.get(3);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(end);
        int weekEnd = cal2.get(3);
        return weekStart - weekEnd;
    }

    public static Date[] getDaysOfWeek(Map<String, Object> map) {
        int mondayPlus = DateUtil.getMondayPlus();
        int year = (Integer)map.get("year");
        int week = (Integer)map.get("week");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        GregorianCalendar currentDate = new GregorianCalendar();
        currentDate.set(1, year);
        currentDate.set(3, week);
        currentDate.add(5, mondayPlus);
        Date monday = currentDate.getTime();
        Date[] ds = new Date[7];
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < 7; ++i) {
            ds[i] = new Date(monday.getTime() + (long)(i * 24 * 60 * 60 * 1000));
            Integer y = Integer.parseInt(sdf.format(ds[i]));
            if (list.contains(y)) continue;
            list.add(y);
        }
        Collections.sort(list, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o1 - o2;
            }
        });
        int calcYear = (Integer)list.get(0);
        if (calcYear > year) {
            year = calcYear;
            week = 2;
            map.put("year", year);
            map.put("week", week);
        }
        if (calcYear < year) {
            year = calcYear;
            map.put("year", year);
            map.put("date", 31);
            int w = DateUtil.getWeeksOfYear(map);
            if ((Integer)map.get("date") != 31) {
                ++w;
            }
            map.put("week", w);
            ds = DateUtil.getDaysOfWeek(map);
        }
        return ds;
    }

    private static int getMondayPlus() {
        Calendar c = Calendar.getInstance();
        int dayOfWeek = c.get(7);
        if (dayOfWeek == 1) {
            return -6;
        }
        return 2 - dayOfWeek;
    }

    private static int getWeeksOfYear(Map<String, Object> map) {
        Calendar c = Calendar.getInstance();
        int year = (Integer)map.get("year");
        int date = (Integer)map.get("date");
        c.set(year, 11, date);
        int weeks = c.get(3);
        if (weeks == 1) {
            map.put("date", --date);
            weeks = DateUtil.getWeeksOfYear(map);
        }
        return weeks;
    }

    public static String getMonth(Date date) {
        String[] months = new String[]{"\u4e00\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u5341\u4e00\u6708", "\u5341\u4e8c\u6708"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int i = cal.get(2);
        if (i < 0) {
            i = 0;
        }
        return months[i];
    }

    public static long millisecondsDistance(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("\u4e24\u4e2a\u65e5\u671f\u53c2\u6570\u503c\u9519\u8bef");
        }
        return date1.getTime() - date2.getTime();
    }

    public static boolean isTheSameDay(Date target1, Date target2) {
        return DateUtil.formatToDay(target1).equals(DateUtil.formatToDay(target2));
    }

    public static Date getDateSetTime(Date date, int hour, int minute, int second) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        return cal.getTime();
    }
}

