/*
 * Decompiled with CFR 0.152.
 */
package cn.m1c.frame.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static Logger logger = LoggerFactory.getLogger(HttpUtil.class);
    private static final String APPLICATION_JSON = "application/json";
    private static final String CONTENT_TYPE_TEXT_JSON = "text/json";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postJson(String url, String parameters) {
        String body = null;
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost method = new HttpPost(url);
        method.addHeader("Content-Type", APPLICATION_JSON);
        try {
            StringEntity se = new StringEntity(parameters, "utf-8");
            se.setContentType(CONTENT_TYPE_TEXT_JSON);
            se.setContentEncoding((Header)new BasicHeader("Content-Type", APPLICATION_JSON));
            method.setEntity((HttpEntity)se);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)method);
            int statusCode = response.getStatusLine().getStatusCode();
            logger.info("response code : {}", (Object)statusCode);
            body = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return body;
    }

    public static String sendPostRequestHttpClient(String path, Map<String, String> params, String encode) throws Throwable {
        ArrayList<BasicNameValuePair> paramspairs = new ArrayList<BasicNameValuePair>();
        if (params != null && !params.isEmpty()) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                paramspairs.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
        }
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(paramspairs, encode);
        HttpPost post = new HttpPost(path);
        post.setEntity((HttpEntity)entity);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)post);
        String body = EntityUtils.toString((HttpEntity)response.getEntity());
        return body;
    }

    public static String paramToJson(HttpServletRequest request) {
        try {
            StringBuffer sb = new StringBuffer();
            BufferedInputStream is = new BufferedInputStream((InputStream)request.getInputStream());
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(HttpServletResponse response, Object value) {
        PrintWriter out = null;
        try {
            response.setContentType("application/json; charset=utf-8");
            out = response.getWriter();
            Object json = JSONObject.toJSON((Object)value);
            out.write(json.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }
}

