/*
 * Decompiled with CFR 0.152.
 */
package cn.m1c.frame.utils;

import cn.m1c.frame.enums.SafeLevel;
import cn.m1c.frame.utils.CodingUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PassportSecurity {
    public static final String SECURITY = "M1cSoft!@#s$%^l&*n";
    public static final String WEB_SECURITY = "SECURITY!@.#s$^%^l&@!Soft";

    public static String getRawPassword(String userId, String md5Password) {
        return CodingUtil.MD5Encoding(userId + md5Password + userId);
    }

    public static String encryptAtWeb(String rawPassword) {
        return new StringBuilder(CodingUtil.MD5Encoding(WEB_SECURITY + rawPassword)).reverse().toString();
    }

    @Deprecated
    public static SafeLevel getSafeLevel(String password) {
        int hasDigit = 0;
        int hasLowChar = 0;
        int hasUpperChar = 0;
        int hasSpecialChar = 0;
        for (int i = 0; i < password.length(); ++i) {
            char c = password.charAt(i);
            if (c >= 'a' && c <= 'z' && hasLowChar == 0) {
                ++hasLowChar;
                continue;
            }
            if (c >= 'A' && c <= 'Z' && hasUpperChar == 0) {
                ++hasUpperChar;
                continue;
            }
            if (c >= '0' && c <= '9' && hasDigit == 0) {
                ++hasDigit;
                continue;
            }
            if (!("" + c).matches("[-`=\\;',./~!@#$%^&*()_+|{}:\"<>?]+") || hasSpecialChar != 0) continue;
            ++hasSpecialChar;
        }
        int safeLevel = hasDigit + hasLowChar + hasUpperChar + hasSpecialChar;
        if (safeLevel <= 1) {
            return SafeLevel.LOW;
        }
        if (safeLevel > 1 && safeLevel <= 3) {
            return SafeLevel.NORMAL;
        }
        return SafeLevel.HIGH;
    }

    public static SafeLevel getSafeLevelNew(String password) {
        Pattern p1 = Pattern.compile("[a-zA-Z]");
        Pattern p2 = Pattern.compile("[0-9]");
        Pattern p3 = Pattern.compile("[\\W]");
        Pattern p4 = Pattern.compile("([0-9a-zA-Z\\W])\\1+");
        Matcher m1 = p1.matcher(password);
        Matcher m2 = p2.matcher(password);
        Matcher m3 = p3.matcher(password);
        Matcher m4 = p4.matcher(password);
        boolean isSeq = PassportSecurity.isSequenceStr(password);
        int category = PassportSecurity.getCategoryOfChar(password);
        if (password == null || password.length() <= 0) {
            return SafeLevel.ERROR;
        }
        if (m4.matches() || isSeq || category <= 1) {
            return SafeLevel.LOW;
        }
        int level = 0;
        if (PassportSecurity.getCharNum(m1) >= 2) {
            ++level;
        }
        if (PassportSecurity.getCharNum(m2) >= 2) {
            ++level;
        }
        if (PassportSecurity.getCharNum(m3) >= 2) {
            ++level;
        }
        if (category > 1 && category <= 3 && level <= 1) {
            return SafeLevel.LOW;
        }
        if (category > 1 && category <= 3 && level >= 2) {
            return SafeLevel.NORMAL;
        }
        if (category > 3) {
            return SafeLevel.HIGH;
        }
        return SafeLevel.ERROR;
    }

    private static int getCharNum(Matcher m) {
        int c = 0;
        while (m.find()) {
            ++c;
        }
        return c;
    }

    public static boolean isSequenceStr(String str) {
        boolean isSeq = true;
        char pre = '\u0000';
        for (int i = 0; i < str.length(); ++i) {
            char d = str.charAt(i);
            if (i == 0) {
                pre = d;
                continue;
            }
            if (d - '\u0001' != pre && d + '\u0001' != pre) {
                isSeq = false;
            }
            pre = d;
        }
        return isSeq;
    }

    public static int getCategoryOfChar(String str) {
        int level = 0;
        Pattern p1 = Pattern.compile("[a-zA-Z]{1,}");
        Pattern p2 = Pattern.compile("[0-9]{1,}");
        Pattern p3 = Pattern.compile("[\\W]{1,}");
        Matcher matcher1 = p1.matcher(str);
        Matcher matcher2 = p2.matcher(str);
        Matcher matcher3 = p3.matcher(str);
        if (matcher1.find()) {
            ++level;
        }
        if (matcher2.find()) {
            ++level;
        }
        if (matcher3.find()) {
            ++level;
        }
        return level;
    }
}

