/*
 * Decompiled with CFR 0.152.
 */
package cn.m1c.frame.utils;

import cn.m1c.frame.utils.IOUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

public final class StreamUtil {
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    private StreamUtil() {
    }

    public static long copy(InputStream pInputStream, OutputStream pOutputStream, boolean pClose) throws IOException {
        return StreamUtil.copy(pInputStream, pOutputStream, pClose, new byte[8192]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream pIn, OutputStream pOut, boolean pClose, byte[] pBuffer) throws IOException {
        long l;
        OutputStream out = pOut;
        InputStream in = pIn;
        try {
            int res;
            long total = 0L;
            while ((res = in.read(pBuffer)) != -1) {
                if (res <= 0) continue;
                total += (long)res;
                if (out == null) continue;
                out.write(pBuffer, 0, res);
            }
            if (out != null) {
                if (pClose) {
                    out.close();
                } else {
                    out.flush();
                }
                out = null;
            }
            in.close();
            in = null;
            l = total;
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            if (pClose) {
                IOUtil.close(out);
            }
            throw throwable;
        }
        IOUtil.close(in);
        if (pClose) {
            IOUtil.close(out);
        }
        return l;
    }

    public static String asString(InputStream pStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamUtil.copy(pStream, baos, true);
        return baos.toString();
    }

    public static String readingTextFile(File textFile) throws IOException {
        return StreamUtil.readingTextFile(textFile, "UTF-8");
    }

    public static String readingTextFile(File textFile, String chartset) throws IOException {
        String string;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(textFile);
            string = StreamUtil.asString(fileInputStream);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                IOUtil.close(fileInputStream);
                throw throwable;
            }
        }
        IOUtil.close(fileInputStream);
        return string;
    }

    public static String asString(InputStream pStream, String pEncoding) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamUtil.copy(pStream, baos, true);
        return baos.toString(pEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writingCharSequence(String sharSequence, File targetFile) {
        FileOutputStream fileOutputStream = null;
        try {
            if (!targetFile.exists()) {
                if (!targetFile.getParentFile().exists()) {
                    targetFile.getParentFile().mkdirs();
                }
                targetFile.createNewFile();
            }
            byte[] b = sharSequence.getBytes("UTF-8");
            fileOutputStream = new FileOutputStream(targetFile);
            fileOutputStream.write(b);
            fileOutputStream.flush();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.close(fileOutputStream);
                throw throwable;
            }
            IOUtil.close(fileOutputStream);
        }
        IOUtil.close(fileOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writingTextFileChannel(String sharSequence, File targetFile) {
        FileOutputStream fileOutputStream = null;
        FileChannel fileChannel = null;
        try {
            if (!targetFile.exists()) {
                if (!targetFile.getParentFile().exists()) {
                    targetFile.getParentFile().mkdirs();
                }
                targetFile.createNewFile();
            }
            byte[] b = sharSequence.getBytes("UTF-8");
            fileOutputStream = new FileOutputStream(targetFile);
            fileChannel = fileOutputStream.getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate(b.length);
            byteBuffer.put(b);
            byteBuffer.flip();
            fileChannel.write(byteBuffer);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.close(fileChannel, fileOutputStream);
                throw throwable;
            }
            IOUtil.close(fileChannel, fileOutputStream);
        }
        IOUtil.close(fileChannel, fileOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readingCharSequence(File targetFile) {
        FileInputStream fileInputStream = null;
        FileChannel fileChannel = null;
        String result = null;
        try {
            fileInputStream = new FileInputStream(targetFile);
            fileChannel = fileInputStream.getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
            fileChannel.read(byteBuffer);
            byteBuffer.flip();
            byte[] b = new byte[byteBuffer.remaining()];
            byteBuffer.get(b);
            result = new String(b);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.close(fileChannel, fileInputStream);
                throw throwable;
            }
            IOUtil.close(fileChannel, fileInputStream);
        }
        IOUtil.close(fileChannel, fileInputStream);
        return result;
    }

    public static List<String> readingLineFormTextFile(File file, String encode) throws IOException {
        return StreamUtil.readingLineFormTextFile(new FileInputStream(file), encode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readingLineFormTextFile(InputStream in, String encode) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        StringReader sr = null;
        BufferedReader br = null;
        try {
            String s;
            String text = StreamUtil.asString(in, encode);
            sr = new StringReader(text);
            br = new BufferedReader(sr);
            while ((s = br.readLine()) != null) {
                lines.add(s);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.close(sr, br);
                throw throwable;
            }
            IOUtil.close(sr, br);
        }
        IOUtil.close(sr, br);
        return lines;
    }

    public static void main(String[] args) {
        File file = new File("e:\\zjh.txt");
        System.out.println(StreamUtil.readingCharSequence(file));
    }
}

