/*
 * Decompiled with CFR 0.152.
 */
package cn.m1c.frame.utils;

import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class StringUtil {
    public static final String FOLDER_SEPARATOR = "/";
    public static final String WINDOWS_FOLDER_SEPARATOR = "\\";
    public static final String TOP_PATH = "..";
    public static final String CURRENT_PATH = ".";
    public static final char EXTENSION_SEPARATOR = '.';
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static boolean hasLength(String str) {
        return StringUtil.hasLength((CharSequence)str);
    }

    public static boolean hasLengthAfterTrimWhiteSpace(String str) {
        return str != null && str.trim().length() > 0;
    }

    public static boolean hasLengthBytrim(String str) {
        return StringUtil.hasLengthAfterTrimWhiteSpace(str);
    }

    public static boolean hasText(CharSequence str) {
        if (!StringUtil.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasText(String str) {
        return StringUtil.hasText((CharSequence)str);
    }

    public static int length(String str) {
        return StringUtil.hasLength(str) ? str.length() : 0;
    }

    public static String getParamValueInPlaceholder(String url, String ref, String placeholder) {
        String result = null;
        try {
            Pattern p;
            Matcher m;
            String[] refs = ref.split(placeholder);
            String reg = "^.*" + refs[0] + "(.+?)";
            if (refs.length > 1) {
                reg = "^.*" + refs[0] + "(.+?)" + refs[1] + ".*";
            }
            if ((m = (p = Pattern.compile(reg)).matcher(url)).matches()) {
                result = m.group(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getPointBefore(String str) {
        try {
            return str.split("\\.")[0];
        }
        catch (Exception e) {
            return str;
        }
    }

    public static String getStringByLength(String source, int length, String fill) {
        if (source == null) {
            return "";
        }
        if (source.length() < length + 1) {
            return source;
        }
        return source.substring(0, length) + fill;
    }

    public static String getterName(String fieldName) {
        if (fieldName != null && !"".equals(fieldName)) {
            fieldName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        }
        return fieldName;
    }

    public static String setterName(String fieldName) {
        if (fieldName != null && !"".equals(fieldName)) {
            fieldName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        }
        return fieldName;
    }

    public static String fieldName(String getterMethodName) {
        if (StringUtil.hasLengthAfterTrimWhiteSpace(getterMethodName) && getterMethodName.startsWith("get")) {
            return getterMethodName.substring(3, 4).toLowerCase() + getterMethodName.substring(4);
        }
        return getterMethodName;
    }

    public static String string2Json(String s) {
        StringBuilder sb = new StringBuilder(s.length() + 20);
        sb.append('\"');
        block11: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case ',': {
                    sb.append("\uff0c");
                    continue block11;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block11;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block11;
                }
                case '/': {
                    sb.append("\\/");
                    continue block11;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block11;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block11;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block11;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block11;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block11;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public static String toString(String str) {
        if (str == null) {
            return "";
        }
        if (str.equals("null")) {
            return "";
        }
        if (str.length() == 0) {
            return "";
        }
        return str.trim();
    }

    public static String dup(CharSequence cs, int num) {
        if (StringUtil.isEmpty(cs) || num <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(cs.length() * num);
        for (int i = 0; i < num; ++i) {
            sb.append(cs);
        }
        return sb.toString();
    }

    public static String dup(char c, int num) {
        if (c == '\u0000' || num < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder(num);
        for (int i = 0; i < num; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    public static String capitalize(CharSequence s) {
        if (null == s) {
            return null;
        }
        int len = s.length();
        if (len == 0) {
            return "";
        }
        char char0 = s.charAt(0);
        if (Character.isUpperCase(char0)) {
            return s.toString();
        }
        return new StringBuilder(len).append(Character.toUpperCase(char0)).append(s.subSequence(1, len)).toString();
    }

    public static String lowerFirst(CharSequence s) {
        if (null == s) {
            return null;
        }
        int len = s.length();
        if (len == 0) {
            return "";
        }
        char c = s.charAt(0);
        if (Character.isLowerCase(c)) {
            return s.toString();
        }
        return new StringBuilder(len).append(Character.toLowerCase(c)).append(s.subSequence(1, len)).toString();
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equalsIgnoreCase(s2);
    }

    public static boolean equals(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public static boolean startsWithChar(String s, char c) {
        return null != s ? (s.length() == 0 ? false : s.charAt(0) == c) : false;
    }

    public static boolean endsWithChar(String s, char c) {
        return null != s ? (s.length() == 0 ? false : s.charAt(s.length() - 1) == c) : false;
    }

    public static boolean isEmpty(CharSequence cs) {
        return null == cs || cs.length() == 0;
    }

    public static boolean isBlank(CharSequence cs) {
        if (null == cs) {
            return true;
        }
        int length = cs.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String trim(CharSequence cs) {
        int l;
        int last;
        if (null == cs) {
            return null;
        }
        if (cs instanceof String) {
            return ((String)cs).trim();
        }
        int length = cs.length();
        if (length == 0) {
            return cs.toString();
        }
        int r = last = length - 1;
        for (l = 0; l < length && Character.isWhitespace(cs.charAt(l)); ++l) {
        }
        while (r > l && Character.isWhitespace(cs.charAt(r))) {
            --r;
        }
        if (l > r) {
            return "";
        }
        if (l == 0 && r == last) {
            return cs.toString();
        }
        return cs.subSequence(l, r + 1).toString();
    }

    public static String[] splitIgnoreBlank(String s) {
        return StringUtil.splitIgnoreBlank(s, ",");
    }

    public static String[] splitIgnoreBlank(String s, String regex) {
        if (null == s) {
            return null;
        }
        String[] ss = s.split(regex);
        LinkedList<String> list = new LinkedList<String>();
        for (String st : ss) {
            if (StringUtil.isBlank(st)) continue;
            list.add(StringUtil.trim(st));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String fillDigit(int d, int width) {
        return StringUtil.alignRight(String.valueOf(d), width, '0');
    }

    public static String fillHex(int d, int width) {
        return StringUtil.alignRight(Integer.toHexString(d), width, '0');
    }

    public static String fillBinary(int d, int width) {
        return StringUtil.alignRight(Integer.toBinaryString(d), width, '0');
    }

    public static String toDigit(int d, int width) {
        return StringUtil.cutRight(String.valueOf(d), width, '0');
    }

    public static String toHex(int d, int width) {
        return StringUtil.cutRight(Integer.toHexString(d), width, '0');
    }

    public static String toBinary(int d, int width) {
        return StringUtil.cutRight(Integer.toBinaryString(d), width, '0');
    }

    public static String cutRight(String s, int width, char c) {
        if (null == s) {
            return null;
        }
        int len = s.length();
        if (len == width) {
            return s;
        }
        if (len < width) {
            return StringUtil.dup(c, width - len) + s;
        }
        return s.substring(len - width, len);
    }

    public static String alignRight(CharSequence cs, int width, char c) {
        if (null == cs) {
            return null;
        }
        int len = cs.length();
        if (len >= width) {
            return cs.toString();
        }
        return StringUtil.dup(c, width - len) + cs;
    }

    public static String alignLeft(CharSequence cs, int width, char c) {
        if (null == cs) {
            return null;
        }
        int length = cs.length();
        if (length >= width) {
            return cs.toString();
        }
        return cs + StringUtil.dup(c, width - length);
    }

    public static boolean isQuoteByIgnoreBlank(CharSequence cs, char lc, char rc) {
        int l;
        int last;
        if (null == cs) {
            return false;
        }
        int len = cs.length();
        if (len < 2) {
            return false;
        }
        int r = last = len - 1;
        for (l = 0; l < len && Character.isWhitespace(cs.charAt(l)); ++l) {
        }
        if (cs.charAt(l) != lc) {
            return false;
        }
        while (r > l && Character.isWhitespace(cs.charAt(r))) {
            --r;
        }
        return l < r && cs.charAt(r) == rc;
    }

    public static boolean isQuoteBy(CharSequence cs, char lc, char rc) {
        if (null == cs) {
            return false;
        }
        int length = cs.length();
        return length > 1 && cs.charAt(0) == lc && cs.charAt(length - 1) == rc;
    }

    public static int maxLength(Collection<? extends CharSequence> coll) {
        int re = 0;
        if (null != coll) {
            for (CharSequence charSequence : coll) {
                if (null == charSequence) continue;
                re = Math.max(re, charSequence.length());
            }
        }
        return re;
    }

    public static <T extends CharSequence> int maxLength(T[] array) {
        int re = 0;
        if (null != array) {
            for (T s : array) {
                if (null == s) continue;
                re = Math.max(re, s.length());
            }
        }
        return re;
    }

    public static String sNull(Object obj) {
        return StringUtil.sNull(obj, "");
    }

    public static String sNull(Object obj, String defaultValue) {
        return obj != null ? obj.toString() : defaultValue;
    }

    public static String sBlank(Object obj) {
        return StringUtil.sBlank(obj, "");
    }

    public static String sBlank(Object obj, String def) {
        if (null == obj) {
            return def;
        }
        String s = obj.toString();
        return StringUtil.isBlank(s) ? def : s;
    }

    public static String removeFirst(CharSequence str) {
        if (str == null) {
            return null;
        }
        if (str.length() > 1) {
            return str.subSequence(1, str.length()).toString();
        }
        return "";
    }

    public static String removeFirst(String str, char c) {
        return StringUtil.isEmpty(str) || c != str.charAt(0) ? str : str.substring(1);
    }

    public static boolean isin(String[] ss, String s) {
        if (null == ss || ss.length == 0 || StringUtil.isBlank(s)) {
            return false;
        }
        for (String w : ss) {
            if (!s.equals(w)) continue;
            return true;
        }
        return false;
    }

    public static String upperWord(CharSequence s, char c) {
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch == c) {
                do {
                    if (++i < len) continue;
                    return sb.toString();
                } while ((ch = s.charAt(i)) == c);
                sb.append(Character.toUpperCase(ch));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static int indexOf(String referer, String string) {
        if (StringUtil.hasLengthBytrim(referer)) {
            return referer.indexOf(string);
        }
        return -1;
    }

    public static String getString(byte[] b, int offset, int len, String encoding) {
        try {
            return new String(b, offset, len, encoding);
        }
        catch (UnsupportedEncodingException e) {
            return new String(b, offset, len);
        }
    }

    public static String toHexString(byte[] buf) {
        return StringUtil.toHexString(buf, null, Integer.MAX_VALUE);
    }

    public static String toHexString(byte[] buf, String sep, int lineLen) {
        if (buf == null) {
            return null;
        }
        if (lineLen <= 0) {
            lineLen = Integer.MAX_VALUE;
        }
        StringBuffer res = new StringBuffer(buf.length * 2);
        for (int i = 0; i < buf.length; ++i) {
            byte b = buf[i];
            res.append(HEX_DIGITS[b >> 4 & 0xF]);
            res.append(HEX_DIGITS[b & 0xF]);
            if (i > 0 && i % lineLen == 0) {
                res.append('\n');
                continue;
            }
            if (sep == null || i >= lineLen - 1) continue;
            res.append(sep);
        }
        return res.toString();
    }

    private static final int charToNibble(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + (c - 97);
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + (c - 65);
        }
        return -1;
    }

    public static byte[] fromHexString(String text) {
        if ((text = text.trim()).length() % 2 != 0) {
            text = "0" + text;
        }
        int resLen = text.length() / 2;
        byte[] res = new byte[resLen];
        for (int i = 0; i < resLen; ++i) {
            int j = i << 1;
            int hiNibble = StringUtil.charToNibble(text.charAt(j));
            int loNibble = StringUtil.charToNibble(text.charAt(j + 1));
            if (loNibble == -1 || hiNibble == -1) {
                return null;
            }
            res[i] = (byte)(hiNibble << 4 | loNibble);
        }
        return res;
    }

    public static final boolean isChinese(String strName) {
        char[] ch = strName.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            if (!StringUtil.isChinese(c)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isChinese(char c) {
        if (c > '\u007f') {
            Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
            return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
        }
        return false;
    }

    public static String trimZero(String str) {
        if (str.indexOf(CURRENT_PATH) != -1 && str.charAt(str.length() - 1) == '0') {
            return StringUtil.trimZero(str.substring(0, str.length() - 1));
        }
        return str.charAt(str.length() - 1) == '.' ? str.substring(0, str.length() - 1) : str;
    }

    public static String ListToString(List<?> list, String sep) {
        StringBuffer sb = new StringBuffer();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) == null || list.get(i) == "") continue;
                sb.append(list.get(i));
                sb.append(sep);
            }
        }
        return sb.toString();
    }

    public static String replaceSubString(String str, int m, int n) {
        if (str == null) {
            return null;
        }
        String sub = "";
        String subPrefix = "";
        String subSuffix = "";
        int strLen = str.length();
        subPrefix = str.substring(0, m);
        subSuffix = str.substring(strLen - n, strLen);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strLen - m - n; ++i) {
            sb = sb.append("*");
        }
        sub = subPrefix + sb.toString() + subSuffix;
        return sub;
    }

    public static String getLast4(String str) {
        if (str != null && str.length() >= 4) {
            return str.substring(str.length() - 4);
        }
        return "";
    }
}

