/*
 * Decompiled with CFR 0.152.
 */
package cn.m1c.frame.utils;

import cn.m1c.frame.utils.CodingUtil;
import cn.m1c.frame.utils.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class WebUtil {
    public static final String URL_PATTERN = "(http://)?([^/]*)(/?.*)";

    public static String getStringByRequestParameter(HttpServletRequest request, String name, String defaultValue) {
        String str = request.getParameter(name);
        return str == null ? defaultValue : str.trim();
    }

    public static boolean getBooleanByRequestParameter(HttpServletRequest request, String name, boolean defaultValue) {
        String value = request.getParameter(name);
        return value == null ? defaultValue : Boolean.parseBoolean(request.getParameter(name));
    }

    public static Integer getIntByRequestParameter(HttpServletRequest request, String name, Integer defaultValue) {
        String str = request.getParameter(name);
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Long getLongByRequestParameter(HttpServletRequest request, String name, Long defaultValue) {
        String str = request.getParameter(name);
        if (str == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(str);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Double getDoubleByRequestParameter(HttpServletRequest request, String name, Double defaultValue) {
        String str = request.getParameter(name);
        if (str == null) {
            return defaultValue;
        }
        try {
            return Double.valueOf(str);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getUrl(HttpServletRequest request, boolean isSyncBase64Encoder) {
        String forward = (String)request.getAttribute("javax.servlet.forward.servlet_path");
        StringBuffer url = new StringBuffer(forward == null ? request.getRequestURL() : forward);
        String parm = WebUtil.param(request, new String[0]);
        if (StringUtil.hasLength(parm)) {
            url.append("?").append(parm);
        }
        return isSyncBase64Encoder ? CodingUtil.base64Encode(url.toString().getBytes()) : url.toString();
    }

    public static String getUrl(HttpServletRequest request, UrlCodeType urlCodeType) throws UnsupportedEncodingException {
        String forward = (String)request.getAttribute("javax.servlet.forward.servlet_path");
        StringBuffer url = new StringBuffer(forward == null ? request.getRequestURL() : forward);
        String parm = WebUtil.param(request, new String[0]);
        if (StringUtil.hasLength(parm)) {
            url.append("?").append(parm);
        }
        String result = url.toString();
        if (urlCodeType != null) {
            switch (urlCodeType) {
                case BASE64: {
                    return CodingUtil.base64Encode(result.getBytes());
                }
                case URLENCODE: {
                    return URLEncoder.encode(result, "UTF-8");
                }
            }
        }
        return result;
    }

    public static String parseUrl(String url, UrlCodeType urlCodeType) throws UnsupportedEncodingException {
        if (urlCodeType != null) {
            switch (urlCodeType) {
                case BASE64: {
                    return new String(CodingUtil.base64Decode(url), "UTF-8");
                }
                case URLENCODE: {
                    return URLDecoder.decode(url, "UTF-8");
                }
            }
        }
        return url;
    }

    public static String param(HttpServletRequest request, String ... ignoreParams) {
        String pname;
        HashSet<String> ignoreSet;
        StringBuffer url = new StringBuffer();
        Enumeration param = request.getParameterNames();
        HashSet<String> hashSet = ignoreSet = ignoreParams.length == 0 ? null : new HashSet<String>(Arrays.asList(ignoreParams));
        if (ignoreSet == null) {
            while (param.hasMoreElements()) {
                pname = param.nextElement().toString();
                url.append(pname).append("=").append(request.getParameter(pname)).append("&");
            }
        } else {
            while (param.hasMoreElements()) {
                pname = param.nextElement().toString();
                if (ignoreSet.contains(pname)) continue;
                url.append(pname).append("=").append(request.getParameter(pname)).append("&");
            }
        }
        if (url.toString().endsWith("&")) {
            url.deleteCharAt(url.length() - 1);
        }
        String result = url.toString().replace("\"", "%22").replace("'", "%27").replace("<", "&lt;").replace(">", "&gt;");
        return result;
    }

    public static String getValidateCode(Object scope) {
        if (scope instanceof HttpSession) {
            HttpSession session = (HttpSession)scope;
            return (String)session.getAttribute("validateCode");
        }
        if (scope instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)scope;
            return WebUtil.getValidateCode(request.getSession());
        }
        return null;
    }

    public static Boolean isValidateCode(Object scope, String validateCode) {
        return validateCode != null && validateCode.equalsIgnoreCase(WebUtil.getValidateCode(scope));
    }

    public static boolean prohibitOutsideLinking(HttpServletRequest request) {
        String Referer = "";
        boolean referer_sign = true;
        Enumeration headerValues = request.getHeaders("Referer");
        while (headerValues.hasMoreElements()) {
            Referer = (String)headerValues.nextElement();
        }
        if (Referer == null || Referer.length() < 1) {
            referer_sign = false;
        } else {
            String servername_str = request.getServerName();
            if (StringUtil.hasLengthBytrim(servername_str)) {
                int index = 0;
                if (StringUtil.indexOf(Referer, "https://") == 0) {
                    index = 8;
                } else if (StringUtil.indexOf(Referer, "http://") == 0) {
                    index = 7;
                }
                if (Referer.length() - index < servername_str.length()) {
                    referer_sign = false;
                } else {
                    String referer_str = Referer.substring(index, index + servername_str.length());
                    if (!servername_str.equalsIgnoreCase(referer_str)) {
                        referer_sign = false;
                    }
                }
            } else {
                referer_sign = false;
            }
        }
        return referer_sign;
    }

    public static enum UrlCodeType {
        BASE64,
        URLENCODE;

    }
}

