/*
 * Decompiled with CFR 0.152.
 */
package cn.m1c.frame.vo;

import cn.m1c.frame.constants.StatusCode;
import cn.m1c.frame.utils.StringUtil;
import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

public class RpcResult
implements Serializable {
    private static final long serialVersionUID = 3468685425329223164L;
    private int code = Integer.MIN_VALUE;
    private String message;
    private Map<String, Object> attributes;
    private Object databody;
    private Map<String, Object> _databodyMap;
    private List<Map<String, Object>> _databodyMaps;

    private RpcResult() {
    }

    public static RpcResult status(StatusCode statusCode) {
        return RpcResult.status(statusCode, null);
    }

    public static RpcResult status(StatusCode statusCode, String defaultMessage) {
        RpcResult rpcResult = new RpcResult();
        rpcResult.setCode(statusCode.getCode());
        rpcResult.setMessage(StringUtil.hasLength(defaultMessage) ? defaultMessage : statusCode.getMessage());
        return rpcResult;
    }

    public static RpcResult success() {
        return RpcResult.status(StatusCode.success);
    }

    public static RpcResult fail() {
        return RpcResult.status(StatusCode.failed);
    }

    public RpcResult addArray() {
        if (this._databodyMaps == null) {
            this._databodyMaps = new ArrayList<Map<String, Object>>();
        }
        this._databodyMaps.add(new HashMap());
        return this;
    }

    public RpcResult addDatabody(String key, Object value) {
        if (this._databodyMaps != null && this._databodyMaps.size() > 0) {
            this._databodyMaps.get(this._databodyMaps.size() - 1).put(key, value == null ? "" : value);
            return this;
        }
        if (this._databodyMap == null) {
            this._databodyMap = new HashMap<String, Object>();
        }
        this._databodyMap.put(key, value == null ? "" : value);
        return this;
    }

    public RpcResult addAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, value == null ? "" : value);
        return this;
    }

    public void out(HttpServletResponse response) {
        try {
            response.setCharacterEncoding("utf-8");
            if (!StringUtil.hasLengthBytrim(response.getContentType())) {
                response.setContentType("application/json");
            }
            response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 0L);
            response.getWriter().print(this.toString());
            response.getWriter().flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void outCrossOrigin(HttpServletResponse response) {
        try {
            response.setCharacterEncoding("utf-8");
            if (!StringUtil.hasLengthBytrim(response.getContentType())) {
                response.setContentType("application/json");
            }
            response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 3600L);
            response.setHeader("Access-Control-Max-Age", "3600");
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE");
            response.setHeader("Access-Control-Allow-Headers", "x-requested-with");
            response.getWriter().print(this.toString());
            response.getWriter().flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void outHtml(HttpServletResponse response) {
        try {
            response.setCharacterEncoding("utf-8");
            if (!StringUtil.hasLengthBytrim(response.getContentType())) {
                response.setContentType("application/html");
            }
            response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 0L);
            response.getWriter().print(this.toString());
            response.getWriter().flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void change() {
        if (this._databodyMaps != null && this._databodyMaps.size() > 0) {
            this.databody = this._databodyMaps;
            this._databodyMaps = null;
            return;
        }
        this.databody = this._databodyMap;
        this._databodyMap = null;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Object getDatabody() {
        if (this.databody == null) {
            this.change();
        }
        return this.databody;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        if (this._databodyMaps != null && this._databodyMaps.size() > 0) {
            this.addAttribute("databodysize", this._databodyMaps.size());
        }
        this.change();
        return JSON.toJSONString((Object)this);
    }
}

