/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common;

import cn.maarlakes.common.Ordered;
import jakarta.annotation.Nonnull;
import java.util.Comparator;

public class OrderedComparator
implements Comparator<Object> {
    protected OrderedComparator() {
    }

    @Nonnull
    public static OrderedComparator getInstance() {
        return Helper.COMPARATOR;
    }

    @Override
    public int compare(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return 0;
        }
        return Integer.compare(this.getOrder(obj1), this.getOrder(obj2));
    }

    protected int getOrder(Object obj) {
        if (obj == null) {
            return Integer.MAX_VALUE;
        }
        Integer order = this.findOrder(obj);
        return order == null ? Integer.MAX_VALUE : order;
    }

    protected Integer findOrder(@Nonnull Object obj) {
        if (obj instanceof Ordered) {
            return ((Ordered)obj).order();
        }
        return null;
    }

    private static final class Helper {
        static final OrderedComparator COMPARATOR = new OrderedComparator();

        private Helper() {
        }
    }
}

