/*
 * Decompiled with CFR 0.152.
 */
package cn.maarlakes.common.id;

import cn.maarlakes.common.id.IdGenerator;
import jakarta.annotation.Nonnull;
import java.security.SecureRandom;
import java.util.Random;

public final class UlidGenerator
implements IdGenerator {
    public static final int ULID_LENGTH = 26;
    public static final int ULID_BINARY_LENGTH = 16;
    public static final int ENTROPY_LENGTH = 10;
    public static final long MIN_TIME = 0L;
    public static final long MAX_TIME = 0xFFFFFFFFFFFFL;
    private static final char[] C = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'v', 'w', 'x', 'y', 'z'};
    private final Random random = new SecureRandom();
    private long lastTimestamp;
    private final byte[] lastEntropy = new byte[10];

    private UlidGenerator() {
    }

    public static UlidGenerator getInstance() {
        return SingleHelper.GENERATOR;
    }

    @Override
    @Nonnull
    public synchronized String generateId() {
        long now = System.currentTimeMillis();
        if (now == this.lastTimestamp) {
            boolean carry = true;
            for (int i = 9; i >= 0; --i) {
                if (!carry) continue;
                byte work = this.lastEntropy[i];
                work = (byte)(work + 1);
                carry = this.lastEntropy[i] == -1;
                this.lastEntropy[i] = work;
            }
            if (carry) {
                while (now == this.lastTimestamp) {
                    now = System.currentTimeMillis();
                }
                this.lastTimestamp = now;
                this.random.nextBytes(this.lastEntropy);
            }
        } else {
            this.lastTimestamp = now;
            this.random.nextBytes(this.lastEntropy);
        }
        return UlidGenerator.generate(this.lastTimestamp, this.lastEntropy);
    }

    private static String generate(long time, byte[] entropy) {
        if (time < 0L || time > 0xFFFFFFFFFFFFL || entropy == null || entropy.length < 10) {
            throw new IllegalArgumentException("Time is too long, or entropy is less than 10 bytes or null");
        }
        char[] chars = new char[]{C[(byte)(time >>> 45) & 0x1F], C[(byte)(time >>> 40) & 0x1F], C[(byte)(time >>> 35) & 0x1F], C[(byte)(time >>> 30) & 0x1F], C[(byte)(time >>> 25) & 0x1F], C[(byte)(time >>> 20) & 0x1F], C[(byte)(time >>> 15) & 0x1F], C[(byte)(time >>> 10) & 0x1F], C[(byte)(time >>> 5) & 0x1F], C[(byte)time & 0x1F], C[(byte)((entropy[0] & 0xFF) >>> 3)], C[(byte)((entropy[0] << 2 | (entropy[1] & 0xFF) >>> 6) & 0x1F)], C[(byte)((entropy[1] & 0xFF) >>> 1 & 0x1F)], C[(byte)((entropy[1] << 4 | (entropy[2] & 0xFF) >>> 4) & 0x1F)], C[(byte)((entropy[2] << 1 | (entropy[3] & 0xFF) >>> 7) & 0x1F)], C[(byte)((entropy[3] & 0xFF) >>> 2 & 0x1F)], C[(byte)((entropy[3] << 3 | (entropy[4] & 0xFF) >>> 5) & 0x1F)], C[(byte)(entropy[4] & 0x1F)], C[(byte)((entropy[5] & 0xFF) >>> 3)], C[(byte)((entropy[5] << 2 | (entropy[6] & 0xFF) >>> 6) & 0x1F)], C[(byte)((entropy[6] & 0xFF) >>> 1 & 0x1F)], C[(byte)((entropy[6] << 4 | (entropy[7] & 0xFF) >>> 4) & 0x1F)], C[(byte)((entropy[7] << 1 | (entropy[8] & 0xFF) >>> 7) & 0x1F)], C[(byte)((entropy[8] & 0xFF) >>> 2 & 0x1F)], C[(byte)((entropy[8] << 3 | (entropy[9] & 0xFF) >>> 5) & 0x1F)], C[(byte)(entropy[9] & 0x1F)]};
        return new String(chars);
    }

    private static final class SingleHelper {
        public static final UlidGenerator GENERATOR = new UlidGenerator();

        private SingleHelper() {
        }
    }
}

