/*
 * Decompiled with CFR 0.152.
 */
package cn.moongoddess.core;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DateTools
extends DateUtils {
    public static final String YYYY = "yyyy";
    public static final String YYYY_MM = "yyyy-MM";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    private static final String[] parsePatterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM"};

    public static Date getNowDate() {
        return new Date();
    }

    public static String getDate() {
        return DateTools.dateTimeNow(YYYY_MM_DD);
    }

    public static String getTime() {
        return DateTools.dateTimeNow(YYYY_MM_DD_HH_MM_SS);
    }

    public static String dateTimeNow() {
        return DateTools.dateTimeNow(YYYYMMDDHHMMSS);
    }

    public static String dateTimeNow(String format) {
        return DateTools.parseDateToStr(format, new Date());
    }

    public static String dateTime(Date date) {
        return DateTools.parseDateToStr(YYYY_MM_DD, date);
    }

    public static String parseDateToStr(String format, Date date) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat(format).format(date);
    }

    public static Date dateTime(String format, String ts) {
        try {
            return new SimpleDateFormat(format).parse(ts);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static String datePath() {
        Date now = new Date();
        return DateFormatUtils.format((Date)now, (String)"yyyy/MM/dd");
    }

    public static String dateTime() {
        Date now = new Date();
        return DateFormatUtils.format((Date)now, (String)"yyyyMMdd");
    }

    public static Date parseDate(String str) {
        if (str == null) {
            return null;
        }
        try {
            return DateTools.parseDate((String)str, (String[])parsePatterns);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static long getDateDifference(Date endDate, Date nowDate) {
        long nd = 86400000L;
        long diff = endDate.getTime() - nowDate.getTime();
        return diff / nd;
    }

    public static Date toDate(LocalDateTime localDateTime) {
        ZonedDateTime zdt = localDateTime.atZone(ZoneId.systemDefault());
        return Date.from(zdt.toInstant());
    }

    public static Date toDate(LocalDate localDate) {
        LocalDateTime localDateTime = LocalDateTime.of(localDate, LocalTime.of(0, 0, 0));
        ZonedDateTime zdt = localDateTime.atZone(ZoneId.systemDefault());
        return Date.from(zdt.toInstant());
    }

    public static Date addDays(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, num);
        date = calendar.getTime();
        return date;
    }

    public static Date addMonths(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, num);
        date = calendar.getTime();
        return date;
    }

    public static Date addYears(Date date, int num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, num);
        date = calendar.getTime();
        return date;
    }
}

