/*
 * Decompiled with CFR 0.152.
 */
package cn.moongoddess.core.metrology;

import cn.moongoddess.core.model.RoundingParams;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class RoundingOff {
    public String get(String value, String level) {
        RoundingParams rp;
        switch (level) {
            case "0.02": {
                rp = new RoundingParams("2", 3);
                break;
            }
            case "0.05": {
                rp = new RoundingParams("5", 3);
                break;
            }
            case "0.2": {
                rp = new RoundingParams("2", 2);
                break;
            }
            case "0.5": {
                rp = new RoundingParams("5", 2);
                break;
            }
            case "1": {
                rp = new RoundingParams("1", 1);
                break;
            }
            case "2": {
                rp = new RoundingParams("2", 1);
                break;
            }
            default: {
                rp = null;
            }
        }
        if (rp == null) {
            return null;
        }
        BigDecimal multiply = new BigDecimal(value).divide(new BigDecimal(rp.getCoefficient())).setScale(rp.getDecimalPlace(), RoundingMode.HALF_EVEN).multiply(new BigDecimal(rp.getCoefficient()));
        return this.numDecimal(multiply.toString(), rp.getDecimalPlace());
    }

    private String numDecimal(String num, int len) {
        if (len == 0) {
            return num.split("\\.")[0];
        }
        if (!num.contains(".")) {
            num = num + ".0";
        }
        String[] split = num.split("\\.");
        String decimal = split[1];
        num = split[0];
        if (decimal.length() > len) {
            decimal = decimal.substring(0, len);
            return num + "." + decimal;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(decimal);
        while (decimal.length() != len) {
            builder.append("0");
        }
        return num + "." + builder;
    }
}

