/*
 * Decompiled with CFR 0.152.
 */
package cn.mybatis.mp.generator.config;

import cn.mybatis.mp.generator.config.ActionConfig;
import cn.mybatis.mp.generator.config.ColumnConfig;
import cn.mybatis.mp.generator.config.DaoConfig;
import cn.mybatis.mp.generator.config.DaoImplConfig;
import cn.mybatis.mp.generator.config.DataBaseConfig;
import cn.mybatis.mp.generator.config.EntityConfig;
import cn.mybatis.mp.generator.config.MapperConfig;
import cn.mybatis.mp.generator.config.MapperXmlConfig;
import cn.mybatis.mp.generator.config.ServiceConfig;
import cn.mybatis.mp.generator.config.ServiceImplConfig;
import cn.mybatis.mp.generator.config.TableConfig;
import cn.mybatis.mp.generator.template.ActionTemplateBuilder;
import cn.mybatis.mp.generator.template.DaoImplTemplateBuilder;
import cn.mybatis.mp.generator.template.DaoTemplateBuilder;
import cn.mybatis.mp.generator.template.EntityTemplateBuilder;
import cn.mybatis.mp.generator.template.ITemplateBuilder;
import cn.mybatis.mp.generator.template.MapperTemplateBuilder;
import cn.mybatis.mp.generator.template.MapperXmlTemplateBuilder;
import cn.mybatis.mp.generator.template.ServiceImplTemplateBuilder;
import cn.mybatis.mp.generator.template.ServiceTemplateBuilder;
import cn.mybatis.mp.generator.template.engine.TemplateEngine;
import db.sql.api.DbType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.sql.DataSource;

public class GeneratorConfig {
    private final DataBaseConfig dataBaseConfig;
    private boolean ignoreView = false;
    private boolean ignoreTable = false;
    private boolean finishOpen = false;
    private String baseFilePath = System.getProperty("user.dir") + "/generate";
    private String basePackage = "";
    private String templateRootPath = "templates";
    private String author;
    private TemplateEngine templateEngine;
    private List<Class<? extends ITemplateBuilder>> templateBuilders = new ArrayList<Class<? extends ITemplateBuilder>>();
    private final TableConfig tableConfig;
    private ColumnConfig columnConfig;
    private EntityConfig entityConfig;
    private final MapperConfig mapperConfig;
    private final MapperXmlConfig mapperXmlConfig;
    private DaoConfig daoConfig;
    private DaoImplConfig daoImplConfig;
    private ServiceConfig serviceConfig;
    private ServiceImplConfig serviceImplConfig;
    private ActionConfig actionConfig;

    public GeneratorConfig(String jdbcUrl, String username, String password) {
        this.templateBuilders.add(EntityTemplateBuilder.class);
        this.templateBuilders.add(MapperTemplateBuilder.class);
        this.templateBuilders.add(MapperXmlTemplateBuilder.class);
        this.templateBuilders.add(DaoTemplateBuilder.class);
        this.templateBuilders.add(DaoImplTemplateBuilder.class);
        this.templateBuilders.add(ServiceTemplateBuilder.class);
        this.templateBuilders.add(ServiceImplTemplateBuilder.class);
        this.templateBuilders.add(ActionTemplateBuilder.class);
        this.tableConfig = new TableConfig();
        this.columnConfig = new ColumnConfig();
        this.entityConfig = new EntityConfig();
        this.mapperConfig = new MapperConfig();
        this.mapperXmlConfig = new MapperXmlConfig();
        this.daoConfig = new DaoConfig();
        this.daoImplConfig = new DaoImplConfig();
        this.serviceConfig = new ServiceConfig();
        this.serviceImplConfig = new ServiceImplConfig();
        this.actionConfig = new ActionConfig();
        this.dataBaseConfig = new DataBaseConfig(jdbcUrl, username, password);
    }

    public GeneratorConfig(DbType dbType, DataSource dataSource) {
        this.templateBuilders.add(EntityTemplateBuilder.class);
        this.templateBuilders.add(MapperTemplateBuilder.class);
        this.templateBuilders.add(MapperXmlTemplateBuilder.class);
        this.templateBuilders.add(DaoTemplateBuilder.class);
        this.templateBuilders.add(DaoImplTemplateBuilder.class);
        this.templateBuilders.add(ServiceTemplateBuilder.class);
        this.templateBuilders.add(ServiceImplTemplateBuilder.class);
        this.templateBuilders.add(ActionTemplateBuilder.class);
        this.tableConfig = new TableConfig();
        this.columnConfig = new ColumnConfig();
        this.entityConfig = new EntityConfig();
        this.mapperConfig = new MapperConfig();
        this.mapperXmlConfig = new MapperXmlConfig();
        this.daoConfig = new DaoConfig();
        this.daoImplConfig = new DaoImplConfig();
        this.serviceConfig = new ServiceConfig();
        this.serviceImplConfig = new ServiceImplConfig();
        this.actionConfig = new ActionConfig();
        this.dataBaseConfig = new DataBaseConfig(dbType, dataSource);
    }

    public GeneratorConfig dataBaseConfig(Consumer<DataBaseConfig> consumer) {
        consumer.accept(this.dataBaseConfig);
        return this;
    }

    public GeneratorConfig templateEngine(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
        return this;
    }

    public GeneratorConfig templateRootPath(String templateRootPath) {
        this.templateRootPath = templateRootPath;
        return this;
    }

    public GeneratorConfig templateBuilders(Consumer<List<Class<? extends ITemplateBuilder>>> consumer) {
        consumer.accept(this.templateBuilders);
        return this;
    }

    public GeneratorConfig baseFilePath(String baseFilePath) {
        this.baseFilePath = baseFilePath;
        return this;
    }

    public GeneratorConfig basePackage(String basePackage) {
        this.basePackage = basePackage;
        return this;
    }

    public GeneratorConfig author(String author) {
        this.author = author;
        return this;
    }

    public GeneratorConfig ignoreView(boolean ignoreView) {
        this.ignoreView = ignoreView;
        return this;
    }

    public GeneratorConfig tableConfig(Consumer<TableConfig> consumer) {
        consumer.accept(this.tableConfig);
        return this;
    }

    public GeneratorConfig columnConfig(Consumer<ColumnConfig> consumer) {
        consumer.accept(this.columnConfig);
        return this;
    }

    public GeneratorConfig entityConfig(Consumer<EntityConfig> consumer) {
        consumer.accept(this.entityConfig);
        return this;
    }

    public GeneratorConfig mapperConfig(Consumer<MapperConfig> consumer) {
        consumer.accept(this.mapperConfig);
        return this;
    }

    public GeneratorConfig mapperXmlConfig(Consumer<MapperXmlConfig> consumer) {
        consumer.accept(this.mapperXmlConfig);
        return this;
    }

    public GeneratorConfig daoConfig(Consumer<DaoConfig> consumer) {
        consumer.accept(this.daoConfig);
        return this;
    }

    public GeneratorConfig daoImplConfig(Consumer<DaoImplConfig> consumer) {
        consumer.accept(this.daoImplConfig);
        return this;
    }

    public GeneratorConfig serviceConfig(Consumer<ServiceConfig> consumer) {
        consumer.accept(this.serviceConfig);
        return this;
    }

    public GeneratorConfig serviceImplConfig(Consumer<ServiceImplConfig> consumer) {
        consumer.accept(this.serviceImplConfig);
        return this;
    }

    public GeneratorConfig actionConfig(Consumer<ActionConfig> consumer) {
        consumer.accept(this.actionConfig);
        return this;
    }

    public GeneratorConfig finishOpen(boolean finishOpen) {
        this.finishOpen = finishOpen;
        return this;
    }

    public DataBaseConfig getDataBaseConfig() {
        return this.dataBaseConfig;
    }

    public boolean isIgnoreView() {
        return this.ignoreView;
    }

    public boolean isIgnoreTable() {
        return this.ignoreTable;
    }

    public boolean isFinishOpen() {
        return this.finishOpen;
    }

    public String getBaseFilePath() {
        return this.baseFilePath;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public String getTemplateRootPath() {
        return this.templateRootPath;
    }

    public String getAuthor() {
        return this.author;
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public List<Class<? extends ITemplateBuilder>> getTemplateBuilders() {
        return this.templateBuilders;
    }

    public TableConfig getTableConfig() {
        return this.tableConfig;
    }

    public ColumnConfig getColumnConfig() {
        return this.columnConfig;
    }

    public EntityConfig getEntityConfig() {
        return this.entityConfig;
    }

    public MapperConfig getMapperConfig() {
        return this.mapperConfig;
    }

    public MapperXmlConfig getMapperXmlConfig() {
        return this.mapperXmlConfig;
    }

    public DaoConfig getDaoConfig() {
        return this.daoConfig;
    }

    public DaoImplConfig getDaoImplConfig() {
        return this.daoImplConfig;
    }

    public ServiceConfig getServiceConfig() {
        return this.serviceConfig;
    }

    public ServiceImplConfig getServiceImplConfig() {
        return this.serviceImplConfig;
    }

    public ActionConfig getActionConfig() {
        return this.actionConfig;
    }
}

