/*
 * Decompiled with CFR 0.152.
 */
package cn.mybatis.mp.generator.database.meta;

import cn.mybatis.mp.generator.config.GeneratorConfig;
import cn.mybatis.mp.generator.database.meta.ColumnInfo;
import cn.mybatis.mp.generator.database.meta.EntityFieldInfo;
import cn.mybatis.mp.generator.database.meta.TableInfo;
import cn.mybatis.mp.generator.util.GeneratorUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class EntityInfo {
    private final TableInfo tableInfo;
    private final String name;
    private final String remarks;
    private final EntityFieldInfo idFieldInfo;
    private final List<EntityFieldInfo> fieldInfoList;
    private final List<EntityFieldInfo> excludeFieldInfoList;
    private final String entityPackage;
    private final String mapperName;
    private final String mapperPackage;
    private final String daoName;
    private final String daoPackage;
    private final String daoImplName;
    private final String daoImplPackage;
    public final String serviceName;
    public final String servicePackage;
    public final String serviceImplName;
    public final String serviceImplPackage;
    public final String actionName;
    public final String actionPackage;
    private boolean hasIgnoreTablePrefix = false;

    public EntityInfo(GeneratorConfig generatorConfig, TableInfo tableInfo) {
        String tmpTableName = tableInfo.getName();
        for (String prefix : generatorConfig.getTableConfig().getTablePrefixs()) {
            if (!tmpTableName.startsWith(prefix)) continue;
            tmpTableName = tmpTableName.replaceFirst(prefix, "");
            this.hasIgnoreTablePrefix = true;
            break;
        }
        this.name = GeneratorUtil.getEntityName(generatorConfig, tmpTableName);
        this.remarks = tableInfo.getRemarks();
        this.tableInfo = tableInfo;
        this.idFieldInfo = tableInfo.getIdColumnInfo() != null ? new EntityFieldInfo(generatorConfig, this, tableInfo.getIdColumnInfo()) : null;
        List fieldInfoList = tableInfo.getColumnInfoList().stream().map(item -> new EntityFieldInfo(generatorConfig, this, (ColumnInfo)item)).collect(Collectors.toList());
        this.excludeFieldInfoList = fieldInfoList.stream().filter(item -> generatorConfig.getColumnConfig().getExcludeColumns().contains(item.getColumnInfo().getName()) || generatorConfig.getColumnConfig().getExcludeColumns().contains(item.getColumnInfo().getName().toUpperCase())).collect(Collectors.toList());
        fieldInfoList.removeAll(this.excludeFieldInfoList);
        this.fieldInfoList = fieldInfoList;
        this.entityPackage = generatorConfig.getBasePackage() + "." + generatorConfig.getEntityConfig().getPackageName();
        this.mapperName = this.name + generatorConfig.getMapperConfig().getSuffix();
        this.mapperPackage = generatorConfig.getBasePackage() + "." + generatorConfig.getMapperConfig().getPackageName();
        this.daoName = this.name + generatorConfig.getDaoConfig().getSuffix();
        this.daoPackage = generatorConfig.getBasePackage() + "." + generatorConfig.getDaoConfig().getPackageName();
        this.daoImplName = this.name + generatorConfig.getDaoImplConfig().getSuffix();
        this.daoImplPackage = generatorConfig.getBasePackage() + "." + generatorConfig.getDaoImplConfig().getPackageName();
        this.serviceName = this.name + generatorConfig.getServiceConfig().getSuffix();
        this.servicePackage = generatorConfig.getBasePackage() + "." + generatorConfig.getServiceConfig().getPackageName();
        this.serviceImplName = this.name + generatorConfig.getServiceImplConfig().getSuffix();
        this.serviceImplPackage = generatorConfig.getBasePackage() + "." + generatorConfig.getServiceImplConfig().getPackageName();
        this.actionName = this.name + generatorConfig.getActionConfig().getSuffix();
        this.actionPackage = generatorConfig.getBasePackage() + "." + generatorConfig.getActionConfig().getPackageName();
    }

    public List<EntityFieldInfo> allFiledInfoList() {
        ArrayList<EntityFieldInfo> list = new ArrayList<EntityFieldInfo>();
        if (this.idFieldInfo != null) {
            list.add(this.idFieldInfo);
        }
        list.addAll(this.excludeFieldInfoList);
        list.addAll(this.fieldInfoList);
        return list.stream().distinct().collect(Collectors.toList());
    }

    public TableInfo getTableInfo() {
        return this.tableInfo;
    }

    public String getName() {
        return this.name;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public EntityFieldInfo getIdFieldInfo() {
        return this.idFieldInfo;
    }

    public List<EntityFieldInfo> getFieldInfoList() {
        return this.fieldInfoList;
    }

    public List<EntityFieldInfo> getExcludeFieldInfoList() {
        return this.excludeFieldInfoList;
    }

    public String getEntityPackage() {
        return this.entityPackage;
    }

    public String getMapperName() {
        return this.mapperName;
    }

    public String getMapperPackage() {
        return this.mapperPackage;
    }

    public String getDaoName() {
        return this.daoName;
    }

    public String getDaoPackage() {
        return this.daoPackage;
    }

    public String getDaoImplName() {
        return this.daoImplName;
    }

    public String getDaoImplPackage() {
        return this.daoImplPackage;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServicePackage() {
        return this.servicePackage;
    }

    public String getServiceImplName() {
        return this.serviceImplName;
    }

    public String getServiceImplPackage() {
        return this.serviceImplPackage;
    }

    public String getActionName() {
        return this.actionName;
    }

    public String getActionPackage() {
        return this.actionPackage;
    }

    public boolean isHasIgnoreTablePrefix() {
        return this.hasIgnoreTablePrefix;
    }

    public String toString() {
        return "EntityInfo(tableInfo=" + this.getTableInfo() + ", name=" + this.getName() + ", remarks=" + this.getRemarks() + ", idFieldInfo=" + this.getIdFieldInfo() + ", fieldInfoList=" + this.getFieldInfoList() + ", excludeFieldInfoList=" + this.getExcludeFieldInfoList() + ", entityPackage=" + this.getEntityPackage() + ", mapperName=" + this.getMapperName() + ", mapperPackage=" + this.getMapperPackage() + ", daoName=" + this.getDaoName() + ", daoPackage=" + this.getDaoPackage() + ", daoImplName=" + this.getDaoImplName() + ", daoImplPackage=" + this.getDaoImplPackage() + ", serviceName=" + this.getServiceName() + ", servicePackage=" + this.getServicePackage() + ", serviceImplName=" + this.getServiceImplName() + ", serviceImplPackage=" + this.getServiceImplPackage() + ", actionName=" + this.getActionName() + ", actionPackage=" + this.getActionPackage() + ", hasIgnoreTablePrefix=" + this.isHasIgnoreTablePrefix() + ")";
    }
}

