/*
 * Decompiled with CFR 0.152.
 */
package cn.mybatis.mp.generator.template;

import cn.mybatis.mp.generator.config.GeneratorConfig;
import cn.mybatis.mp.generator.database.meta.EntityInfo;
import cn.mybatis.mp.generator.template.AbstractTemplateBuilder;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

public class MapperXmlTemplateBuilder
extends AbstractTemplateBuilder {
    public MapperXmlTemplateBuilder(GeneratorConfig generatorConfig, EntityInfo entityInfo) {
        super(generatorConfig, entityInfo);
    }

    @Override
    public boolean enable() {
        return this.generatorConfig.getMapperXmlConfig().isEnable();
    }

    @Override
    public String targetFilePath() {
        return this.generatorConfig.getBaseFilePath() + "/" + (this.generatorConfig.getMapperXmlConfig().getPackageName() + "." + this.entityInfo.getName() + this.generatorConfig.getMapperXmlConfig().getSuffix()).replaceAll("\\.", "/") + ".xml";
    }

    @Override
    public String templateFilePath() {
        return this.generatorConfig.getTemplateRootPath() + "/mapper.xml";
    }

    @Override
    public Map<String, Object> contextData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("date", LocalDate.now().toString());
        data.put("author", this.generatorConfig.getAuthor());
        data.put("entityInfo", this.entityInfo);
        data.put("mapperConfig", this.generatorConfig.getMapperConfig());
        data.put("mapperXmlConfig", this.generatorConfig.getMapperXmlConfig());
        return data;
    }
}

