/*
 * Decompiled with CFR 0.152.
 */
package cn.mybatis.mp.generator.util;

import cn.mybatis.mp.core.mybatis.mapper.context.Pager;
import cn.mybatis.mp.core.sql.executor.chain.DeleteChain;
import cn.mybatis.mp.core.sql.executor.chain.InsertChain;
import cn.mybatis.mp.core.sql.executor.chain.QueryChain;
import cn.mybatis.mp.core.sql.executor.chain.UpdateChain;
import cn.mybatis.mp.core.util.NamingUtil;
import cn.mybatis.mp.db.IdAutoType;
import cn.mybatis.mp.db.annotations.Table;
import cn.mybatis.mp.db.annotations.TableField;
import cn.mybatis.mp.db.annotations.TableId;
import cn.mybatis.mp.generator.config.EntityConfig;
import cn.mybatis.mp.generator.config.GeneratorConfig;
import cn.mybatis.mp.generator.database.meta.ColumnInfo;
import cn.mybatis.mp.generator.database.meta.EntityInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Data;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

public class GeneratorUtil {
    public static String getEntityName(GeneratorConfig generatorConfig, String tableName) {
        EntityConfig entityConfig = generatorConfig.getEntityConfig();
        if (entityConfig.getNameConvert() == null) {
            entityConfig.nameConvert(table -> NamingUtil.firstToUpperCase((String)NamingUtil.underlineToCamel((String)tableName)));
        }
        return entityConfig.getNameConvert().apply(tableName);
    }

    public static String getEntityFieldName(GeneratorConfig generatorConfig, ColumnInfo columnInfo) {
        EntityConfig entityConfig = generatorConfig.getEntityConfig();
        if (entityConfig.getFieldNameConverter() == null) {
            return entityConfig.getFieldNamingStrategy().getName(columnInfo.getName(), false);
        }
        return entityConfig.getFieldNameConverter().apply(columnInfo);
    }

    public static String getEntityFieldRemarks(GeneratorConfig generatorConfig, ColumnInfo columnInfo) {
        EntityConfig entityConfig = generatorConfig.getEntityConfig();
        if (entityConfig.getRemarksConverter() == null) {
            return columnInfo.getRemarks();
        }
        return entityConfig.getRemarksConverter().apply(columnInfo);
    }

    public static Class<?> getColumnType(GeneratorConfig generatorConfig, ColumnInfo columnInfo) {
        Class<?> type = generatorConfig.getEntityConfig().getTypeMapping().get(columnInfo.getJdbcType());
        if (type == null) {
            return Object.class;
        }
        return type;
    }

    public static List<String> buildEntityImports(GeneratorConfig generatorConfig, EntityInfo entityInfo) {
        ArrayList<String> classList = new ArrayList<String>();
        classList.add(Table.class.getName());
        if (entityInfo.getIdFieldInfo() != null) {
            classList.add(TableId.class.getName());
            if (entityInfo.getIdFieldInfo() != null) {
                classList.add(IdAutoType.class.getName());
            }
        }
        if (generatorConfig.getEntityConfig().getSuperClass() != null) {
            classList.add(generatorConfig.getEntityConfig().getSuperClass());
        }
        if (generatorConfig.getEntityConfig().isLombok()) {
            classList.add(Data.class.getName());
        }
        entityInfo.getFieldInfoList().forEach(item -> {
            classList.add(item.getType().getName());
            if (item.isNeedTableFiled()) {
                classList.add(TableField.class.getName());
            }
        });
        return GeneratorUtil.buildImports(classList);
    }

    public static List<String> buildMapperImports(GeneratorConfig generatorConfig, EntityInfo entityInfo) {
        ArrayList<String> classList = new ArrayList<String>();
        if (generatorConfig.getMapperConfig().getSuperClass() != null) {
            classList.add(generatorConfig.getMapperConfig().getSuperClass());
        }
        if (generatorConfig.getMapperConfig().isMapperAnnotation()) {
            classList.add(Mapper.class.getName());
        }
        classList.add(entityInfo.getEntityPackage() + "." + entityInfo.getName());
        return GeneratorUtil.buildImports(classList);
    }

    public static List<String> buildDaoImports(GeneratorConfig generatorConfig, EntityInfo entityInfo) {
        ArrayList<String> classList = new ArrayList<String>();
        if (generatorConfig.getDaoConfig().getSuperClass() != null) {
            classList.add(generatorConfig.getDaoConfig().getSuperClass());
        }
        classList.add(entityInfo.getEntityPackage() + "." + entityInfo.getName());
        if (entityInfo.getIdFieldInfo() != null) {
            classList.add(entityInfo.getIdFieldInfo().getType().getName());
        }
        return GeneratorUtil.buildImports(classList);
    }

    public static List<String> buildDaoImplImports(GeneratorConfig generatorConfig, EntityInfo entityInfo) {
        ArrayList<String> classList = new ArrayList<String>();
        if (generatorConfig.getDaoImplConfig().getSuperClass() != null) {
            classList.add(generatorConfig.getDaoImplConfig().getSuperClass());
        }
        classList.add(entityInfo.getEntityPackage() + "." + entityInfo.getName());
        if (entityInfo.getIdFieldInfo() != null) {
            classList.add(entityInfo.getIdFieldInfo().getType().getName());
        }
        classList.add(entityInfo.getMapperPackage() + "." + entityInfo.getMapperName());
        classList.add(entityInfo.getDaoPackage() + "." + entityInfo.getDaoName());
        classList.add(Repository.class.getName());
        classList.add(Autowired.class.getName());
        return GeneratorUtil.buildImports(classList);
    }

    public static List<String> buildServiceImports(GeneratorConfig generatorConfig, EntityInfo entityInfo) {
        ArrayList<String> classList = new ArrayList<String>();
        if (generatorConfig.getServiceConfig().getSuperClass() != null) {
            classList.add(generatorConfig.getServiceConfig().getSuperClass());
        }
        classList.add(entityInfo.getEntityPackage() + "." + entityInfo.getName());
        if (entityInfo.getIdFieldInfo() != null) {
            classList.add(entityInfo.getIdFieldInfo().getType().getName());
        }
        return GeneratorUtil.buildImports(classList);
    }

    public static List<String> buildServiceImplImports(GeneratorConfig generatorConfig, EntityInfo entityInfo) {
        ArrayList<String> classList = new ArrayList<String>();
        if (generatorConfig.getServiceImplConfig().getSuperClass() != null) {
            classList.add(generatorConfig.getServiceImplConfig().getSuperClass());
        }
        classList.add(entityInfo.getEntityPackage() + "." + entityInfo.getName());
        if (entityInfo.getIdFieldInfo() != null) {
            classList.add(entityInfo.getIdFieldInfo().getType().getName());
        }
        classList.add(entityInfo.getDaoPackage() + "." + entityInfo.getDaoName());
        classList.add(entityInfo.getServicePackage() + "." + entityInfo.getServiceName());
        classList.add(Service.class.getName());
        classList.add(Autowired.class.getName());
        if (generatorConfig.getServiceImplConfig().isInjectMapper()) {
            classList.add(entityInfo.getMapperPackage() + "." + entityInfo.getMapperName());
            classList.add(QueryChain.class.getName());
            classList.add(UpdateChain.class.getName());
            classList.add(InsertChain.class.getName());
            classList.add(DeleteChain.class.getName());
        }
        return GeneratorUtil.buildImports(classList);
    }

    public static List<String> buildActionImports(GeneratorConfig generatorConfig, EntityInfo entityInfo) {
        ArrayList<String> classList = new ArrayList<String>();
        if (generatorConfig.getActionConfig().getSuperClass() != null) {
            classList.add(generatorConfig.getActionConfig().getSuperClass());
        }
        classList.add(entityInfo.getEntityPackage() + "." + entityInfo.getName());
        if (entityInfo.getIdFieldInfo() != null) {
            classList.add(entityInfo.getIdFieldInfo().getType().getName());
        }
        classList.add(entityInfo.getServicePackage() + "." + entityInfo.getServiceName());
        classList.add(RestController.class.getName());
        classList.add(RequestMapping.class.getName());
        classList.add(Autowired.class.getName());
        if (generatorConfig.getActionConfig().isSave() || generatorConfig.getActionConfig().isUpdate()) {
            classList.add(PostMapping.class.getName());
        }
        if (generatorConfig.getActionConfig().isGetById() || generatorConfig.getActionConfig().isFind()) {
            classList.add(GetMapping.class.getName());
            if (generatorConfig.getActionConfig().isFind()) {
                classList.add(Pager.class.getName());
            }
        }
        if (generatorConfig.getActionConfig().isDeleteById()) {
            classList.add(DeleteMapping.class.getName());
        }
        return GeneratorUtil.buildImports(classList);
    }

    public static List<String> buildImports(List<String> classList) {
        return classList.stream().filter(item -> !item.startsWith("java.lang")).distinct().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
    }
}

