/*
 * Decompiled with CFR 0.152.
 */
package cn.mybatis.mp.generator.config;

import cn.mybatis.mp.generator.database.meta.ColumnInfo;
import cn.mybatis.mp.generator.strategy.NamingStrategy;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ibatis.type.JdbcType;

public class EntityConfig {
    private String superClass;
    private boolean lombok = true;
    private boolean schema = false;
    private String defaultTableIdCode;
    private String packageName = "DO";
    private Function<String, String> nameConvert;
    private NamingStrategy fieldNamingStrategy = NamingStrategy.UNDERLINE_TO_CAMEL;
    private Function<ColumnInfo, String> fieldNameConverter;
    private Function<ColumnInfo, String> remarksConverter;
    private final Map<JdbcType, Class<?>> typeMapping = new HashMap();

    public EntityConfig() {
        this.typeMapping.put(JdbcType.BIT, Boolean.class);
        this.typeMapping.put(JdbcType.TINYINT, Byte.class);
        this.typeMapping.put(JdbcType.SMALLINT, Integer.class);
        this.typeMapping.put(JdbcType.INTEGER, Integer.class);
        this.typeMapping.put(JdbcType.BIGINT, Long.class);
        this.typeMapping.put(JdbcType.FLOAT, Double.class);
        this.typeMapping.put(JdbcType.REAL, Double.class);
        this.typeMapping.put(JdbcType.DOUBLE, Double.class);
        this.typeMapping.put(JdbcType.NUMERIC, BigDecimal.class);
        this.typeMapping.put(JdbcType.DECIMAL, BigDecimal.class);
        this.typeMapping.put(JdbcType.CHAR, Character.class);
        this.typeMapping.put(JdbcType.VARCHAR, String.class);
        this.typeMapping.put(JdbcType.LONGVARCHAR, String.class);
        this.typeMapping.put(JdbcType.DATE, LocalDateTime.class);
        this.typeMapping.put(JdbcType.TIME, LocalTime.class);
        this.typeMapping.put(JdbcType.TIMESTAMP, LocalTime.class);
        this.typeMapping.put(JdbcType.BINARY, byte[].class);
        this.typeMapping.put(JdbcType.VARBINARY, byte[].class);
        this.typeMapping.put(JdbcType.LONGVARBINARY, byte[].class);
        this.typeMapping.put(JdbcType.BLOB, byte[].class);
        this.typeMapping.put(JdbcType.CLOB, String.class);
        this.typeMapping.put(JdbcType.BOOLEAN, Boolean.class);
        this.typeMapping.put(JdbcType.NVARCHAR, String.class);
        this.typeMapping.put(JdbcType.NCHAR, String.class);
        this.typeMapping.put(JdbcType.NCLOB, String.class);
        this.typeMapping.put(JdbcType.LONGNVARCHAR, String.class);
        this.typeMapping.put(JdbcType.NCLOB, String.class);
        this.typeMapping.put(JdbcType.DATETIMEOFFSET, OffsetDateTime.class);
        this.typeMapping.put(JdbcType.TIME_WITH_TIMEZONE, OffsetTime.class);
        this.typeMapping.put(JdbcType.TIMESTAMP_WITH_TIMEZONE, OffsetDateTime.class);
    }

    public EntityConfig superClass(String superClass) {
        this.superClass = superClass;
        return this;
    }

    public EntityConfig lombok(boolean lombok) {
        this.lombok = lombok;
        return this;
    }

    public EntityConfig schema(boolean schema) {
        this.schema = schema;
        return this;
    }

    public EntityConfig packageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public EntityConfig typeMapping(Consumer<Map<JdbcType, Class<?>>> consumer) {
        consumer.accept(this.typeMapping);
        return this;
    }

    public EntityConfig nameConvert(Function<String, String> nameConvert) {
        this.nameConvert = nameConvert;
        return this;
    }

    public EntityConfig fieldNamingStrategy(NamingStrategy fieldNamingStrategy) {
        this.fieldNamingStrategy = fieldNamingStrategy;
        return this;
    }

    public EntityConfig fieldNameConverter(Function<ColumnInfo, String> fieldNameConverter) {
        this.fieldNameConverter = fieldNameConverter;
        return this;
    }

    public EntityConfig remarksConverter(Function<ColumnInfo, String> remarksConverter) {
        this.remarksConverter = remarksConverter;
        return this;
    }

    public EntityConfig defaultTableIdCode(String defaultTableIdCode) {
        this.defaultTableIdCode = defaultTableIdCode;
        return this;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public boolean isLombok() {
        return this.lombok;
    }

    public boolean isSchema() {
        return this.schema;
    }

    public String getDefaultTableIdCode() {
        return this.defaultTableIdCode;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Function<String, String> getNameConvert() {
        return this.nameConvert;
    }

    public NamingStrategy getFieldNamingStrategy() {
        return this.fieldNamingStrategy;
    }

    public Function<ColumnInfo, String> getFieldNameConverter() {
        return this.fieldNameConverter;
    }

    public Function<ColumnInfo, String> getRemarksConverter() {
        return this.remarksConverter;
    }

    public Map<JdbcType, Class<?>> getTypeMapping() {
        return this.typeMapping;
    }
}

