/*
 * Decompiled with CFR 0.152.
 */
package cn.mybatis.mp.generator.template.engine;

import cn.mybatis.mp.generator.template.ITemplateBuilder;
import cn.mybatis.mp.generator.template.engine.EngineUtil;
import cn.mybatis.mp.generator.template.engine.TemplateEngine;
import freemarker.core.OutputFormat;
import freemarker.core.PlainTextOutputFormat;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateModelException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class FreemarkerTemplateEngine
implements TemplateEngine {
    private Configuration configuration = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);

    public FreemarkerTemplateEngine() {
        this.configuration.setDefaultEncoding("UTF-8");
        this.configuration.setOutputFormat((OutputFormat)PlainTextOutputFormat.INSTANCE);
        this.configuration.setClassForTemplateLoading(FreemarkerTemplateEngine.class, "/");
        try {
            this.configuration.setSharedVariable("util", (Object)new EngineUtil());
        }
        catch (TemplateModelException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void render(ITemplateBuilder templateBuilder) {
        try {
            Template template = this.configuration.getTemplate(templateBuilder.templateFilePath() + ".ftl");
            File outputFile = new File(templateBuilder.targetFilePath());
            if (!outputFile.exists()) {
                outputFile.getParentFile().mkdirs();
                outputFile.createNewFile();
            }
            try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);){
                template.process(templateBuilder.contextData(), (Writer)new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
            }
            catch (Exception e) {
                outputFile.delete();
                throw new RuntimeException(e);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

