/*
 * Decompiled with CFR 0.152.
 */
package cn.mybatis.mp.generator;

import cn.mybatis.mp.generator.config.GeneratorConfig;
import cn.mybatis.mp.generator.database.meta.EntityInfo;
import cn.mybatis.mp.generator.database.meta.TableInfo;
import cn.mybatis.mp.generator.database.meta.TableMetaDataQuery;
import cn.mybatis.mp.generator.template.ITemplateBuilder;
import cn.mybatis.mp.generator.template.engine.FreemarkerTemplateEngine;
import cn.mybatis.mp.generator.template.engine.TemplateEngine;
import cn.mybatis.mp.generator.util.RuntimeUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class FastGenerator {
    private final GeneratorConfig generatorConfig;

    public FastGenerator(GeneratorConfig generatorConfig) {
        this.generatorConfig = generatorConfig;
    }

    public void create() {
        List entityInfoList;
        try {
            Connection connection = this.generatorConfig.getDataBaseConfig().getConnection();
            Object object = null;
            try {
                TableMetaDataQuery tableMetaDataQuery = new TableMetaDataQuery(this.generatorConfig, connection);
                List<TableInfo> tableInfoList = tableMetaDataQuery.getTableInfoList(!this.generatorConfig.isIgnoreTable(), !this.generatorConfig.isIgnoreView());
                if (!this.generatorConfig.getTableConfig().getExcludeTables().isEmpty() || !this.generatorConfig.getTableConfig().getIncludeTables().isEmpty()) {
                    tableInfoList = tableInfoList.stream().filter(tableInfo -> !this.generatorConfig.getTableConfig().getExcludeTables().stream().anyMatch(item -> item.equalsIgnoreCase(tableInfo.getName()) || Pattern.matches(item, tableInfo.getName().toLowerCase()))).filter(tableInfo -> this.generatorConfig.getTableConfig().getIncludeTables().stream().anyMatch(item -> item.equalsIgnoreCase(tableInfo.getName()) || Pattern.matches(item, tableInfo.getName().toLowerCase()))).collect(Collectors.toList());
                }
                entityInfoList = tableInfoList.stream().map(item -> new EntityInfo(this.generatorConfig, (TableInfo)item)).collect(Collectors.toList());
            }
            catch (Throwable tableMetaDataQuery) {
                object = tableMetaDataQuery;
                throw tableMetaDataQuery;
            }
            finally {
                if (connection != null) {
                    if (object != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable tableMetaDataQuery) {
                            ((Throwable)object).addSuppressed(tableMetaDataQuery);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        TemplateEngine templateEngine = this.generatorConfig.getTemplateEngine();
        templateEngine = templateEngine == null ? new FreemarkerTemplateEngine() : templateEngine;
        for (EntityInfo entityInfo : entityInfoList) {
            for (Class<? extends ITemplateBuilder> templateBuilderClass : this.generatorConfig.getTemplateBuilders()) {
                ITemplateBuilder templateBuilder = null;
                try {
                    templateBuilder = templateBuilderClass.getConstructor(GeneratorConfig.class, EntityInfo.class).newInstance(this.generatorConfig, entityInfo);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (!templateBuilder.enable()) continue;
                templateEngine.render(templateBuilder);
            }
        }
        if (this.generatorConfig.isFinishOpen()) {
            RuntimeUtils.openDir(this.generatorConfig.getBaseFilePath());
        }
    }
}

