/*
 * Decompiled with CFR 0.152.
 */
package cn.mybatis.mp.generator.database.meta;

import cn.mybatis.mp.core.util.NamingUtil;
import cn.mybatis.mp.generator.config.GeneratorConfig;
import cn.mybatis.mp.generator.database.meta.ColumnInfo;
import cn.mybatis.mp.generator.database.meta.EntityInfo;
import cn.mybatis.mp.generator.util.GeneratorUtil;

public class EntityFieldInfo {
    private final EntityInfo entityInfo;
    private final ColumnInfo columnInfo;
    private final String name;
    private final Class<?> type;
    private final String typeName;
    private final String remarks;
    private final boolean select;
    private final boolean update;
    private final String defaultTableIdCode;

    public EntityFieldInfo(GeneratorConfig generatorConfig, EntityInfo entityInfo, ColumnInfo columnInfo) {
        this.entityInfo = entityInfo;
        this.columnInfo = columnInfo;
        this.update = !generatorConfig.getColumnConfig().getDisableUpdateColumns().contains(columnInfo.getName());
        this.name = GeneratorUtil.getEntityFieldName(generatorConfig, columnInfo);
        this.remarks = GeneratorUtil.getEntityFieldRemarks(generatorConfig, columnInfo);
        this.type = GeneratorUtil.getColumnType(generatorConfig, columnInfo);
        this.select = this.type == byte[].class ? false : !generatorConfig.getColumnConfig().getDisableSelectColumns().contains(columnInfo.getName());
        this.typeName = this.type.getSimpleName();
        this.defaultTableIdCode = generatorConfig.getEntityConfig().getDefaultTableIdCode();
    }

    public boolean isNeedTableFiled() {
        return !this.select || !this.update;
    }

    public String buildTableField() {
        StringBuilder stringBuilder = new StringBuilder("@TableField(");
        if (!this.select) {
            stringBuilder.append("select = false,");
        }
        if (!this.update) {
            stringBuilder.append("update = false,");
        }
        stringBuilder = stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String getterMethodName() {
        return (this.type == Boolean.class ? "is" : "get") + NamingUtil.firstToUpperCase((String)this.name);
    }

    public String setterMethodName() {
        return "set" + NamingUtil.firstToUpperCase((String)this.name);
    }

    public String buildTableIdCode() {
        if (!this.columnInfo.isPrimaryKey()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder("@TableId");
        if (this.columnInfo.isAutoIncrement()) {
            stringBuilder.append("(IdAutoType.AUTO)");
        } else {
            if (this.defaultTableIdCode != null) {
                return this.defaultTableIdCode;
            }
            stringBuilder.append("(IdAutoType.NONE)");
        }
        return stringBuilder.toString();
    }

    public EntityInfo getEntityInfo() {
        return this.entityInfo;
    }

    public ColumnInfo getColumnInfo() {
        return this.columnInfo;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public boolean isSelect() {
        return this.select;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public String getDefaultTableIdCode() {
        return this.defaultTableIdCode;
    }

    public String toString() {
        return "EntityFieldInfo(columnInfo=" + this.getColumnInfo() + ", name=" + this.getName() + ", type=" + this.getType() + ", typeName=" + this.getTypeName() + ", remarks=" + this.getRemarks() + ", select=" + this.isSelect() + ", update=" + this.isUpdate() + ", defaultTableIdCode=" + this.getDefaultTableIdCode() + ")";
    }
}

