/*
 * Decompiled with CFR 0.152.
 */
package cn.mybatis.mp.generator.template;

import cn.mybatis.mp.generator.config.GeneratorConfig;
import cn.mybatis.mp.generator.database.meta.EntityInfo;
import cn.mybatis.mp.generator.template.AbstractTemplateBuilder;
import cn.mybatis.mp.generator.util.GeneratorUtil;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

public class DaoTemplateBuilder
extends AbstractTemplateBuilder {
    public DaoTemplateBuilder(GeneratorConfig generatorConfig, EntityInfo entityInfo) {
        super(generatorConfig, entityInfo);
    }

    @Override
    public boolean enable() {
        return this.generatorConfig.getDaoConfig().isEnable();
    }

    @Override
    public String targetFilePath() {
        return this.generatorConfig.getBaseFilePath() + "/" + (this.entityInfo.getDaoPackage() + "." + this.entityInfo.getDaoName()).replaceAll("\\.", "/") + ".java";
    }

    @Override
    public String templateFilePath() {
        return this.generatorConfig.getTemplateRootPath() + "/dao";
    }

    @Override
    public Map<String, Object> contextData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("imports", GeneratorUtil.buildDaoImports(this.generatorConfig, this.entityInfo));
        if (this.generatorConfig.getDaoConfig().getSuperClass() != null) {
            int dotIndex = this.generatorConfig.getDaoConfig().getSuperClass().lastIndexOf(".");
            String superName = dotIndex > 0 ? this.generatorConfig.getDaoConfig().getSuperClass().substring(dotIndex + 1) : this.generatorConfig.getDaoConfig().getSuperClass();
            data.put("superExtend", "extends " + superName);
        } else {
            data.put("superExtend", "");
        }
        data.put("date", LocalDate.now().toString());
        data.put("author", this.generatorConfig.getAuthor());
        data.put("entityInfo", this.entityInfo);
        data.put("daoConfig", this.generatorConfig.getDaoConfig());
        return data;
    }
}

