/*
 * Decompiled with CFR 0.152.
 */
package cn.mybatis.mp.generator.database.meta;

import cn.mybatis.mp.generator.config.GeneratorConfig;
import cn.mybatis.mp.generator.database.meta.ColumnInfo;
import cn.mybatis.mp.generator.database.meta.TableInfo;
import db.sql.api.DbType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ibatis.type.JdbcType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableMetaDataQuery {
    private static final Logger log = LoggerFactory.getLogger(TableMetaDataQuery.class);
    protected final DatabaseMetaData metaData;
    protected final GeneratorConfig generatorConfig;
    protected final String connDatabaseName;

    public TableMetaDataQuery(GeneratorConfig generatorConfig, Connection connection) throws SQLException {
        this.metaData = connection.getMetaData();
        this.generatorConfig = generatorConfig;
        this.connDatabaseName = connection.getCatalog();
    }

    public List<TableInfo> getTableInfoList(boolean includeTable, boolean includeView) {
        String schema;
        HashSet<String> types = new HashSet<String>();
        if (includeTable) {
            types.add("TABLE");
        }
        if (includeView) {
            types.add("VIEW");
        }
        ArrayList<TableInfo> tables = new ArrayList<TableInfo>();
        String databaseName = this.generatorConfig.getDataBaseConfig().getDatabaseName();
        if (databaseName == null) {
            databaseName = this.connDatabaseName;
        }
        if ((schema = this.generatorConfig.getDataBaseConfig().getSchema()) == null && this.generatorConfig.getDataBaseConfig().getDbType() == DbType.H2) {
            schema = "PUBLIC";
        }
        try (ResultSet resultSet = this.metaData.getTables(databaseName, schema, null, types.toArray(new String[2]));){
            while (resultSet.next()) {
                String TABLE_NAME = resultSet.getString("TABLE_NAME");
                String tableName = TABLE_NAME;
                if (tableName.toUpperCase().equals(tableName)) {
                    tableName = tableName.toLowerCase();
                }
                TableInfo tableInfo = new TableInfo();
                tableInfo.setName(tableName);
                tableInfo.setRemarks(resultSet.getString("REMARKS"));
                tableInfo.setTableType(resultSet.getString("TABLE_TYPE"));
                tableInfo.setSchema(resultSet.getString("TABLE_SCHEM"));
                tableInfo.setCatalog(resultSet.getString("TABLE_CAT"));
                tableInfo.setColumnInfoList(this.getColumnInfo(tableInfo, TABLE_NAME));
                List idColumnInfoList = tableInfo.getColumnInfoList().stream().filter(item -> item.isPrimaryKey()).collect(Collectors.toList());
                if (!idColumnInfoList.isEmpty()) {
                    tableInfo.setIdColumnInfo((ColumnInfo)idColumnInfoList.get(0));
                }
                tables.add(tableInfo);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("\u8bfb\u53d6\u6570\u636e\u5e93\u8868\u4fe1\u606f\u51fa\u73b0\u9519\u8bef", e);
        }
        return tables;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<ColumnInfo> getColumnInfo(TableInfo tableInfo, String tableName) {
        HashSet<String> primaryKeys = new HashSet<String>();
        if (!tableInfo.isView()) {
            try (ResultSet primaryKeysResultSet = this.metaData.getPrimaryKeys(tableInfo.getCatalog(), tableInfo.getSchema(), tableName);){
                while (primaryKeysResultSet.next()) {
                    String columnName = primaryKeysResultSet.getString("COLUMN_NAME");
                    if (columnName.toUpperCase().equals(columnName)) {
                        columnName = columnName.toLowerCase();
                    }
                    primaryKeys.add(columnName);
                }
            }
            catch (SQLException e) {
                throw new RuntimeException("\u8bfb\u53d6\u8868\u4e3b\u952e\u4fe1\u606f:" + tableInfo.getName() + "\u9519\u8bef:", e);
            }
        }
        if (primaryKeys.size() > 1) {
            log.warn("\u5f53\u524d\u8868:{}\uff0c\u5b58\u5728\u591a\u4e3b\u952e\u60c5\u51b5\uff01", (Object)tableInfo.getName());
        }
        ArrayList<ColumnInfo> columnsInfoList = new ArrayList<ColumnInfo>();
        try (ResultSet resultSet = this.metaData.getColumns(tableInfo.getCatalog(), tableInfo.getSchema(), tableName, "%");){
            while (resultSet.next()) {
                String columnName = resultSet.getString("COLUMN_NAME");
                if (columnName.toUpperCase().equals(columnName)) {
                    columnName = columnName.toLowerCase();
                }
                ColumnInfo columnInfo = new ColumnInfo();
                columnInfo.setTableInfo(tableInfo);
                columnInfo.setName(columnName);
                columnInfo.setPrimaryKey(primaryKeys.contains(columnInfo.getName()));
                columnInfo.setTypeName(resultSet.getString("TYPE_NAME"));
                columnInfo.setJdbcType(JdbcType.forCode((int)resultSet.getInt("DATA_TYPE")));
                columnInfo.setLength(resultSet.getInt("COLUMN_SIZE"));
                columnInfo.setScale(resultSet.getInt("DECIMAL_DIGITS"));
                columnInfo.setRemarks(resultSet.getString("REMARKS"));
                columnInfo.setDefaultValue(this.generatorConfig.getColumnConfig().getDefaultValueConvert().apply(resultSet.getString("COLUMN_DEF")));
                columnInfo.setNullable(resultSet.getInt("NULLABLE") == 1);
                columnInfo.setVersion(columnName.equals(this.generatorConfig.getColumnConfig().getVersionColumn()));
                columnInfo.setTenantId(columnName.equals(this.generatorConfig.getColumnConfig().getTenantIdColumn()));
                columnInfo.setLogicDelete(columnName.equals(this.generatorConfig.getColumnConfig().getLogicDeleteColumn()));
                try {
                    columnInfo.setAutoIncrement("YES".equals(resultSet.getString("IS_AUTOINCREMENT")));
                }
                catch (SQLException e) {
                    log.error("\u83b7\u53d6\u81ea\u589e\u4fe1\u606f\u5f02\u5e38\uff1a", (Throwable)e);
                }
                columnsInfoList.add(columnInfo);
            }
            ArrayList<ColumnInfo> arrayList = columnsInfoList;
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException("\u8bfb\u53d6\u8868\u5b57\u6bb5\u4fe1\u606f:" + tableInfo.getName() + "\u9519\u8bef:", e);
        }
    }
}

