/*
 * Decompiled with CFR 0.152.
 */
package cn.mybatis.mp.generator.template;

import cn.mybatis.mp.generator.config.GeneratorConfig;
import cn.mybatis.mp.generator.database.meta.EntityInfo;
import cn.mybatis.mp.generator.template.AbstractTemplateBuilder;
import cn.mybatis.mp.generator.util.GeneratorUtil;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

public class DaoImplTemplateBuilder
extends AbstractTemplateBuilder {
    public DaoImplTemplateBuilder(GeneratorConfig generatorConfig, EntityInfo entityInfo) {
        super(generatorConfig, entityInfo);
    }

    @Override
    public boolean enable() {
        return this.generatorConfig.getDaoConfig().isEnable();
    }

    @Override
    public String targetFilePath() {
        return this.generatorConfig.getBaseFilePath() + "/" + (this.entityInfo.getDaoImplPackage() + "." + this.entityInfo.getDaoImplName()).replaceAll("\\.", "/") + ".java";
    }

    @Override
    public String templateFilePath() {
        return this.generatorConfig.getTemplateRootPath() + "/dao.impl";
    }

    @Override
    public Map<String, Object> contextData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        GeneratorUtil.buildDaoImplImports(this.generatorConfig, this.entityInfo, data);
        if (this.generatorConfig.getDaoImplConfig().getSuperClass() != null) {
            int dotIndex = this.generatorConfig.getDaoImplConfig().getSuperClass().lastIndexOf(".");
            String superName = dotIndex > 0 ? this.generatorConfig.getDaoImplConfig().getSuperClass().substring(dotIndex + 1) : this.generatorConfig.getDaoImplConfig().getSuperClass();
            data.put("superExtend", "extends " + superName);
        } else {
            data.put("superExtend", "");
        }
        data.put("date", LocalDate.now().toString());
        data.put("author", this.generatorConfig.getAuthor());
        data.put("entityInfo", this.entityInfo);
        data.put("daoConfig", this.generatorConfig.getDaoConfig());
        data.put("daoImplConfig", this.generatorConfig.getDaoImplConfig());
        data.put("containerType", (Object)this.generatorConfig.getContainerType());
        return data;
    }
}

