/*
 * Decompiled with CFR 0.152.
 */
package cn.mybatis.mp.generator.template;

import cn.mybatis.mp.generator.config.GeneratorConfig;
import cn.mybatis.mp.generator.database.meta.EntityInfo;
import cn.mybatis.mp.generator.template.AbstractTemplateBuilder;
import cn.mybatis.mp.generator.util.GeneratorUtil;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

public class EntityTemplateBuilder
extends AbstractTemplateBuilder {
    public EntityTemplateBuilder(GeneratorConfig generatorConfig, EntityInfo entityInfo) {
        super(generatorConfig, entityInfo);
    }

    @Override
    public String targetFilePath() {
        return this.generatorConfig.getBaseFilePath() + "/" + (this.entityInfo.getEntityPackage() + "." + this.entityInfo.getName()).replaceAll("\\.", "/") + ".java";
    }

    @Override
    public String templateFilePath() {
        return this.generatorConfig.getTemplateRootPath() + "/entity";
    }

    @Override
    public Map<String, Object> contextData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("imports", GeneratorUtil.buildEntityImports(this.generatorConfig, this.entityInfo));
        if (this.generatorConfig.getEntityConfig().getSuperClass() != null) {
            int dotIndex = this.generatorConfig.getEntityConfig().getSuperClass().lastIndexOf(".");
            String superName = dotIndex > 0 ? this.generatorConfig.getEntityConfig().getSuperClass().substring(dotIndex + 1) : this.generatorConfig.getEntityConfig().getSuperClass();
            data.put("superExtend", "extends " + superName);
        } else {
            data.put("superExtend", "");
        }
        data.put("package", this.entityInfo.getEntityPackage());
        data.put("date", LocalDate.now().toString());
        data.put("author", this.generatorConfig.getAuthor());
        data.put("entityInfo", this.entityInfo);
        data.put("entityConfig", this.generatorConfig.getEntityConfig());
        data.put("generatorConfig", this.generatorConfig);
        return data;
    }
}

