/*
 * Decompiled with CFR 0.152.
 */
package cn.mybatis.mp.generator.template;

import cn.mybatis.mp.generator.config.GeneratorConfig;
import cn.mybatis.mp.generator.database.meta.EntityInfo;
import cn.mybatis.mp.generator.template.AbstractTemplateBuilder;
import cn.mybatis.mp.generator.util.GeneratorUtil;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

public class MapperTemplateBuilder
extends AbstractTemplateBuilder {
    public MapperTemplateBuilder(GeneratorConfig generatorConfig, EntityInfo entityInfo) {
        super(generatorConfig, entityInfo);
    }

    @Override
    public String targetFilePath() {
        return this.generatorConfig.getBaseFilePath() + "/" + (this.entityInfo.getMapperPackage() + "." + this.entityInfo.getMapperName()).replaceAll("\\.", "/") + ".java";
    }

    @Override
    public String templateFilePath() {
        return this.generatorConfig.getTemplateRootPath() + "/mapper";
    }

    @Override
    public Map<String, Object> contextData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("imports", GeneratorUtil.buildMapperImports(this.generatorConfig, this.entityInfo));
        if (this.generatorConfig.getMapperConfig().getSuperClass() != null) {
            int dotIndex = this.generatorConfig.getMapperConfig().getSuperClass().lastIndexOf(".");
            String superName = dotIndex > 0 ? this.generatorConfig.getMapperConfig().getSuperClass().substring(dotIndex + 1) : this.generatorConfig.getMapperConfig().getSuperClass();
            data.put("superExtend", "extends " + superName);
        } else {
            data.put("superExtend", "");
        }
        data.put("date", LocalDate.now().toString());
        data.put("author", this.generatorConfig.getAuthor());
        data.put("entityInfo", this.entityInfo);
        data.put("mapperConfig", this.generatorConfig.getMapperConfig());
        data.put("containerType", (Object)this.generatorConfig.getContainerType());
        return data;
    }
}

