/*
 * Decompiled with CFR 0.152.
 */
package cn.mybatis.mp.generator.template;

import cn.mybatis.mp.generator.config.GeneratorConfig;
import cn.mybatis.mp.generator.database.meta.EntityInfo;
import cn.mybatis.mp.generator.template.AbstractTemplateBuilder;
import cn.mybatis.mp.generator.util.GeneratorUtil;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

public class ServiceTemplateBuilder
extends AbstractTemplateBuilder {
    public ServiceTemplateBuilder(GeneratorConfig generatorConfig, EntityInfo entityInfo) {
        super(generatorConfig, entityInfo);
    }

    @Override
    public boolean enable() {
        return this.generatorConfig.getServiceConfig().isEnable();
    }

    @Override
    public String targetFilePath() {
        return this.generatorConfig.getBaseFilePath() + "/" + (this.entityInfo.getServicePackage() + "." + this.entityInfo.getServiceName()).replaceAll("\\.", "/") + ".java";
    }

    @Override
    public String templateFilePath() {
        return this.generatorConfig.getTemplateRootPath() + "/service";
    }

    @Override
    public Map<String, Object> contextData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("imports", GeneratorUtil.buildServiceImports(this.generatorConfig, this.entityInfo));
        if (this.generatorConfig.getServiceConfig().getSuperClass() != null) {
            int dotIndex = this.generatorConfig.getServiceConfig().getSuperClass().lastIndexOf(".");
            String superName = dotIndex > 0 ? this.generatorConfig.getServiceConfig().getSuperClass().substring(dotIndex + 1) : this.generatorConfig.getServiceConfig().getSuperClass();
            data.put("superExtend", "extends " + superName);
        } else {
            data.put("superExtend", "");
        }
        data.put("date", LocalDate.now().toString());
        data.put("author", this.generatorConfig.getAuthor());
        data.put("entityInfo", this.entityInfo);
        data.put("daoConfig", this.generatorConfig.getDaoConfig());
        data.put("serviceConfig", this.generatorConfig.getServiceConfig());
        data.put("containerType", (Object)this.generatorConfig.getContainerType());
        return data;
    }
}

