/*
 * Decompiled with CFR 0.152.
 */
package cn.mybatis.mp.generator.util;

import cn.mybatis.mp.core.mybatis.mapper.context.Pager;
import cn.mybatis.mp.core.sql.executor.chain.DeleteChain;
import cn.mybatis.mp.core.sql.executor.chain.InsertChain;
import cn.mybatis.mp.core.sql.executor.chain.QueryChain;
import cn.mybatis.mp.core.sql.executor.chain.UpdateChain;
import cn.mybatis.mp.core.util.NamingUtil;
import cn.mybatis.mp.db.IdAutoType;
import cn.mybatis.mp.db.annotations.LogicDelete;
import cn.mybatis.mp.db.annotations.Table;
import cn.mybatis.mp.db.annotations.TableField;
import cn.mybatis.mp.db.annotations.TableId;
import cn.mybatis.mp.db.annotations.TenantId;
import cn.mybatis.mp.db.annotations.Version;
import cn.mybatis.mp.generator.config.ContainerType;
import cn.mybatis.mp.generator.config.EntityConfig;
import cn.mybatis.mp.generator.config.GeneratorConfig;
import cn.mybatis.mp.generator.database.meta.ColumnInfo;
import cn.mybatis.mp.generator.database.meta.EntityInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Data;
import org.apache.ibatis.annotations.Mapper;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Delete;
import org.noear.solon.annotation.Get;
import org.noear.solon.annotation.Init;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Post;
import org.noear.solon.core.handle.MethodType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

public class GeneratorUtil {
    public static String getEntityName(GeneratorConfig generatorConfig, String tableName) {
        EntityConfig entityConfig = generatorConfig.getEntityConfig();
        if (entityConfig.getNameConvert() == null) {
            entityConfig.nameConvert(table -> NamingUtil.firstToUpperCase((String)NamingUtil.underlineToCamel((String)table)));
        }
        return entityConfig.getNameConvert().apply(tableName);
    }

    public static String getEntityFieldName(GeneratorConfig generatorConfig, ColumnInfo columnInfo) {
        EntityConfig entityConfig = generatorConfig.getEntityConfig();
        if (entityConfig.getFieldNameConverter() == null) {
            return entityConfig.getFieldNamingStrategy().getName(columnInfo.getName(), false);
        }
        return entityConfig.getFieldNameConverter().apply(columnInfo);
    }

    public static String getEntityFieldRemarks(GeneratorConfig generatorConfig, ColumnInfo columnInfo) {
        EntityConfig entityConfig = generatorConfig.getEntityConfig();
        if (entityConfig.getRemarksConverter() == null) {
            return columnInfo.getRemarks();
        }
        return entityConfig.getRemarksConverter().apply(columnInfo);
    }

    public static Class<?> getColumnType(GeneratorConfig generatorConfig, ColumnInfo columnInfo) {
        Class<?> type = generatorConfig.getEntityConfig().getTypeMapping().get(columnInfo.getJdbcType());
        if (type == null) {
            return Object.class;
        }
        return type;
    }

    public static List<String> buildEntityImports(GeneratorConfig generatorConfig, EntityInfo entityInfo) {
        ArrayList<String> classList = new ArrayList<String>();
        classList.add(Table.class.getName());
        if (entityInfo.getIdFieldInfo() != null) {
            classList.add(TableId.class.getName());
            classList.add(IdAutoType.class.getName());
        }
        if (generatorConfig.getEntityConfig().getSuperClass() != null) {
            classList.add(generatorConfig.getEntityConfig().getSuperClass());
        }
        if (generatorConfig.getEntityConfig().isLombok()) {
            classList.add(Data.class.getName());
        }
        entityInfo.getFieldInfoList().forEach(item -> {
            classList.add(item.getType().getName());
            if (item.isNeedTableField()) {
                classList.add(TableField.class.getName());
            }
            if (item.getColumnInfo().isVersion()) {
                classList.add(Version.class.getName());
            } else if (item.getColumnInfo().isTenantId()) {
                classList.add(TenantId.class.getName());
            } else if (item.getColumnInfo().isLogicDelete()) {
                classList.add(LogicDelete.class.getName());
            }
        });
        return GeneratorUtil.buildImports(classList);
    }

    public static List<String> buildMapperImports(GeneratorConfig generatorConfig, EntityInfo entityInfo) {
        ArrayList<String> classList = new ArrayList<String>();
        if (generatorConfig.getMapperConfig().getSuperClass() != null) {
            classList.add(generatorConfig.getMapperConfig().getSuperClass());
        }
        if (generatorConfig.getMapperConfig().isMapperAnnotation()) {
            classList.add(Mapper.class.getName());
        }
        classList.add(entityInfo.getEntityPackage() + "." + entityInfo.getName());
        return GeneratorUtil.buildImports(classList);
    }

    public static List<String> buildDaoImports(GeneratorConfig generatorConfig, EntityInfo entityInfo) {
        ArrayList<String> classList = new ArrayList<String>();
        if (generatorConfig.getDaoConfig().getSuperClass() != null) {
            classList.add(generatorConfig.getDaoConfig().getSuperClass());
        }
        classList.add(entityInfo.getEntityPackage() + "." + entityInfo.getName());
        if (entityInfo.getIdFieldInfo() != null) {
            classList.add(entityInfo.getIdFieldInfo().getType().getName());
        }
        return GeneratorUtil.buildImports(classList);
    }

    public static void buildDaoImplImports(GeneratorConfig generatorConfig, EntityInfo entityInfo, Map<String, Object> data) {
        ArrayList<String> classList = new ArrayList<String>();
        if (generatorConfig.getDaoImplConfig().getSuperClass() != null) {
            classList.add(generatorConfig.getDaoImplConfig().getSuperClass());
        }
        classList.add(entityInfo.getEntityPackage() + "." + entityInfo.getName());
        if (entityInfo.getIdFieldInfo() != null) {
            classList.add(entityInfo.getIdFieldInfo().getType().getName());
        }
        classList.add(entityInfo.getMapperPackage() + "." + entityInfo.getMapperName());
        classList.add(entityInfo.getDaoPackage() + "." + entityInfo.getDaoName());
        if (generatorConfig.getContainerType() == ContainerType.SPRING) {
            classList.add(Repository.class.getName());
            classList.add(Autowired.class.getName());
            data.put("repositoryAnnotationName", Repository.class.getSimpleName());
            data.put("autowiredAnnotationName", Autowired.class.getSimpleName());
        } else if (generatorConfig.getContainerType() == ContainerType.SOLON) {
            classList.add(Component.class.getName());
            classList.add(Inject.class.getName());
            classList.add(Init.class.getName());
            data.put("repositoryAnnotationName", Component.class.getSimpleName());
            data.put("autowiredAnnotationName", Inject.class.getSimpleName());
        }
        data.put("imports", GeneratorUtil.buildImports(classList));
    }

    public static List<String> buildServiceImports(GeneratorConfig generatorConfig, EntityInfo entityInfo) {
        ArrayList<String> classList = new ArrayList<String>();
        if (generatorConfig.getServiceConfig().getSuperClass() != null) {
            classList.add(generatorConfig.getServiceConfig().getSuperClass());
        }
        classList.add(entityInfo.getEntityPackage() + "." + entityInfo.getName());
        if (entityInfo.getIdFieldInfo() != null) {
            classList.add(entityInfo.getIdFieldInfo().getType().getName());
        }
        return GeneratorUtil.buildImports(classList);
    }

    public static void buildServiceImplImports(GeneratorConfig generatorConfig, EntityInfo entityInfo, Map<String, Object> data) {
        ArrayList<String> classList = new ArrayList<String>();
        if (generatorConfig.getServiceImplConfig().getSuperClass() != null) {
            classList.add(generatorConfig.getServiceImplConfig().getSuperClass());
        }
        classList.add(entityInfo.getEntityPackage() + "." + entityInfo.getName());
        if (entityInfo.getIdFieldInfo() != null) {
            classList.add(entityInfo.getIdFieldInfo().getType().getName());
        }
        classList.add(entityInfo.getDaoPackage() + "." + entityInfo.getDaoName());
        classList.add(entityInfo.getServicePackage() + "." + entityInfo.getServiceName());
        if (generatorConfig.getServiceImplConfig().isInjectMapper() || !generatorConfig.getServiceImplConfig().isInjectDao()) {
            classList.add(entityInfo.getMapperPackage() + "." + entityInfo.getMapperName());
            classList.add(QueryChain.class.getName());
            classList.add(UpdateChain.class.getName());
            classList.add(InsertChain.class.getName());
            classList.add(DeleteChain.class.getName());
        }
        if (generatorConfig.getContainerType() == ContainerType.SPRING) {
            classList.add(Service.class.getName());
            classList.add(Autowired.class.getName());
            data.put("serviceAnnotationName", Service.class.getSimpleName());
            data.put("autowiredAnnotationName", Autowired.class.getSimpleName());
        } else if (generatorConfig.getContainerType() == ContainerType.SOLON) {
            classList.add(Component.class.getName());
            classList.add(Inject.class.getName());
            data.put("serviceAnnotationName", Component.class.getSimpleName());
            data.put("autowiredAnnotationName", Inject.class.getSimpleName());
        }
        data.put("imports", GeneratorUtil.buildImports(classList));
    }

    public static void buildActionImports(GeneratorConfig generatorConfig, EntityInfo entityInfo, Map<String, Object> data) {
        ArrayList<String> classList = new ArrayList<String>();
        if (generatorConfig.getActionConfig().getSuperClass() != null) {
            classList.add(generatorConfig.getActionConfig().getSuperClass());
        }
        if (generatorConfig.getActionConfig().getReturnClass() != null) {
            classList.add(generatorConfig.getActionConfig().getReturnClass());
        }
        classList.add(entityInfo.getEntityPackage() + "." + entityInfo.getName());
        if (entityInfo.getIdFieldInfo() != null) {
            classList.add(entityInfo.getIdFieldInfo().getType().getName());
        }
        classList.add(entityInfo.getServicePackage() + "." + entityInfo.getServiceName());
        if (generatorConfig.getContainerType() == ContainerType.SPRING) {
            classList.add(RestController.class.getName());
            classList.add(RequestMapping.class.getName());
            classList.add(Autowired.class.getName());
            data.put("controllerAnnotationName", RestController.class.getSimpleName());
            data.put("requestMappingAnnotationName", RequestMapping.class.getSimpleName());
            data.put("autowiredAnnotationName", Autowired.class.getSimpleName());
        } else if (generatorConfig.getContainerType() == ContainerType.SOLON) {
            classList.add(Controller.class.getName());
            classList.add(Mapping.class.getName());
            classList.add(MethodType.class.getName());
            classList.add(Inject.class.getName());
            data.put("controllerAnnotationName", Controller.class.getSimpleName());
            data.put("requestMappingAnnotationName", Mapping.class.getSimpleName());
            data.put("autowiredAnnotationName", Inject.class.getSimpleName());
        }
        if (generatorConfig.getActionConfig().isSave() || generatorConfig.getActionConfig().isUpdate()) {
            if (generatorConfig.getContainerType() == ContainerType.SPRING) {
                classList.add(PostMapping.class.getName());
                data.put("postMappingAnnotationName", PostMapping.class.getSimpleName());
            } else {
                classList.add(Post.class.getName());
                classList.add(Mapping.class.getName());
                classList.add(MethodType.class.getName());
                data.put("postMappingAnnotationName", Mapping.class.getSimpleName());
            }
        }
        if (generatorConfig.getActionConfig().isGetById() || generatorConfig.getActionConfig().isFind()) {
            if (generatorConfig.getActionConfig().isFind()) {
                classList.add(Pager.class.getName());
            }
            if (generatorConfig.getContainerType() == ContainerType.SPRING) {
                classList.add(GetMapping.class.getName());
                data.put("getMappingAnnotationName", GetMapping.class.getSimpleName());
            } else {
                classList.add(Get.class.getName());
                classList.add(Mapping.class.getName());
                data.put("getMappingAnnotationName", Mapping.class.getSimpleName());
            }
        }
        if (generatorConfig.getActionConfig().isDeleteById()) {
            if (generatorConfig.getContainerType() == ContainerType.SPRING) {
                classList.add(DeleteMapping.class.getName());
                data.put("deleteMappingAnnotationName", DeleteMapping.class.getSimpleName());
            } else {
                classList.add(Delete.class.getName());
                classList.add(Mapping.class.getName());
                data.put("deleteMappingAnnotationName", Mapping.class.getSimpleName());
            }
        }
        data.put("imports", GeneratorUtil.buildImports(classList));
    }

    public static List<String> buildImports(List<String> classList) {
        return classList.stream().filter(item -> !item.startsWith("java.lang")).distinct().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
    }
}

