package cn.net.vidyo.framework.common.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

/**
 * 对象反射相关
 * User: 马生录（mason
 * Date: 14-3-19
 * Time: 上午9:18
 */
public class ReflectUtil {

    public static List<Field> findAllFields(Class entityClass, boolean includeParent){
        List<Field> list = new ArrayList<>();
        Field[] fields = entityClass.getFields();
        for (Field field : fields) {
            list.add(field);
        }
        return list;
    }
    public static Field getAllDeclaredFields(Class entityClass,String fileName, boolean includeParent){
        Field[] fields = entityClass.getDeclaredFields();
        for (Field field : fields) {
            if(field.getName().equalsIgnoreCase(fileName)){
                return field;
            }
        }
        if(includeParent){
            Class superclass = entityClass.getSuperclass();
            if(superclass!=null){
                return getAllDeclaredFields(superclass,fileName, includeParent);
            }
        }
        return null;
    }
    public static List<Field> findAllDeclaredFields(Class entityClass, boolean includeParent){
        List<Field> list = new ArrayList<>();
        Field[] fields = entityClass.getDeclaredFields();
        for (Field field : fields) {
            list.add(field);
        }
        if(includeParent){
            Class superclass = entityClass.getSuperclass();
            if(superclass!=null){
                List<Field> allDeclaredFields = findAllDeclaredFields(superclass, includeParent);
                list.addAll(allDeclaredFields);
            }
        }
        return list;
    }

    public static Type getGenericClassParameterizedType(Class classz){
        return getGenericClassParameterizedType(classz,0);
    }
    public static Type getGenericClassParameterizedType(Class classz, int index){
        Type type = classz.getGenericSuperclass();
        if(!(type instanceof ParameterizedType)){
            Class superclass = classz.getSuperclass();
            if(superclass!=null) {
                type = superclass.getGenericSuperclass();
            }
        }
        if(type instanceof ParameterizedType){
            return ((ParameterizedType)type).getActualTypeArguments()[index];
        }
        return null;
    }

    @SuppressWarnings("unchecked")
    public static Method getGetMethodByField(Class objectClass, String fieldName) {
        Field field = null;
        try {
            field = objectClass.getField(fieldName);
            if (field == null) {
                field = objectClass.getDeclaredField(fieldName);
            }
        } catch (NoSuchFieldException e) {
        }
        if (field == null) {
            try {
                field = objectClass.getDeclaredField(fieldName);
            } catch (NoSuchFieldException e) {
            }
        }
        if (field == null) {
            throw new IllegalArgumentException("not find field " + fieldName+" for class "+objectClass.toString());
        }
        return getGetMethodByField(objectClass, field);
    }

    public static Method getGetMethodByField(Class objectClass, Field field) {
        return getGetMethodByField(objectClass, field.getType(), field.getName());
    }

    public static Method getGetMethodByField(Class objectClass, Class fieldClass, String fieldName) {
        StringBuffer sb = new StringBuffer();

        if (fieldClass.equals(boolean.class) || fieldClass.equals(Boolean.class)) {
            sb.append("is");
        } else {
            sb.append("get");
        }
        sb.append(fieldName.substring(0, 1).toUpperCase());
        sb.append(fieldName.substring(1));
        try {
            return objectClass.getMethod(sb.toString());
        } catch (Exception e) {
        }
        return null;
    }

    /**
     * java反射bean的set方法
     *
     * @param objectClass
     * @param fieldName
     * @return 返回信息
     */
    @SuppressWarnings("unchecked")
    public static Method getSetMethodByField(Class objectClass, String fieldName) {
        try {
            Class[] parameterTypes = new Class[1];
            Field field = objectClass.getDeclaredField(fieldName);
            parameterTypes[0] = field.getType();
            StringBuffer sb = new StringBuffer();
            sb.append("set");
            sb.append(fieldName.substring(0, 1).toUpperCase());
            sb.append(fieldName.substring(1));
            Method method = objectClass.getMethod(sb.toString(), parameterTypes);
            return method;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 执行set方法
     *
     * @param o         执行对象
     * @param fieldName 属性
     * @param value     值
     */
    public static void invokeSetByField(Object o, String fieldName, Object value) {
        Method method = getSetMethodByField(o.getClass(), fieldName);
        try {
            method.invoke(o, new Object[]{value});
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 执行get方法
     *
     * @param o         执行对象
     * @param fieldName 属性
     */
    public static Object invokeGetByField(Object o, String fieldName) {
        Method method = getGetMethodByField(o.getClass(), fieldName);
        try {
            return method.invoke(o, new Object[0]);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }


    public static Annotation[] getClassAnnotations(Class<?> aClass) {
        return aClass.getAnnotations();
    }

    public static <ANNOTATION extends Annotation> ANNOTATION getClassAnnotation(Class<?> aClass, Class<ANNOTATION> annotationClass) {
        return aClass.getAnnotation(annotationClass);
    }

    public static Annotation[] getMethodAnnotations(Method method) {
        return method.getAnnotations();
    }

    public static <ANNOTATION extends Annotation> ANNOTATION getMethodAnnotation(Method method, Class<ANNOTATION> annotationClass) {
        return method.getAnnotation(annotationClass);
    }

    public static Annotation[] getFieldAnnotations(Field field) {
        return field.getAnnotations();
    }

    public static <ANNOTATION extends Annotation> ANNOTATION getFieldAnnotation(Field field, Class<ANNOTATION> annotationClass) {
        return field.getAnnotation(annotationClass);
    }
}
