/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.file;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.model.UnzipParameters;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.CompressionLevel;
import net.lingala.zip4j.model.enums.CompressionMethod;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import org.hy.common.ByteHelp;
import org.hy.common.Date;
import org.hy.common.ExpireMap;
import org.hy.common.Help;
import org.hy.common.Return;
import org.hy.common.StringHelp;
import org.hy.common.file.FileBiggerMemory;
import org.hy.common.file.FileDataPacket;
import org.hy.common.file.FileSerializable;
import org.hy.common.file.event.CreateCSVEvent;
import org.hy.common.file.event.CreateCSVListener;
import org.hy.common.file.event.CreateZipEvent;
import org.hy.common.file.event.CreateZipListener;
import org.hy.common.file.event.DefaultCreateCSVEvent;
import org.hy.common.file.event.DefaultCreateZipEvent;
import org.hy.common.file.event.DefaultFileCopyEvent;
import org.hy.common.file.event.DefaultFileReadEvent;
import org.hy.common.file.event.DefaultUnCompressZipEvent;
import org.hy.common.file.event.FileCopyEvent;
import org.hy.common.file.event.FileCopyListener;
import org.hy.common.file.event.FileReadEvent;
import org.hy.common.file.event.FileReadListener;
import org.hy.common.file.event.UnCompressZipEvent;
import org.hy.common.file.event.UnCompressZipListener;
import org.hy.common.xml.log.Logger;

public final class FileHelp {
    private static final Logger $Logger = new Logger(FileHelp.class);
    public static final int $Upload_GoOn = 0;
    public static final int $Upload_Finish = 1;
    public static final int $Upload_Error = -1;
    public static final int $Upload_ErrorCheck = -2;
    private static final ExpireMap<String, FileDataPacket> $DataPackets = new ExpireMap();
    private int bufferSize = 131072;
    private String newLine = "\r\n";
    private boolean isOverWrite = false;
    private boolean isAppend = false;
    private String charEncoding = "UTF-8";
    private String contentType = "application/json; charset=utf-8";
    private String csvDataPrefix = "=";
    private long dataPacketTimeOut = 600L;
    private boolean isReturnContent = true;
    private Collection<FileCopyListener> fileCopyListeners;
    private Collection<CreateCSVListener> createCSVListeners;
    private Collection<CreateZipListener> createZipListeners;
    private Collection<UnCompressZipListener> unCompressZipListeners;
    private Collection<FileReadListener> readListener;

    public void addReadListener(FileReadListener e) {
        if (this.readListener == null) {
            this.readListener = new HashSet<FileReadListener>();
        }
        this.readListener.add(e);
    }

    public void removeReadListener(FileReadListener e) {
        if (this.readListener == null) {
            return;
        }
        this.readListener.remove(e);
    }

    protected boolean fireReadBeforeListener(FileReadEvent i_Event) {
        if (this.readListener == null) {
            return true;
        }
        return this.notifyReadBeforeListeners(i_Event);
    }

    protected boolean fireReadingListener(FileReadEvent io_Event) {
        if (this.readListener == null) {
            return true;
        }
        return this.notifyReadingListeners(io_Event);
    }

    protected void fireReadAfterListener(FileReadEvent i_Event) {
        if (this.readListener == null) {
            return;
        }
        this.notifyReadAfterListeners(i_Event);
    }

    private boolean notifyReadBeforeListeners(FileReadEvent i_Event) {
        Iterator<FileReadListener> v_Iter = this.readListener.iterator();
        boolean v_IsContinue = true;
        while (v_IsContinue && v_Iter.hasNext()) {
            v_IsContinue = v_Iter.next().readBefore(i_Event);
        }
        return v_IsContinue;
    }

    private boolean notifyReadingListeners(FileReadEvent io_Event) {
        Iterator<FileReadListener> v_Iter = this.readListener.iterator();
        boolean v_IsContinue = true;
        while (v_IsContinue && v_Iter.hasNext()) {
            v_IsContinue = v_Iter.next().readProcess(io_Event);
        }
        return v_IsContinue;
    }

    private void notifyReadAfterListeners(FileReadEvent i_Event) {
        Iterator<FileReadListener> v_Iter = this.readListener.iterator();
        while (v_Iter.hasNext()) {
            v_Iter.next().readAfter(i_Event);
        }
    }

    public void addCopyListener(FileCopyListener e) {
        if (this.fileCopyListeners == null) {
            this.fileCopyListeners = new HashSet<FileCopyListener>();
        }
        this.fileCopyListeners.add(e);
    }

    public void removeCopyListener(FileCopyListener e) {
        if (this.fileCopyListeners == null) {
            return;
        }
        this.fileCopyListeners.remove(e);
    }

    protected boolean fireCopyBeforeListener(FileCopyEvent i_Event) {
        if (this.fileCopyListeners == null) {
            return true;
        }
        return this.notifyCopyBeforeListeners(i_Event);
    }

    protected boolean fireCopyingListener(FileCopyEvent i_Event) {
        if (this.fileCopyListeners == null) {
            return true;
        }
        return this.notifyCopyingListeners(i_Event);
    }

    protected void fireCopyAfterListener(FileCopyEvent i_Event) {
        if (this.fileCopyListeners == null) {
            return;
        }
        this.notifyCopyAfterListeners(i_Event);
    }

    private boolean notifyCopyBeforeListeners(FileCopyEvent i_Event) {
        Iterator<FileCopyListener> v_Iter = this.fileCopyListeners.iterator();
        boolean v_IsContinue = true;
        while (v_IsContinue && v_Iter.hasNext()) {
            v_IsContinue = v_Iter.next().copyBefore(i_Event);
        }
        return v_IsContinue;
    }

    private boolean notifyCopyingListeners(FileCopyEvent i_Event) {
        Iterator<FileCopyListener> v_Iter = this.fileCopyListeners.iterator();
        boolean v_IsContinue = true;
        while (v_IsContinue && v_Iter.hasNext()) {
            v_IsContinue = v_Iter.next().copyProcess(i_Event);
        }
        return v_IsContinue;
    }

    private void notifyCopyAfterListeners(FileCopyEvent i_Event) {
        Iterator<FileCopyListener> v_Iter = this.fileCopyListeners.iterator();
        while (v_Iter.hasNext()) {
            v_Iter.next().copyAfter(i_Event);
        }
    }

    public void addCreateCSVListener(CreateCSVListener e) {
        if (this.createCSVListeners == null) {
            this.createCSVListeners = new HashSet<CreateCSVListener>();
        }
        this.createCSVListeners.add(e);
    }

    public void removeCreateCSVListener(CreateCSVListener e) {
        if (this.createCSVListeners == null) {
            return;
        }
        this.createCSVListeners.remove(e);
    }

    protected boolean fireCreateCSVBeforeListener(CreateCSVEvent i_Event) {
        if (this.createCSVListeners == null) {
            return true;
        }
        return this.notifyCreateCSVBeforeListeners(i_Event);
    }

    protected boolean fireCreatingCSVListener(CreateCSVEvent i_Event) {
        if (this.createCSVListeners == null) {
            return true;
        }
        return this.notifyCreatingCSVListeners(i_Event);
    }

    protected void fireCreateCSVAfterListener(CreateCSVEvent i_Event) {
        if (this.createCSVListeners == null) {
            return;
        }
        this.notifyCreateCSVAfterListeners(i_Event);
    }

    private boolean notifyCreateCSVBeforeListeners(CreateCSVEvent i_Event) {
        Iterator<CreateCSVListener> v_Iter = this.createCSVListeners.iterator();
        boolean v_IsContinue = true;
        while (v_IsContinue && v_Iter.hasNext()) {
            v_IsContinue = v_Iter.next().createCSVBefore(i_Event);
        }
        return v_IsContinue;
    }

    private boolean notifyCreatingCSVListeners(CreateCSVEvent i_Event) {
        Iterator<CreateCSVListener> v_Iter = this.createCSVListeners.iterator();
        boolean v_IsContinue = true;
        while (v_IsContinue && v_Iter.hasNext()) {
            v_IsContinue = v_Iter.next().createCSVProcess(i_Event);
        }
        return v_IsContinue;
    }

    private void notifyCreateCSVAfterListeners(CreateCSVEvent i_Event) {
        Iterator<CreateCSVListener> v_Iter = this.createCSVListeners.iterator();
        while (v_Iter.hasNext()) {
            v_Iter.next().createCSVAfter(i_Event);
        }
    }

    public void addCreateZipListener(CreateZipListener e) {
        if (this.createZipListeners == null) {
            this.createZipListeners = new HashSet<CreateZipListener>();
        }
        this.createZipListeners.add(e);
    }

    public void removeCreateZipListener(CreateZipListener e) {
        if (this.createZipListeners == null) {
            return;
        }
        this.createZipListeners.remove(e);
    }

    protected boolean fireCreateZipBeforeListener(CreateZipEvent i_Event) {
        if (this.createZipListeners == null) {
            return true;
        }
        return this.notifyCreateZipBeforeListeners(i_Event);
    }

    protected boolean fireCreatingZipListener(CreateZipEvent i_Event) {
        if (this.createZipListeners == null) {
            return true;
        }
        return this.notifyCreatingZipListeners(i_Event);
    }

    protected void fireCreateZipAfterListener(CreateZipEvent i_Event) {
        if (this.createZipListeners == null) {
            return;
        }
        this.notifyCreateZipAfterListeners(i_Event);
    }

    private boolean notifyCreateZipBeforeListeners(CreateZipEvent i_Event) {
        Iterator<CreateZipListener> v_Iter = this.createZipListeners.iterator();
        boolean v_IsContinue = true;
        while (v_IsContinue && v_Iter.hasNext()) {
            v_IsContinue = v_Iter.next().createZipBefore(i_Event);
        }
        return v_IsContinue;
    }

    private boolean notifyCreatingZipListeners(CreateZipEvent i_Event) {
        Iterator<CreateZipListener> v_Iter = this.createZipListeners.iterator();
        boolean v_IsContinue = true;
        while (v_IsContinue && v_Iter.hasNext()) {
            v_IsContinue = v_Iter.next().createZipProcess(i_Event);
        }
        return v_IsContinue;
    }

    private void notifyCreateZipAfterListeners(CreateZipEvent i_Event) {
        Iterator<CreateZipListener> v_Iter = this.createZipListeners.iterator();
        while (v_Iter.hasNext()) {
            v_Iter.next().createZipAfter(i_Event);
        }
    }

    public void addUnCompressZipListener(UnCompressZipListener e) {
        if (this.unCompressZipListeners == null) {
            this.unCompressZipListeners = new HashSet<UnCompressZipListener>();
        }
        this.unCompressZipListeners.add(e);
    }

    public void removeUnCompressZipListener(UnCompressZipListener e) {
        if (this.unCompressZipListeners == null) {
            return;
        }
        this.unCompressZipListeners.remove(e);
    }

    protected boolean fireUnCompressZipBeforeListener(UnCompressZipEvent i_Event) {
        if (this.unCompressZipListeners == null) {
            return true;
        }
        return this.notifyUnCompressZipBeforeListeners(i_Event);
    }

    protected boolean fireUnCompressZipListener(UnCompressZipEvent i_Event) {
        if (this.unCompressZipListeners == null) {
            return true;
        }
        return this.notifyUnCompressZipListeners(i_Event);
    }

    protected void fireUnCompressZipAfterListener(UnCompressZipEvent i_Event) {
        if (this.unCompressZipListeners == null) {
            return;
        }
        this.notifyUnCompressZipAfterListeners(i_Event);
    }

    private boolean notifyUnCompressZipBeforeListeners(UnCompressZipEvent i_Event) {
        Iterator<UnCompressZipListener> v_Iter = this.unCompressZipListeners.iterator();
        boolean v_IsContinue = true;
        while (v_IsContinue && v_Iter.hasNext()) {
            v_IsContinue = v_Iter.next().unCompressZipBefore(i_Event);
        }
        return v_IsContinue;
    }

    private boolean notifyUnCompressZipListeners(UnCompressZipEvent i_Event) {
        Iterator<UnCompressZipListener> v_Iter = this.unCompressZipListeners.iterator();
        boolean v_IsContinue = true;
        while (v_IsContinue && v_Iter.hasNext()) {
            v_IsContinue = v_Iter.next().unCompressZipProcess(i_Event);
        }
        return v_IsContinue;
    }

    private void notifyUnCompressZipAfterListeners(UnCompressZipEvent i_Event) {
        Iterator<UnCompressZipListener> v_Iter = this.unCompressZipListeners.iterator();
        while (v_Iter.hasNext()) {
            v_Iter.next().unCompressZipAfter(i_Event);
        }
    }

    public BufferedImage resizeImageByMin(String i_File, boolean i_IsScale, int i_MinWidth, int i_MinHeight) throws IOException {
        if (i_File.startsWith("file:")) {
            return this.resizeImageByMin(new URL(i_File), i_IsScale, i_MinWidth, i_MinHeight);
        }
        return this.resizeImageByMin(new File(i_File), i_IsScale, i_MinWidth, i_MinHeight);
    }

    public BufferedImage resizeImageByMin(URL i_File, boolean i_IsScale, int i_MinWidth, int i_MinHeight) throws IOException {
        return this.resizeImageByMin(ImageIO.read(i_File), i_IsScale, i_MinWidth, i_MinHeight);
    }

    public BufferedImage resizeImageByMin(File i_File, boolean i_IsScale, int i_MinWidth, int i_MinHeight) throws IOException {
        return this.resizeImageByMin(ImageIO.read(i_File), i_IsScale, i_MinWidth, i_MinHeight);
    }

    public BufferedImage resizeImageByMin(BufferedImage i_Image, boolean i_IsScale, int i_MinWidth, int i_MinHeight) {
        if (i_MinWidth <= 0 && i_MinHeight <= 0) {
            return i_Image;
        }
        int v_NewWidth = i_Image.getWidth();
        int v_NewHeight = i_Image.getHeight();
        boolean v_IsResize = false;
        if (i_IsScale) {
            double v_WidthZoomRate = 1.0;
            double v_HeightZoomRate = 1.0;
            if (i_MinWidth > 0 && v_NewWidth < i_MinWidth) {
                v_WidthZoomRate = Help.division((Number)i_MinWidth, (Number[])new Number[]{v_NewWidth});
                v_IsResize = true;
            }
            if (i_MinHeight > 0 && v_NewHeight < i_MinHeight) {
                v_HeightZoomRate = Help.division((Number)i_MinHeight, (Number[])new Number[]{v_NewHeight});
                v_IsResize = true;
            }
            if (v_IsResize) {
                double v_ZoomRate = Help.max((Double)v_WidthZoomRate, (Double[])new Double[]{v_HeightZoomRate});
                v_NewWidth = (int)Math.floor(Help.multiply((Number)v_NewWidth, (Number[])new Number[]{v_ZoomRate}));
                v_NewHeight = (int)Math.floor(Help.multiply((Number)v_NewHeight, (Number[])new Number[]{v_ZoomRate}));
            }
        } else {
            if (i_MinWidth > 0 && v_NewWidth < i_MinWidth) {
                v_NewWidth = i_MinWidth;
                v_IsResize = true;
            }
            if (i_MinHeight > 0 && v_NewHeight < i_MinHeight) {
                v_NewHeight = i_MinHeight;
                v_IsResize = true;
            }
        }
        if (v_IsResize) {
            return this.resizeImage(i_Image, v_NewWidth, v_NewHeight);
        }
        return i_Image;
    }

    public BufferedImage resizeImageByMax(String i_File, boolean i_IsScale, int i_MaxWidth, int i_MaxHeight) throws IOException {
        if (i_File.startsWith("file:")) {
            return this.resizeImageByMax(new URL(i_File), i_IsScale, i_MaxWidth, i_MaxHeight);
        }
        return this.resizeImageByMax(new File(i_File), i_IsScale, i_MaxWidth, i_MaxHeight);
    }

    public BufferedImage resizeImageByMax(URL i_File, boolean i_IsScale, int i_MaxWidth, int i_MaxHeight) throws IOException {
        return this.resizeImageByMax(ImageIO.read(i_File), i_IsScale, i_MaxWidth, i_MaxHeight);
    }

    public BufferedImage resizeImageByMax(File i_File, boolean i_IsScale, int i_MaxWidth, int i_MaxHeight) throws IOException {
        return this.resizeImageByMax(ImageIO.read(i_File), i_IsScale, i_MaxWidth, i_MaxHeight);
    }

    public BufferedImage resizeImageByMax(BufferedImage i_Image, boolean i_IsScale, int i_MaxWidth, int i_MaxHeight) {
        if (i_MaxWidth <= 0 && i_MaxHeight <= 0) {
            return i_Image;
        }
        int v_NewWidth = i_Image.getWidth();
        int v_NewHeight = i_Image.getHeight();
        boolean v_IsResize = false;
        if (i_IsScale) {
            double v_WidthZoomRate = 1.0;
            double v_HeightZoomRate = 1.0;
            if (i_MaxWidth > 0 && v_NewWidth > i_MaxWidth) {
                v_WidthZoomRate = Help.division((Number)i_MaxWidth, (Number[])new Number[]{v_NewWidth});
                v_IsResize = true;
            }
            if (i_MaxHeight > 0 && v_NewHeight > i_MaxHeight) {
                v_HeightZoomRate = Help.division((Number)i_MaxHeight, (Number[])new Number[]{v_NewHeight});
                v_IsResize = true;
            }
            if (v_IsResize) {
                double v_ZoomRate = Help.min((Double)v_WidthZoomRate, (Double[])new Double[]{v_HeightZoomRate});
                v_NewWidth = (int)Math.floor(Help.multiply((Number)v_NewWidth, (Number[])new Number[]{v_ZoomRate}));
                v_NewHeight = (int)Math.floor(Help.multiply((Number)v_NewHeight, (Number[])new Number[]{v_ZoomRate}));
            }
        } else {
            if (i_MaxWidth > 0 && v_NewWidth > i_MaxWidth) {
                v_NewWidth = i_MaxWidth;
                v_IsResize = true;
            }
            if (i_MaxHeight > 0 && v_NewHeight > i_MaxHeight) {
                v_NewHeight = i_MaxHeight;
                v_IsResize = true;
            }
        }
        if (v_IsResize) {
            return this.resizeImage(i_Image, v_NewWidth, v_NewHeight);
        }
        return i_Image;
    }

    public BufferedImage resizeImage(String i_File, int i_NewWidth, int i_NewHeight) throws IOException {
        if (i_File.startsWith("file:")) {
            return this.resizeImage(new URL(i_File), i_NewWidth, i_NewHeight);
        }
        return this.resizeImage(new File(i_File), i_NewWidth, i_NewHeight);
    }

    public BufferedImage resizeImage(URL i_File, int i_NewWidth, int i_NewHeight) throws IOException {
        return this.resizeImage(ImageIO.read(i_File), i_NewWidth, i_NewHeight);
    }

    public BufferedImage resizeImage(File i_File, int i_NewWidth, int i_NewHeight) throws IOException {
        return this.resizeImage(ImageIO.read(i_File), i_NewWidth, i_NewHeight);
    }

    public BufferedImage resizeImage(BufferedImage i_Image, int i_NewWidth, int i_NewHeight) {
        Image v_ScaleImage = i_Image.getScaledInstance(i_NewWidth, i_NewHeight, 4);
        BufferedImage v_NewImage = new BufferedImage(i_NewWidth, i_NewHeight, i_Image.getType());
        Graphics2D v_Graphics = v_NewImage.createGraphics();
        v_Graphics.drawImage(v_ScaleImage, 0, 0, i_NewWidth, i_NewHeight, null);
        v_Graphics.dispose();
        return v_NewImage;
    }

    public static File findLastModified(File i_Dir, String i_FindDirName, String i_FindFileName, boolean i_IsFindChilds) {
        if (i_Dir.isDirectory()) {
            File[] v_ChildFiles = i_Dir.listFiles();
            long v_MaxTime = 0L;
            File v_MaxFile = null;
            File v_SecondFile = null;
            for (File v_ChildFile : v_ChildFiles) {
                if (!v_ChildFile.isDirectory() ? v_ChildFile.isFile() && !Help.isNull((String)i_FindFileName) && v_ChildFile.getName().toLowerCase().indexOf(i_FindFileName.toLowerCase()) < 0 : !Help.isNull((String)i_FindDirName) && v_ChildFile.getName().toLowerCase().indexOf(i_FindDirName.toLowerCase()) < 0) continue;
                if (v_MaxTime >= v_ChildFile.lastModified()) continue;
                v_SecondFile = v_MaxFile;
                v_MaxTime = v_ChildFile.lastModified();
                v_MaxFile = v_ChildFile;
            }
            if (v_MaxFile == null) {
                return null;
            }
            if (v_MaxFile.isFile()) {
                return v_MaxFile;
            }
            if (v_MaxFile.isDirectory()) {
                File v_FindFile = null;
                if (i_IsFindChilds) {
                    v_FindFile = FileHelp.findLastModified(v_MaxFile, i_FindDirName, i_FindFileName, i_IsFindChilds);
                    if (v_FindFile == null) {
                        if (v_SecondFile == null) {
                            return null;
                        }
                        if (v_SecondFile.isFile()) {
                            return v_SecondFile;
                        }
                        if (v_SecondFile.isDirectory()) {
                            return FileHelp.findLastModified(v_SecondFile, i_FindDirName, i_FindFileName, i_IsFindChilds);
                        }
                        return null;
                    }
                    return v_FindFile;
                }
                if (v_SecondFile == null) {
                    return null;
                }
                if (v_SecondFile.isFile()) {
                    return v_SecondFile;
                }
                return null;
            }
            return null;
        }
        if (i_Dir.isFile()) {
            return i_Dir;
        }
        return null;
    }

    public static File findLastName(File i_Dir, String i_FindDirName, String i_FindFileName, boolean i_IsFindChilds) {
        if (i_Dir.isDirectory()) {
            File[] v_ChildFiles = i_Dir.listFiles();
            String v_MaxName = "";
            File v_MaxFile = null;
            File v_SecondFile = null;
            for (File v_ChildFile : v_ChildFiles) {
                if (!v_ChildFile.isDirectory() ? v_ChildFile.isFile() && !Help.isNull((String)i_FindFileName) && v_ChildFile.getName().toLowerCase().indexOf(i_FindFileName.toLowerCase()) < 0 : !Help.isNull((String)i_FindDirName) && v_ChildFile.getName().toLowerCase().indexOf(i_FindDirName.toLowerCase()) < 0) continue;
                if (v_MaxName.compareTo(v_ChildFile.getName()) > -1) continue;
                v_SecondFile = v_MaxFile;
                v_MaxName = v_ChildFile.getName();
                v_MaxFile = v_ChildFile;
            }
            if (v_MaxFile == null) {
                return null;
            }
            if (v_MaxFile.isFile()) {
                return v_MaxFile;
            }
            if (v_MaxFile.isDirectory()) {
                File v_FindFile = null;
                if (i_IsFindChilds) {
                    v_FindFile = FileHelp.findLastName(v_MaxFile, i_FindDirName, i_FindFileName, i_IsFindChilds);
                    if (v_FindFile == null) {
                        if (v_SecondFile == null) {
                            return null;
                        }
                        if (v_SecondFile.isFile()) {
                            return v_SecondFile;
                        }
                        if (v_SecondFile.isDirectory()) {
                            return FileHelp.findLastName(v_SecondFile, i_FindDirName, i_FindFileName, i_IsFindChilds);
                        }
                        return null;
                    }
                    return v_FindFile;
                }
                if (v_SecondFile == null) {
                    return null;
                }
                if (v_SecondFile.isFile()) {
                    return v_SecondFile;
                }
                return null;
            }
            return null;
        }
        if (i_Dir.isFile()) {
            return i_Dir;
        }
        return null;
    }

    public void delFiles(String i_Folder, int i_ExpireDays, boolean i_IsDelChilds) {
        this.delFiles(new File(i_Folder), i_ExpireDays, i_IsDelChilds);
    }

    public void delFiles(File i_Folder, int i_ExpireDays, boolean i_IsDelChilds) {
        Date v_ExpireTime = Date.getNowTime().getDate(Math.abs(i_ExpireDays) * -1);
        this.delFiles(i_Folder, v_ExpireTime, i_IsDelChilds, null, null);
    }

    public void delFiles(File i_Folder, Date i_ExpireTime, boolean i_IsDelChilds) {
        this.delFiles(i_Folder, i_ExpireTime, i_IsDelChilds, null, null);
    }

    public void delFiles(File i_Folder, Date i_ExpireTime, boolean i_IsDelChilds, String i_ExcludeFiles, String i_ExcludeFolders) {
        if (i_Folder == null) {
            return;
        }
        if (!i_Folder.exists() && !i_Folder.isDirectory()) {
            return;
        }
        Object[] v_Files = i_Folder.listFiles();
        if (Help.isNull((Object[])v_Files)) {
            return;
        }
        String v_ExcludeFiles = Help.NVL((String)i_ExcludeFiles).toLowerCase();
        String v_ExcludeFolders = Help.NVL((String)i_ExcludeFolders).toLowerCase();
        for (Object v_File : v_Files) {
            if (((File)v_File).isFile()) {
                String v_FilePostfix;
                String v_FileName;
                if (!Help.isNull((String)v_ExcludeFiles) && (v_ExcludeFiles.indexOf("|" + (v_FileName = ((File)v_File).getName().toLowerCase()) + "|") >= 0 || (v_FilePostfix = StringHelp.getFilePostfix((String)v_FileName)) != null && v_ExcludeFiles.indexOf("|" + v_FilePostfix + "|") >= 0) || ((File)v_File).lastModified() >= i_ExpireTime.getTime()) continue;
                try {
                    ((File)v_File).delete();
                }
                catch (Exception exce) {
                    exce.printStackTrace();
                }
                continue;
            }
            if (!((File)v_File).isDirectory() || !i_IsDelChilds || !Help.isNull((String)v_ExcludeFolders) && v_ExcludeFolders.indexOf("|" + ((File)v_File).getName().toLowerCase() + "|") >= 0) continue;
            this.delFiles((File)v_File, i_ExpireTime, i_IsDelChilds, v_ExcludeFiles, v_ExcludeFolders);
            ((File)v_File).delete();
        }
    }

    public long calcSize(File i_Folder) {
        long v_Size = 0L;
        if (i_Folder == null) {
            return v_Size;
        }
        if (!i_Folder.exists() && !i_Folder.isDirectory()) {
            return v_Size;
        }
        Object[] v_Files = i_Folder.listFiles();
        if (Help.isNull((Object[])v_Files)) {
            return v_Size;
        }
        for (Object v_File : v_Files) {
            if (((File)v_File).isFile()) {
                v_Size += ((File)v_File).length();
                continue;
            }
            if (!((File)v_File).isDirectory()) continue;
            v_Size += this.calcSize((File)v_File);
        }
        return v_Size;
    }

    public long calcSize(File i_Folder, String i_ExcludeFiles) {
        return this.calcSize(i_Folder, i_ExcludeFiles, null);
    }

    public long calcSize(File i_Folder, String i_ExcludeFiles, String i_ExcludeFolders) {
        long v_Size = 0L;
        if (i_Folder == null) {
            return v_Size;
        }
        if (!i_Folder.exists() && !i_Folder.isDirectory()) {
            return v_Size;
        }
        Object[] v_Files = i_Folder.listFiles();
        if (Help.isNull((Object[])v_Files)) {
            return v_Size;
        }
        String v_ExcludeFiles = Help.NVL((String)i_ExcludeFiles).toLowerCase();
        String v_ExcludeFolders = Help.NVL((String)i_ExcludeFolders).toLowerCase();
        for (Object v_File : v_Files) {
            if (((File)v_File).isFile()) {
                if (!Help.isNull((String)v_ExcludeFiles) && v_ExcludeFiles.indexOf("|" + ((File)v_File).getName().toLowerCase() + "|") >= 0) continue;
                v_Size += ((File)v_File).length();
                continue;
            }
            if (!((File)v_File).isDirectory() || !Help.isNull((String)v_ExcludeFolders) && v_ExcludeFolders.indexOf("|" + ((File)v_File).getName().toLowerCase() + "|") >= 0) continue;
            v_Size += this.calcSize((File)v_File, v_ExcludeFiles, v_ExcludeFolders);
        }
        return v_Size;
    }

    public List<File> getFiles(String i_Folder, boolean i_HaveDirectory) {
        return this.getFiles(new File(i_Folder), i_HaveDirectory);
    }

    public List<File> getFiles(File i_Folder, boolean i_HaveDirectory) {
        ArrayList<File> v_Ret = new ArrayList<File>();
        if (i_Folder == null) {
            return v_Ret;
        }
        if (!i_Folder.exists() && !i_Folder.isDirectory()) {
            return v_Ret;
        }
        Object[] v_Files = i_Folder.listFiles();
        if (Help.isNull((Object[])v_Files)) {
            return v_Ret;
        }
        for (Object v_File : v_Files) {
            if (((File)v_File).isFile()) {
                v_Ret.add((File)v_File);
                continue;
            }
            if (!((File)v_File).isDirectory()) continue;
            if (i_HaveDirectory) {
                v_Ret.add((File)v_File);
            }
            v_Ret.addAll(this.getFiles((File)v_File, i_HaveDirectory));
        }
        return v_Ret;
    }

    public String getContent(JarFile i_Jar, String i_FileName) throws IOException {
        return this.getContent(i_Jar, i_FileName, this.charEncoding, false);
    }

    public String getContent(JarFile i_Jar, String i_FileName, String i_CharEncoding) throws IOException {
        return this.getContent(i_Jar, i_FileName, i_CharEncoding, false);
    }

    public String getContent(JarFile i_Jar, String i_FileName, String i_CharEncoding, boolean i_HaveNewLine) throws IOException {
        String v_Content = null;
        Enumeration<JarEntry> v_Entries = i_Jar.entries();
        while (v_Entries.hasMoreElements()) {
            JarEntry v_JarEntry = v_Entries.nextElement();
            String v_Name = v_JarEntry.getName();
            if (!v_Name.endsWith(i_FileName)) continue;
            v_Content = this.getContent(i_Jar.getInputStream(v_JarEntry), i_CharEncoding, i_HaveNewLine);
            break;
        }
        return v_Content;
    }

    public String getContent(String i_FileFullName) throws IOException, ClassNotFoundException {
        return this.getContent(i_FileFullName, this.charEncoding);
    }

    public String getContent(String i_FileName, String i_CharEncoding) throws IOException, ClassNotFoundException {
        return this.getContent(i_FileName, i_CharEncoding, false);
    }

    public String getContent(String i_FileName, String i_CharEncoding, boolean i_HaveNewLine) throws IOException, ClassNotFoundException {
        String[] v_FileInfoArr;
        if (Help.isNull((String)i_FileName)) {
            throw new NullPointerException("File name is null.");
        }
        Object v_FileFullName = i_FileName.trim();
        if (((String)v_FileFullName).startsWith(".")) {
            v_FileFullName = Help.getSysCurrentPath() + ((String)v_FileFullName).substring(1);
        } else if ("CLASS:".equals(((String)v_FileFullName).substring(0, 6).toUpperCase()) && (v_FileInfoArr = ((String)v_FileFullName).split(":")).length >= 3) {
            String v_ClassName = v_FileInfoArr[1];
            v_FileFullName = v_FileInfoArr[2];
            Class v_ClassObj = Help.forName((String)v_ClassName);
            return this.getContent(v_ClassObj.getResourceAsStream((String)v_FileFullName), i_CharEncoding, i_HaveNewLine);
        }
        return this.getContent(new File((String)v_FileFullName), i_CharEncoding, i_HaveNewLine);
    }

    public String getContent(File i_SourceFile) throws IOException {
        return this.getContent(i_SourceFile, this.charEncoding);
    }

    public String getContent(File i_SourceFile, String i_CharEncoding) throws IOException {
        return this.getContent(i_SourceFile, i_CharEncoding, false);
    }

    public String getContent(File i_SourceFile, String i_CharEncoding, boolean i_HaveNewLine) throws IOException {
        if (i_SourceFile == null) {
            throw new NullPointerException("Source file is null.");
        }
        if (!i_SourceFile.exists()) {
            throw new RuntimeException("Source file[" + i_SourceFile.toString() + "] is not exists.");
        }
        if (!i_SourceFile.isFile()) {
            throw new RuntimeException("Source file[" + i_SourceFile.toString() + "] is not file.");
        }
        if (!i_SourceFile.canRead()) {
            throw new RuntimeException("Source file[" + i_SourceFile.toString() + "] can not read.");
        }
        FileInputStream v_InputStream = null;
        String v_Ret = "";
        try {
            v_InputStream = new FileInputStream(i_SourceFile);
            v_Ret = this.getContent(v_InputStream, i_CharEncoding, i_HaveNewLine);
        }
        catch (Exception exce) {
            exce.printStackTrace();
        }
        return v_Ret;
    }

    public String getContent(URL i_FileURL) throws IOException {
        return this.getContent(i_FileURL, this.charEncoding);
    }

    public String getContent(URL i_FileURL, String i_CharEncoding) throws IOException {
        return this.getContent(i_FileURL, i_CharEncoding, false);
    }

    public String getContent(URL i_FileURL, String i_CharEncoding, boolean i_HaveNewLine) throws IOException {
        if (i_FileURL == null) {
            throw new NullPointerException("File rul is null.");
        }
        File v_SourceFile = null;
        try {
            v_SourceFile = new File(i_FileURL.toURI());
        }
        catch (Exception exce) {
            v_SourceFile = null;
            throw new IOException(exce.getMessage());
        }
        if (!v_SourceFile.exists()) {
            throw new RuntimeException("File[" + v_SourceFile.toString() + "] is not exists.");
        }
        if (!v_SourceFile.isFile()) {
            throw new RuntimeException("File[" + v_SourceFile.toString() + "] is not file.");
        }
        if (!v_SourceFile.canRead()) {
            throw new RuntimeException("File[" + v_SourceFile.toString() + "] can not read.");
        }
        FileInputStream v_InputStream = null;
        String v_Ret = "";
        try {
            v_InputStream = new FileInputStream(v_SourceFile);
            v_Ret = this.getContent(v_InputStream, i_CharEncoding, i_HaveNewLine);
        }
        catch (Exception exce) {
            exce.printStackTrace();
        }
        return v_Ret;
    }

    public String getContent(InputStream i_SourceInput) throws IOException {
        return this.getContent(i_SourceInput, this.charEncoding);
    }

    public String getContent(InputStream i_SourceInput, String i_CharEncoding) throws IOException {
        return this.getContent(i_SourceInput, i_CharEncoding, false);
    }

    public String getContent(InputStream i_SourceInput, String i_CharEncoding, boolean i_HaveNewLine) throws IOException {
        if (i_SourceInput == null) {
            throw new NullPointerException("Source inputstream is null.");
        }
        InputStreamReader v_ReaderIO = null;
        BufferedReader v_Reader = null;
        StringBuilder v_Buffer = new StringBuilder();
        String v_LineData = null;
        long v_ReadIndex = 0L;
        DefaultFileReadEvent v_Event = new DefaultFileReadEvent(this);
        boolean v_IsContinue = true;
        try {
            v_ReaderIO = new InputStreamReader(i_SourceInput, i_CharEncoding);
            v_Reader = new BufferedReader(v_ReaderIO);
            v_IsContinue = this.fireReadBeforeListener(v_Event);
            if (i_HaveNewLine) {
                if (this.isReturnContent) {
                    while (v_IsContinue && (v_LineData = v_Reader.readLine()) != null) {
                        v_Event.setDataString(v_LineData + "\r\n");
                        v_Event.setCompleteSize(v_ReadIndex += (long)v_LineData.length());
                        v_IsContinue = this.fireReadingListener(v_Event);
                        v_Buffer.append(v_Event.getDataString());
                    }
                } else {
                    while (v_IsContinue && (v_LineData = v_Reader.readLine()) != null) {
                        v_Event.setDataString(v_LineData + "\r\n");
                        v_Event.setCompleteSize(v_ReadIndex += (long)v_LineData.length());
                        v_IsContinue = this.fireReadingListener(v_Event);
                    }
                }
            } else if (this.isReturnContent) {
                while (v_IsContinue && (v_LineData = v_Reader.readLine()) != null) {
                    v_Event.setDataString(v_LineData);
                    v_Event.setCompleteSize(v_ReadIndex += (long)v_LineData.length());
                    v_IsContinue = this.fireReadingListener(v_Event);
                    v_Buffer.append(v_Event.getDataString());
                }
            } else {
                while (v_IsContinue && (v_LineData = v_Reader.readLine()) != null) {
                    v_Event.setDataString(v_LineData);
                    v_Event.setCompleteSize(v_ReadIndex += (long)v_LineData.length());
                    v_IsContinue = this.fireReadingListener(v_Event);
                }
            }
            v_Event.setSucceedFinish();
        }
        catch (Exception exce) {
            v_Event.setEndTime();
            throw new IOException(exce.getMessage());
        }
        finally {
            if (v_Reader != null) {
                try {
                    v_Reader.close();
                }
                catch (Exception exception) {}
            }
            v_Reader = null;
            if (v_ReaderIO != null) {
                try {
                    v_ReaderIO.close();
                }
                catch (Exception exception) {}
            }
            v_ReaderIO = null;
            if (i_SourceInput != null) {
                try {
                    i_SourceInput.close();
                }
                catch (Exception exception) {}
            }
            i_SourceInput = null;
            this.fireReadAfterListener(v_Event);
        }
        return v_Buffer.toString();
    }

    public byte[] getContentByte(String i_FileName) throws IOException, ClassNotFoundException {
        String[] v_FileInfoArr;
        if (Help.isNull((String)i_FileName)) {
            throw new NullPointerException("File name is null.");
        }
        Object v_FileFullName = i_FileName.trim();
        if (((String)v_FileFullName).startsWith(".")) {
            v_FileFullName = Help.getSysCurrentPath() + ((String)v_FileFullName).substring(1);
        } else if ("CLASS:".equals(((String)v_FileFullName).substring(0, 6).toUpperCase()) && (v_FileInfoArr = ((String)v_FileFullName).split(":")).length >= 3) {
            String v_ClassName = v_FileInfoArr[1];
            v_FileFullName = v_FileInfoArr[2];
            Class v_ClassObj = Help.forName((String)v_ClassName);
            return this.getContentByte(v_ClassObj.getResourceAsStream((String)v_FileFullName));
        }
        return this.getContentByte(new File((String)v_FileFullName));
    }

    public byte[] getContentByte(File i_SourceFile) throws IOException {
        if (i_SourceFile == null) {
            throw new NullPointerException("Source file is null.");
        }
        if (!i_SourceFile.exists()) {
            throw new RuntimeException("Source file[" + i_SourceFile.toString() + "] is not exists.");
        }
        if (!i_SourceFile.isFile()) {
            throw new RuntimeException("Source file[" + i_SourceFile.toString() + "] is not file.");
        }
        if (!i_SourceFile.canRead()) {
            throw new RuntimeException("Source file[" + i_SourceFile.toString() + "] can not read.");
        }
        FileInputStream v_InputStream = null;
        byte[] v_Ret = new byte[]{};
        try {
            v_InputStream = new FileInputStream(i_SourceFile);
            v_Ret = this.getContentByte(v_InputStream);
        }
        catch (Exception exce) {
            exce.printStackTrace();
        }
        return v_Ret;
    }

    public byte[] getContentByte(URL i_FileURL) throws IOException {
        if (i_FileURL == null) {
            throw new NullPointerException("File rul is null.");
        }
        File v_SourceFile = null;
        try {
            v_SourceFile = new File(i_FileURL.toURI());
        }
        catch (Exception exce) {
            v_SourceFile = null;
            throw new IOException(exce.getMessage());
        }
        if (!v_SourceFile.exists()) {
            throw new RuntimeException("File[" + v_SourceFile.toString() + "] is not exists.");
        }
        if (!v_SourceFile.isFile()) {
            throw new RuntimeException("File[" + v_SourceFile.toString() + "] is not file.");
        }
        if (!v_SourceFile.canRead()) {
            throw new RuntimeException("File[" + v_SourceFile.toString() + "] can not read.");
        }
        FileInputStream v_InputStream = null;
        byte[] v_Ret = new byte[]{};
        try {
            v_InputStream = new FileInputStream(v_SourceFile);
            v_Ret = this.getContentByte(v_InputStream);
        }
        catch (Exception exce) {
            exce.printStackTrace();
        }
        return v_Ret;
    }

    public byte[] getContentByte(InputStream i_SourceInput) throws IOException {
        if (i_SourceInput == null) {
            throw new NullPointerException("Source inputstream is null.");
        }
        byte[] v_ReadBuffer = new byte[this.bufferSize];
        int v_ReadSize = 0;
        long v_ReadIndex = 0L;
        ByteArrayOutputStream v_Output = new ByteArrayOutputStream();
        DefaultFileReadEvent v_Event = new DefaultFileReadEvent(this);
        boolean v_IsContinue = true;
        try {
            v_IsContinue = this.fireReadBeforeListener(v_Event);
            if (this.isReturnContent) {
                while (v_IsContinue && (v_ReadSize = i_SourceInput.read(v_ReadBuffer, 0, this.bufferSize)) > 0) {
                    v_Event.setDataByte(ByteHelp.substr((byte[])v_ReadBuffer, (int)0, (int)v_ReadSize));
                    v_Event.setCompleteSize(v_ReadIndex += (long)v_ReadSize);
                    v_IsContinue = this.fireReadingListener(v_Event);
                    v_Output.write(v_Event.getDataByte(), 0, v_Event.getDataByte().length);
                }
            } else {
                while (v_IsContinue && (v_ReadSize = i_SourceInput.read(v_ReadBuffer, 0, this.bufferSize)) > 0) {
                    v_Event.setDataByte(ByteHelp.substr((byte[])v_ReadBuffer, (int)0, (int)v_ReadSize));
                    v_Event.setCompleteSize(v_ReadIndex += (long)v_ReadSize);
                    v_IsContinue = this.fireReadingListener(v_Event);
                }
            }
            v_Event.setSucceedFinish();
        }
        catch (Exception exce) {
            v_Event.setEndTime();
            throw new IOException(exce.getMessage());
        }
        finally {
            if (i_SourceInput != null) {
                try {
                    i_SourceInput.close();
                }
                catch (Exception exception) {}
            }
            i_SourceInput = null;
            this.fireReadAfterListener(v_Event);
        }
        return v_Output.toByteArray();
    }

    public static byte[] toBytes(BufferedImage i_ImageDatas, String i_ImageType) throws IOException {
        try (ByteArrayOutputStream v_BytesOutput = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)i_ImageDatas, i_ImageType, v_BytesOutput);
            v_BytesOutput.flush();
            byte[] byArray = v_BytesOutput.toByteArray();
            return byArray;
        }
    }

    public static BufferedImage getContentImage(String i_ImageUrl) throws MalformedURLException, IOException {
        BufferedImage v_Image = null;
        String v_URL = i_ImageUrl.toLowerCase();
        v_Image = v_URL.startsWith("file:") || v_URL.startsWith("http:") || v_URL.startsWith("https:") ? ImageIO.read(new URL(i_ImageUrl)) : ImageIO.read(new File(i_ImageUrl));
        return v_Image;
    }

    public static BufferedImage getContentImage(URL i_ImageUrl) throws MalformedURLException, IOException {
        return ImageIO.read(i_ImageUrl);
    }

    public static String getContentImageBase64(BufferedImage i_Image) throws IOException {
        ByteArrayOutputStream v_Out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)i_Image, "png", v_Out);
        return Base64.getEncoder().encodeToString(v_Out.toByteArray());
    }

    public static void copyImage(BufferedImage i_OldImage, BufferedImage io_NewImage) {
        int v_MaxWidthOld = i_OldImage.getWidth();
        int v_MaxHeightOld = i_OldImage.getHeight();
        int v_MaxWidthNew = io_NewImage.getWidth();
        int v_MaxHeightNew = io_NewImage.getHeight();
        int yOld = 0;
        for (int yNew = 0; yOld < v_MaxHeightOld && yNew < v_MaxHeightNew; ++yOld, ++yNew) {
            int xOld = 0;
            for (int xNew = 0; xOld < v_MaxWidthOld && xNew < v_MaxWidthNew; ++xOld, ++xNew) {
                io_NewImage.setRGB(xNew, yNew, i_OldImage.getRGB(xOld, yOld));
            }
        }
    }

    public static Return<?>[][] getImageOutline(BufferedImage i_Image, int i_TransparentColor) throws MalformedURLException, IOException {
        return FileHelp.getImageOutline(i_Image, i_TransparentColor, i_TransparentColor);
    }

    public static Return<?>[][] getImageOutline(BufferedImage i_Image, int i_TransparentColor, int i_StrokeColor) throws MalformedURLException, IOException {
        int v_Width = i_Image.getWidth();
        int v_Height = i_Image.getHeight();
        Return[][] v_Datas = new Return[v_Width][v_Height];
        for (int y = 0; y < v_Height; ++y) {
            for (int x = 0; x < v_Width; ++x) {
                int v_Color = i_Image.getRGB(x, y);
                v_Datas[x][y] = v_Color == i_TransparentColor ? new Return(false) : (v_Color == i_StrokeColor ? new Return(true).setParamStr("1").setParamInt(v_Color) : new Return(true).setParamInt(v_Color));
            }
        }
        return v_Datas;
    }

    public static void strokeImage(BufferedImage io_Image, Return<?>[][] i_StrokeOutline, int i_StrokeX, int i_StrokeY, int i_StrokeColor) {
        int v_MaxWidth = Help.min((Integer)io_Image.getWidth(), (Integer[])new Integer[]{i_StrokeOutline.length + i_StrokeX});
        int v_MaxHeight = Help.min((Integer)io_Image.getHeight(), (Integer[])new Integer[]{i_StrokeOutline[0].length + i_StrokeY});
        int y = i_StrokeY;
        int v_OutY = 0;
        while (y < v_MaxHeight) {
            int x = i_StrokeX;
            int v_OutX = 0;
            while (x < v_MaxWidth) {
                Boolean v_IsStroke = "1".equals(i_StrokeOutline[v_OutX][v_OutY].getParamStr());
                if (v_IsStroke.booleanValue()) {
                    io_Image.setRGB(x, y, i_StrokeColor);
                }
                ++x;
                ++v_OutX;
            }
            ++y;
            ++v_OutY;
        }
    }

    public static void cutImage(BufferedImage i_OrgImage, BufferedImage io_NewImage, Return<?>[][] i_CutOutline, int i_CutX, int i_CutY) {
        int v_MaxWidth = Help.min((Integer)i_OrgImage.getWidth(), (Integer[])new Integer[]{i_CutOutline.length + i_CutX});
        int v_MaxHeight = Help.min((Integer)i_OrgImage.getHeight(), (Integer[])new Integer[]{i_CutOutline[0].length + i_CutY});
        int y = i_CutY;
        int v_NewY = 0;
        while (y < v_MaxHeight) {
            int x = i_CutX;
            int v_NewX = 0;
            while (x < v_MaxWidth) {
                Return<?> v_IsCut = i_CutOutline[v_NewX][v_NewY];
                int v_OrgRGB = i_OrgImage.getRGB(x, y);
                if (v_IsCut.booleanValue()) {
                    io_NewImage.setRGB(v_NewX, v_NewY, v_OrgRGB);
                } else {
                    io_NewImage.setRGB(v_NewX, v_NewY, 0xFFFFFF);
                }
                ++x;
                ++v_NewX;
            }
            ++y;
            ++v_NewY;
        }
    }

    public static BufferedImage expandImage(BufferedImage i_Image, int i_NewWidth, int i_NewHeight, int i_BGColor) {
        int x;
        int y;
        int v_BorderLRSize = (i_NewWidth - i_Image.getWidth()) / 2;
        int v_BorderTBSize = (i_NewHeight - i_Image.getHeight()) / 2;
        BufferedImage v_NewImage = new BufferedImage(i_NewWidth, i_NewHeight, 2);
        for (int x2 = 0; x2 < i_NewWidth; ++x2) {
            int y2;
            for (y2 = 0; y2 < v_BorderTBSize; ++y2) {
                v_NewImage.setRGB(x2, y2, i_BGColor);
            }
            for (y2 = i_NewHeight - v_BorderTBSize; y2 < i_NewHeight; ++y2) {
                v_NewImage.setRGB(x2, y2, i_BGColor);
            }
        }
        for (y = 0; y < i_NewHeight; ++y) {
            for (x = 0; x < v_BorderLRSize; ++x) {
                v_NewImage.setRGB(x, y, i_BGColor);
            }
            for (x = i_NewWidth - v_BorderLRSize; x < i_NewWidth; ++x) {
                v_NewImage.setRGB(x, y, i_BGColor);
            }
        }
        for (y = 0; y < i_Image.getHeight(); ++y) {
            for (x = 0; x < i_Image.getWidth(); ++x) {
                int v_OrgRGB = i_Image.getRGB(x, y);
                v_NewImage.setRGB(x + v_BorderLRSize, y + v_BorderTBSize, v_OrgRGB);
            }
        }
        return v_NewImage;
    }

    public static void overAlphaImage(BufferedImage io_Background, BufferedImage i_Frontgroud, int i_FrontX, int i_FrontY, float i_Alpha) {
        Graphics2D g = io_Background.createGraphics();
        g.setComposite(AlphaComposite.getInstance(10, i_Alpha));
        g.drawImage(i_Frontgroud, i_FrontX, i_FrontY, i_Frontgroud.getWidth(), i_Frontgroud.getHeight(), null);
        g.dispose();
    }

    public int xcopy(String i_SourceFolderFullName, String i_TargetFolderFullName, Long i_ModifiedTime, String i_Exclusion) throws IOException {
        return this.xcopy(i_SourceFolderFullName, i_TargetFolderFullName, i_ModifiedTime, i_Exclusion, null);
    }

    public int xcopyExclusion(String i_SourceFolderFullName, String i_TargetFolderFullName, Long i_ModifiedTime, String i_Exclusion) throws IOException {
        return this.xcopy(i_SourceFolderFullName, i_TargetFolderFullName, i_ModifiedTime, i_Exclusion, null);
    }

    public int xcopyAccept(String i_SourceFolderFullName, String i_TargetFolderFullName, Long i_ModifiedTime, String i_Accept) throws IOException {
        return this.xcopy(i_SourceFolderFullName, i_TargetFolderFullName, i_ModifiedTime, null, i_Accept);
    }

    public int xcopy(String i_SourceFolderFullName, String i_TargetFolderFullName, long i_ModifiedTime) throws IOException {
        return this.xcopy(i_SourceFolderFullName, i_TargetFolderFullName, (Long)i_ModifiedTime, null, null);
    }

    public int xcopy(String i_SourceFolderFullName, String i_TargetFolderFullName, Long i_ModifiedTime, String i_Exclusion, String i_Accept) throws IOException {
        if (Help.isNull((String)i_SourceFolderFullName)) {
            throw new NullPointerException("Source full name is null.");
        }
        if (Help.isNull((String)i_TargetFolderFullName)) {
            throw new NullPointerException("Target full name is null.");
        }
        Pattern v_Exclusion = null;
        Pattern v_Accept = null;
        if (!Help.isNull((String)i_Exclusion)) {
            v_Exclusion = Pattern.compile(i_Exclusion);
        }
        if (!Help.isNull((String)i_Accept)) {
            v_Accept = Pattern.compile(i_Accept);
        }
        return this.xcopy(new File(i_SourceFolderFullName), new File(i_TargetFolderFullName), i_ModifiedTime, v_Exclusion, v_Accept);
    }

    public int xcopy(File i_SourceFolder, File i_TargetFolder, Long i_ModifiedTime, Pattern i_Exclusion) throws IOException {
        return this.xcopy(i_SourceFolder, i_TargetFolder, i_ModifiedTime, i_Exclusion, null);
    }

    public int xcopyExclusion(File i_SourceFolder, File i_TargetFolder, Long i_ModifiedTime, Pattern i_Exclusion) throws IOException {
        return this.xcopy(i_SourceFolder, i_TargetFolder, i_ModifiedTime, i_Exclusion, null);
    }

    public int xcopyAccept(File i_SourceFolder, File i_TargetFolder, Long i_ModifiedTime, Pattern i_Accept) throws IOException {
        return this.xcopy(i_SourceFolder, i_TargetFolder, i_ModifiedTime, null, i_Accept);
    }

    public int xcopy(File i_SourceFolder, File i_TargetFolder, Long i_ModifiedTime) throws IOException {
        return this.xcopy(i_SourceFolder, i_TargetFolder, i_ModifiedTime, null, null);
    }

    public int xcopy(File i_SourceFolder, File i_TargetFolder, Long i_ModifiedTime, Pattern i_Exclusion, Pattern i_Accept) throws IOException {
        if (!i_SourceFolder.exists()) {
            throw new RuntimeException("Source folder[" + i_SourceFolder.toString() + "] is not exists.");
        }
        if (!i_SourceFolder.isDirectory()) {
            throw new RuntimeException("Source[" + i_SourceFolder.toString() + "] is not directory.");
        }
        if (!i_SourceFolder.canRead()) {
            throw new RuntimeException("Source[" + i_SourceFolder.toString() + "] can not read.");
        }
        boolean v_TargetFolderIsExists = false;
        if (i_TargetFolder.exists()) {
            if (!i_TargetFolder.isDirectory()) {
                throw new RuntimeException("Target[" + i_TargetFolder.toString() + "] is not directory.");
            }
            v_TargetFolderIsExists = true;
        }
        int v_CopyFileCount = 0;
        Object[] v_Files = i_SourceFolder.listFiles();
        if (Help.isNull((Object[])v_Files)) {
            return v_CopyFileCount;
        }
        for (Object v_File : v_Files) {
            if (((File)v_File).isFile()) {
                if (i_ModifiedTime != null && ((File)v_File).lastModified() < i_ModifiedTime || i_Exclusion != null && i_Exclusion.matcher(((File)v_File).getName()).matches() || i_Accept != null && !i_Accept.matcher(((File)v_File).getName()).matches()) continue;
                if (!v_TargetFolderIsExists) {
                    try {
                        i_TargetFolder.mkdirs();
                    }
                    catch (Exception exce) {
                        throw new IOException("mkdirs[" + i_TargetFolder.getAbsolutePath() + "] is error. " + exce.getMessage());
                    }
                }
                this.copyFile((File)v_File, new File(i_TargetFolder.getAbsolutePath() + Help.getSysPathSeparator() + ((File)v_File).getName()));
                ++v_CopyFileCount;
                continue;
            }
            if (!((File)v_File).isDirectory()) continue;
            v_CopyFileCount += this.xcopy((File)v_File, new File(i_TargetFolder.getAbsolutePath() + Help.getSysPathSeparator() + ((File)v_File).getName()), i_ModifiedTime, i_Exclusion, i_Accept);
        }
        return v_CopyFileCount;
    }

    public void copyFile(String i_SourceFullName, String i_TargetFullName) throws NullPointerException, IOException {
        if (Help.isNull((String)i_SourceFullName)) {
            throw new NullPointerException("Source full name is null.");
        }
        if (Help.isNull((String)i_TargetFullName)) {
            throw new NullPointerException("Target full name is null.");
        }
        this.copyFile(new File(i_SourceFullName), new File(i_TargetFullName));
    }

    public void copyFile(File i_SourceFile, File i_TargetFile) throws NullPointerException, IOException {
        if (!i_SourceFile.exists()) {
            throw new IOException("Source file[" + i_SourceFile.toString() + "] is not exists.");
        }
        if (!i_SourceFile.isFile()) {
            throw new IOException("Source[" + i_SourceFile.toString() + "] is not file.");
        }
        if (!i_SourceFile.canRead()) {
            throw new IOException("Source[" + i_SourceFile.toString() + "] can not read.");
        }
        if (i_TargetFile.exists()) {
            if (this.isOverWrite) {
                boolean v_Result = i_TargetFile.delete();
                if (!v_Result) {
                    throw new IOException("Delete target file[" + i_TargetFile.toString() + "] exception.");
                }
            } else {
                throw new IOException("Target[" + i_TargetFile.toString() + "] is exists.");
            }
        }
        FileInputStream v_SourceInput = new FileInputStream(i_SourceFile);
        FileOutputStream v_TargetOutput = new FileOutputStream(i_TargetFile);
        long v_SourceLen = i_SourceFile.length();
        long v_WriteIndex = 0L;
        byte[] v_ByteBuffer = new byte[this.bufferSize];
        DefaultFileCopyEvent v_Event = new DefaultFileCopyEvent(this, v_SourceLen);
        boolean v_IsContinue = true;
        try {
            v_Event.setInfo(i_TargetFile.getAbsolutePath());
            v_IsContinue = this.fireCopyBeforeListener(v_Event);
            while (v_IsContinue) {
                if (v_WriteIndex + (long)this.bufferSize <= v_SourceLen) {
                    v_SourceInput.read(v_ByteBuffer);
                    v_TargetOutput.write(v_ByteBuffer);
                    v_TargetOutput.flush();
                    v_Event.setCompleteSize(v_WriteIndex += (long)this.bufferSize);
                    v_IsContinue = this.fireCopyingListener(v_Event);
                    continue;
                }
                v_ByteBuffer = new byte[(int)(v_SourceLen - v_WriteIndex)];
                v_SourceInput.read(v_ByteBuffer);
                v_TargetOutput.write(v_ByteBuffer);
                v_TargetOutput.flush();
                v_Event.setSucceedFinish();
                this.fireCopyingListener(v_Event);
                break;
            }
        }
        catch (Exception exce) {
            v_Event.setEndTime();
            throw new IOException(exce.getMessage());
        }
        finally {
            try {
                v_SourceInput.close();
            }
            catch (Exception exception) {}
            try {
                v_TargetOutput.close();
            }
            catch (Exception exception) {}
            v_SourceInput = null;
            v_TargetOutput = null;
            this.fireCopyAfterListener(v_Event);
        }
    }

    public void copyFile(InputStream i_SourceInput, String i_TargetFullName) throws NullPointerException, IOException {
        if (i_SourceInput == null) {
            throw new NullPointerException("Source InputStream is null.");
        }
        if (Help.isNull((String)i_TargetFullName)) {
            throw new NullPointerException("Target full name is null.");
        }
        this.copyFile(i_SourceInput, new File(i_TargetFullName));
    }

    public void copyFile(InputStream i_SourceInput, File i_TargetFile) throws NullPointerException, IOException {
        if (i_SourceInput == null) {
            throw new NullPointerException("Source InputStream is null.");
        }
        if (i_TargetFile == null) {
            throw new NullPointerException("Target file is null.");
        }
        File v_TargetFile = i_TargetFile;
        if (v_TargetFile.exists()) {
            if (this.isOverWrite) {
                boolean v_Result = v_TargetFile.delete();
                if (!v_Result) {
                    throw new IOException("Delete target file[" + i_TargetFile.toString() + "] exception.");
                }
            } else {
                throw new IOException("Target[" + i_TargetFile.toString() + "] is exists.");
            }
        }
        InputStream v_SourceInput = i_SourceInput;
        FileOutputStream v_TargetOutput = new FileOutputStream(v_TargetFile);
        int v_ReadLen = 0;
        byte[] v_ByteBuffer = new byte[this.bufferSize];
        try {
            while ((v_ReadLen = v_SourceInput.read(v_ByteBuffer)) > 0) {
                v_TargetOutput.write(v_ByteBuffer, 0, v_ReadLen);
                v_TargetOutput.flush();
            }
        }
        catch (Exception exce) {
            throw new IOException(exce.getMessage());
        }
        finally {
            try {
                v_SourceInput.close();
            }
            catch (Exception exception) {}
            try {
                v_TargetOutput.close();
            }
            catch (Exception exception) {}
            v_SourceInput = null;
            v_TargetOutput = null;
            v_TargetFile = null;
        }
    }

    public void download(String i_URL, String i_SaveFullName) {
        if (Help.isNull((String)i_SaveFullName)) {
            throw new NullPointerException("SaveFullName is null.");
        }
        this.download(i_URL, new File(i_SaveFullName));
    }

    public void download(String i_URL, File i_SaveFile) {
        if (Help.isNull((String)i_URL)) {
            throw new NullPointerException("URL is null.");
        }
        try {
            URL v_URL = new URL(i_URL);
            HttpURLConnection v_Conn = (HttpURLConnection)v_URL.openConnection();
            v_Conn.setDoInput(true);
            v_Conn.connect();
            this.copyFile(v_Conn.getInputStream(), i_SaveFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void download(URL i_URL, String i_SaveFullName) {
        if (Help.isNull((String)i_SaveFullName)) {
            throw new NullPointerException("SaveFullName is null.");
        }
        this.download(i_URL, new File(i_SaveFullName));
    }

    public void download(URL i_URL, File i_SaveFile) {
        if (i_URL == null) {
            throw new NullPointerException("URL is null.");
        }
        try {
            HttpURLConnection v_Conn = (HttpURLConnection)i_URL.openConnection();
            v_Conn.setDoInput(true);
            v_Conn.connect();
            this.copyFile(v_Conn.getInputStream(), i_SaveFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void downloadServer(HttpServletResponse i_Response, String i_ContentType, File i_File) throws Exception {
        this.downloadServer(i_Response, i_ContentType, i_File, null);
    }

    public void downloadServer(HttpServletResponse i_Response, String i_ContentType, File i_File, String i_FileName) throws Exception {
        FileInputStream v_Input = null;
        BufferedInputStream v_InputBuffer = null;
        OutputStream v_Output = null;
        try {
            i_Response.reset();
            i_Response.setContentType(i_ContentType);
            i_Response.setHeader("Content-Length", "" + i_File.length());
            i_Response.setHeader("Content-Disposition", "attachment;filename=" + StringHelp.toCharEncoding((String)Help.NVL((String)i_FileName, (String)i_File.getName()), (String)i_ContentType, (String)"ISO-8859-1"));
            i_Response.setStatus(200);
            v_Input = new FileInputStream(i_File);
            v_InputBuffer = new BufferedInputStream(v_Input);
            v_Output = i_Response.getOutputStream();
            if (i_File.length() <= 0xA00000L) {
                byte[] v_ReadBuffer = new byte[v_InputBuffer.available()];
                v_InputBuffer.read(v_ReadBuffer);
                v_Output.write(v_ReadBuffer);
            } else {
                byte[] v_ReadBuffer = new byte[this.bufferSize];
                int v_ReadSize = 0;
                while ((v_ReadSize = v_InputBuffer.read(v_ReadBuffer, 0, this.bufferSize)) > 0) {
                    v_Output.write(v_ReadBuffer, 0, v_ReadSize);
                }
            }
            v_Output.flush();
        }
        catch (Exception exce) {
            throw exce;
        }
        finally {
            if (v_Output != null) {
                try {
                    v_Output.close();
                }
                catch (Exception exception) {}
                v_Output = null;
            }
            if (v_InputBuffer != null) {
                try {
                    v_InputBuffer.close();
                }
                catch (Exception exception) {}
                v_InputBuffer = null;
            }
            if (v_Input != null) {
                try {
                    v_Input.close();
                }
                catch (Exception exception) {}
                v_Input = null;
            }
        }
    }

    public void downloadServer(HttpServletRequest i_Request, HttpServletResponse i_Response, String i_ContentType, File i_File) throws Exception {
        this.downloadServer(i_Request, i_Response, i_ContentType, i_File, null);
    }

    public void downloadServer(HttpServletRequest i_Request, HttpServletResponse i_Response, String i_ContentType, File i_File, String i_FileName) throws Exception {
        FileInputStream v_Input = null;
        BufferedInputStream v_InputBuffer = null;
        OutputStream v_Output = null;
        try {
            long v_ReadTotal;
            v_Input = new FileInputStream(i_File);
            v_InputBuffer = new BufferedInputStream(v_Input);
            v_Output = i_Response.getOutputStream();
            i_Response.reset();
            i_Response.setContentType(i_ContentType);
            i_Response.setHeader("Content-Disposition", "attachment;filename=" + StringHelp.toCharEncoding((String)Help.NVL((String)i_FileName, (String)i_File.getName()), (String)i_ContentType, (String)"ISO-8859-1"));
            String v_Range = i_Request.getHeader("Range");
            boolean v_IsRange = false;
            long v_FileLength = i_File.length();
            long v_ContentLen = 0L;
            long v_Place_Being = 0L;
            long v_Place_End = 0L;
            if (v_Range != null && v_Range.trim().length() > 0 && !"null".equals(v_Range)) {
                v_IsRange = true;
                i_Response.setHeader("Accept-Ranges", "bytes");
                i_Response.setStatus(206);
                String v_RangeBytes = v_Range.replaceAll("bytes=", "");
                if (v_RangeBytes.startsWith("-")) {
                    v_Place_End = Long.parseLong(v_RangeBytes.substring(v_RangeBytes.indexOf("-") + 1));
                    v_Place_Being = v_FileLength - v_Place_End - 1L;
                } else if (v_RangeBytes.endsWith("-")) {
                    v_Place_Being = Long.parseLong(v_RangeBytes.substring(0, v_RangeBytes.indexOf("-")));
                    v_Place_End = v_FileLength - v_Place_Being - 1L;
                } else {
                    v_Place_Being = Long.parseLong(v_RangeBytes.substring(0, v_RangeBytes.indexOf("-")));
                    v_Place_End = Long.parseLong(v_RangeBytes.substring(v_RangeBytes.indexOf("-") + 1));
                }
            } else {
                v_Place_Being = 0L;
                v_Place_End = v_FileLength - 1L;
            }
            v_ContentLen = v_Place_End - v_Place_Being + 1L;
            i_Response.setHeader("Content-Length", "" + v_ContentLen);
            if (v_IsRange) {
                String v_ContentRange = "bytes " + v_Place_Being + "-" + v_Place_End + "/" + v_FileLength;
                i_Response.setHeader("Content-Range", v_ContentRange);
                if (v_Place_Being > 0L) {
                    long l = v_InputBuffer.skip(v_Place_Being);
                }
            }
            byte[] v_ReadBuffer = new byte[this.bufferSize];
            int v_ReadSize = 0;
            for (v_ReadTotal = 0L; v_ReadTotal <= v_ContentLen - (long)this.bufferSize; v_ReadTotal += (long)v_ReadSize) {
                v_ReadSize = v_InputBuffer.read(v_ReadBuffer, 0, this.bufferSize);
                v_Output.write(v_ReadBuffer, 0, v_ReadSize);
            }
            if (v_ReadTotal <= v_ContentLen) {
                v_ReadSize = v_InputBuffer.read(v_ReadBuffer, 0, this.bufferSize);
                v_Output.write(v_ReadBuffer, 0, v_ReadSize);
            }
            v_Output.flush();
        }
        catch (Exception exce) {
            throw exce;
        }
        finally {
            if (v_Output != null) {
                try {
                    v_Output.close();
                }
                catch (Exception exception) {}
                v_Output = null;
            }
            if (v_InputBuffer != null) {
                try {
                    v_InputBuffer.close();
                }
                catch (Exception exception) {}
                v_InputBuffer = null;
            }
            if (v_Input != null) {
                try {
                    v_Input.close();
                }
                catch (Exception exception) {}
                v_Input = null;
            }
        }
    }

    public int uploadServer(String i_Dir, FileDataPacket i_DataPacket) throws Exception {
        return this.uploadServer(new File(i_Dir), i_DataPacket);
    }

    public int uploadServer(File i_Dir, FileDataPacket i_DataPacket) throws Exception {
        if (null == i_Dir || null == i_DataPacket || null == i_DataPacket.getDataNo() || null == i_DataPacket.getDataCount() || Help.isNull((String)i_DataPacket.getName())) {
            return -1;
        }
        if (!i_Dir.exists()) {
            i_Dir.mkdirs();
        } else if (!i_Dir.isDirectory()) {
            return -1;
        }
        FileDataPacket v_Old = (FileDataPacket)$DataPackets.get((Object)i_DataPacket.getName());
        if (v_Old != null && v_Old.getDataNo() >= i_DataPacket.getDataNo()) {
            return 0;
        }
        String v_FileFullName = i_Dir.getAbsolutePath() + Help.getSysPathSeparator() + i_DataPacket.getName();
        this.append(v_FileFullName, i_DataPacket.getDataByte());
        if (i_DataPacket.getDataCount().intValue() == i_DataPacket.getDataNo().intValue()) {
            $DataPackets.remove((Object)i_DataPacket.getName());
            File v_UploadFile = new File(v_FileFullName);
            if (v_UploadFile.exists() && (i_DataPacket.getSize() == null || i_DataPacket.getSize().equals(v_UploadFile.length()))) {
                return 1;
            }
            return -2;
        }
        $DataPackets.put((Object)i_DataPacket.getName(), (Object)i_DataPacket, this.dataPacketTimeOut);
        return 0;
    }

    public static String getContent(ServletRequest i_Request) {
        return FileHelp.getContent(i_Request, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContent(ServletRequest i_Request, String i_CharacterEncoding) {
        BufferedReader v_Input = null;
        try {
            StringBuilder v_Buffer = new StringBuilder();
            String v_Line = "";
            v_Input = new BufferedReader(new InputStreamReader((InputStream)i_Request.getInputStream(), i_CharacterEncoding));
            while ((v_Line = v_Input.readLine()) != null) {
                v_Buffer.append(v_Line);
            }
            String string = v_Buffer.toString();
            return string;
        }
        catch (Exception exce) {
            exce.printStackTrace();
        }
        finally {
            if (v_Input != null) {
                try {
                    v_Input.close();
                }
                catch (Exception exce) {
                    exce.printStackTrace();
                }
            }
            v_Input = null;
        }
        return null;
    }

    public void writeHttp(String i_Datas, ServletResponse i_Response) throws IOException {
        FileHelp.writeHttp(i_Datas, i_Response, this.charEncoding, this.contentType);
    }

    public static void writeHttp(String i_Datas, ServletResponse i_Response, String i_CharacterEncoding, String i_ContentType) throws IOException {
        i_Response.setCharacterEncoding(i_CharacterEncoding);
        i_Response.setContentType(i_ContentType);
        try (PrintWriter v_Out = null;){
            v_Out = i_Response.getWriter();
            v_Out.write(i_Datas);
        }
    }

    public static void printlnRequestHeader(HttpServletRequest i_Request) {
        if (i_Request != null) {
            Enumeration v_HeaderNames = i_Request.getHeaderNames();
            while (v_HeaderNames.hasMoreElements()) {
                String v_HeaderName = v_HeaderNames.nextElement().toString();
                String v_HeaderValue = i_Request.getHeader(v_HeaderName);
                System.out.println("-- " + v_HeaderName + "=" + v_HeaderValue);
            }
        }
    }

    public void append(String i_SaveFileFullName, String i_Contents) throws IOException {
        this.append(i_SaveFileFullName, i_Contents, this.charEncoding);
    }

    public void append(String i_SaveFileFullName, String i_Contents, String i_CharEncoding) throws IOException {
        this.isAppend = true;
        this.create(i_SaveFileFullName, i_Contents, i_CharEncoding);
    }

    public void append(String i_SaveFileFullName, byte[] i_Contents) throws IOException {
        this.isAppend = true;
        this.create(i_SaveFileFullName, i_Contents);
    }

    public void create(String i_SaveFileFullName, String[] i_Contents) throws IOException {
        this.create(i_SaveFileFullName, i_Contents, this.charEncoding);
    }

    public void create(String i_SaveFileFullName, String[] i_Contents, String i_CharEncoding) throws IOException {
        StringBuilder v_Buffer = new StringBuilder();
        for (String v_Row : i_Contents) {
            v_Buffer.append(v_Row).append("\r\n");
        }
        this.create(i_SaveFileFullName, v_Buffer.toString(), i_CharEncoding);
    }

    public void create(String i_SaveFileFullName, String i_Contents) throws IOException {
        this.create(i_SaveFileFullName, i_Contents, this.charEncoding);
    }

    public void create(String i_SaveFileFullName, String i_Contents, String i_CharEncoding) throws IOException {
        if (Help.isNull((String)i_SaveFileFullName)) {
            throw new NullPointerException("Save full name is null.");
        }
        File v_SaveFile = new File(i_SaveFileFullName);
        if (v_SaveFile.exists() && !this.isAppend) {
            if (this.isOverWrite) {
                boolean v_Result = v_SaveFile.delete();
                if (!v_Result) {
                    v_SaveFile = null;
                    throw new IOException("Delete target file[" + i_SaveFileFullName + "] exception.");
                }
            } else {
                v_SaveFile = null;
                throw new IOException("Target[" + i_SaveFileFullName + "] is exists.");
            }
        }
        FileOutputStream v_SaveOutput = new FileOutputStream(v_SaveFile, this.isAppend);
        OutputStreamWriter v_SaveWriter = new OutputStreamWriter((OutputStream)v_SaveOutput, i_CharEncoding);
        try {
            v_SaveWriter.write(i_Contents);
            v_SaveWriter.flush();
        }
        catch (Exception exce) {
            throw new IOException(exce.getMessage());
        }
        finally {
            try {
                v_SaveWriter.flush();
                v_SaveWriter.close();
            }
            catch (Exception exception) {}
            try {
                v_SaveOutput.close();
            }
            catch (Exception exception) {}
            v_SaveWriter = null;
            v_SaveOutput = null;
            v_SaveFile = null;
        }
    }

    public void create(URL i_SaveFile, String[] i_Contents) throws IOException, URISyntaxException {
        this.create(i_SaveFile, i_Contents, this.charEncoding);
    }

    public void create(URL i_SaveFile, String[] i_Contents, String i_CharEncoding) throws IOException, URISyntaxException {
        StringBuilder v_Buffer = new StringBuilder();
        for (String v_Row : i_Contents) {
            v_Buffer.append(v_Row).append("\r\n");
        }
        this.create(i_SaveFile, v_Buffer.toString(), i_CharEncoding);
    }

    public void create(URL i_SaveFile, String i_Contents) throws IOException, URISyntaxException {
        this.create(i_SaveFile, i_Contents, this.charEncoding);
    }

    public void create(URL i_SaveFile, String i_Contents, String i_CharEncoding) throws IOException, URISyntaxException {
        if (i_SaveFile == null) {
            throw new NullPointerException("Save full file is null.");
        }
        File v_SaveFile = new File(i_SaveFile.toURI());
        if (v_SaveFile.exists() && !this.isAppend) {
            if (this.isOverWrite) {
                boolean v_Result = v_SaveFile.delete();
                if (!v_Result) {
                    v_SaveFile = null;
                    throw new IOException("Delete target file[" + i_SaveFile.toString() + "] exception.");
                }
            } else {
                v_SaveFile = null;
                throw new IOException("Target[" + i_SaveFile.toString() + "] is exists.");
            }
        }
        FileOutputStream v_SaveOutput = new FileOutputStream(v_SaveFile, this.isAppend);
        OutputStreamWriter v_SaveWriter = new OutputStreamWriter((OutputStream)v_SaveOutput, i_CharEncoding);
        try {
            v_SaveWriter.write(i_Contents);
            v_SaveWriter.flush();
        }
        catch (Exception exce) {
            throw new IOException(exce.getMessage());
        }
        finally {
            try {
                v_SaveWriter.flush();
                v_SaveWriter.close();
            }
            catch (Exception exception) {}
            try {
                v_SaveOutput.close();
            }
            catch (Exception exception) {}
            v_SaveWriter = null;
            v_SaveOutput = null;
            v_SaveFile = null;
        }
    }

    public void create(String i_SaveFileFullName, byte[] i_Contents) throws IOException {
        if (Help.isNull((String)i_SaveFileFullName)) {
            throw new NullPointerException("Save full name is null.");
        }
        File v_SaveFile = new File(i_SaveFileFullName);
        if (v_SaveFile.exists() && !this.isAppend) {
            if (this.isOverWrite) {
                boolean v_Result = v_SaveFile.delete();
                if (!v_Result) {
                    v_SaveFile = null;
                    throw new IOException("Delete target file[" + i_SaveFileFullName + "] exception.");
                }
            } else {
                v_SaveFile = null;
                throw new IOException("Target[" + i_SaveFileFullName + "] is exists.");
            }
        }
        FileOutputStream v_SaveOutput = new FileOutputStream(v_SaveFile, this.isAppend);
        try {
            v_SaveOutput.write(i_Contents == null ? new byte[]{} : i_Contents);
            v_SaveOutput.flush();
        }
        catch (Exception exce) {
            throw new IOException(exce.getMessage());
        }
        finally {
            try {
                v_SaveOutput.close();
            }
            catch (Exception exception) {}
            v_SaveOutput = null;
            v_SaveFile = null;
        }
    }

    public void createCSV(String i_SaveFileFullName, List<?> i_Contents) throws IOException {
        this.createCSV(i_SaveFileFullName, null, i_Contents, this.charEncoding);
    }

    public void createCSV(String i_SaveFileFullName, List<?> i_Titles, List<?> i_Contents) throws IOException {
        this.createCSV(i_SaveFileFullName, i_Titles, i_Contents, this.charEncoding);
    }

    public void createCSV(String i_SaveFileFullName, FileBiggerMemory i_FileBiggerMemory) throws IOException {
        this.createCSV(i_SaveFileFullName, null, i_FileBiggerMemory, this.charEncoding);
    }

    public void createCSV(String i_SaveFileFullName, List<?> i_Titles, FileBiggerMemory i_FileBiggerMemory) throws IOException {
        this.createCSV(i_SaveFileFullName, i_Titles, i_FileBiggerMemory, this.charEncoding);
    }

    public void createCSV(String i_SaveFileFullName, List<?> i_Titles, List<?> i_Contents, String i_CharEncoding) throws IOException {
        if (Help.isNull((String)i_SaveFileFullName)) {
            throw new NullPointerException("Save full name is null.");
        }
        if (i_Contents == null || i_Contents.size() <= 0) {
            throw new NullPointerException("File[" + i_SaveFileFullName + "] contents is null.");
        }
        File v_SaveFile = new File(i_SaveFileFullName);
        if (v_SaveFile.exists() && !this.isAppend) {
            if (this.isOverWrite) {
                boolean v_Result = v_SaveFile.delete();
                if (!v_Result) {
                    v_SaveFile = null;
                    throw new IOException("Delete target file[" + i_SaveFileFullName + "] exception.");
                }
            } else {
                v_SaveFile = null;
                throw new IOException("Target[" + i_SaveFileFullName + "] is exists.");
            }
        }
        long v_RowSize = i_Contents.size();
        FileOutputStream v_SaveOutput = new FileOutputStream(v_SaveFile, this.isAppend);
        OutputStreamWriter v_SaveWriter = new OutputStreamWriter((OutputStream)v_SaveOutput, i_CharEncoding);
        DefaultCreateCSVEvent v_Event = new DefaultCreateCSVEvent(this, v_RowSize);
        boolean v_IsContinue = true;
        try {
            v_IsContinue = this.fireCreateCSVBeforeListener(v_Event);
            if (v_IsContinue) {
                int v_RowInfoType = 0;
                int v_PropertySize = 0;
                Object v_TitleData = i_Contents.get(0);
                if (v_TitleData instanceof FileSerializable) {
                    v_PropertySize = ((FileSerializable)v_TitleData).gatPropertySize();
                    v_RowInfoType = 1;
                } else if (v_TitleData instanceof List) {
                    v_PropertySize = ((List)v_TitleData).size();
                    v_RowInfoType = 2;
                } else {
                    throw new ClassCastException("Row info type is only FileSerializable or List.");
                }
                if (v_PropertySize > 0) {
                    if (v_RowInfoType == 1) {
                        if (i_Titles == null) {
                            this.createCSV_WriteTitle(v_SaveWriter, (FileSerializable)v_TitleData, v_PropertySize);
                        } else {
                            this.createCSV_WriteTitle(v_SaveWriter, i_Titles, v_PropertySize);
                        }
                        this.createCSV_WriteRowData(v_SaveWriter, (FileSerializable)v_TitleData, v_PropertySize);
                        ((FileSerializable)v_TitleData).freeResource();
                    } else if (v_RowInfoType == 2) {
                        if (i_Titles != null) {
                            this.createCSV_WriteTitle(v_SaveWriter, i_Titles, v_PropertySize);
                        }
                        this.createCSV_WriteRowData(v_SaveWriter, (List)v_TitleData, v_PropertySize);
                        ((List)v_TitleData).clear();
                    }
                    v_TitleData = null;
                    if (v_RowInfoType == 1) {
                        for (long v_RowIndex = 1L; v_IsContinue && v_RowIndex < v_RowSize; ++v_RowIndex) {
                            FileSerializable v_RowData = (FileSerializable)i_Contents.get((int)v_RowIndex);
                            this.createCSV_WriteRowData(v_SaveWriter, v_RowData, v_PropertySize);
                            v_Event.setCompleteSize(v_RowIndex);
                            v_IsContinue = this.fireCreatingCSVListener(v_Event);
                        }
                    } else if (v_RowInfoType == 2) {
                        for (long v_RowIndex = 1L; v_IsContinue && v_RowIndex < v_RowSize; ++v_RowIndex) {
                            List v_RowData = (List)i_Contents.get((int)v_RowIndex);
                            this.createCSV_WriteRowData(v_SaveWriter, v_RowData, v_PropertySize);
                            v_Event.setCompleteSize(v_RowIndex);
                            v_IsContinue = this.fireCreatingCSVListener(v_Event);
                        }
                    }
                }
            }
            v_Event.setSucceedFinish();
        }
        catch (Exception exce) {
            v_Event.setEndTime();
            throw new IOException(exce.getMessage());
        }
        finally {
            try {
                v_SaveWriter.flush();
                v_SaveWriter.close();
            }
            catch (Exception exception) {}
            try {
                v_SaveOutput.close();
            }
            catch (Exception exception) {}
            v_SaveWriter = null;
            v_SaveOutput = null;
            v_SaveFile = null;
            this.fireCreateCSVAfterListener(v_Event);
        }
    }

    public void createCSV(String i_SaveFileFullName, List<?> i_Titles, FileBiggerMemory i_FileBiggerMemory, String i_CharEncoding) throws IOException {
        if (Help.isNull((String)i_SaveFileFullName)) {
            throw new NullPointerException("Save full name is null.");
        }
        if (i_FileBiggerMemory == null || i_FileBiggerMemory.getRowSize() <= 0L) {
            throw new NullPointerException("File[" + i_SaveFileFullName + "] bigger memory is null.");
        }
        File v_SaveFile = new File(i_SaveFileFullName);
        if (v_SaveFile.exists() && !this.isAppend) {
            if (this.isOverWrite) {
                boolean v_Result = v_SaveFile.delete();
                if (!v_Result) {
                    v_SaveFile = null;
                    throw new IOException("Delete target file[" + i_SaveFileFullName + "] exception.");
                }
            } else {
                v_SaveFile = null;
                throw new IOException("Target[" + i_SaveFileFullName + "] is exists.");
            }
        }
        long v_RowSize = i_FileBiggerMemory.getRowSize();
        FileOutputStream v_SaveOutput = new FileOutputStream(v_SaveFile, this.isAppend);
        OutputStreamWriter v_SaveWriter = new OutputStreamWriter((OutputStream)v_SaveOutput, i_CharEncoding);
        DefaultCreateCSVEvent v_Event = new DefaultCreateCSVEvent(this, v_RowSize);
        boolean v_IsContinue = true;
        try {
            v_IsContinue = this.fireCreateCSVBeforeListener(v_Event);
            if (v_IsContinue) {
                int v_RowInfoType = 0;
                int v_PropertySize = 0;
                Object v_TitleData = i_FileBiggerMemory.getRowInfo(0L);
                if (v_TitleData instanceof FileSerializable) {
                    v_PropertySize = ((FileSerializable)v_TitleData).gatPropertySize();
                    v_RowInfoType = 1;
                } else if (v_TitleData instanceof List) {
                    v_PropertySize = ((List)v_TitleData).size();
                    v_RowInfoType = 2;
                } else {
                    throw new ClassCastException("Row info type is only FileSerializable or List.");
                }
                if (v_PropertySize > 0) {
                    if (v_RowInfoType == 1) {
                        if (i_Titles == null) {
                            this.createCSV_WriteTitle(v_SaveWriter, (FileSerializable)v_TitleData, v_PropertySize);
                        } else {
                            this.createCSV_WriteTitle(v_SaveWriter, i_Titles, v_PropertySize);
                        }
                        this.createCSV_WriteRowData(v_SaveWriter, (FileSerializable)v_TitleData, v_PropertySize);
                        ((FileSerializable)v_TitleData).freeResource();
                    } else if (v_RowInfoType == 2) {
                        if (i_Titles != null) {
                            this.createCSV_WriteTitle(v_SaveWriter, i_Titles, v_PropertySize);
                        }
                        this.createCSV_WriteRowData(v_SaveWriter, (List)v_TitleData, v_PropertySize);
                        ((List)v_TitleData).clear();
                    }
                    v_TitleData = null;
                    if (v_RowInfoType == 1) {
                        for (long v_RowIndex = 1L; v_IsContinue && v_RowIndex < v_RowSize; ++v_RowIndex) {
                            FileSerializable v_RowData = (FileSerializable)i_FileBiggerMemory.getRowInfo(v_RowIndex);
                            this.createCSV_WriteRowData(v_SaveWriter, v_RowData, v_PropertySize);
                            v_RowData.freeResource();
                            v_RowData = null;
                            v_Event.setCompleteSize(v_RowIndex);
                            v_IsContinue = this.fireCreatingCSVListener(v_Event);
                        }
                    } else if (v_RowInfoType == 2) {
                        for (long v_RowIndex = 1L; v_IsContinue && v_RowIndex < v_RowSize; ++v_RowIndex) {
                            List v_RowData = (List)i_FileBiggerMemory.getRowInfo(v_RowIndex);
                            this.createCSV_WriteRowData(v_SaveWriter, v_RowData, v_PropertySize);
                            v_RowData.clear();
                            v_RowData = null;
                            v_Event.setCompleteSize(v_RowIndex);
                            v_IsContinue = this.fireCreatingCSVListener(v_Event);
                        }
                    }
                }
            }
            v_Event.setSucceedFinish();
        }
        catch (Exception exce) {
            v_Event.setEndTime();
            throw new IOException(exce.getMessage());
        }
        finally {
            try {
                v_SaveWriter.flush();
                v_SaveWriter.close();
            }
            catch (Exception exception) {}
            try {
                v_SaveOutput.close();
            }
            catch (Exception exception) {}
            v_SaveWriter = null;
            v_SaveOutput = null;
            v_SaveFile = null;
            this.fireCreateCSVAfterListener(v_Event);
        }
    }

    private void createCSV(String i_SaveFileFullName, ResultSet i_ResultSet, String i_CharEncoding) throws IOException {
        if (Help.isNull((String)i_SaveFileFullName)) {
            throw new NullPointerException("Save full name is null.");
        }
        if (i_ResultSet == null) {
            throw new NullPointerException("File[" + i_SaveFileFullName + "] bigger memory is null.");
        }
        File v_SaveFile = new File(i_SaveFileFullName);
        if (v_SaveFile.exists() && !this.isAppend) {
            if (this.isOverWrite) {
                boolean v_Result = v_SaveFile.delete();
                if (!v_Result) {
                    v_SaveFile = null;
                    throw new IOException("Delete target file[" + i_SaveFileFullName + "] exception.");
                }
            } else {
                v_SaveFile = null;
                throw new IOException("Target[" + i_SaveFileFullName + "] is exists.");
            }
        }
        FileOutputStream v_SaveOutput = new FileOutputStream(v_SaveFile, this.isAppend);
        OutputStreamWriter v_SaveWriter = new OutputStreamWriter((OutputStream)v_SaveOutput, i_CharEncoding);
        boolean v_IsContinue = true;
        try {
            if (v_IsContinue) {
                int v_PropertySize = i_ResultSet.getMetaData().getColumnCount();
                while (i_ResultSet.next()) {
                    for (int v_PropertyIndex = 1; v_PropertyIndex <= v_PropertySize; ++v_PropertyIndex) {
                        String v_Value = i_ResultSet.getString(v_PropertyIndex);
                        if (v_Value == null) {
                            v_SaveWriter.write("\"\"");
                        } else {
                            v_SaveWriter.write("\"");
                            v_SaveWriter.write(v_Value.replaceAll("\"", "\"\""));
                            v_SaveWriter.write("\"");
                        }
                        if (v_PropertyIndex >= v_PropertySize - 1) continue;
                        v_SaveWriter.write(",");
                    }
                    v_SaveWriter.write(this.getNewLine());
                    v_SaveWriter.flush();
                }
            }
        }
        catch (Exception exce) {
            throw new IOException(exce.getMessage());
        }
        finally {
            try {
                v_SaveWriter.flush();
                v_SaveWriter.close();
            }
            catch (Exception exception) {}
            try {
                v_SaveOutput.close();
            }
            catch (Exception exception) {}
            v_SaveWriter = null;
            v_SaveOutput = null;
            v_SaveFile = null;
        }
    }

    private void createCSV_WriteTitle(OutputStreamWriter i_Write, FileSerializable i_RowData, int i_PropertySize) throws IOException {
        StringBuilder v_Buffer = new StringBuilder();
        for (int v_PropertyIndex = 0; v_PropertyIndex < i_PropertySize; ++v_PropertyIndex) {
            v_Buffer.append("\"");
            String v_Value = i_RowData.gatPropertyName(v_PropertyIndex);
            if (v_Value != null) {
                v_Buffer.append(v_Value.toString().replaceAll("\"", "\"\""));
            }
            v_Buffer.append("\"");
            if (v_PropertyIndex >= i_PropertySize - 1) continue;
            v_Buffer.append(",");
        }
        v_Buffer.append(this.getNewLine());
        i_Write.write(v_Buffer.toString());
        i_Write.flush();
    }

    private void createCSV_WriteTitle(OutputStreamWriter i_Write, List<?> i_Titals, int i_PropertySize) throws IOException {
        StringBuilder v_Buffer = new StringBuilder();
        for (int v_PropertyIndex = 0; v_PropertyIndex < i_PropertySize; ++v_PropertyIndex) {
            v_Buffer.append("\"");
            Object v_Value = i_Titals.get(v_PropertyIndex);
            if (v_Value != null) {
                v_Buffer.append(v_Value.toString().replaceAll("\"", "\"\""));
            }
            v_Buffer.append("\"");
            if (v_PropertyIndex >= i_PropertySize - 1) continue;
            v_Buffer.append(",");
        }
        v_Buffer.append(this.getNewLine());
        i_Write.write(v_Buffer.toString());
        i_Write.flush();
    }

    private void createCSV_WriteRowData(OutputStreamWriter i_Write, FileSerializable i_RowData, int i_PropertySize) throws IOException {
        StringBuilder v_Buffer = new StringBuilder();
        for (int v_PropertyIndex = 0; v_PropertyIndex < i_PropertySize; ++v_PropertyIndex) {
            v_Buffer.append(this.getCsvDataPrefix());
            v_Buffer.append("\"");
            Object v_Value = i_RowData.gatPropertyValue(v_PropertyIndex);
            if (v_Value != null) {
                v_Buffer.append(v_Value.toString().replaceAll("\"", "\"\""));
            }
            v_Buffer.append("\"");
            if (v_PropertyIndex >= i_PropertySize - 1) continue;
            v_Buffer.append(",");
        }
        v_Buffer.append(this.getNewLine());
        i_Write.write(v_Buffer.toString());
        i_Write.flush();
    }

    private void createCSV_WriteRowData(OutputStreamWriter i_Write, List<?> i_RowData, int i_PropertySize) throws IOException {
        StringBuilder v_Buffer = new StringBuilder();
        for (int v_PropertyIndex = 0; v_PropertyIndex < i_PropertySize; ++v_PropertyIndex) {
            v_Buffer.append(this.getCsvDataPrefix());
            v_Buffer.append("\"");
            Object v_Value = i_RowData.get(v_PropertyIndex);
            if (v_Value != null) {
                v_Buffer.append(v_Value.toString().replaceAll("\"", "\"\""));
            }
            v_Buffer.append("\"");
            if (v_PropertyIndex >= i_PropertySize - 1) continue;
            v_Buffer.append(",");
        }
        v_Buffer.append(this.getNewLine());
        i_Write.write(v_Buffer.toString());
        i_Write.flush();
    }

    public void createZip(String i_SaveZipFullName, Collection<?> i_SourceLists) throws IOException {
        this.createZip(i_SaveZipFullName, null, i_SourceLists, false);
    }

    public void createZip(String i_SaveZipFullName, String i_ZipRootPath, Collection<?> i_SourceLists) throws IOException {
        this.createZip(i_SaveZipFullName, i_ZipRootPath, i_SourceLists, false);
    }

    public void createZip(String i_SaveZipFullName, String i_ZipRootPath, Collection<?> i_SourceLists, boolean i_IgnoreSourceFileError) throws IOException {
        if (Help.isNull((String)i_SaveZipFullName)) {
            throw new NullPointerException("Save full name is null.");
        }
        if (i_SourceLists == null || i_SourceLists.size() <= 0) {
            throw new NullPointerException("Zip source files[" + i_SaveZipFullName + "] list is null.");
        }
        File v_SaveZipFile = new File(i_SaveZipFullName);
        if (v_SaveZipFile.exists()) {
            if (this.isOverWrite) {
                boolean v_Result = v_SaveZipFile.delete();
                if (!v_Result) {
                    v_SaveZipFile = null;
                    throw new IOException("Delete target file[" + i_SaveZipFullName + "] exception.");
                }
            } else {
                v_SaveZipFile = null;
                throw new IOException("Target[" + i_SaveZipFullName + "] is exists.");
            }
        }
        FileInputStream v_SourceInput = null;
        FileOutputStream v_ZipOutput = new FileOutputStream(v_SaveZipFile);
        ZipOutputStream v_ZipWriter = new ZipOutputStream((OutputStream)v_ZipOutput, Charset.forName(this.charEncoding));
        Iterator<?> v_IterSources = i_SourceLists.iterator();
        DefaultCreateZipEvent v_Event = new DefaultCreateZipEvent(this, i_SourceLists.size());
        boolean v_IsContinue = true;
        Object v_ZipRootPath = Help.NVL((String)i_ZipRootPath).trim().toLowerCase();
        int v_ReadIndex = 0;
        if (!((String)v_ZipRootPath).endsWith(Help.getSysPathSeparator())) {
            v_ZipRootPath = (String)v_ZipRootPath + Help.getSysPathSeparator();
        }
        try {
            v_IsContinue = this.fireCreateZipBeforeListener(v_Event);
            while (v_IsContinue && v_IterSources.hasNext()) {
                String v_LowerFullName;
                String v_SourceFileFullName = v_IterSources.next().toString();
                File v_SourceFile = new File(v_SourceFileFullName);
                if (!v_SourceFile.exists()) {
                    if (!i_IgnoreSourceFileError) {
                        throw new RuntimeException(v_SourceFileFullName + " is not exists.");
                    }
                    v_Event.setIgnoreErrorSize(v_Event.getIgnoreErrorSize() + 1L);
                    continue;
                }
                if (!v_SourceFile.canRead()) {
                    if (!i_IgnoreSourceFileError) {
                        throw new RuntimeException(v_SourceFileFullName + " can not read.");
                    }
                    v_Event.setIgnoreErrorSize(v_Event.getIgnoreErrorSize() + 1L);
                    continue;
                }
                long v_SourceLen = v_SourceFile.length();
                long v_WriteIndex = 0L;
                byte[] v_ByteBuffer = new byte[this.bufferSize];
                DefaultCreateZipEvent v_PerSource = new DefaultCreateZipEvent(this, v_SourceLen);
                ZipEntry v_ZipEntry = null;
                String v_DirFlag = v_SourceFile.isDirectory() ? "/" : "";
                v_Event.setPerSource(v_PerSource);
                v_IsContinue = this.fireCreatingZipListener(v_Event);
                v_ZipEntry = Help.isNull((String)i_ZipRootPath) ? new ZipEntry(v_SourceFile.getName() + v_DirFlag) : ((v_LowerFullName = v_SourceFile.getAbsolutePath().toLowerCase()).startsWith((String)v_ZipRootPath) ? new ZipEntry(v_SourceFile.getAbsolutePath().substring(((String)v_ZipRootPath).length()) + v_DirFlag) : new ZipEntry(v_SourceFile.getAbsolutePath() + v_DirFlag));
                v_ZipEntry.setTime(v_SourceFile.lastModified());
                v_ZipWriter.putNextEntry(v_ZipEntry);
                if (!v_SourceFile.isDirectory()) {
                    v_SourceInput = new FileInputStream(v_SourceFile);
                    v_ReadIndex = v_SourceInput.read(v_ByteBuffer);
                    while (v_IsContinue && v_ReadIndex >= 1) {
                        v_ZipWriter.write(v_ByteBuffer, 0, v_ReadIndex);
                        v_ZipWriter.flush();
                        v_PerSource.setCompleteSize(v_WriteIndex += (long)v_ReadIndex);
                        v_Event.setPerSource(v_PerSource);
                        v_IsContinue = this.fireCreatingZipListener(v_Event);
                        v_ReadIndex = v_SourceInput.read(v_ByteBuffer);
                    }
                    try {
                        v_SourceInput.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    v_SourceInput = null;
                    v_SourceFile = null;
                    continue;
                }
                v_ZipWriter.closeEntry();
            }
            v_Event.setSucceedFinish();
        }
        catch (Exception exce) {
            v_Event.setEndTime();
            throw new IOException(exce.getMessage());
        }
        finally {
            if (v_SourceInput != null) {
                try {
                    v_SourceInput.close();
                }
                catch (Exception exception) {}
                v_SourceInput = null;
            }
            if (v_ZipWriter != null) {
                try {
                    v_ZipWriter.close();
                }
                catch (Exception exception) {}
                v_ZipWriter = null;
            }
            if (v_ZipOutput != null) {
                try {
                    v_ZipOutput.close();
                }
                catch (Exception exception) {}
                v_ZipOutput = null;
            }
            this.fireCreateZipAfterListener(v_Event);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void UnCompressZip(String i_ZipFullName, String i_SaveDir, boolean i_IgnoreUnZipError) throws IOException {
        boolean v_Result;
        if (Help.isNull((String)i_ZipFullName)) {
            throw new NullPointerException("Zip full name is null.");
        }
        if (Help.isNull((String)i_SaveDir)) {
            throw new NullPointerException("Zip save directory is null.");
        }
        File v_ZipFile = new File(i_ZipFullName);
        if (!v_ZipFile.exists()) {
            v_ZipFile = null;
            throw new IOException("Zip file[" + i_ZipFullName + "] is not exists.");
        }
        if (!v_ZipFile.isFile()) {
            v_ZipFile = null;
            throw new IOException("Zip[" + i_ZipFullName + "] is not file.");
        }
        if (!v_ZipFile.canRead()) {
            v_ZipFile = null;
            throw new IOException("Zip[" + i_ZipFullName + "] can not read.");
        }
        File v_SaveDirFile = new File(i_SaveDir);
        if (!v_SaveDirFile.exists() && !(v_Result = v_SaveDirFile.mkdirs())) {
            v_SaveDirFile = null;
            throw new IOException("Create save dir[" + i_SaveDir + "] exception.");
        }
        java.util.zip.ZipFile v_ZipFileObject = new java.util.zip.ZipFile(v_ZipFile);
        Enumeration<? extends ZipEntry> v_ZipEntries = v_ZipFileObject.entries();
        boolean v_IsContinue = true;
        long v_TotalSize = v_ZipFile.length();
        DefaultUnCompressZipEvent v_Event = new DefaultUnCompressZipEvent(this, v_TotalSize);
        v_IsContinue = this.fireUnCompressZipBeforeListener(v_Event);
        block13: while (v_IsContinue && v_ZipEntries.hasMoreElements()) {
            File v_TargetFile;
            ZipEntry v_ZipEntry;
            block28: {
                boolean v_Result2;
                v_ZipEntry = v_ZipEntries.nextElement();
                String v_TargetFullName = v_SaveDirFile.getAbsolutePath() + Help.getSysPathSeparator() + StringHelp.replaceAll((String)v_ZipEntry.getName(), (String[])new String[]{"\\", "/"}, (String[])new String[]{Help.getSysPathSeparator()});
                v_TargetFile = new File(v_TargetFullName);
                if (v_TargetFile.exists()) {
                    if (this.isOverWrite()) {
                        if (!v_TargetFile.delete()) {
                            if (i_IgnoreUnZipError) continue;
                            v_Event.setEndTime();
                            this.fireUnCompressZipAfterListener(v_Event);
                            throw new IOException("Delete target file[" + v_TargetFullName + "] exception.");
                        }
                        break block28;
                    } else {
                        if (i_IgnoreUnZipError) continue;
                        v_Event.setEndTime();
                        this.fireUnCompressZipAfterListener(v_Event);
                        throw new IOException("Target file[" + v_TargetFullName + "] is exists.");
                    }
                }
                if (v_ZipEntry.isDirectory()) {
                    if (v_TargetFile.exists() || (v_Result2 = v_TargetFile.mkdirs())) continue;
                    v_SaveDirFile = null;
                    throw new IOException("Create save dir[" + v_TargetFile.toString() + "] exception.");
                }
                if (!v_TargetFile.getParentFile().exists() && !(v_Result2 = v_TargetFile.getParentFile().mkdirs())) {
                    v_SaveDirFile = null;
                    throw new IOException("Create save dir[" + v_TargetFile.getParent() + "] exception.");
                }
            }
            InputStream v_SourceInput = v_ZipFileObject.getInputStream(v_ZipEntry);
            FileOutputStream v_TargetOutput = new FileOutputStream(v_TargetFile);
            long v_SourceLen = v_ZipEntry.getSize();
            long v_WriteIndex = 0L;
            byte[] v_ByteBuffer = new byte[this.bufferSize];
            DefaultUnCompressZipEvent v_PerSource = new DefaultUnCompressZipEvent(this, v_SourceLen);
            try {
                v_Event.setPerSource(v_PerSource);
                v_IsContinue = this.fireUnCompressZipListener(v_Event);
                while (v_IsContinue) {
                    int v_ReadSize = v_SourceInput.read(v_ByteBuffer);
                    if (v_ReadSize <= 0) {
                        v_PerSource.setSucceedFinish();
                        v_Event.setPerSource(v_PerSource);
                        v_IsContinue = this.fireUnCompressZipListener(v_Event);
                        continue block13;
                    }
                    ((OutputStream)v_TargetOutput).write(v_ByteBuffer, 0, v_ReadSize);
                    v_TargetOutput.flush();
                    v_PerSource.setCompleteSize(v_WriteIndex += (long)v_ReadSize);
                    v_Event.setPerSource(v_PerSource);
                    v_IsContinue = this.fireUnCompressZipListener(v_Event);
                }
            }
            catch (Exception exce) {
                v_PerSource.setEndTime();
                throw new IOException(exce.getMessage());
            }
            finally {
                try {
                    v_SourceInput.close();
                }
                catch (Exception exception) {}
                try {
                    ((OutputStream)v_TargetOutput).close();
                }
                catch (Exception exception) {}
                v_TargetFile.setLastModified(v_ZipEntry.getTime());
                v_SourceInput = null;
                v_TargetOutput = null;
                v_TargetFile = null;
            }
        }
        v_Event.setSucceedFinish();
        this.fireUnCompressZipAfterListener(v_Event);
        v_ZipEntries = null;
        v_ZipFileObject.close();
    }

    public String UnCompressZip(URL i_ZipURL, String i_ReadFileName, String i_CharEncoding) throws Exception {
        if (i_ZipURL == null) {
            throw new NullPointerException("Zip URL is null.");
        }
        File v_File = new File(i_ZipURL.toString());
        if (!v_File.exists()) {
            v_File = new File(i_ZipURL.getFile());
        }
        return this.UnCompressZip(v_File, i_ReadFileName, i_CharEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String UnCompressZip(File i_ZipFile, String i_ReadFileName, String i_CharEncoding) throws Exception {
        if (i_ZipFile == null) {
            throw new NullPointerException("Zip file is null.");
        }
        File v_ZipFile = i_ZipFile;
        if (!v_ZipFile.exists()) {
            v_ZipFile = null;
            throw new IOException("Zip file[" + i_ZipFile.toString() + "] is not exists.");
        }
        if (!v_ZipFile.isFile()) {
            v_ZipFile = null;
            throw new IOException("Zip[" + i_ZipFile.toString() + "] is not file.");
        }
        if (!v_ZipFile.canRead()) {
            v_ZipFile = null;
            throw new IOException("Zip[" + i_ZipFile.toString() + "] can not read.");
        }
        java.util.zip.ZipFile v_ZipFileObject = null;
        StringBuilder v_Buffer = new StringBuilder();
        try {
            v_ZipFileObject = new java.util.zip.ZipFile(v_ZipFile);
            Enumeration<? extends ZipEntry> v_ZipEntries = v_ZipFileObject.entries();
            while (v_ZipEntries.hasMoreElements()) {
                ZipEntry v_ZipEntry = v_ZipEntries.nextElement();
                if (v_ZipEntry.isDirectory() || !i_ReadFileName.equalsIgnoreCase(v_ZipEntry.getName()) || v_ZipEntry.getSize() <= 0L) continue;
                BufferedReader v_SourceInput = null;
                try {
                    v_SourceInput = new BufferedReader(new InputStreamReader(v_ZipFileObject.getInputStream(v_ZipEntry), i_CharEncoding));
                    String v_Line = "";
                    while ((v_Line = v_SourceInput.readLine()) != null) {
                        v_Buffer.append(v_Line).append(Help.getSysLineSeparator());
                    }
                }
                catch (Exception exce) {
                    throw new IOException(exce.getMessage());
                }
                finally {
                    try {
                        v_SourceInput.close();
                    }
                    catch (Exception exception) {}
                    v_SourceInput = null;
                }
            }
            v_ZipEntries = null;
            v_ZipFile = null;
        }
        catch (Exception exce) {
            $Logger.error(exce);
        }
        finally {
            if (v_ZipFileObject != null) {
                v_ZipFileObject.close();
                v_ZipFileObject = null;
            }
        }
        return v_Buffer.toString();
    }

    public void createZip4j(String i_SaveZipFullName, String i_ZipFile) throws IOException {
        this.createZip4j(i_SaveZipFullName, i_ZipFile, true);
    }

    public void createZip4j(String i_SaveZipFullName, String i_ZipFile, boolean i_HaveRootName) throws IOException {
        this.createZip4j(i_SaveZipFullName, i_ZipFile, i_HaveRootName, null, CompressionLevel.NORMAL);
    }

    public void createZip4j(String i_SaveZipFullName, String i_ZipFile, String i_Password) throws IOException {
        this.createZip4j(i_SaveZipFullName, i_ZipFile, true, i_Password);
    }

    public void createZip4j(String i_SaveZipFullName, String i_ZipFile, boolean i_HaveRootName, String i_Password) throws IOException {
        this.createZip4j(i_SaveZipFullName, i_ZipFile, i_HaveRootName, i_Password, CompressionLevel.NORMAL);
    }

    public void createZip4j(String i_SaveZipFullName, String i_ZipFile, CompressionLevel i_CompressionLevel) throws IOException {
        this.createZip4j(i_SaveZipFullName, i_ZipFile, true, i_CompressionLevel);
    }

    public void createZip4j(String i_SaveZipFullName, String i_ZipFile, boolean i_HaveRootName, CompressionLevel i_CompressionLevel) throws IOException {
        this.createZip4j(i_SaveZipFullName, i_ZipFile, i_HaveRootName, null, i_CompressionLevel);
    }

    public void createZip4j(String i_SaveZipFullName, String i_ZipFile, String i_Password, CompressionLevel i_CompressionLevel) throws IOException {
        this.createZip4j(i_SaveZipFullName, i_ZipFile, true, i_Password, i_CompressionLevel);
    }

    public void createZip4j(String i_SaveZipFullName, String i_ZipFile, boolean i_HaveRootName, String i_Password, CompressionLevel i_CompressionLevel) throws IOException {
        if (Help.isNull((String)i_ZipFile)) {
            throw new NullPointerException("ZipFile is null.");
        }
        if (Help.isNull((String)i_SaveZipFullName)) {
            throw new NullPointerException("Save full name is null.");
        }
        this.createZip4j(new File(i_SaveZipFullName), new File(i_ZipFile), i_HaveRootName, i_Password, i_CompressionLevel);
    }

    public void createZip4j(File i_SaveZipFile, File i_ZipFile, boolean i_HaveRootName, String i_Password, CompressionLevel i_CompressionLevel) throws IOException {
        if (!i_ZipFile.exists()) {
            throw new IOException("ZipFile[" + i_ZipFile + "] is not exists.");
        }
        if (i_SaveZipFile.exists()) {
            if (this.isOverWrite) {
                boolean v_Result = i_SaveZipFile.delete();
                if (!v_Result) {
                    throw new IOException("Delete target file[" + i_SaveZipFile.toString() + "] exception.");
                }
            } else {
                throw new IOException("Target[" + i_SaveZipFile.toString() + "] is exists.");
            }
        }
        ZipParameters v_ZipParams = new ZipParameters();
        v_ZipParams.setCompressionMethod(CompressionMethod.DEFLATE);
        v_ZipParams.setCompressionLevel(i_CompressionLevel);
        if (i_Password != null && !"".equals(i_Password)) {
            v_ZipParams.setEncryptFiles(true);
            v_ZipParams.setEncryptionMethod(EncryptionMethod.AES);
        }
        try {
            ZipFile v_ZipWriter = null;
            v_ZipWriter = i_Password != null && !"".equals(i_Password) ? new ZipFile(i_SaveZipFile, i_Password.toCharArray()) : new ZipFile(i_SaveZipFile);
            v_ZipWriter.setCharset(Charset.forName(this.charEncoding));
            if (i_ZipFile.isDirectory()) {
                if (i_HaveRootName) {
                    v_ZipWriter.addFolder(i_ZipFile, v_ZipParams);
                } else {
                    Object[] v_ChildFiles = i_ZipFile.listFiles();
                    if (!Help.isNull((Object[])v_ChildFiles)) {
                        for (Object v_ChildFile : v_ChildFiles) {
                            if (((File)v_ChildFile).isDirectory()) {
                                v_ZipWriter.addFolder((File)v_ChildFile, v_ZipParams);
                                continue;
                            }
                            v_ZipWriter.addFile((File)v_ChildFile, v_ZipParams);
                        }
                    }
                }
            } else {
                v_ZipWriter.addFile(i_ZipFile, v_ZipParams);
            }
        }
        catch (Exception exce) {
            throw new IOException(exce.getMessage());
        }
    }

    public void UnCompressZip4j(String i_ZipFile, String i_UnCompressDir) throws IOException {
        this.UnCompressZip4j(i_ZipFile, i_UnCompressDir, null);
    }

    public void UnCompressZip4j(String i_ZipFile, String i_UnCompressDir, String i_Passwd) throws IOException {
        if (Help.isNull((String)i_ZipFile)) {
            throw new NullPointerException("ZipFile is null.");
        }
        this.UnCompressZip4j(new File(i_ZipFile), i_UnCompressDir, i_Passwd);
    }

    public void UnCompressZip4j(File i_ZipFile, String i_UnCompressDir) throws IOException {
        this.UnCompressZip4j(i_ZipFile, i_UnCompressDir, null);
    }

    public void UnCompressZip4j(File i_ZipFile, String i_UnCompressDir, String i_Passwd) throws IOException {
        if (Help.isNull((String)i_UnCompressDir)) {
            throw new NullPointerException("UnCompressDir is null.");
        }
        File v_UnCompressDir = new File(i_UnCompressDir.trim());
        if (!v_UnCompressDir.exists() || !v_UnCompressDir.isDirectory()) {
            v_UnCompressDir.mkdirs();
        }
        ZipFile v_ZipFile = null;
        try {
            v_ZipFile = new ZipFile(i_ZipFile);
            v_ZipFile.setCharset(Charset.forName(this.charEncoding));
        }
        catch (Exception exce) {
            throw new IOException(exce.getMessage());
        }
        if (!v_ZipFile.isValidZipFile()) {
            throw new IOException("ZipFile[" + i_ZipFile.toString() + "] is not valid ,may be damage.");
        }
        try {
            if (v_ZipFile.isEncrypted()) {
                if (i_Passwd == null || "".equals(i_Passwd)) {
                    throw new IOException("ZipFile[" + i_ZipFile.toString() + "] is the password required for encryption.");
                }
                v_ZipFile.setPassword(i_Passwd.toCharArray());
            }
            UnzipParameters v_UnzipParameters = new UnzipParameters();
            v_ZipFile.extractAll(i_UnCompressDir.trim(), v_UnzipParameters);
        }
        catch (Exception exce) {
            throw new IOException(exce.getMessage());
        }
    }

    public void createXD(String i_SaveXDFullName, String i_XDRootPath, Collection<?> i_SourceLists, boolean i_IgnoreSourceFileError) throws IOException {
        if (Help.isNull((String)i_SaveXDFullName)) {
            throw new NullPointerException("Save full name is null.");
        }
        if (i_SourceLists == null || i_SourceLists.size() <= 0) {
            throw new NullPointerException("source files[" + i_SaveXDFullName + "] list is null.");
        }
        File v_SaveXDFile = new File(i_SaveXDFullName);
        if (v_SaveXDFile.exists()) {
            if (this.isOverWrite) {
                boolean v_Result = v_SaveXDFile.delete();
                if (!v_Result) {
                    v_SaveXDFile = null;
                    throw new IOException("Delete target file[" + i_SaveXDFullName + "] exception.");
                }
            } else {
                v_SaveXDFile = null;
                throw new IOException("Target[" + i_SaveXDFullName + "] is exists.");
            }
        }
        FileOutputStream v_XDOutput = new FileOutputStream(v_SaveXDFile);
        ZipOutputStream v_XDWriter = new ZipOutputStream(v_XDOutput);
        Iterator<?> v_IterSources = i_SourceLists.iterator();
        Object v_XDRootPath = Help.NVL((String)i_XDRootPath).trim().toLowerCase();
        if (!((String)v_XDRootPath).endsWith(Help.getSysPathSeparator())) {
            v_XDRootPath = (String)v_XDRootPath + Help.getSysPathSeparator();
        }
        try {
            while (v_IterSources.hasNext()) {
                String v_SourceFileFullName = v_IterSources.next().toString();
                File v_SourceFile = new File(v_SourceFileFullName);
                if (!v_SourceFile.exists()) {
                    if (i_IgnoreSourceFileError) continue;
                    throw new RuntimeException(v_SourceFileFullName + " is not exists.");
                }
                if (!v_SourceFile.canRead()) {
                    if (i_IgnoreSourceFileError) continue;
                    throw new RuntimeException(v_SourceFileFullName + " can not read.");
                }
                FileInputStream v_SourceInput = new FileInputStream(v_SourceFile);
                long v_SourceLen = v_SourceFile.length();
                long v_WriteIndex = 0L;
                byte[] v_ByteBuffer = new byte[this.bufferSize];
                if (Help.isNull((String)i_XDRootPath)) {
                    v_XDWriter.putNextEntry(new ZipEntry(v_SourceFile.getName()));
                } else {
                    String v_LowerFullName = v_SourceFile.getAbsolutePath().toLowerCase();
                    if (v_LowerFullName.startsWith((String)v_XDRootPath)) {
                        v_XDWriter.putNextEntry(new ZipEntry(v_SourceFile.getAbsolutePath().substring(((String)v_XDRootPath).length())));
                    } else {
                        v_XDWriter.putNextEntry(new ZipEntry(v_SourceFile.getAbsolutePath()));
                    }
                }
                while (v_WriteIndex + (long)this.bufferSize <= v_SourceLen) {
                    v_SourceInput.read(v_ByteBuffer);
                    v_XDWriter.write(ByteHelp.xorMV((byte[])v_ByteBuffer));
                    v_XDWriter.flush();
                    v_WriteIndex += (long)this.bufferSize;
                }
                v_ByteBuffer = new byte[(int)(v_SourceLen - v_WriteIndex)];
                v_SourceInput.read(v_ByteBuffer);
                v_XDWriter.write(ByteHelp.xorMV((byte[])v_ByteBuffer));
                v_XDWriter.flush();
                try {
                    v_SourceInput.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                v_SourceInput = null;
                v_SourceFile = null;
            }
        }
        catch (Exception exce) {
            throw new IOException(exce.getMessage());
        }
        finally {
            try {
                v_XDWriter.close();
            }
            catch (Exception exception) {}
            v_XDWriter = null;
            v_XDOutput = null;
        }
    }

    public String getXD(InputStream i_XDInput, String i_ReadName, String i_CharEncoding) throws Exception {
        File v_DatFile = new File(Help.getSysTempPath() + Help.getSysPathSeparator() + Date.getNowTime().getFullMilli_ID());
        try {
            if (i_XDInput == null) {
                throw new NullPointerException("XD Input is null.");
            }
            FileHelp v_FH = new FileHelp();
            v_FH.setOverWrite(true);
            v_FH.copyFile(i_XDInput, v_DatFile);
            String string = this.getXD(v_DatFile, i_ReadName, i_CharEncoding);
            return string;
        }
        catch (Exception exce) {
            throw exce;
        }
        finally {
            if (v_DatFile != null && v_DatFile.exists()) {
                try {
                    v_DatFile.delete();
                }
                catch (Exception exception) {}
            }
        }
    }

    public String getXD(URL i_XDURL, String i_ReadName, String i_CharEncoding) throws Exception {
        if (i_XDURL == null) {
            throw new NullPointerException("XD URL is null.");
        }
        File v_File = new File(i_XDURL.toString());
        if (!v_File.exists()) {
            v_File = new File(i_XDURL.getFile());
        }
        return this.getXD(v_File, i_ReadName, i_CharEncoding);
    }

    public String getXD(String i_XDFullName, String i_ReadName, String i_CharEncoding) throws Exception {
        if (i_XDFullName == null) {
            throw new NullPointerException("XD full name is null.");
        }
        return this.getXD(new File(i_XDFullName), i_ReadName, i_CharEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXD(File i_XDFile, String i_ReadName, String i_CharEncoding) throws Exception {
        if (i_XDFile == null) {
            throw new NullPointerException("XD file is null.");
        }
        File v_XDFile = i_XDFile;
        if (!v_XDFile.exists()) {
            v_XDFile = null;
            throw new IOException("XD file[" + i_XDFile.toString() + "] is not exists.");
        }
        if (!v_XDFile.isFile()) {
            v_XDFile = null;
            throw new IOException("XD[" + i_XDFile.toString() + "] is not file.");
        }
        if (!v_XDFile.canRead()) {
            v_XDFile = null;
            throw new IOException("XD[" + i_XDFile.toString() + "] can not read.");
        }
        java.util.zip.ZipFile v_XDFileObject = null;
        StringBuilder v_Buffer = new StringBuilder();
        try {
            v_XDFileObject = new java.util.zip.ZipFile(v_XDFile);
            Enumeration<? extends ZipEntry> v_XDEntries = v_XDFileObject.entries();
            while (v_XDEntries.hasMoreElements()) {
                ZipEntry v_XDEntry = v_XDEntries.nextElement();
                if (v_XDEntry.isDirectory() || !i_ReadName.equalsIgnoreCase(v_XDEntry.getName()) || v_XDEntry.getSize() <= 0L) continue;
                InputStream v_SourceInput = v_XDFileObject.getInputStream(v_XDEntry);
                byte[] v_ByteBuffer = new byte[this.bufferSize];
                long v_MaxLen = v_XDEntry.getSize();
                long v_ReadIndex = 0L;
                try {
                    while (v_ReadIndex + (long)this.bufferSize <= v_MaxLen) {
                        v_SourceInput.read(v_ByteBuffer);
                        v_Buffer.append(new String(ByteHelp.xorMV((byte[])v_ByteBuffer), i_CharEncoding));
                        v_ReadIndex += (long)this.bufferSize;
                    }
                    v_ByteBuffer = new byte[(int)(v_MaxLen - v_ReadIndex)];
                    v_SourceInput.read(v_ByteBuffer);
                    v_Buffer.append(new String(ByteHelp.xorMV((byte[])v_ByteBuffer), i_CharEncoding));
                }
                catch (Exception exce) {
                    throw new IOException(exce.getMessage());
                }
                finally {
                    try {
                        v_SourceInput.close();
                    }
                    catch (Exception exception) {}
                    v_SourceInput = null;
                }
            }
            v_XDEntries = null;
            v_XDFile = null;
        }
        catch (Exception exce) {
            $Logger.error(exce);
        }
        finally {
            if (v_XDFileObject != null) {
                v_XDFileObject.close();
                v_XDFileObject = null;
            }
        }
        return v_Buffer.toString();
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public String getNewLine() {
        return this.newLine;
    }

    public void setNewLine(String newLine) {
        this.newLine = newLine;
    }

    public boolean isOverWrite() {
        return this.isOverWrite;
    }

    public void setOverWrite(boolean isOverWrite) {
        this.isOverWrite = isOverWrite;
    }

    public boolean isAppend() {
        return this.isAppend;
    }

    public void setAppend(boolean isAppend) {
        this.isAppend = isAppend;
    }

    public String getCsvDataPrefix() {
        return Help.NVL((String)this.csvDataPrefix, (String)"");
    }

    public void setCsvDataPrefix(String csvDataPrefix) {
        this.csvDataPrefix = csvDataPrefix;
    }

    public long getDataPacketTimeOut() {
        return this.dataPacketTimeOut;
    }

    public void setDataPacketTimeOut(long dataPacketTimeOut) {
        this.dataPacketTimeOut = dataPacketTimeOut;
    }

    public String getCharEncoding() {
        return this.charEncoding;
    }

    public void setCharEncoding(String charEncoding) {
        this.charEncoding = charEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public boolean isReturnContent() {
        return this.isReturnContent;
    }

    public void setReturnContent(boolean isReturnContent) {
        this.isReturnContent = isReturnContent;
    }

    protected void finalize() throws Throwable {
        if (this.fileCopyListeners != null) {
            this.fileCopyListeners.clear();
            this.fileCopyListeners = null;
        }
        if (this.createCSVListeners != null) {
            this.createCSVListeners.clear();
            this.createCSVListeners = null;
        }
        if (this.createZipListeners != null) {
            this.createZipListeners.clear();
            this.createZipListeners = null;
        }
        if (this.unCompressZipListeners != null) {
            this.unCompressZipListeners.clear();
            this.unCompressZipListeners = null;
        }
    }
}

