/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.ftp;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.net.ftp.FTPClient;
import org.hy.common.ByteHelp;
import org.hy.common.ExpireMap;
import org.hy.common.Help;
import org.hy.common.StringHelp;
import org.hy.common.file.FileDataPacket;
import org.hy.common.ftp.FTPInfo;
import org.hy.common.ftp.event.DefaultFTPEvent;
import org.hy.common.ftp.event.FTPEvent;
import org.hy.common.ftp.event.FTPListener;

public final class FTPHelp {
    private static final int $BufferSize = 4096;
    private static final ExpireMap<String, FileDataPacket> $DataPackets = new ExpireMap();
    private FTPInfo ftpInfo;
    private FTPClient ftpClient;
    private boolean dataSafe;
    private Collection<FTPListener> ftpListeners;
    private long dataPacketTimeOut = 600L;

    public FTPHelp(FTPInfo i_FTPInfo) {
        this.ftpInfo = i_FTPInfo;
        this.dataSafe = false;
    }

    public FTPInfo getFTPInfo() {
        return this.ftpInfo.clone();
    }

    public String connect() {
        if (this.ftpInfo == null) {
            return "Fpt info is null.";
        }
        try {
            if (this.ftpClient != null) {
                this.close();
            }
            this.ftpClient = new FTPClient();
            this.ftpClient.setProxy(this.ftpInfo.getProxy());
            this.ftpClient.setDefaultTimeout(this.ftpInfo.getDefaultTimeout());
            this.ftpClient.setConnectTimeout(this.ftpInfo.getConnectTimeout());
            this.ftpClient.setControlKeepAliveReplyTimeout(this.ftpInfo.getControlKeepAliveReplyTimeoutDuration());
            this.ftpClient.setControlKeepAliveTimeout(this.ftpInfo.getControlKeepAliveTimeoutDuration());
            this.ftpClient.setDataTimeout(this.ftpInfo.getDataTimeoutMillis());
            this.ftpClient.connect(this.ftpInfo.getIp(), this.ftpInfo.getPort());
            this.ftpClient.login(this.ftpInfo.getUser(), this.ftpInfo.getPassword());
            if (this.ftpInfo.isLocalPassiveMode()) {
                this.ftpClient.enterLocalPassiveMode();
            }
            if (this.ftpInfo.isRemotePassiveMode()) {
                this.ftpClient.enterRemotePassiveMode();
            }
            this.ftpClient.setFileType(2);
            this.ftpClient.setBufferSize(this.ftpInfo.getBufferSize());
            this.ftpClient.setReceiveBufferSize(this.ftpInfo.getReceiveBufferSize());
            this.ftpClient.setReceieveDataSocketBufferSize(this.ftpInfo.getReceiveDataSocketBufferSize());
            this.ftpClient.setSendBufferSize(this.ftpInfo.getSendBufferSize());
            this.ftpClient.setSendDataSocketBufferSize(this.ftpInfo.getSendDataSocketBufferSize());
            this.ftpClient.setStrictMultilineParsing(this.ftpInfo.isStrictMultilineParsing());
            this.ftpClient.setStrictReplyParsing(this.ftpInfo.isStrictReplyParsing());
            this.ftpClient.setUseEPSVwithIPv4(this.ftpInfo.isUseEPSVwithIPv4());
            this.ftpClient.setRemoteVerificationEnabled(this.ftpInfo.isRemoteVerificationEnabled());
            this.ftpClient.setListHiddenFiles(this.ftpInfo.getListHiddenFiles());
            this.ftpClient.setControlEncoding(this.ftpInfo.getControlEncoding());
            this.ftpClient.setAutodetectUTF8(this.ftpInfo.getAutodetectUTF8());
            this.ftpClient.setCharset(this.ftpInfo.getCharset());
            this.ftpClient.changeWorkingDirectory(this.ftpInfo.getInitPath());
        }
        catch (Exception exce) {
            this.ftpClient = null;
            exce.printStackTrace();
            return exce.getMessage();
        }
        return null;
    }

    public void close() {
        if (this.ftpClient != null) {
            try {
                this.ftpClient.logout();
                this.ftpClient.disconnect();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.ftpClient = null;
            }
        }
    }

    public String download(String i_RemoteFullName, String i_SaveFullName) {
        return this.download(i_RemoteFullName, i_SaveFullName, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String download(String i_RemoteFullName, String i_SaveFullName, long i_FileSize) {
        if (this.ftpClient == null) {
            return "Ftp Client is not connect.";
        }
        InputStream v_Input = null;
        FilterInputStream v_DataInput = null;
        File v_SaveFile = null;
        FileOutputStream v_SaveFileOutput = null;
        long v_FTPingSize = 0L;
        DefaultFTPEvent v_Event = new DefaultFTPEvent(this, i_FileSize);
        boolean v_IsContinue = true;
        v_Event.setActionType(2);
        try {
            v_Input = this.ftpClient.retrieveFileStream(new String(i_RemoteFullName.getBytes("GBK"), "ISO-8859-1"));
            v_DataInput = new DataInputStream(v_Input);
            v_SaveFile = new File(i_SaveFullName);
            v_SaveFileOutput = new FileOutputStream(v_SaveFile);
            byte[] v_Buffer = new byte[4096];
            int v_RSize = 0;
            v_IsContinue = this.fireFTPBeforeListener(v_Event);
            if (this.dataSafe) {
                while (v_IsContinue && (v_RSize = ((DataInputStream)v_DataInput).read(v_Buffer)) >= 0) {
                    v_SaveFileOutput.write(ByteHelp.xorMV((byte[])v_Buffer, (int)0, (int)v_RSize), 0, v_RSize);
                    v_Event.setCompleteSize(v_FTPingSize += (long)v_RSize);
                    v_IsContinue = this.fireFTPingListener(v_Event);
                }
            } else {
                while (v_IsContinue && (v_RSize = ((DataInputStream)v_DataInput).read(v_Buffer)) >= 0) {
                    v_SaveFileOutput.write(v_Buffer, 0, v_RSize);
                    v_Event.setCompleteSize(v_FTPingSize += (long)v_RSize);
                    v_IsContinue = this.fireFTPingListener(v_Event);
                }
            }
            v_SaveFileOutput.flush();
            v_SaveFileOutput.close();
            v_SaveFileOutput = null;
            this.ftpClient.completePendingCommand();
            v_Event.setSucceedFinish();
        }
        catch (Exception e) {
            v_Event.setEndTime();
            String string = e.toString();
            return string;
        }
        finally {
            if (v_SaveFileOutput != null) {
                try {
                    v_SaveFileOutput.close();
                }
                catch (Exception exception) {}
                v_SaveFileOutput = null;
            }
            if (v_DataInput != null) {
                try {
                    v_DataInput.close();
                }
                catch (Exception exception) {}
                v_DataInput = null;
            }
            if (v_Input != null) {
                try {
                    v_Input.close();
                }
                catch (Exception exception) {}
                v_Input = null;
            }
            this.fireFTPAfterListener(v_Event);
        }
        return null;
    }

    public String download(String i_RemoteFullName) {
        return this.download(i_RemoteFullName, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String download(String i_RemoteFullName, long i_FileSize) {
        if (this.ftpClient == null) {
            return "Ftp Client is not connect.";
        }
        InputStream v_Input = null;
        FilterInputStream v_DataInput = null;
        long v_FTPingSize = 0L;
        StringBuilder v_OutBuffer = new StringBuilder();
        DefaultFTPEvent v_Event = new DefaultFTPEvent(this, i_FileSize);
        boolean v_IsContinue = true;
        v_Event.setActionType(2);
        try {
            v_Input = this.ftpClient.retrieveFileStream(new String(i_RemoteFullName.getBytes("GBK"), "ISO-8859-1"));
            v_DataInput = new DataInputStream(v_Input);
            byte[] v_Buffer = new byte[4096];
            int v_RSize = 0;
            v_IsContinue = this.fireFTPBeforeListener(v_Event);
            if (this.dataSafe) {
                while (v_IsContinue && (v_RSize = ((DataInputStream)v_DataInput).read(v_Buffer)) >= 0) {
                    v_OutBuffer.append(StringHelp.bytesToHex((byte[])ByteHelp.xorMV((byte[])v_Buffer, (int)0, (int)v_RSize), (int)0, (int)v_RSize));
                    v_Event.setCompleteSize(v_FTPingSize += (long)v_RSize);
                    v_IsContinue = this.fireFTPingListener(v_Event);
                }
            } else {
                while (v_IsContinue && (v_RSize = ((DataInputStream)v_DataInput).read(v_Buffer)) >= 0) {
                    v_OutBuffer.append(StringHelp.bytesToHex((byte[])v_Buffer, (int)0, (int)v_RSize));
                    v_Event.setCompleteSize(v_FTPingSize += (long)v_RSize);
                    v_IsContinue = this.fireFTPingListener(v_Event);
                }
            }
            this.ftpClient.completePendingCommand();
            v_Event.setSucceedFinish();
        }
        catch (Exception e) {
            v_Event.setEndTime();
            String string = e.toString();
            return string;
        }
        finally {
            if (v_DataInput != null) {
                try {
                    v_DataInput.close();
                }
                catch (Exception exception) {}
                v_DataInput = null;
            }
            if (v_Input != null) {
                try {
                    v_Input.close();
                }
                catch (Exception exception) {}
                v_Input = null;
            }
            this.fireFTPAfterListener(v_Event);
        }
        return v_OutBuffer.toString();
    }

    public String upload(String i_LocalFullName, String i_RemoteFullName) {
        return this.upload(i_LocalFullName, i_RemoteFullName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String upload(String i_LocalFullName, String i_RemoteFullName, boolean i_IsAppend) {
        File v_File = new File(i_LocalFullName);
        FileInputStream v_Input = null;
        FilterInputStream v_DataInput = null;
        try {
            v_Input = new FileInputStream(i_LocalFullName);
            v_DataInput = new DataInputStream(v_Input);
            String string = this.upload((DataInputStream)v_DataInput, v_File.length(), i_RemoteFullName, i_IsAppend);
            return string;
        }
        catch (Exception e) {
            String string = e.toString();
            return string;
        }
        finally {
            if (v_DataInput != null) {
                try {
                    v_DataInput.close();
                }
                catch (Exception exception) {}
                v_DataInput = null;
            }
            if (v_Input != null) {
                try {
                    v_Input.close();
                }
                catch (Exception exception) {}
                v_Input = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int upload(FileDataPacket i_FileDataPacket) {
        ByteArrayInputStream v_ByteInput = new ByteArrayInputStream(i_FileDataPacket.getDataByte());
        DataInputStream v_DataInput = new DataInputStream(v_ByteInput);
        String v_UploadRet = null;
        FileDataPacket v_Old = (FileDataPacket)$DataPackets.get((Object)i_FileDataPacket.getName());
        if (v_Old != null && v_Old.getDataNo() >= i_FileDataPacket.getDataNo()) {
            return 0;
        }
        try {
            v_UploadRet = this.upload(v_DataInput, i_FileDataPacket.getDataByte().length, i_FileDataPacket.getName(), true);
        }
        finally {
            if (v_DataInput != null) {
                try {
                    v_DataInput.close();
                }
                catch (Exception exception) {}
                v_DataInput = null;
            }
            if (v_ByteInput != null) {
                try {
                    v_ByteInput.close();
                }
                catch (Exception exception) {}
                v_ByteInput = null;
            }
        }
        if (Help.isNull((String)v_UploadRet)) {
            if (i_FileDataPacket.getDataCount().intValue() == i_FileDataPacket.getDataNo().intValue()) {
                $DataPackets.remove((Object)i_FileDataPacket.getName());
                return 1;
            }
            $DataPackets.put((Object)i_FileDataPacket.getName(), (Object)i_FileDataPacket, this.dataPacketTimeOut);
            return 0;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String upload(DataInputStream i_LocalDataInput, long i_LocalDataSize, String i_RemoteFullName, boolean i_IsAppend) {
        if (this.ftpClient == null) {
            return "Ftp Client is not connect.";
        }
        DataInputStream v_DataInput = null;
        OutputStream v_Output = null;
        long v_FTPingSize = 0L;
        DefaultFTPEvent v_Event = new DefaultFTPEvent(this, i_LocalDataSize);
        boolean v_IsContinue = true;
        v_Event.setActionType(1);
        try {
            if (!Help.isNull((String)i_RemoteFullName)) {
                String[] v_RFNameArr = i_RemoteFullName.split("/");
                String v_DirFullName = StringHelp.replaceLast((String)i_RemoteFullName, (String)("/" + v_RFNameArr[v_RFNameArr.length - 1]), (String)"");
                this.makeDirectory(v_DirFullName);
            }
            v_DataInput = i_LocalDataInput;
            byte[] v_Buffer = new byte[4096];
            int v_RSize = 0;
            v_Output = i_IsAppend ? this.ftpClient.appendFileStream(new String(i_RemoteFullName.getBytes("GBK"), "ISO-8859-1")) : this.ftpClient.storeFileStream(new String(i_RemoteFullName.getBytes("GBK"), "ISO-8859-1"));
            v_IsContinue = this.fireFTPBeforeListener(v_Event);
            if (this.dataSafe) {
                while (v_IsContinue && (v_RSize = v_DataInput.read(v_Buffer)) >= 0) {
                    v_Output.write(ByteHelp.xorMV((byte[])v_Buffer, (int)0, (int)v_RSize), 0, v_RSize);
                    v_Event.setCompleteSize(v_FTPingSize += (long)v_RSize);
                    v_IsContinue = this.fireFTPingListener(v_Event);
                }
            } else {
                while (v_IsContinue && (v_RSize = v_DataInput.read(v_Buffer)) >= 0) {
                    v_Output.write(v_Buffer, 0, v_RSize);
                    v_Event.setCompleteSize(v_FTPingSize += (long)v_RSize);
                    v_IsContinue = this.fireFTPingListener(v_Event);
                }
            }
            v_Output.flush();
            v_Output.close();
            v_Output = null;
            this.ftpClient.completePendingCommand();
            v_Event.setSucceedFinish();
        }
        catch (Exception e) {
            e.printStackTrace();
            v_Event.setEndTime();
            String string = e.toString();
            return string;
        }
        finally {
            if (v_Output != null) {
                try {
                    v_Output.close();
                }
                catch (Exception exception) {}
                v_Output = null;
            }
            this.fireFTPAfterListener(v_Event);
        }
        return null;
    }

    public int makeDirectory(String i_DirFullName) {
        if (Help.isNull((String)i_DirFullName)) {
            return 0;
        }
        if (this.ftpClient == null) {
            return -99;
        }
        try {
            String[] v_DirFullNameArr = i_DirFullName.trim().split("/");
            StringBuilder v_DirBuffer = new StringBuilder();
            int v_CreateCount = 0;
            for (String v_DirName : v_DirFullNameArr) {
                if (Help.isNull((String)v_DirName)) continue;
                v_DirBuffer.append("/").append(new String(v_DirName.getBytes("GBK"), "ISO-8859-1"));
                if (!this.ftpClient.makeDirectory(v_DirBuffer.toString())) continue;
                ++v_CreateCount;
            }
            return v_CreateCount;
        }
        catch (Exception exce) {
            exce.printStackTrace();
            return -1;
        }
    }

    public String deleteFile(String i_RemoteFullName) {
        if (this.ftpClient == null) {
            return "Ftp Client is not connect.";
        }
        try {
            boolean v_Ret = this.ftpClient.deleteFile(new String(i_RemoteFullName.getBytes("GBK"), "ISO-8859-1"));
            if (!v_Ret) {
                return "Delete file is faild.";
            }
        }
        catch (Exception exce) {
            return exce.toString();
        }
        return null;
    }

    public void addFTPListener(FTPListener e) {
        if (this.ftpListeners == null) {
            this.ftpListeners = new HashSet<FTPListener>();
        }
        this.ftpListeners.add(e);
    }

    public void removeFTPListener(FTPListener e) {
        if (this.ftpListeners == null) {
            return;
        }
        this.ftpListeners.remove(e);
    }

    protected boolean fireFTPBeforeListener(FTPEvent i_Event) {
        if (this.ftpListeners == null) {
            return true;
        }
        return this.notifyFTPBeforeListeners(i_Event);
    }

    protected boolean fireFTPingListener(FTPEvent i_Event) {
        if (this.ftpListeners == null) {
            return true;
        }
        return this.notifyFTPingListeners(i_Event);
    }

    protected void fireFTPAfterListener(FTPEvent i_Event) {
        if (this.ftpListeners == null) {
            return;
        }
        this.notifyFTPAfterListeners(i_Event);
    }

    private boolean notifyFTPBeforeListeners(FTPEvent i_Event) {
        Iterator<FTPListener> v_Iter = this.ftpListeners.iterator();
        boolean v_IsContinue = true;
        while (v_IsContinue && v_Iter.hasNext()) {
            v_IsContinue = v_Iter.next().ftpBefore(i_Event);
        }
        return v_IsContinue;
    }

    private boolean notifyFTPingListeners(FTPEvent i_Event) {
        Iterator<FTPListener> v_Iter = this.ftpListeners.iterator();
        boolean v_IsContinue = true;
        while (v_IsContinue && v_Iter.hasNext()) {
            v_IsContinue = v_Iter.next().ftpProcess(i_Event);
        }
        return v_IsContinue;
    }

    private void notifyFTPAfterListeners(FTPEvent i_Event) {
        Iterator<FTPListener> v_Iter = this.ftpListeners.iterator();
        while (v_Iter.hasNext()) {
            v_Iter.next().ftpAfter(i_Event);
        }
    }

    public boolean isDataSafe() {
        return this.dataSafe;
    }

    public void setDataSafe(boolean dataSafe) {
        this.dataSafe = dataSafe;
    }

    protected void finalize() throws Throwable {
        this.close();
        if (this.ftpListeners != null) {
            this.ftpListeners.clear();
            this.ftpListeners = null;
        }
    }
}

