/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.ftp;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.apache.commons.net.ftp.FTPClient;
import org.hy.common.Help;
import org.hy.common.ftp.FTPSecurity;

public class FTPInfo
extends FTPClient
implements Cloneable {
    public static final int $ConnectTimeOut = 30000;
    public static final Duration $ReadTimeOut = Duration.of(120L, ChronoUnit.SECONDS);
    private String ip;
    private int port;
    private String user;
    private String password;
    private String initPath;
    private boolean isLocalPassiveMode;
    private boolean isRemotePassiveMode;
    private FTPSecurity security;
    private int dataTimeout;

    public FTPInfo() {
        this("", 21, "", "");
    }

    public FTPInfo(String i_IP, int i_Port, String i_User, String i_Password) {
        this.setIp(i_IP);
        this.setPort(i_Port);
        this.setUser(i_User);
        this.setPassword(i_Password);
        this.setControlEncoding("UTF-8");
        this.setLocalPassiveMode(false);
        this.setRemotePassiveMode(false);
        this.setDataTimeout($ReadTimeOut);
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getPasswordValue() {
        return this.password;
    }

    public String getPassword() {
        if (this.security != null && !Help.isNull((String)this.user)) {
            if (Help.isNull((String)this.password)) {
                return "";
            }
            return this.security.getDecrypt(this.password, this.user);
        }
        return this.password;
    }

    public void setPassword(String i_Password) {
        this.password = this.security != null && !Help.isNull((String)this.user) ? (i_Password != null ? (i_Password.trim().length() == this.security.getSecurityLen() ? i_Password : this.security.getEncrypt(i_Password, this.user)) : i_Password) : i_Password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getInitPath() {
        return Help.NVL((String)this.initPath, (String)"/");
    }

    public void setInitPath(String initPath) {
        this.initPath = initPath;
    }

    public FTPSecurity getSecurity() {
        return this.security;
    }

    public void setSecurity(FTPSecurity security) {
        this.security = security;
    }

    public boolean isLocalPassiveMode() {
        return this.isLocalPassiveMode;
    }

    public boolean isRemotePassiveMode() {
        return this.isRemotePassiveMode;
    }

    public void setLocalPassiveMode(boolean isLocalPassiveMode) {
        this.isLocalPassiveMode = isLocalPassiveMode;
    }

    public void setRemotePassiveMode(boolean isRemotePassiveMode) {
        this.isRemotePassiveMode = isRemotePassiveMode;
    }

    public int getDataTimeoutMillis() {
        return super.getDataTimeout().toMillisPart();
    }

    public void setDataTimeoutMillis(int dataTimeout) {
        super.setDataTimeout(this.dataTimeout);
    }

    public int getReceiveBufferSize() {
        return super.getReceiveBufferSize();
    }

    public int getSendBufferSize() {
        return super.getSendBufferSize();
    }

    public FTPInfo clone() {
        FTPInfo v_Clone = new FTPInfo(this.ip, this.port, this.user, this.password);
        v_Clone.setLocalPassiveMode(this.isLocalPassiveMode);
        v_Clone.setRemotePassiveMode(this.isRemotePassiveMode);
        v_Clone.setInitPath(this.initPath);
        v_Clone.setSecurity(this.security);
        v_Clone.setControlEncoding(this.getControlEncoding());
        return v_Clone;
    }
}

