/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.xml.log;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hy.common.Busway;
import org.hy.common.Counter;
import org.hy.common.Date;
import org.hy.common.Help;
import org.hy.common.PartitionMap;
import org.hy.common.StaticReflect;
import org.hy.common.StringHelp;
import org.hy.common.TablePartition;
import org.hy.common.TablePartitionBusway;
import org.hy.common.file.FileHelp;
import org.hy.common.xml.log.Level;
import org.hy.common.xml.log.LogException;
import org.hy.common.xml.log.LogStackTrace;

public class Logger {
    private static boolean $IsEnabled_SLF4J = true;
    private static boolean $IsEnabled_Log4J = true;
    private static boolean $IsEnabled_Print = false;
    public static final int $LogType_SLF4J = 1;
    public static final int $LogType_Log4J = 2;
    private static final String $FQCN = Logger.class.getName();
    private static int $LogType = -1;
    private static int $LogVersion = -1;
    private static Class<?> $LogClass;
    private static Class<?> $LogManager;
    private static Level $LogLevelFatal;
    private static Level $LogLevelError;
    private static Level $LogLevelWarn;
    private static Level $LogLevelInfo;
    private static Level $LogLevelDebug;
    private static Level $LogLevelTrace;
    private static Method $FatalIsEnabled;
    private static Method $ErrorIsEnabled;
    private static Method $WarnIsEnabled;
    private static Method $InfoIsEnabled;
    private static Method $DebugIsEnabled;
    private static Method $TraceIsEnabled;
    private static Method $LogMethodNull;
    private static Method $LogMethod;
    private static Method $LogMethod_Log4j2Throwable;
    private static PartitionMap<String, Logger> $Loggers;
    private Object log;
    private Class<?> logClass;
    private Counter<String> requestCount = new Counter();
    private Map<String, Long> requestTime = new ConcurrentHashMap<String, Long>();
    private TablePartitionBusway<String, LogException> execptionLog;
    private Counter<String> methodExecSumTime = new Counter();
    private Map<String, Integer> methodExecLines = new ConcurrentHashMap<String, Integer>();
    private Map<String, Long> methodExecLastime = new ConcurrentHashMap<String, Long>();

    public static void useSLF4J() {
        $IsEnabled_SLF4J = true;
        $IsEnabled_Log4J = false;
        $IsEnabled_Print = false;
    }

    public static void useLogback() {
        $IsEnabled_SLF4J = true;
        $IsEnabled_Log4J = false;
        $IsEnabled_Print = false;
    }

    public static void useLog4J() {
        $IsEnabled_SLF4J = false;
        $IsEnabled_Log4J = true;
        $IsEnabled_Print = false;
    }

    public static void usePrint() {
        $IsEnabled_SLF4J = false;
        $IsEnabled_Log4J = false;
        $IsEnabled_Print = true;
    }

    public static Object getLevelFatal() {
        return $LogLevelFatal;
    }

    public static Object getLevelError() {
        return $LogLevelError;
    }

    public static Object getLevelWarn() {
        return $LogLevelWarn;
    }

    public static Object getLevelnfo() {
        return $LogLevelInfo;
    }

    public static Object getLevelDebug() {
        return $LogLevelDebug;
    }

    public static Object getLevelTrace() {
        return $LogLevelTrace;
    }

    public static Logger getLogger(Class<?> i_Class) {
        return new Logger(i_Class.getName(), null);
    }

    public static Logger getLogger(Class<?> i_Class, Boolean i_IsPrintln) {
        return new Logger(i_Class.getName(), i_IsPrintln);
    }

    public static Logger getLogger(String i_ClassName) {
        return new Logger(i_ClassName, null);
    }

    public static Logger getLogger(String i_ClassName, Boolean i_IsPrintln) {
        return new Logger(i_ClassName, i_IsPrintln);
    }

    public Logger(String i_ClassName) {
        this(i_ClassName, null);
    }

    public Logger(Class<?> i_Class) {
        this(i_Class, null);
    }

    public Logger(Class<?> i_Class, Boolean i_IsPrintln) {
        this(i_Class.getName(), i_IsPrintln);
    }

    public Logger(String i_ClassName, Boolean i_IsPrintln) {
        this.addLogger();
        Logger.initLogTypeVersion();
        if ($LogManager != null) {
            try {
                Method v_Methd = $LogManager.getMethod("getLogger", String.class);
                this.log = StaticReflect.invoke((Method)v_Methd, (Object[])new Object[]{i_ClassName});
            }
            catch (Exception exce) {
                exce.printStackTrace();
            }
            if (this.log != null) {
                try {
                    if ($LogType == 1) {
                        Logger.initSLF4JMethod(this.log);
                        Logger.initSLF4JLevels();
                        $FatalIsEnabled = null;
                        $ErrorIsEnabled = null;
                        $WarnIsEnabled = null;
                        $InfoIsEnabled = null;
                        $DebugIsEnabled = null;
                        $TraceIsEnabled = null;
                    } else if ($LogType == 2) {
                        Logger.initLog4JMethod(this.log);
                        Logger.initLog4JLevels();
                        if ($LogVersion == 1) {
                            $FatalIsEnabled = null;
                            $ErrorIsEnabled = null;
                            $WarnIsEnabled = null;
                            $InfoIsEnabled = null;
                            $DebugIsEnabled = $LogClass.getMethod("isDebugEnabled", new Class[0]);
                            $TraceIsEnabled = null;
                        } else if ($LogVersion == 2) {
                            $FatalIsEnabled = $LogClass.getMethod("isFatalEnabled", new Class[0]);
                            $ErrorIsEnabled = $LogClass.getMethod("isErrorEnabled", new Class[0]);
                            $WarnIsEnabled = $LogClass.getMethod("isWarnEnabled", new Class[0]);
                            $InfoIsEnabled = $LogClass.getMethod("isInfoEnabled", new Class[0]);
                            $DebugIsEnabled = $LogClass.getMethod("isDebugEnabled", new Class[0]);
                            $TraceIsEnabled = $LogClass.getMethod("isTraceEnabled", new Class[0]);
                        }
                    }
                }
                catch (Exception exce) {
                    exce.printStackTrace();
                }
            }
        } else if ($IsEnabled_Print && i_IsPrintln == null || i_IsPrintln != null && i_IsPrintln.booleanValue()) {
            try {
                this.logClass = Help.forName((String)i_ClassName);
                if ($LogMethod != $LogMethodNull) {
                    Logger.showLoggerInfo(this.logClass);
                    $LogMethod = $LogMethodNull;
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else if ($LogMethod != $LogMethodNull) {
            Logger.showLoggerInfo(null);
            $LogMethod = $LogMethodNull;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showLoggerInfo(Object i_Log) {
        FileHelp v_FileHelp = new FileHelp();
        StringBuilder v_Buffer = new StringBuilder();
        InputStream v_LogInput = null;
        try {
            if ($LogType == 1) {
                String v_LoggerName = i_Log.getClass().getName();
                if ("org.slf4j.helpers.NOPLogger".equalsIgnoreCase(v_LoggerName)) {
                    v_LogInput = Logger.class.getResourceAsStream("SFL4J_NoLogger.txt");
                    v_Buffer.append("Loading logger is SLF4J ,but not any implementation (").append(Date.getNowTime().getFullMilli()).append(")\n");
                    v_Buffer.append(v_FileHelp.getContent(v_LogInput, "UTF-8", true));
                } else if ("ch.qos.logback.classic.Logger".equalsIgnoreCase(v_LoggerName)) {
                    v_LogInput = Logger.class.getResourceAsStream("SFL4J_Logback.txt");
                    v_Buffer.append("Loading logger is SLF4J & Logback (").append(Date.getNowTime().getFullMilli()).append(")\n");
                    v_Buffer.append(v_FileHelp.getContent(v_LogInput, "UTF-8", true));
                } else if ("org.apache.logging.slf4j.Log4jLogger".equalsIgnoreCase(v_LoggerName)) {
                    v_LogInput = Logger.class.getResourceAsStream("SFL4J_Log4J.txt");
                    v_Buffer.append("Loading logger is SLF4J & Log4J (").append(Date.getNowTime().getFullMilli()).append(")\n");
                    v_Buffer.append(v_FileHelp.getContent(v_LogInput, "UTF-8", true));
                }
            } else if ($LogType == 2) {
                v_LogInput = Logger.class.getResourceAsStream("Log4J.txt");
                v_Buffer.append("Loading logger is Log4J " + $LogVersion + ".x (").append(Date.getNowTime().getFullMilli()).append(")\n");
                v_Buffer.append(v_FileHelp.getContent(v_LogInput, "UTF-8", true));
            } else if (i_Log != null) {
                v_Buffer.append("Loading logger is System.out (").append(Date.getNowTime().getFullMilli()).append(")\n\n");
            } else {
                v_LogInput = Logger.class.getResourceAsStream("NoLogger.txt");
                v_Buffer.append("Loading logger is not any implementation (").append(Date.getNowTime().getFullMilli()).append(")\n");
                v_Buffer.append(v_FileHelp.getContent(v_LogInput, "UTF-8", true));
            }
        }
        catch (Exception exce) {
            exce.printStackTrace();
        }
        finally {
            if (v_LogInput != null) {
                try {
                    v_LogInput.close();
                }
                catch (IOException iOException) {}
                v_LogInput = null;
            }
        }
        System.out.print(v_Buffer.toString());
    }

    private static synchronized void initLogTypeVersion() {
        if ($LogClass != null) {
            return;
        }
        if ($IsEnabled_SLF4J) {
            try {
                $LogClass = Help.forName((String)"org.slf4j.Logger");
                $LogManager = Help.forName((String)"org.slf4j.LoggerFactory");
                $LogType = 1;
                $LogVersion = 1;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ($IsEnabled_Log4J) {
            if ($LogClass == null) {
                try {
                    $LogClass = Help.forName((String)"org.apache.logging.log4j.Logger");
                    $LogManager = Help.forName((String)"org.apache.logging.log4j.LogManager");
                    $LogType = 2;
                    $LogVersion = 2;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ($LogClass == null) {
                try {
                    $LogClass = Help.forName((String)"org.apache.log4j.Logger");
                    $LogManager = Help.forName((String)"org.apache.log4j.LogManager");
                    $LogType = 2;
                    $LogVersion = 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static synchronized void initSLF4JMethod(Object i_Log) {
        if ($LogMethod != null) {
            return;
        }
        Logger.showLoggerInfo(i_Log);
        Method[] v_Methods = i_Log.getClass().getMethods();
        if ($LogVersion >= 0) {
            for (Method v_Method : v_Methods) {
                Class<?>[] v_MPamams;
                if (!"log".equals(v_Method.getName()) || (v_MPamams = v_Method.getParameterTypes()).length != 6 || !String.class.equals(v_MPamams[1]) || !Integer.TYPE.equals(v_MPamams[2]) || !String.class.equals(v_MPamams[3]) || !Object[].class.equals(v_MPamams[4]) || !Throwable.class.equals(v_MPamams[5])) continue;
                $LogMethod = v_Method;
                return;
            }
        }
        $LogMethod = $LogMethodNull;
    }

    private static synchronized void initLog4JMethod(Object i_Log) {
        if ($LogMethod != null) {
            return;
        }
        Logger.showLoggerInfo(i_Log);
        Method[] v_Methods = i_Log.getClass().getMethods();
        if ($LogVersion == 1) {
            for (Method v_Method : v_Methods) {
                Class<?>[] v_MPamams;
                if (!"log".equals(v_Method.getName()) || (v_MPamams = v_Method.getParameterTypes()).length != 4 || !Object.class.equals(v_MPamams[2]) || !Throwable.class.equals(v_MPamams[3])) continue;
                $LogMethod = v_Method;
                return;
            }
        } else {
            Class<?>[] v_MPamams;
            for (Method v_Method : v_Methods) {
                if (!"logIfEnabled".equals(v_Method.getName()) || (v_MPamams = v_Method.getParameterTypes()).length != 5 || !String.class.equals(v_MPamams[3]) || !Object[].class.equals(v_MPamams[4])) continue;
                $LogMethod = v_Method;
                break;
            }
            for (Method v_Method : v_Methods) {
                if (!"logIfEnabled".equals(v_Method.getName()) || (v_MPamams = v_Method.getParameterTypes()).length != 5 || !String.class.equals(v_MPamams[3]) || !Throwable.class.equals(v_MPamams[4])) continue;
                $LogMethod_Log4j2Throwable = v_Method;
                return;
            }
        }
        $LogMethod = $LogMethodNull;
    }

    private static synchronized void initSLF4JLevels() {
        if ($LogLevelFatal != null) {
            return;
        }
        if ($LogVersion >= 0) {
            $LogLevelFatal = new Level(StaticReflect.getStaticValue((String)"org.slf4j.event.EventConstants.ERROR_INT"));
            $LogLevelError = new Level(StaticReflect.getStaticValue((String)"org.slf4j.event.EventConstants.ERROR_INT"));
            $LogLevelWarn = new Level(StaticReflect.getStaticValue((String)"org.slf4j.event.EventConstants.WARN_INT"));
            $LogLevelInfo = new Level(StaticReflect.getStaticValue((String)"org.slf4j.event.EventConstants.INFO_INT"));
            $LogLevelDebug = new Level(StaticReflect.getStaticValue((String)"org.slf4j.event.EventConstants.DEBUG_INT"));
            $LogLevelTrace = new Level(StaticReflect.getStaticValue((String)"org.slf4j.event.EventConstants.TRACE_INT"));
        }
    }

    private static synchronized void initLog4JLevels() {
        if ($LogLevelFatal != null) {
            return;
        }
        if ($LogVersion == 1) {
            $LogLevelFatal = new Level(StaticReflect.getStaticValue((String)"org.apache.log4j.Level.FATAL"));
            $LogLevelError = new Level(StaticReflect.getStaticValue((String)"org.apache.log4j.Level.ERROR"));
            $LogLevelWarn = new Level(StaticReflect.getStaticValue((String)"org.apache.log4j.Level.WARN"));
            $LogLevelInfo = new Level(StaticReflect.getStaticValue((String)"org.apache.log4j.Level.INFO"));
            $LogLevelDebug = new Level(StaticReflect.getStaticValue((String)"org.apache.log4j.Level.DEBUG"));
            $LogLevelTrace = new Level(StaticReflect.getStaticValue((String)"org.apache.log4j.Level.DEBUG"));
        } else {
            $LogLevelFatal = new Level(StaticReflect.getStaticValue((String)"org.apache.logging.log4j.Level.FATAL"));
            $LogLevelError = new Level(StaticReflect.getStaticValue((String)"org.apache.logging.log4j.Level.ERROR"));
            $LogLevelWarn = new Level(StaticReflect.getStaticValue((String)"org.apache.logging.log4j.Level.WARN"));
            $LogLevelInfo = new Level(StaticReflect.getStaticValue((String)"org.apache.logging.log4j.Level.INFO"));
            $LogLevelDebug = new Level(StaticReflect.getStaticValue((String)"org.apache.logging.log4j.Level.DEBUG"));
            $LogLevelTrace = new Level(StaticReflect.getStaticValue((String)"org.apache.logging.log4j.Level.TRACE"));
        }
    }

    public static String getLevelName(Object i_Level) {
        if ($LogLevelFatal == null) {
            return "--";
        }
        if ($LogLevelFatal.equals(i_Level)) {
            return "fatal";
        }
        if ($LogLevelError.equals(i_Level)) {
            return "error";
        }
        if ($LogLevelWarn.equals(i_Level)) {
            return "warn";
        }
        if ($LogLevelInfo.equals(i_Level)) {
            return "info";
        }
        if ($LogLevelDebug.equals(i_Level)) {
            return "debug";
        }
        if ($LogLevelTrace.equals(i_Level)) {
            return "trace";
        }
        return "unknown";
    }

    public static PartitionMap<String, Logger> getLoggers() {
        return $Loggers;
    }

    public static void resets() {
        for (List v_ClassForLoggers : $Loggers.values()) {
            for (Logger v_Logger : v_ClassForLoggers) {
                v_Logger.reset();
            }
        }
    }

    public void reset() {
        for (String v_Key : this.requestCount.keySet()) {
            this.requestCount.set((Object)v_Key, Long.valueOf(0L));
        }
        for (String v_Key : this.requestTime.keySet()) {
            this.requestTime.put(v_Key, 0L);
        }
        for (String v_Key : this.methodExecSumTime.keySet()) {
            this.methodExecSumTime.set((Object)v_Key, Long.valueOf(0L));
        }
        if (this.execptionLog != null) {
            for (String v_Key : this.execptionLog.keySet()) {
                ((Busway)this.execptionLog.get((Object)v_Key)).clear();
            }
        }
    }

    private void addLogger() {
        StackTraceElement v_StackTrace = LogStackTrace.calcLocation($FQCN);
        if (v_StackTrace != null) {
            $Loggers.putRow((Object)v_StackTrace.getClassName(), (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void request(Level i_Level, String i_LevelName, String i_Message, Throwable i_Throwable) {
        StackTraceElement v_StackTrace = LogStackTrace.calcLocation($FQCN);
        if (v_StackTrace != null) {
            Long v_LastTime;
            String v_Key = i_LevelName + ":" + v_StackTrace.getMethodName() + ":" + v_StackTrace.getLineNumber();
            this.requestCount.put((Object)v_Key, Long.valueOf(1L));
            this.requestTime.put(v_Key, Date.getNowTime().getTime());
            if (i_Level == $LogLevelWarn || i_Level == $LogLevelError || i_Level == $LogLevelFatal) {
                Logger logger = this;
                synchronized (logger) {
                    if (this.execptionLog == null) {
                        this.execptionLog = new TablePartitionBusway();
                    }
                }
                this.execptionLog.putRow((Object)v_Key, (Object)new LogException(i_Message, i_Throwable));
            }
            String v_MethodThreadID = v_StackTrace.getMethodName() + Thread.currentThread().getId();
            Integer v_LastLine = this.methodExecLines.get(v_MethodThreadID);
            long v_NowTime = Date.getNowTime().getTime();
            if (v_LastLine != null && v_StackTrace.getLineNumber() > v_LastLine && (v_LastTime = this.methodExecLastime.get(v_MethodThreadID)) != null && v_LastTime <= v_NowTime) {
                this.methodExecSumTime.put((Object)v_StackTrace.getMethodName(), Long.valueOf(v_NowTime - v_LastTime));
            }
            this.methodExecLines.put(v_MethodThreadID, v_StackTrace.getLineNumber());
            this.methodExecLastime.put(v_MethodThreadID, v_NowTime);
        }
    }

    public Counter<String> getRequestCount() {
        return this.requestCount;
    }

    public TablePartitionBusway<String, LogException> getExecptionLog() {
        return this.execptionLog;
    }

    public Map<String, Long> getRequestTime() {
        return this.requestTime;
    }

    public Counter<String> getMethodExecSumTimes() {
        return this.methodExecSumTime;
    }

    public boolean isFatalEnabled() {
        if ($FatalIsEnabled != null) {
            try {
                return (Boolean)$FatalIsEnabled.invoke(this.log, new Object[0]);
            }
            catch (Exception exce) {
                exce.printStackTrace();
            }
        }
        return true;
    }

    public boolean isErrorEnabled() {
        if ($ErrorIsEnabled != null) {
            try {
                return (Boolean)$ErrorIsEnabled.invoke(this.log, new Object[0]);
            }
            catch (Exception exce) {
                exce.printStackTrace();
            }
        }
        return true;
    }

    public boolean isWarnEnabled() {
        if ($WarnIsEnabled != null) {
            try {
                return (Boolean)$WarnIsEnabled.invoke(this.log, new Object[0]);
            }
            catch (Exception exce) {
                exce.printStackTrace();
            }
        }
        return true;
    }

    public boolean isInfoEnabled() {
        if ($InfoIsEnabled != null) {
            try {
                return (Boolean)$InfoIsEnabled.invoke(this.log, new Object[0]);
            }
            catch (Exception exce) {
                exce.printStackTrace();
            }
        }
        return true;
    }

    public boolean isDebugEnabled() {
        if ($DebugIsEnabled != null) {
            try {
                return (Boolean)$DebugIsEnabled.invoke(this.log, new Object[0]);
            }
            catch (Exception exce) {
                exce.printStackTrace();
            }
        }
        return true;
    }

    public boolean isTraceEnabled() {
        if ($TraceIsEnabled != null) {
            try {
                return (Boolean)$TraceIsEnabled.invoke(this.log, new Object[0]);
            }
            catch (Exception exce) {
                exce.printStackTrace();
            }
        }
        return true;
    }

    public void log(Object i_Marker, Level i_Level, String i_Message, Object[] i_Arguments, Throwable i_Throwable) {
        block21: {
            this.request(i_Level, Logger.getLevelName(i_Level), i_Message, i_Throwable);
            if (this.log != null && $LogMethod != $LogMethodNull) {
                try {
                    if (i_Marker == null || i_Marker != null && i_Marker.getClass().getName().endsWith("Marker")) {
                        if ($LogType == 1) {
                            $LogMethod.invoke(this.log, i_Marker, $FQCN, i_Level.getLevel(), i_Message, i_Arguments, i_Throwable);
                        } else if ($LogType == 2) {
                            if ($LogVersion == 1) {
                                $LogMethod.invoke(this.log, $FQCN, i_Level.getLevel(), i_Message + StringHelp.toString((Object[])i_Arguments), i_Throwable);
                            } else if (i_Throwable == null) {
                                $LogMethod.invoke(this.log, $FQCN, i_Level.getLevel(), i_Marker, i_Message, i_Arguments);
                            } else {
                                $LogMethod_Log4j2Throwable.invoke(this.log, $FQCN, i_Level.getLevel(), i_Marker, i_Message + StringHelp.toString((Object[])i_Arguments), i_Throwable);
                            }
                        }
                        break block21;
                    }
                    String v_Message = i_Marker.toString();
                    Object[] v_Arguments = new Object[i_Arguments.length + 1];
                    v_Arguments[0] = i_Message;
                    Help.fillArray((Object[])i_Arguments, (Object[])v_Arguments, (int)1);
                    if ($LogType == 1) {
                        $LogMethod.invoke(this.log, null, $FQCN, i_Level.getLevel(), v_Message, v_Arguments, i_Throwable);
                        break block21;
                    }
                    if ($LogType != 2) break block21;
                    if ($LogVersion == 1) {
                        $LogMethod.invoke(this.log, $FQCN, i_Level.getLevel(), v_Message + StringHelp.toString((Object[])v_Arguments), i_Throwable);
                        break block21;
                    }
                    if (i_Throwable == null) {
                        $LogMethod.invoke(this.log, $FQCN, i_Level.getLevel(), null, v_Message, v_Arguments);
                        break block21;
                    }
                    $LogMethod_Log4j2Throwable.invoke(this.log, $FQCN, i_Level.getLevel(), null, v_Message + StringHelp.toString((Object[])v_Arguments), i_Throwable);
                }
                catch (Exception exce) {
                    exce.printStackTrace();
                }
            } else if (this.logClass != null) {
                String v_ThreadName = Thread.currentThread().getName();
                if (i_Marker == null) {
                    this.println(Logger.getLevelName(i_Level) + "> " + v_ThreadName + "> " + i_Message + StringHelp.toString((Object[])i_Arguments));
                } else {
                    this.println(Logger.getLevelName(i_Level) + "> " + v_ThreadName + "> " + i_Marker.toString() + i_Message + StringHelp.toString((Object[])i_Arguments));
                }
                if (i_Throwable != null) {
                    i_Throwable.printStackTrace();
                }
            } else if (i_Throwable != null) {
                i_Throwable.printStackTrace();
            }
        }
    }

    public void fatal(String i_Message) {
        this.log(null, $LogLevelFatal, i_Message, null, null);
    }

    public void fatal(String i_Message, String i_Argument) {
        this.log(null, $LogLevelFatal, i_Message, new Object[]{i_Argument}, null);
    }

    public void fatal(Object i_Message) {
        if (i_Message != null) {
            this.log(null, $LogLevelFatal, i_Message.toString(), null, null);
        }
    }

    public void fatal(String i_Message, Throwable i_Throwable) {
        this.log(null, $LogLevelFatal, i_Message, null, i_Throwable);
    }

    public void fatal(Throwable i_Throwable) {
        this.log(null, $LogLevelFatal, "", null, i_Throwable);
    }

    public void fatal(Object i_Marker, String i_Message, Object ... i_Arguments) {
        this.log(i_Marker, $LogLevelFatal, i_Message, i_Arguments, null);
    }

    public void fatal(Object i_Marker, String i_Message, Throwable i_Throwable) {
        this.log(i_Marker, $LogLevelFatal, i_Message, null, i_Throwable);
    }

    public void error(String i_Message) {
        this.log(null, $LogLevelError, i_Message, null, null);
    }

    public void error(String i_Message, String i_Argument) {
        this.log(null, $LogLevelError, i_Message, new Object[]{i_Argument}, null);
    }

    public void error(Object i_Message) {
        if (i_Message != null) {
            this.log(null, $LogLevelError, i_Message.toString(), null, null);
        }
    }

    public void error(String i_Message, Throwable i_Throwable) {
        this.log(null, $LogLevelError, i_Message, null, i_Throwable);
    }

    public void error(Throwable i_Throwable) {
        this.log(null, $LogLevelError, "", null, i_Throwable);
    }

    public void error(Object i_Marker, String i_Message, Object ... i_Arguments) {
        this.log(i_Marker, $LogLevelError, i_Message, i_Arguments, null);
    }

    public void error(Object i_Marker, String i_Message, Throwable i_Throwable) {
        this.log(i_Marker, $LogLevelError, i_Message, null, i_Throwable);
    }

    public void warn(String i_Message) {
        this.log(null, $LogLevelWarn, i_Message, null, null);
    }

    public void warn(String i_Message, String i_Argument) {
        this.log(null, $LogLevelWarn, i_Message, new Object[]{i_Argument}, null);
    }

    public void warn(Object i_Message) {
        if (i_Message != null) {
            this.log(null, $LogLevelWarn, i_Message.toString(), null, null);
        }
    }

    public void warn(String i_Message, Throwable i_Throwable) {
        this.log(null, $LogLevelWarn, i_Message, null, i_Throwable);
    }

    public void warn(Throwable i_Throwable) {
        this.log(null, $LogLevelWarn, "", null, i_Throwable);
    }

    public void warn(Object i_Marker, String i_Message, Object ... i_Arguments) {
        this.log(i_Marker, $LogLevelWarn, i_Message, i_Arguments, null);
    }

    public void warn(Object i_Marker, String i_Message, Throwable i_Throwable) {
        this.log(i_Marker, $LogLevelWarn, i_Message, null, i_Throwable);
    }

    public void info(String i_Message) {
        this.log(null, $LogLevelInfo, i_Message, null, null);
    }

    public void info(String i_Message, String i_Argument) {
        this.log(null, $LogLevelInfo, i_Message, new Object[]{i_Argument}, null);
    }

    public void info(Object i_Message) {
        if (i_Message != null) {
            this.log(null, $LogLevelInfo, i_Message.toString(), null, null);
        }
    }

    public void info(String i_Message, Throwable i_Throwable) {
        this.log(null, $LogLevelInfo, i_Message, null, i_Throwable);
    }

    public void info(Throwable i_Throwable) {
        this.log(null, $LogLevelInfo, "", null, i_Throwable);
    }

    public void info(Object i_Marker, String i_Message, Object ... i_Arguments) {
        this.log(i_Marker, $LogLevelInfo, i_Message, i_Arguments, null);
    }

    public void info(Object i_Marker, String i_Message, Throwable i_Throwable) {
        this.log(i_Marker, $LogLevelInfo, i_Message, null, i_Throwable);
    }

    public void debug(String i_Message) {
        this.log(null, $LogLevelDebug, i_Message, null, null);
    }

    public void debug(String i_Message, String i_Argument) {
        this.log(null, $LogLevelDebug, i_Message, new Object[]{i_Argument}, null);
    }

    public void debug(Object i_Message) {
        if (i_Message != null) {
            this.log(null, $LogLevelDebug, i_Message.toString(), null, null);
        }
    }

    public void debug(String i_Message, Throwable i_Throwable) {
        this.log(null, $LogLevelDebug, i_Message, null, i_Throwable);
    }

    public void debug(Throwable i_Throwable) {
        this.log(null, $LogLevelDebug, "", null, i_Throwable);
    }

    public void debug(Object i_Marker, String i_Message, Object ... i_Arguments) {
        this.log(i_Marker, $LogLevelDebug, i_Message, i_Arguments, null);
    }

    public void debug(Object i_Marker, String i_Message, Throwable i_Throwable) {
        this.log(i_Marker, $LogLevelDebug, i_Message, null, i_Throwable);
    }

    public void trace(String i_Message) {
        this.log(null, $LogLevelTrace, i_Message, null, null);
    }

    public void trace(String i_Message, String i_Argument) {
        this.log(null, $LogLevelTrace, i_Message, new Object[]{i_Argument}, null);
    }

    public void trace(Object i_Message) {
        if (i_Message != null) {
            this.log(null, $LogLevelTrace, i_Message.toString(), null, null);
        }
    }

    public void trace(String i_Message, Throwable i_Throwable) {
        this.log(null, $LogLevelTrace, i_Message, null, i_Throwable);
    }

    public void trace(Throwable i_Throwable) {
        this.log(null, $LogLevelTrace, "", null, i_Throwable);
    }

    public void trace(Object i_Marker, String i_Message, Object ... i_Arguments) {
        this.log(i_Marker, $LogLevelTrace, i_Message, i_Arguments, null);
    }

    public void trace(Object i_Marker, String i_Message, Throwable i_Throwable) {
        this.log(i_Marker, $LogLevelTrace, i_Message, null, i_Throwable);
    }

    public void println(String i_Message) {
        if (this.logClass != null) {
            System.out.println("-- " + Date.getNowTime().getFullMilli() + " [" + this.logClass.getName() + "] " + i_Message);
        } else {
            System.out.println("-- " + Date.getNowTime().getFullMilli() + " " + i_Message);
        }
    }

    public int getLogType() {
        return $LogType;
    }

    public int getLogVersion() {
        return $LogVersion;
    }

    static {
        $Loggers = new TablePartition();
        try {
            $LogMethodNull = Logger.class.getMethod("toString", new Class[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

