/*
 * Decompiled with CFR 0.152.
 */
package org.hy.common.xml.plugins;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseFactory;
import org.hy.common.Date;
import org.hy.common.Help;
import org.hy.common.Return;
import org.hy.common.XJavaID;
import org.hy.common.xml.SerializableDef;
import org.hy.common.xml.XHttp;
import org.hy.common.xml.log.Logger;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class XRule
extends SerializableDef
implements XJavaID {
    private static final long serialVersionUID = 1329720425183820778L;
    private static final Logger $Logger = new Logger(XRule.class);
    private static final String $REGEX_Package = "[Pp][Aa][Cc][Kk][Aa][Gg][Ee]( )+\\w+\\.\\w+[\\w\\.]*;";
    private static final String $REGEX_Import = "[Ii][Mm][Pp][Oo][Rr][Tt]( )+\\w+\\.\\w+[\\w\\.]*;";
    private String xjavaID;
    private String ruleInfo = null;
    private String ruleFile;
    private XHttp ruleRemote;
    private StatelessKieSession kieSession = null;
    private String comment;
    private boolean isLazyMode;
    private boolean isNeedInit;

    public XRule() {
        this(true);
    }

    public XRule(boolean i_IsLazyMode) {
        this.isLazyMode = i_IsLazyMode;
        this.isNeedInit = true;
    }

    public boolean execute(Object io_RuleData) {
        if (io_RuleData == null) {
            return false;
        }
        if (this.isLazyMode) {
            this.initRule();
        }
        if (this.kieSession == null) {
            return false;
        }
        this.kieSession.execute(io_RuleData);
        return true;
    }

    public boolean execute(Iterable<?> io_RuleData) {
        if (io_RuleData == null) {
            return false;
        }
        if (this.isLazyMode) {
            this.initRule();
        }
        if (this.kieSession == null) {
            return false;
        }
        this.kieSession.execute(io_RuleData);
        return true;
    }

    public synchronized void initRule() {
        if (Help.isNull((String)this.ruleInfo) && Help.isNull((String)this.ruleFile) || !this.isNeedInit) {
            return;
        }
        if (!Help.isNull((String)this.ruleFile)) {
            this.initRuleFile();
        } else if (!Help.isNull((String)this.ruleInfo)) {
            this.initRuleInfo();
        } else if (null != this.ruleRemote) {
            this.initRuleRemote();
        }
        this.isNeedInit = false;
    }

    private void initRuleRemote() {
        Return<?> v_Response = this.ruleRemote.request();
        if (v_Response == null || !v_Response.booleanValue() || Help.isNull((String)v_Response.getParamStr())) {
            $Logger.error(Date.getNowTime().getFullMilli() + " XRule Build Errors: " + Help.NVL((String)this.comment) + "\n" + this.ruleRemote.getUrl());
            return;
        }
        KnowledgeBuilder v_KBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        v_KBuilder.add(ResourceFactory.newByteArrayResource((byte[])v_Response.getParamStr().getBytes()), ResourceType.DRL);
        if (v_KBuilder.hasErrors()) {
            $Logger.error(Date.getNowTime().getFullMilli() + " XRule Build Errors: " + Help.NVL((String)this.comment) + "\n" + this.ruleRemote.getUrl() + "\n" + v_Response.getParamStr());
            throw new RuntimeException("XRule Build Errors:\n" + v_KBuilder.getErrors());
        }
        InternalKnowledgeBase v_KBase = KnowledgeBaseFactory.newKnowledgeBase();
        v_KBase.addPackages(v_KBuilder.getKnowledgePackages());
        this.kieSession = v_KBase.newStatelessKieSession();
    }

    private void initRuleInfo() {
        KnowledgeBuilder v_KBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        v_KBuilder.add(ResourceFactory.newByteArrayResource((byte[])this.ruleInfo.getBytes()), ResourceType.DRL);
        if (v_KBuilder.hasErrors()) {
            $Logger.error(Date.getNowTime().getFullMilli() + " XRule Build Errors: " + Help.NVL((String)this.comment) + "\n" + this.ruleInfo);
            throw new RuntimeException("XRule Build Errors:\n" + v_KBuilder.getErrors());
        }
        InternalKnowledgeBase v_KBase = KnowledgeBaseFactory.newKnowledgeBase();
        v_KBase.addPackages(v_KBuilder.getKnowledgePackages());
        this.kieSession = v_KBase.newStatelessKieSession();
    }

    private void initRuleFile() {
        KnowledgeBuilder v_KBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        v_KBuilder.add(ResourceFactory.newClassPathResource((String)this.ruleFile, (String)"UTF-8"), ResourceType.DRL);
        if (v_KBuilder.hasErrors()) {
            $Logger.error(Date.getNowTime().getFullMilli() + " XRule Build Errors: " + Help.NVL((String)this.comment) + "\n" + this.ruleFile);
            throw new RuntimeException("XRule Build Errors:\n" + v_KBuilder.getErrors());
        }
        InternalKnowledgeBase v_KBase = KnowledgeBaseFactory.newKnowledgeBase();
        v_KBase.addPackages(v_KBuilder.getKnowledgePackages());
        this.kieSession = v_KBase.newStatelessKieSession();
    }

    public String getPackage() {
        if (Help.isNull((String)this.ruleInfo)) {
            return null;
        }
        Pattern v_Pattern = Pattern.compile($REGEX_Package);
        Matcher v_Matcher = v_Pattern.matcher(this.ruleInfo);
        if (v_Matcher.find()) {
            return this.ruleInfo.substring(v_Matcher.start(), v_Matcher.end());
        }
        return null;
    }

    public List<String> getImports() {
        if (Help.isNull((String)this.ruleInfo)) {
            return null;
        }
        ArrayList<String> v_Imports = new ArrayList<String>();
        Pattern v_Pattern = Pattern.compile($REGEX_Import);
        Matcher v_Matcher = v_Pattern.matcher(this.ruleInfo);
        while (v_Matcher.find()) {
            v_Imports.add(this.ruleInfo.substring(v_Matcher.start(), v_Matcher.end()));
        }
        return v_Imports;
    }

    public String getValue() {
        return this.ruleInfo;
    }

    public void setValue(String i_RuleInfo) {
        this.ruleInfo = i_RuleInfo;
        this.isNeedInit = true;
        if (!this.isLazyMode) {
            this.initRule();
        }
    }

    public String getFile() {
        return this.ruleFile;
    }

    public void setFile(String i_RuleFile) {
        this.ruleFile = i_RuleFile;
        this.isNeedInit = true;
        if (!this.isLazyMode) {
            this.initRule();
        }
    }

    public XHttp getRuleRemote() {
        return this.ruleRemote;
    }

    public void setRuleRemote(XHttp i_RuleRemote) {
        this.ruleRemote = i_RuleRemote;
        this.isNeedInit = true;
        if (!this.isLazyMode) {
            this.initRule();
        }
    }

    public StatelessKieSession getKieSession() {
        return this.kieSession;
    }

    public void setXJavaID(String i_XJavaID) {
        this.xjavaID = i_XJavaID;
    }

    public String getXJavaID() {
        return this.xjavaID;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isLazyMode() {
        return this.isLazyMode;
    }

    public void setLazyMode(boolean isLazyMode) {
        this.isLazyMode = isLazyMode;
    }
}

