/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao;

import cn.schoolwow.quickdao.dao.DAOOperation;
import cn.schoolwow.quickdao.dao.DAOOperationImpl;
import cn.schoolwow.quickdao.dao.sql.AbstractDatabaseDAO;
import cn.schoolwow.quickdao.dao.sql.DatabaseDAO;
import cn.schoolwow.quickdao.dao.transaction.Transaction;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class DAOInvocationHandler
implements InvocationHandler {
    private QuickDAOConfig quickDAOConfig;
    private DAOOperation daoOperation;

    public DAOInvocationHandler(QuickDAOConfig quickDAOConfig) {
        this.quickDAOConfig = quickDAOConfig;
        this.daoOperation = new DAOOperationImpl(quickDAOConfig);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String interfaceName = method.getDeclaringClass().getSimpleName();
        DatabaseDAO instance = null;
        switch (interfaceName) {
            case "DatabaseDAO": {
                instance = new AbstractDatabaseDAO(this.quickDAOConfig);
                break;
            }
            case "DatabaseControl": {
                instance = this.quickDAOConfig.databaseProvider.getDatabaseControlInstance(this.quickDAOConfig);
                break;
            }
            case "DatabaseDefinition": {
                instance = this.quickDAOConfig.databaseProvider.getDatabaseDefinitionInstance(this.quickDAOConfig);
                break;
            }
            case "DatabaseManipulation": {
                Transaction threadTransaction = this.quickDAOConfig.transactionThreadLocal.get();
                if (null != threadTransaction) {
                    instance = threadTransaction;
                    break;
                }
                instance = this.quickDAOConfig.databaseProvider.getDatabaseManipulationInstance(this.quickDAOConfig);
                break;
            }
            default: {
                return method.invoke((Object)this.daoOperation, args);
            }
        }
        Object result = method.invoke((Object)instance, args);
        return result;
    }
}

