/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao;

import cn.schoolwow.quickdao.dao.DAOOperation;
import cn.schoolwow.quickdao.dao.dql.condition.AbstractCondition;
import cn.schoolwow.quickdao.dao.dql.condition.Condition;
import cn.schoolwow.quickdao.dao.transaction.Transaction;
import cn.schoolwow.quickdao.dao.transaction.TransactionInvocationHandler;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.Query;
import cn.schoolwow.quickdao.provider.DatabaseProvider;
import cn.schoolwow.quickdao.statement.dql.response.GetResponseArrayDatabaseStatement;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DAOOperationImpl
implements DAOOperation {
    private Logger logger = LoggerFactory.getLogger(DAOOperationImpl.class);
    private final QuickDAOConfig quickDAOConfig;

    public DAOOperationImpl(QuickDAOConfig quickDAOConfig) {
        this.quickDAOConfig = quickDAOConfig;
    }

    @Override
    public <T> Condition<T> query(Class<T> clazz) {
        Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
        if (null == entity) {
            throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u7684\u5b9e\u4f53\u7c7b:" + clazz.getName() + "!");
        }
        return this.query(entity);
    }

    @Override
    public Condition query(String tableName) {
        Entity entity = this.quickDAOConfig.getDatabaseEntityByTableName(tableName);
        if (null == entity) {
            for (String virtualTableName : this.quickDAOConfig.databaseOption.virtualTableNameList) {
                if (!virtualTableName.equalsIgnoreCase(tableName)) continue;
                entity = new Entity();
                entity.tableName = virtualTableName;
                entity.properties = new ArrayList<Property>();
                break;
            }
        }
        if (null == entity) {
            throw new IllegalArgumentException("\u4e0d\u5b58\u5728\u7684\u8868\u540d:" + tableName + "!");
        }
        return this.query(entity);
    }

    @Override
    public Condition query(Condition condition) {
        Query fromQuery = ((AbstractCondition)condition).query;
        condition.execute();
        Entity entity = new Entity();
        entity.clazz = JSONObject.class;
        entity.properties = new ArrayList<Property>();
        AbstractCondition condition1 = (AbstractCondition)this.query(entity);
        condition1.query.fromQuery = fromQuery;
        entity.tableName = "( " + new GetResponseArrayDatabaseStatement(fromQuery).getStatement() + ")";
        return condition1;
    }

    @Override
    public Transaction startTransaction() {
        TransactionInvocationHandler transactionInvocationHandler = new TransactionInvocationHandler(this.quickDAOConfig);
        Transaction transactionProxy = (Transaction)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Transaction.class}, (InvocationHandler)transactionInvocationHandler);
        return transactionProxy;
    }

    @Override
    public void startTransaction(Consumer<Transaction> transactionConsumer) {
        try (Transaction transaction = this.startTransaction();){
            transactionConsumer.accept(transaction);
            transaction.commit();
        }
    }

    @Override
    public DataSource getDataSource() {
        return this.quickDAOConfig.dataSource;
    }

    @Override
    public Map<String, Entity> getEntityMap() {
        return this.quickDAOConfig.entityMap;
    }

    @Override
    public Entity getEntity(Class clazz) {
        return this.quickDAOConfig.entityMap.values().stream().filter(entity -> entity.clazz.getName().equalsIgnoreCase(clazz.getName())).findFirst().orElse(null);
    }

    @Override
    public Entity getEntity(String tableName) {
        return this.quickDAOConfig.entityMap.values().stream().filter(entity -> entity.tableName.equalsIgnoreCase(tableName)).findFirst().orElse(null);
    }

    @Override
    public DatabaseProvider getDatabaseProvider() {
        return this.quickDAOConfig.databaseProvider;
    }

    @Override
    public QuickDAOConfig getQuickDAOConfig() {
        return this.quickDAOConfig;
    }

    @Override
    public void startRecord() {
        this.quickDAOConfig.record = true;
    }

    @Override
    public String stopRecord() {
        this.quickDAOConfig.record = false;
        String sqlRecord = this.quickDAOConfig.sqlRecordBuilder.toString();
        this.quickDAOConfig.sqlRecordBuilder.setLength(0);
        return sqlRecord;
    }

    @Override
    public <T> T log(Class<T> logEntity) {
        return this.logMap("#SINGLE_INSTANCE#", logEntity);
    }

    @Override
    public <T> T logIfExist(Class<T> logEntity) {
        return this.logMapIfExist("#SINGLE_INSTANCE#", logEntity);
    }

    @Override
    public <T> T logMapIfExist(String uniqueKey, Class<T> logEntity) {
        try {
            Map classNameLogInstance;
            Map<Object, Object> classNameLogInstanceMap;
            if (null == this.quickDAOConfig.classNameLogInstanceMapThreadLocal.get()) {
                classNameLogInstanceMap = new HashMap();
                this.quickDAOConfig.classNameLogInstanceMapThreadLocal.set(classNameLogInstanceMap);
            }
            if (!(classNameLogInstanceMap = this.quickDAOConfig.classNameLogInstanceMapThreadLocal.get()).containsKey(logEntity.getName())) {
                classNameLogInstanceMap.put(logEntity.getName(), new ConcurrentHashMap());
            }
            if ((classNameLogInstance = (Map)classNameLogInstanceMap.get(logEntity.getName())).containsKey(uniqueKey)) {
                Object logInstance = classNameLogInstance.get(uniqueKey);
                return (T)logInstance;
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> List<T> logMap(Class<T> logEntity) {
        try {
            Map classNameLogInstance;
            Map<Object, Object> classNameLogInstanceMap;
            if (null == this.quickDAOConfig.classNameLogInstanceMapThreadLocal.get()) {
                classNameLogInstanceMap = new HashMap();
                this.quickDAOConfig.classNameLogInstanceMapThreadLocal.set(classNameLogInstanceMap);
            }
            if (!(classNameLogInstanceMap = this.quickDAOConfig.classNameLogInstanceMapThreadLocal.get()).containsKey(logEntity.getName())) {
                classNameLogInstanceMap.put(logEntity.getName(), new ConcurrentHashMap());
            }
            if (null == (classNameLogInstance = (Map)classNameLogInstanceMap.get(logEntity.getName()))) {
                return null;
            }
            ArrayList instanceList = new ArrayList();
            for (Object instance : classNameLogInstance.values()) {
                instanceList.add(instance);
            }
            return instanceList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T logMap(String uniqueKey, Class<T> logEntity) {
        try {
            Map classNameLogInstance;
            Map<Object, Object> classNameLogInstanceMap;
            if (null == this.quickDAOConfig.classNameLogInstanceMapThreadLocal.get()) {
                classNameLogInstanceMap = new HashMap();
                this.quickDAOConfig.classNameLogInstanceMapThreadLocal.set(classNameLogInstanceMap);
            }
            if (!(classNameLogInstanceMap = this.quickDAOConfig.classNameLogInstanceMapThreadLocal.get()).containsKey(logEntity.getName())) {
                classNameLogInstanceMap.put(logEntity.getName(), new ConcurrentHashMap());
            }
            if (!(classNameLogInstance = (Map)classNameLogInstanceMap.get(logEntity.getName())).containsKey(uniqueKey)) {
                classNameLogInstance.put(uniqueKey, logEntity.newInstance());
            }
            Object logInstance = classNameLogInstance.get(uniqueKey);
            return (T)logInstance;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clearLog() {
        Map<String, Map<String, Object>> classNameLogInstanceMap = this.quickDAOConfig.classNameLogInstanceMapThreadLocal.get();
        if (null != classNameLogInstanceMap) {
            classNameLogInstanceMap.clear();
        }
    }

    @Override
    public void insertLog() {
        Map<Object, Object> classNameLogInstanceMap;
        if (null == this.quickDAOConfig.classNameLogInstanceMapThreadLocal.get()) {
            classNameLogInstanceMap = new ConcurrentHashMap();
            this.quickDAOConfig.classNameLogInstanceMapThreadLocal.set(classNameLogInstanceMap);
        }
        if (null == (classNameLogInstanceMap = this.quickDAOConfig.classNameLogInstanceMapThreadLocal.get())) {
            return;
        }
        Collection<Object> logInstanceMapCollection = classNameLogInstanceMap.values();
        for (Map map : logInstanceMapCollection) {
            Collection logInstances = map.values();
            this.quickDAOConfig.dao.insert(logInstances);
        }
        classNameLogInstanceMap.clear();
    }

    private Condition query(Entity entity) {
        Query query = new Query();
        query.entity = entity;
        query.quickDAOConfig = this.quickDAOConfig;
        return this.quickDAOConfig.databaseProvider.getConditionInstance(query);
    }
}

