/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao.ddl;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.annotation.IndexType;
import cn.schoolwow.quickdao.dao.ddl.AbstractDatabaseDefinition;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.IndexField;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MySQLDatabaseDefinition
extends AbstractDatabaseDefinition {
    public MySQLDatabaseDefinition(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
    }

    @Override
    public boolean hasTable(String tableName) {
        String hasTableSQL = "show tables like ?;";
        return this.connectionExecutor.name("\u5224\u65ad\u8868\u662f\u5426\u5b58\u5728").sql(hasTableSQL).parameters(Arrays.asList(tableName)).executeAndCheckExists();
    }

    @Override
    public boolean hasColumn(String tableName, String columnName) {
        String hasTableColumnSQL = "select table_name, column_name, data_type, character_maximum_length, numeric_precision, is_nullable, column_key, extra, column_default, column_comment from information_schema.`columns` where table_name = ? and column_name = ?;";
        List<String> parameters = Arrays.asList(tableName, columnName);
        return this.connectionExecutor.name("\u5224\u65ad\u8868\u6307\u5b9a\u5217\u662f\u5426\u5b58\u5728").sql(hasTableColumnSQL).parameters(parameters).executeAndCheckExists();
    }

    @Override
    public List<String> getTableNameList() {
        String getEntityListSQL = "show table status;";
        ArrayList<String> tableNames = new ArrayList<String>();
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u540d\u5217\u8868").sql(getEntityListSQL).executeQuery(resultSet -> {
            while (resultSet.next()) {
                tableNames.add(resultSet.getString("name"));
            }
        });
        return tableNames;
    }

    @Override
    public List<Entity> getDatabaseEntityList() {
        String getEntityListSQL = "show table status;";
        ArrayList<Entity> entityList = new ArrayList<Entity>();
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u5217\u8868").sql(getEntityListSQL).executeQuery(resultSet -> {
            while (resultSet.next()) {
                Entity entity = new Entity();
                entity.tableName = resultSet.getString("name");
                entity.comment = resultSet.getString("comment").replace("\"", "\\\"");
                entityList.add(entity);
            }
        });
        String getEntityPropertyListSQL = "select table_name, column_name, data_type, character_maximum_length, numeric_precision, is_nullable, column_key, extra, column_default, column_comment from information_schema.`columns` where table_schema = '" + this.quickDAOConfig.databaseName + "' order by table_name asc, ordinal_position asc;";
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u5b57\u6bb5\u4fe1\u606f").sql(getEntityPropertyListSQL).executeQuery(resultSet -> {
            block0: while (resultSet.next()) {
                for (Entity entity : entityList) {
                    if (!entity.tableName.equalsIgnoreCase(resultSet.getString("table_name"))) continue;
                    Property property = new Property();
                    this.getProperty((ResultSet)resultSet, property);
                    entity.properties.add(property);
                    continue block0;
                }
            }
        });
        this.getIndex(entityList);
        return entityList;
    }

    @Override
    public Entity getDatabaseEntity(String tableName) {
        String getEntityListSQL = "show table status;";
        Entity entity = new Entity();
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u5217\u8868").sql(getEntityListSQL).executeQuery(resultSet -> {
            while (resultSet.next()) {
                if (!resultSet.getString("name").equalsIgnoreCase(tableName)) continue;
                entity.tableName = resultSet.getString("name");
                entity.comment = resultSet.getString("comment").replace("\"", "\\\"");
                entity.properties = this.getPropertyList(tableName);
                entity.indexFieldList = this.getIndexField(tableName);
                break;
            }
        });
        return null == entity.tableName ? null : entity;
    }

    @Override
    public List<Property> getPropertyList(Class clazz) {
        Entity entity = this.quickDAOConfig.entityMap.get(clazz.getName());
        if (null == entity) {
            throw new IllegalArgumentException("\u5b9e\u4f53\u7c7b\u4e0d\u5b58\u5728!\u5b9e\u4f53\u7c7b:" + clazz.getName());
        }
        return this.getPropertyList(entity.tableName);
    }

    @Override
    public List<Property> getPropertyList(String tableName) {
        String getEntityPropertyListSQL = "select table_name, column_name, data_type, character_maximum_length, numeric_precision, is_nullable, column_key, extra, column_default, column_comment from information_schema.`columns` where table_name = ? and table_schema = '" + this.quickDAOConfig.databaseName + "';";
        ArrayList<Property> propertyList = new ArrayList<Property>();
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u5b57\u6bb5\u5217\u8868\u4fe1\u606f").sql(getEntityPropertyListSQL).parameters(Arrays.asList(tableName)).executeQuery(resultSet -> {
            while (resultSet.next()) {
                Property property = new Property();
                this.getProperty((ResultSet)resultSet, property);
                propertyList.add(property);
            }
        });
        return propertyList;
    }

    @Override
    public Property getProperty(String tableName, String columnName) {
        String getEntityPropertyListSQL = "select table_name, column_name, data_type, character_maximum_length, numeric_precision, is_nullable, column_key, extra, column_default, column_comment from information_schema.`columns` where table_name = ? and column_name = ? and table_schema = '" + this.quickDAOConfig.databaseName + "';";
        List<String> parameters = Arrays.asList(tableName, columnName);
        Property property = new Property();
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u5b57\u6bb5\u4fe1\u606f").sql(getEntityPropertyListSQL).parameters(parameters).executeQuery(resultSet -> {
            if (resultSet.next()) {
                this.getProperty((ResultSet)resultSet, property);
            }
        });
        return null == property.column ? null : property;
    }

    @Override
    public void create(Entity entity) {
        StringBuilder builder = new StringBuilder("create table " + this.quickDAOConfig.databaseProvider.escape(entity.tableName) + "(");
        for (Property property : entity.properties) {
            if (property.id && property.strategy == IdStrategy.AutoIncrement) {
                builder.append(this.getAutoIncrementSQL(property));
            } else {
                builder.append(this.quickDAOConfig.databaseProvider.escape(property.column) + " " + property.columnType + (null == property.length ? "" : "(" + property.length + ")"));
                if (property.notNull) {
                    builder.append(" not null");
                }
                if (null != property.defaultValue && !property.defaultValue.isEmpty()) {
                    builder.append(" default " + property.defaultValue);
                }
                if (null != property.comment) {
                    builder.append(" " + this.quickDAOConfig.databaseProvider.comment(property.comment));
                }
                if (null != property.escapeCheck && !property.escapeCheck.isEmpty()) {
                    builder.append(" check " + property.escapeCheck);
                }
            }
            builder.append(",");
        }
        for (IndexField indexField : entity.indexFieldList) {
            if (null == indexField.columns || indexField.columns.isEmpty()) {
                this.logger.warn("\u5ffd\u7565\u7d22\u5f15,\u8be5\u7d22\u5f15\u5b57\u6bb5\u4fe1\u606f\u4e3a\u7a7a!\u8868:{},\u7d22\u5f15\u540d\u79f0:{}", (Object)entity.tableName, (Object)indexField.indexName);
                continue;
            }
            switch (indexField.indexType) {
                case UNIQUE: {
                    builder.append("unique");
                }
                case NORMAL: {
                    builder.append(" index " + this.quickDAOConfig.databaseProvider.escape(indexField.indexName) + " (");
                    for (String column : indexField.columns) {
                        builder.append(this.quickDAOConfig.databaseProvider.escape(column) + ",");
                    }
                    builder.deleteCharAt(builder.length() - 1);
                    builder.append(")");
                    if (null != indexField.using && !indexField.using.isEmpty()) {
                        builder.append(" using " + indexField.using);
                    }
                    if (null != indexField.comment && !indexField.comment.isEmpty()) {
                        builder.append(" " + this.quickDAOConfig.databaseProvider.comment(indexField.comment));
                    }
                    builder.append(",");
                    break;
                }
                case FULLTEXT: {
                    builder.append("fulltext(" + indexField.columns.get(0) + "),");
                }
            }
        }
        if (this.quickDAOConfig.databaseOption.openForeignKey && null != entity.foreignKeyProperties && entity.foreignKeyProperties.size() > 0) {
            for (Property property : entity.foreignKeyProperties) {
                builder.append("foreign key(" + this.quickDAOConfig.databaseProvider.escape(property.column) + ") references ");
                String operation = property.foreignKey.foreignKeyOption().getOperation();
                builder.append(this.quickDAOConfig.databaseProvider.escape(this.quickDAOConfig.getEntityByClassName((String)property.foreignKey.table().getName()).tableName) + "(" + this.quickDAOConfig.databaseProvider.escape(property.foreignKey.field()) + ") ON DELETE " + operation + " ON UPDATE " + operation);
                builder.append(",");
            }
        }
        builder.deleteCharAt(builder.length() - 1);
        if (!entity.properties.isEmpty()) {
            builder.append(")");
        }
        if (null != entity.comment) {
            builder.append(" " + this.quickDAOConfig.databaseProvider.comment(entity.comment));
        }
        builder.append(";");
        String createTableSQL = builder.toString();
        this.connectionExecutor.name("\u751f\u6210\u65b0\u8868").sql(createTableSQL).executeUpdate();
        this.quickDAOConfig.getDatabaseEntityByTableName(entity.tableName);
    }

    @Override
    public boolean hasIndex(String tableName, String indexName) {
        String hasIndexSQL = "show index from " + this.quickDAOConfig.databaseProvider.escape(tableName) + " where key_name = ?;";
        return this.connectionExecutor.name("\u5224\u65ad\u7d22\u5f15\u662f\u5426\u5b58\u5728").sql(hasIndexSQL).parameters(Arrays.asList(indexName)).executeAndCheckExists();
    }

    @Override
    public List<IndexField> getIndexField(String tableName) {
        String getIndexSQL = "select table_name, index_name, non_unique, column_name, index_type, index_comment from information_schema.`statistics` where table_name = ? and table_schema = '" + this.quickDAOConfig.databaseName + "';";
        ArrayList<IndexField> indexFieldList = new ArrayList<IndexField>();
        this.connectionExecutor.name("\u83b7\u53d6\u7d22\u5f15\u4fe1\u606f").sql(getIndexSQL).parameters(Arrays.asList(tableName)).executeQuery(resultSet -> {
            while (resultSet.next()) {
                String indexName = resultSet.getString("index_name");
                IndexField indexField = null;
                for (IndexField indexField1 : indexFieldList) {
                    if (!indexField1.indexName.equals(indexName)) continue;
                    indexField = indexField1;
                    break;
                }
                if (null == indexField) {
                    indexField = new IndexField();
                    IndexType indexType = indexField.indexType = resultSet.getInt("non_unique") == 0 ? IndexType.UNIQUE : IndexType.NORMAL;
                    if ("FULLTEXT".equals(resultSet.getString("index_type"))) {
                        indexField.indexType = IndexType.FULLTEXT;
                    }
                    indexField.indexName = resultSet.getString("index_name");
                    indexField.columns.add(resultSet.getString("column_name"));
                    indexField.using = resultSet.getString("index_type");
                    indexField.comment = resultSet.getString("index_comment");
                    indexFieldList.add(indexField);
                    continue;
                }
                indexField.columns.add(resultSet.getString("column_name"));
            }
        });
        return indexFieldList;
    }

    @Override
    public void dropIndex(String tableName, String indexName) {
        String dropIndexSQL = "drop index " + this.quickDAOConfig.databaseProvider.escape(indexName) + " on " + this.quickDAOConfig.databaseProvider.escape(tableName) + ";";
        this.connectionExecutor.name("\u5220\u9664\u7d22\u5f15").sql(dropIndexSQL).executeUpdate();
    }

    @Override
    public void enableForeignConstraintCheck(boolean enable) {
        String foreignConstraintCheckSQL = "set foreign_key_checks = " + (enable ? 1 : 0) + ";";
        this.connectionExecutor.name(enable ? "\u542f\u7528\u5916\u952e\u7ea6\u675f\u68c0\u67e5" : "\u7981\u7528\u5916\u952e\u7ea6\u675f\u68c0\u67e5").sql(foreignConstraintCheckSQL).executeUpdate();
    }

    @Override
    protected String getAutoIncrementSQL(Property property) {
        return property.column + " " + property.columnType + (null == property.length ? "" : "(" + property.length + ")") + " primary key auto_increment";
    }

    @Override
    protected void getIndex(List<Entity> entityList) {
        String getIndexSQL = "select table_name, index_name, non_unique, column_name, index_type, index_comment from information_schema.`statistics` where table_schema = '" + this.quickDAOConfig.databaseName + "';";
        this.connectionExecutor.name("\u83b7\u53d6\u7d22\u5f15\u4fe1\u606f").sql(getIndexSQL).executeQuery(resultSet -> {
            block0: while (resultSet.next()) {
                for (Entity entity : entityList) {
                    if (!entity.tableName.equalsIgnoreCase(resultSet.getString("table_name"))) continue;
                    String indexName = resultSet.getString("index_name");
                    IndexField indexField = null;
                    for (IndexField indexField1 : entity.indexFieldList) {
                        if (!indexField1.indexName.equals(indexName)) continue;
                        indexField = indexField1;
                        break;
                    }
                    if (null == indexField) {
                        indexField = new IndexField();
                        IndexType indexType = indexField.indexType = resultSet.getInt("non_unique") == 0 ? IndexType.UNIQUE : IndexType.NORMAL;
                        if ("FULLTEXT".equals(resultSet.getString("index_type"))) {
                            indexField.indexType = IndexType.FULLTEXT;
                        }
                        indexField.indexName = resultSet.getString("index_name");
                        if ("PRIMARY".equalsIgnoreCase(indexField.indexName)) {
                            for (Property property : entity.properties) {
                                if (!property.column.equals(resultSet.getString("column_name"))) continue;
                                property.id = true;
                            }
                            continue block0;
                        }
                        indexField.columns.add(resultSet.getString("column_name"));
                        indexField.using = resultSet.getString("index_type");
                        indexField.comment = resultSet.getString("index_comment");
                        entity.indexFieldList.add(indexField);
                        continue block0;
                    }
                    indexField.columns.add(resultSet.getString("column_name"));
                    continue block0;
                }
            }
        });
    }

    private void getProperty(ResultSet resultSet, Property property) throws SQLException {
        Object numericPrecision;
        Object characterMaximumLength;
        property.column = resultSet.getString("column_name");
        property.columnType = resultSet.getString("data_type");
        if (property.columnType.contains(" ")) {
            property.columnType = property.columnType.substring(0, property.columnType.indexOf(" ")).trim();
        }
        if (null != (characterMaximumLength = resultSet.getObject("character_maximum_length")) && characterMaximumLength.toString().length() < 7) {
            property.length = Integer.parseInt(characterMaximumLength.toString());
        }
        if (null != (numericPrecision = resultSet.getObject("numeric_precision"))) {
            property.length = Integer.parseInt(numericPrecision.toString());
        }
        property.notNull = "NO".equals(resultSet.getString("is_nullable"));
        String key = resultSet.getString("column_key");
        if ("PRI".equals(key)) {
            property.id = true;
        }
        if ("auto_increment".equals(resultSet.getString("extra"))) {
            property.id = true;
            property.strategy = IdStrategy.AutoIncrement;
        } else {
            property.strategy = IdStrategy.None;
        }
        if (null != resultSet.getString("column_default")) {
            property.defaultValue = resultSet.getString("column_default");
            if (!property.defaultValue.contains("CURRENT_TIMESTAMP") && !property.defaultValue.contains("'")) {
                property.defaultValue = "'" + property.defaultValue + "'";
            }
        }
        property.comment = resultSet.getString("column_comment").replace("\"", "\\\"");
    }
}

