/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao.ddl;

import cn.schoolwow.quickdao.annotation.IndexType;
import cn.schoolwow.quickdao.dao.ddl.PostgreDatabaseDefinition;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.IndexField;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OracleDatabaseDefinition
extends PostgreDatabaseDefinition {
    public OracleDatabaseDefinition(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
    }

    @Override
    public boolean hasTable(String tableName) {
        String hasTableSQL = "select table_name from user_tables where table_name = ?";
        return this.connectionExecutor.name("\u5224\u65ad\u8868\u662f\u5426\u5b58\u5728").sql(hasTableSQL).parameters(Arrays.asList(tableName)).executeAndCheckExists();
    }

    @Override
    public boolean hasColumn(String tableName, String columnName) {
        String hasTableColumnSQL = "select table_name, column_name, data_type, nullable, data_length from user_tab_columns where table_name = ? and column_name = ?";
        List<String> parameters = Arrays.asList(tableName, columnName);
        return this.connectionExecutor.name("\u5224\u65ad\u8868\u6307\u5b9a\u5217\u662f\u5426\u5b58\u5728").sql(hasTableColumnSQL).parameters(parameters).executeAndCheckExists();
    }

    @Override
    public List<String> getTableNameList() {
        String getEntityListSQL = "select user_tables.table_name from user_tables";
        ArrayList<String> tableNames = new ArrayList<String>();
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u540d\u5217\u8868").sql(getEntityListSQL).executeQuery(resultSet -> {
            while (resultSet.next()) {
                tableNames.add(resultSet.getString("table_name"));
            }
        });
        return tableNames;
    }

    @Override
    public List<Entity> getDatabaseEntityList() {
        String getEntityListSQL = "select user_tables.table_name, user_tab_comments.comments from user_tables left join user_tab_comments on user_tables.table_name = user_tab_comments.table_name";
        ArrayList<Entity> entityList = new ArrayList<Entity>();
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u5217\u8868").sql(getEntityListSQL).executeQuery(resultSet -> {
            while (resultSet.next()) {
                Entity entity = new Entity();
                entity.tableName = resultSet.getString("table_name");
                entity.comment = resultSet.getString("comments");
                entity.properties = this.getPropertyList(entity.tableName);
                entityList.add(entity);
            }
        });
        this.getIndex(entityList);
        return entityList;
    }

    @Override
    public Entity getDatabaseEntity(String tableName) {
        String getEntitySQL = "select user_tables.table_name,user_tab_comments.comments from user_tables left join user_tab_comments on user_tables.table_name = user_tab_comments.table_name where user_tables.table_name = ?";
        Entity entity = new Entity();
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u5217\u8868").sql(getEntitySQL).parameters(Arrays.asList(tableName)).executeQuery(resultSet -> {
            if (resultSet.next()) {
                entity.tableName = resultSet.getString("table_name");
                entity.comment = resultSet.getString("comments");
                entity.properties = this.getPropertyList(entity.tableName);
                entity.indexFieldList = this.getIndexField(tableName);
            }
        });
        return null == entity.tableName ? null : entity;
    }

    @Override
    public List<Property> getPropertyList(String tableName) {
        String getEntityPropertyListSQL = "select table_name, column_name, data_type, nullable, data_length from user_tab_columns where table_name = ?";
        ArrayList<Property> propertyList = new ArrayList<Property>();
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u5b57\u6bb5\u4fe1\u606f").sql(getEntityPropertyListSQL).parameters(Arrays.asList(tableName)).executeQuery(resultSet -> {
            while (resultSet.next()) {
                Property property = new Property();
                property.column = resultSet.getString("column_name");
                property.columnType = resultSet.getString("data_type");
                if (property.columnType.contains(" ")) {
                    property.columnType = property.columnType.substring(0, property.columnType.indexOf(" "));
                }
                String dataLength = resultSet.getString("data_length");
                if (property.columnType.toLowerCase().contains("char") && null != dataLength && !dataLength.isEmpty()) {
                    property.columnType = property.columnType + "(" + dataLength + ")";
                }
                property.notNull = "N".equals(resultSet.getString("nullable"));
                propertyList.add(property);
            }
        });
        String getPropertyCommentList = "select table_name, column_name, comments from user_col_comments where table_name = '" + tableName + "'";
        this.connectionExecutor.name("\u83b7\u53d6\u5b57\u6bb5\u5217\u8868\u6ce8\u91ca").sql(getPropertyCommentList).executeQuery(resultSet -> {
            block0: while (resultSet.next()) {
                for (Property property : propertyList) {
                    if (!property.column.equalsIgnoreCase(resultSet.getString("column_name"))) continue;
                    property.comment = resultSet.getString("comments");
                    continue block0;
                }
            }
        });
        return propertyList;
    }

    @Override
    public Property getProperty(String tableName, String columnName) {
        String getEntityPropertyListSQL = "select table_name, column_name, data_type, nullable, data_length from user_tab_columns where table_name = ? and column_name = ?";
        List<String> parameters = Arrays.asList(tableName, columnName);
        Property property = new Property();
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u5b57\u6bb5\u4fe1\u606f").sql(getEntityPropertyListSQL).parameters(parameters).executeQuery(resultSet -> {
            if (resultSet.next()) {
                property.column = resultSet.getString("column_name");
                property.columnType = resultSet.getString("data_type");
                if (property.columnType.contains(" ")) {
                    property.columnType = property.columnType.substring(0, property.columnType.indexOf(" "));
                }
                String dataLength = resultSet.getString("data_length");
                if (property.columnType.toLowerCase().contains("char") && null != dataLength && !dataLength.isEmpty()) {
                    property.columnType = property.columnType + "(" + dataLength + ")";
                }
                property.notNull = "N".equals(resultSet.getString("nullable"));
            }
        });
        if (null != property.column) {
            String getPropertyCommentList = "select table_name, column_name, comments from user_col_comments where table_name = '" + tableName + "' and column_name = '" + columnName + "'";
            this.connectionExecutor.name("\u83b7\u53d6\u5b57\u6bb5\u6ce8\u91ca").sql(getPropertyCommentList).executeQuery(resultSet -> {
                if (resultSet.next()) {
                    property.comment = resultSet.getString("comments");
                }
            });
        }
        return null == property.column ? null : property;
    }

    @Override
    public void create(Entity entity) {
        super.create(entity);
        this.createSequence(entity);
    }

    @Override
    public boolean hasIndex(String tableName, String indexName) {
        String hasIndexSQL = "select index_name from user_indexes where table_name = ? and index_name = ?";
        List<String> parameters = Arrays.asList(tableName, indexName);
        return this.connectionExecutor.name("\u5224\u65ad\u7d22\u5f15\u662f\u5426\u5b58\u5728").sql(hasIndexSQL).parameters(parameters).executeAndCheckExists();
    }

    @Override
    public List<IndexField> getIndexField(String tableName) {
        ArrayList<IndexField> indexFieldList = new ArrayList<IndexField>();
        String getIndexSQL = "select table_name, index_name,uniqueness from user_indexes where table_name = ?";
        this.connectionExecutor.name("\u83b7\u53d6\u7d22\u5f15\u4fe1\u606f").sql(getIndexSQL).parameters(Arrays.asList(tableName)).executeQuery(resultSet -> {
            while (resultSet.next()) {
                IndexField indexField = new IndexField();
                indexField.tableName = tableName;
                indexField.indexType = "UNIQUE".equalsIgnoreCase(resultSet.getString("uniqueness")) ? IndexType.UNIQUE : IndexType.NORMAL;
                indexField.indexName = resultSet.getString("index_name");
                indexFieldList.add(indexField);
            }
        });
        return indexFieldList;
    }

    @Override
    protected String getAutoIncrementSQL(Property property) {
        return this.quickDAOConfig.databaseProvider.escape(property.column) + " number not null";
    }

    @Override
    protected void getIndex(List<Entity> entityList) {
        String getIndexSQL = "select table_name, index_name,uniqueness from user_indexes";
        this.connectionExecutor.name("\u83b7\u53d6\u7d22\u5f15\u4fe1\u606f").sql(getIndexSQL).executeQuery(resultSet -> {
            block0: while (resultSet.next()) {
                for (Entity entity : entityList) {
                    String tableName = resultSet.getString("table_name");
                    if (!entity.tableName.equalsIgnoreCase(tableName)) continue;
                    IndexField indexField = new IndexField();
                    indexField.tableName = tableName;
                    indexField.indexType = "UNIQUE".equalsIgnoreCase(resultSet.getString("uniqueness")) ? IndexType.UNIQUE : IndexType.NORMAL;
                    indexField.indexName = resultSet.getString("index_name");
                    entity.indexFieldList.add(indexField);
                    continue block0;
                }
            }
        });
        String getIndexColumnsSQL = "select table_name, index_name,column_name from user_ind_columns";
        this.connectionExecutor.name("\u83b7\u53d6\u7d22\u5f15\u5b57\u6bb5\u4fe1\u606f").sql(getIndexColumnsSQL).executeQuery(resultSet -> {
            block0: while (resultSet.next()) {
                String indexName = resultSet.getString("index_name");
                for (Entity entity : entityList) {
                    IndexField existIndexField;
                    if (!entity.tableName.equalsIgnoreCase(resultSet.getString("table_name")) || null == (existIndexField = (IndexField)entity.indexFieldList.stream().filter(indexField1 -> indexField1.indexName.equals(indexName)).findFirst().orElse(null))) continue;
                    existIndexField.columns.add(resultSet.getString("column_name"));
                    continue block0;
                }
            }
        });
    }

    private void createSequence(Entity entity) {
        if (null == entity.id) {
            return;
        }
        StringBuilder createSequenceBuilder = new StringBuilder();
        String sequenceExistSQL = "select sequence_name from user_sequences where sequence_name= '" + entity.tableName.toUpperCase() + "_SEQ'";
        this.connectionExecutor.name("\u5224\u65ad\u5e8f\u5217\u662f\u5426\u5b58\u5728").sql(sequenceExistSQL).executeQuery(resultSet -> {
            if (resultSet.next()) {
                createSequenceBuilder.append("drop sequence " + entity.tableName.toUpperCase() + "_SEQ;");
            }
        });
        createSequenceBuilder.append("create sequence " + entity.tableName + "_seq increment by 1 start with 1 minvalue 1 maxvalue 9999999999999 nocache order;");
        this.connectionExecutor.name("\u521b\u5efa\u5e8f\u5217").sql(createSequenceBuilder.toString()).executeUpdate();
        String createTrigger = "create or replace trigger " + entity.tableName + "_trigger before insert on " + this.quickDAOConfig.databaseProvider.escape(entity.tableName) + " for each row when(new.\"" + entity.id.column + "\" is null) begin select " + entity.tableName + "_seq.nextval into:new.\"" + entity.id.column + "\" from dual; end;";
        this.connectionExecutor.name("\u521b\u5efa\u89e6\u53d1\u5668").sql(createTrigger).executeUpdate();
    }
}

