/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao.ddl;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.annotation.IndexType;
import cn.schoolwow.quickdao.dao.ddl.AbstractDatabaseDefinition;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.IndexField;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PostgreDatabaseDefinition
extends AbstractDatabaseDefinition {
    public PostgreDatabaseDefinition(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
    }

    @Override
    public boolean hasTable(String tableName) {
        String hasTableSQL = "select tablename from pg_tables where schemaname = 'public' and tablename = ?;";
        return this.connectionExecutor.name("\u5224\u65ad\u8868\u662f\u5426\u5b58\u5728").sql(hasTableSQL).parameters(Arrays.asList(tableName)).executeAndCheckExists();
    }

    @Override
    public boolean hasColumn(String tableName, String columnName) {
        String hasTableColumnSQL = "select pg_class.relname as table_name, attname as column_name from pg_attribute join pg_class on pg_attribute.attrelid = pg_class.oid where attnum > 0 and atttypid > 0 and pg_class.relname = ? and attname = ?;";
        List<String> parameters = Arrays.asList(tableName, columnName);
        return this.connectionExecutor.name("\u5224\u65ad\u8868\u6307\u5b9a\u5217\u662f\u5426\u5b58\u5728").sql(hasTableColumnSQL).parameters(parameters).executeAndCheckExists();
    }

    @Override
    public List<String> getTableNameList() {
        String getEntityListSQL = "select relname as name from pg_class c where relkind = 'r' and relname not like 'pg_%' and relname not like 'sql_%' order by relname;";
        ArrayList<String> tableNames = new ArrayList<String>();
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u5217\u8868").sql(getEntityListSQL).executeQuery(resultSet -> {
            while (resultSet.next()) {
                tableNames.add(resultSet.getString("name"));
            }
        });
        return tableNames;
    }

    @Override
    public List<Entity> getDatabaseEntityList() {
        String getEntityListSQL = "select relname as name,cast(obj_description(relfilenode,'pg_class') as varchar) as comment from pg_class c where  relkind = 'r' and relname not like 'pg_%' and relname not like 'sql_%' order by relname;";
        ArrayList<Entity> entityList = new ArrayList<Entity>();
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u540d\u5217\u8868").sql(getEntityListSQL).executeQuery(resultSet -> {
            while (resultSet.next()) {
                Entity entity = new Entity();
                entity.tableName = resultSet.getString("name");
                entity.comment = resultSet.getString("comment");
                entity.properties = this.getPropertyList(entity.tableName);
                entityList.add(entity);
            }
        });
        this.getIndex(entityList);
        return entityList;
    }

    @Override
    public Entity getDatabaseEntity(String tableName) {
        Entity entity = new Entity();
        String getEntitySQL = "select relname as name,cast(obj_description(relfilenode,'pg_class') as varchar) as comment from pg_class c where relkind = 'r' and relname = ? order by relname;";
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u5217\u8868").sql(getEntitySQL).parameters(Arrays.asList(tableName)).executeQuery(resultSet -> {
            if (resultSet.next()) {
                entity.tableName = resultSet.getString("name");
                entity.comment = resultSet.getString("comment");
                entity.properties = this.getPropertyList(entity.tableName);
                entity.indexFieldList = this.getIndexField(tableName);
            }
        });
        return null == entity.tableName ? null : entity;
    }

    @Override
    public List<Property> getPropertyList(String tableName) {
        ArrayList<Property> propertyList = new ArrayList<Property>();
        String getEntityPropertyListSQL = "select pg_class.relname as table_name, attname as column_name, attnum as oridinal_position, attnotnull as notnull, format_type(atttypid,atttypmod) as type, col_description(attrelid, attnum) as comment from pg_attribute join pg_class on pg_attribute.attrelid = pg_class.oid where attnum > 0 and atttypid > 0 and pg_class.relname = ?;";
        List<String> parameters = Arrays.asList(tableName);
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u5b57\u6bb5\u4fe1\u606f").sql(getEntityPropertyListSQL).parameters(parameters).executeQuery(resultSet -> {
            while (resultSet.next()) {
                Property property = new Property();
                property.column = resultSet.getString("column_name");
                property.columnType = resultSet.getString("type");
                property.notNull = "t".equals(resultSet.getString("notnull"));
                property.comment = resultSet.getString("comment");
                propertyList.add(property);
            }
        });
        String getEntityPropertyTypeListSQL = "select table_name,ordinal_position,column_name,column_default,is_nullable,udt_name,character_maximum_length,column_default from information_schema.columns where table_name = ?;";
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u5b57\u6bb5\u7c7b\u578b\u4fe1\u606f").sql(getEntityPropertyTypeListSQL).parameters(parameters).executeQuery(resultSet -> {
            block0: while (resultSet.next()) {
                for (Property property : propertyList) {
                    if (!property.column.equalsIgnoreCase(resultSet.getString("column_name"))) continue;
                    this.getProperty((ResultSet)resultSet, property);
                    continue block0;
                }
            }
        });
        return propertyList;
    }

    @Override
    public Property getProperty(String tableName, String columnName) {
        Property property = new Property();
        String getEntityPropertyListSQL = "select pg_class.relname as table_name, attname as column_name, attnum as oridinal_position, attnotnull as notnull, format_type(atttypid,atttypmod) as type, col_description(attrelid, attnum) as comment from pg_attribute join pg_class on pg_attribute.attrelid = pg_class.oid where attnum > 0 and atttypid > 0 and pg_class.relname = ? and attname = ?;";
        List<String> parameters = Arrays.asList(tableName, columnName);
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u5b57\u6bb5\u4fe1\u606f").sql(getEntityPropertyListSQL).parameters(parameters).executeQuery(resultSet -> {
            if (resultSet.next()) {
                property.column = resultSet.getString("column_name");
                property.columnType = resultSet.getString("type");
                property.notNull = "t".equals(resultSet.getString("notnull"));
                property.comment = resultSet.getString("comment");
            }
        });
        String getEntityPropertyTypeListSQL = "select table_name, ordinal_position,column_name,column_default,is_nullable,udt_name,character_maximum_length,column_default from information_schema.columns where table_name = ? and column_name = ?;";
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u5b57\u6bb5\u7c7b\u578b\u4fe1\u606f").sql(getEntityPropertyTypeListSQL).parameters(parameters).executeQuery(resultSet -> {
            if (resultSet.next()) {
                this.getProperty((ResultSet)resultSet, property);
            }
        });
        return property;
    }

    @Override
    public void create(Entity entity) {
        StringBuilder builder = new StringBuilder();
        if (this.quickDAOConfig.databaseOption.openForeignKey && null != entity.foreignKeyProperties && entity.foreignKeyProperties.size() > 0) {
            builder.append("PRAGMA foreign_keys = ON;");
        }
        builder.append("create table " + this.quickDAOConfig.databaseProvider.escape(entity.tableName) + "(");
        for (Property property : entity.properties) {
            if (property.id && property.strategy == IdStrategy.AutoIncrement) {
                builder.append(this.getAutoIncrementSQL(property));
            } else {
                builder.append(this.quickDAOConfig.databaseProvider.escape(property.column) + " " + property.columnType + (null == property.length ? "" : "(" + property.length + ")"));
                if (null != property.defaultValue && !property.defaultValue.isEmpty()) {
                    builder.append(" default '" + property.defaultValue + "'");
                }
                if (property.notNull) {
                    builder.append(" not null");
                }
                if (null != property.comment) {
                    builder.append(" " + this.quickDAOConfig.databaseProvider.comment(property.comment));
                }
                if (null != property.escapeCheck && !property.escapeCheck.isEmpty()) {
                    builder.append(" check " + property.escapeCheck);
                }
            }
            builder.append(",");
        }
        if (this.quickDAOConfig.databaseOption.openForeignKey && null != entity.foreignKeyProperties && entity.foreignKeyProperties.size() > 0) {
            for (Property property : entity.foreignKeyProperties) {
                builder.append("foreign key(" + this.quickDAOConfig.databaseProvider.escape(property.column) + ") references ");
                String operation = property.foreignKey.foreignKeyOption().getOperation();
                builder.append(this.quickDAOConfig.databaseProvider.escape(this.quickDAOConfig.getEntityByClassName((String)property.foreignKey.table().getName()).tableName) + "(" + this.quickDAOConfig.databaseProvider.escape(property.foreignKey.field()) + ") ON DELETE " + operation + " ON UPDATE " + operation);
                builder.append(",");
            }
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(")");
        if (null != entity.comment) {
            builder.append(" " + this.quickDAOConfig.databaseProvider.comment(entity.comment));
        }
        builder.append(";");
        for (IndexField indexField : entity.indexFieldList) {
            builder.append(this.getCreateIndexStatement(indexField));
        }
        if (null != entity.comment) {
            builder.append("comment on table \"" + entity.tableName + "\" is '" + entity.comment + "';");
        }
        for (Property property : entity.properties) {
            if (property.comment == null) continue;
            builder.append("comment on column \"" + entity.tableName + "\".\"" + property.column + "\" is '" + property.comment + "';");
        }
        String createTableSQL = builder.toString();
        this.connectionExecutor.name("\u751f\u6210\u65b0\u8868").sql(createTableSQL).executeUpdate();
        this.quickDAOConfig.getDatabaseEntityByTableName(entity.tableName);
    }

    @Override
    public void alterColumn(Property property) {
        String commonSQL = "alter table " + this.quickDAOConfig.databaseProvider.escape(property.entity.tableName) + " alter column " + this.quickDAOConfig.databaseProvider.escape(property.column);
        StringBuilder alterColumnBuilder = new StringBuilder();
        alterColumnBuilder.append(commonSQL + " type " + property.columnType + (null == property.length ? "" : "(" + property.length + ")") + ";");
        if (property.notNull) {
            alterColumnBuilder.append(commonSQL + " set not null;");
        }
        if (null != property.defaultValue && !property.defaultValue.isEmpty()) {
            alterColumnBuilder.append(commonSQL + " set default " + property.defaultValue + ";");
        }
        String alterColumnSQL = alterColumnBuilder.toString();
        this.connectionExecutor.name("\u4fee\u6539\u5217").sql(alterColumnSQL).executeUpdate();
        this.quickDAOConfig.deleteDatabaseEntityCache(property.entity.tableName);
    }

    @Override
    public boolean hasIndex(String tableName, String indexName) {
        String hasIndexSQL = "select indexname from pg_indexes where tablename = ? and indexname = ?;";
        List<String> parameters = Arrays.asList(tableName, indexName);
        return this.connectionExecutor.name("\u5224\u65ad\u7d22\u5f15\u662f\u5426\u5b58\u5728").sql(hasIndexSQL).parameters(parameters).executeAndCheckExists();
    }

    @Override
    public List<IndexField> getIndexField(String tableName) {
        String getIndexSQL = "select tablename,indexname,indexdef from pg_indexes where tablename = ?;";
        ArrayList<IndexField> indexFieldList = new ArrayList<IndexField>();
        this.connectionExecutor.name("\u83b7\u53d6\u7d22\u5f15\u4fe1\u606f").sql(getIndexSQL).parameters(Arrays.asList(tableName)).executeQuery(resultSet -> {
            while (resultSet.next()) {
                IndexField indexField = this.getIndexField((ResultSet)resultSet);
                indexFieldList.add(indexField);
            }
        });
        return indexFieldList;
    }

    @Override
    public void createIndex(IndexField indexField) {
        String createIndexSQL = this.getCreateIndexStatement(indexField);
        this.connectionExecutor.name("\u521b\u5efa\u7d22\u5f15").sql(createIndexSQL).executeUpdate();
    }

    @Override
    protected String getAutoIncrementSQL(Property property) {
        return this.quickDAOConfig.databaseProvider.escape(property.column) + " SERIAL UNIQUE PRIMARY KEY";
    }

    @Override
    protected void getIndex(List<Entity> entityList) {
        String getIndexSQL = "select tablename,indexname,indexdef from pg_indexes;";
        this.connectionExecutor.name("\u83b7\u53d6\u7d22\u5f15\u4fe1\u606f").sql(getIndexSQL).executeQuery(resultSet -> {
            block0: while (resultSet.next()) {
                for (Entity entity : entityList) {
                    if (!entity.tableName.equalsIgnoreCase(resultSet.getString("tablename"))) continue;
                    IndexField indexField = this.getIndexField((ResultSet)resultSet);
                    entity.indexFieldList.add(indexField);
                    continue block0;
                }
            }
        });
    }

    @Override
    protected String getCreateIndexStatement(IndexField indexField) {
        StringBuilder createIndexBuilder = new StringBuilder("create");
        switch (indexField.indexType) {
            case NORMAL: {
                break;
            }
            case UNIQUE: {
                createIndexBuilder.append(" unique");
                break;
            }
            case FULLTEXT: {
                createIndexBuilder.append(" fulltext");
            }
        }
        createIndexBuilder.append(" index " + this.quickDAOConfig.databaseProvider.escape(indexField.indexName) + " on " + this.quickDAOConfig.databaseProvider.escape(indexField.tableName));
        if (null != indexField.using && !indexField.using.isEmpty()) {
            createIndexBuilder.append(" using " + indexField.using);
        }
        createIndexBuilder.append("(");
        for (String column : indexField.columns) {
            createIndexBuilder.append(this.quickDAOConfig.databaseProvider.escape(column) + ",");
        }
        createIndexBuilder.deleteCharAt(createIndexBuilder.length() - 1);
        createIndexBuilder.append(")");
        if (null != indexField.comment && !indexField.comment.isEmpty()) {
            createIndexBuilder.append(" " + this.quickDAOConfig.databaseProvider.comment(indexField.comment));
        }
        createIndexBuilder.append(";");
        return createIndexBuilder.toString();
    }

    private void getProperty(ResultSet resultSet, Property property) throws SQLException {
        property.columnType = resultSet.getString("udt_name");
        Object characterMaximumLength = resultSet.getObject("character_maximum_length");
        if (null != characterMaximumLength && characterMaximumLength.toString().length() < 7) {
            property.length = Integer.parseInt(characterMaximumLength.toString());
        }
        if (null != resultSet.getString("column_default")) {
            property.defaultValue = resultSet.getString("column_default");
            if (property.defaultValue.startsWith("nextval(")) {
                property.id = true;
                property.strategy = IdStrategy.AutoIncrement;
            }
        }
    }

    private IndexField getIndexField(ResultSet resultSet) throws SQLException {
        IndexField indexField = new IndexField();
        indexField.tableName = resultSet.getString("tablename");
        indexField.indexName = resultSet.getString("indexname");
        String def = resultSet.getString("indexdef");
        indexField.indexType = def.contains("UNIQUE INDEX") ? IndexType.UNIQUE : IndexType.NORMAL;
        indexField.using = def.substring(def.indexOf("USING") + "USING".length(), def.indexOf("(")).replace("\"", "");
        String[] columns = def.substring(def.indexOf("(") + 1, def.indexOf(")")).split(",");
        for (int i = 0; i < columns.length; ++i) {
            indexField.columns.add(columns[i]);
        }
        return indexField;
    }
}

