/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao.ddl;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.annotation.IndexType;
import cn.schoolwow.quickdao.dao.ddl.AbstractDatabaseDefinition;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.IndexField;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SQLServerDatabaseDefinition
extends AbstractDatabaseDefinition {
    public SQLServerDatabaseDefinition(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
    }

    @Override
    public boolean hasTable(String tableName) {
        String hasTableSQL = "select name from sysobjects where xtype='u' and name = ?;";
        return this.connectionExecutor.name("\u5224\u65ad\u8868\u662f\u5426\u5b58\u5728").sql(hasTableSQL).parameters(Arrays.asList(tableName)).executeAndCheckExists();
    }

    @Override
    public boolean hasColumn(String tableName, String columnName) {
        String hasTableColumnSQL = "select table_name, column_name from information_schema.columns where table_name = ? and column_name = ?;";
        List<String> parameters = Arrays.asList(tableName, columnName);
        return this.connectionExecutor.name("\u5224\u65ad\u8868\u6307\u5b9a\u5217\u662f\u5426\u5b58\u5728").sql(hasTableColumnSQL).parameters(parameters).executeAndCheckExists();
    }

    @Override
    public List<String> getTableNameList() {
        String getEntityListSQL = "select name from sysobjects where xtype='u' order by name;";
        ArrayList<String> tableNames = new ArrayList<String>();
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u540d\u5217\u8868").sql(getEntityListSQL).executeQuery(resultSet -> {
            while (resultSet.next()) {
                tableNames.add(resultSet.getString("name"));
            }
        });
        return tableNames;
    }

    @Override
    public List<Entity> getDatabaseEntityList() {
        String getEntityListSQL = "select name from sysobjects where xtype='u' order by name;";
        ArrayList<Entity> entityList = new ArrayList<Entity>();
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u5217\u8868").sql(getEntityListSQL).executeQuery(resultSet -> {
            while (resultSet.next()) {
                Entity entity = new Entity();
                entity.tableName = resultSet.getString("name");
                entity.properties = this.getPropertyList(entity.tableName);
                entityList.add(entity);
            }
        });
        String getEntityCommentSQL = "select so.name table_name, isnull(convert(varchar(255),value),'') comment from sys.extended_properties ex_p left join sys.sysobjects so on ex_p.major_id = so.id where ex_p.minor_id=0;";
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u6ce8\u91ca").sql(getEntityCommentSQL).executeQuery(resultSet -> {
            block0: while (resultSet.next()) {
                for (Entity entity : entityList) {
                    if (!entity.tableName.equalsIgnoreCase(resultSet.getString("table_name"))) continue;
                    entity.comment = resultSet.getString("comment");
                    continue block0;
                }
            }
        });
        this.getIndex(entityList);
        return entityList;
    }

    @Override
    public Entity getDatabaseEntity(String tableName) {
        Entity entity = new Entity();
        String getEntityListSQL = "select name from sysobjects where xtype='u' and name = ? order by name;";
        List<String> parameters = Arrays.asList(tableName);
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u5217\u8868").sql(getEntityListSQL).parameters(parameters).executeQuery(resultSet -> {
            if (resultSet.next()) {
                entity.tableName = resultSet.getString("name");
                entity.properties = this.getPropertyList(entity.tableName);
            }
        });
        if (null != entity.tableName) {
            String getEntityCommentSQL = "select so.name table_name, isnull(convert(varchar(255),value),'') comment from sys.extended_properties ex_p left join sys.sysobjects so on ex_p.major_id = so.id where ex_p.minor_id=0 and so.name = ?;";
            this.connectionExecutor.name("\u83b7\u53d6\u8868\u6ce8\u91ca").sql(getEntityCommentSQL).parameters(parameters).executeQuery(resultSet -> {
                if (resultSet.next()) {
                    entity.comment = resultSet.getString("comment");
                }
            });
        }
        if (null != entity.tableName) {
            entity.indexFieldList = this.getIndexField(tableName);
        }
        if (null == entity.tableName) {
            return null;
        }
        return entity;
    }

    @Override
    public List<Property> getPropertyList(String tableName) {
        String getEntityPropertyTypeListSQL = "select table_name,ordinal_position,column_name,data_type,is_nullable,character_maximum_length from information_schema.columns where table_name = ?;";
        List<String> parameters = Arrays.asList(tableName);
        ArrayList<Property> properties = new ArrayList<Property>();
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u5b57\u6bb5\u7c7b\u578b\u4fe1\u606f").sql(getEntityPropertyTypeListSQL).parameters(parameters).executeQuery(resultSet -> {
            while (resultSet.next()) {
                Property property = new Property();
                property.column = resultSet.getString("column_name");
                property.columnType = resultSet.getString("data_type");
                try {
                    String characterMaximumLength = resultSet.getString("character_maximum_length");
                    property.length = Integer.parseInt(characterMaximumLength);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                property.notNull = "NO".equals(resultSet.getString("is_nullable"));
                properties.add(property);
            }
        });
        String getPropertyCommentList = "select b.name table_name, c.name, convert(varchar(255),a.value) value from sys.extended_properties a, sysobjects b, sys.columns c where a.major_id = b.id and c.object_id = b.id and c.column_id = a.minor_id and b.name = ?;";
        this.connectionExecutor.name("\u83b7\u53d6\u5b57\u6bb5\u6ce8\u91ca").sql(getPropertyCommentList).parameters(parameters).executeQuery(resultSet -> {
            block0: while (resultSet.next()) {
                for (Property property : properties) {
                    if (!property.column.equalsIgnoreCase(resultSet.getString("name"))) continue;
                    property.comment = resultSet.getString("value");
                    continue block0;
                }
            }
        });
        String getPrimaryKeyColumn = "select column_name from information_schema.key_column_usage where table_name = ?;";
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u4e3b\u952e").sql(getPrimaryKeyColumn).parameters(parameters).executeQuery(resultSet -> {
            if (resultSet.next()) {
                for (Property property : properties) {
                    if (!property.column.equalsIgnoreCase(resultSet.getString("column_name"))) continue;
                    property.id = true;
                    property.strategy = IdStrategy.AutoIncrement;
                    break;
                }
            }
        });
        return properties;
    }

    @Override
    public Property getProperty(String tableName, String columnName) {
        Property property = new Property();
        String getEntityPropertyTypeListSQL = "select table_name,ordinal_position,column_name,data_type,is_nullable,character_maximum_length from information_schema.columns where table_name = ? and column_name = ?;";
        List<String> parameters = Arrays.asList(tableName, columnName);
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u5b57\u6bb5\u7c7b\u578b\u4fe1\u606f").sql(getEntityPropertyTypeListSQL).parameters(parameters).executeQuery(resultSet -> {
            if (resultSet.next()) {
                property.column = resultSet.getString("column_name");
                property.columnType = resultSet.getString("data_type");
                try {
                    String characterMaximumLength = resultSet.getString("character_maximum_length");
                    property.length = Integer.parseInt(characterMaximumLength);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                property.notNull = "NO".equals(resultSet.getString("is_nullable"));
            }
        });
        String getPropertyCommentList = "select b.name table_name, c.name, convert(varchar(255),a.value) value from sys.extended_properties a, sysobjects b, sys.columns c where a.major_id = b.id and c.object_id = b.id and c.column_id = a.minor_id and b.name = ? and c.name = ?;";
        this.connectionExecutor.name("\u83b7\u53d6\u5b57\u6bb5\u6ce8\u91ca").sql(getPropertyCommentList).parameters(parameters).executeQuery(resultSet -> {
            if (resultSet.next()) {
                property.comment = resultSet.getString("value");
            }
        });
        String getPrimaryKeyColumn = "select column_name from information_schema.key_column_usage where table_name = ?;";
        this.connectionExecutor.name("\u83b7\u53d6\u8868\u4e3b\u952e").sql(getPrimaryKeyColumn).parameters(Arrays.asList(tableName)).executeQuery(resultSet -> {
            if (resultSet.next() && property.column.equalsIgnoreCase(resultSet.getString("column_name"))) {
                property.id = true;
                property.strategy = IdStrategy.AutoIncrement;
            }
        });
        return null == property.column ? null : property;
    }

    @Override
    public void create(Entity entity) {
        StringBuilder createTableBuilder = new StringBuilder("create table " + this.quickDAOConfig.databaseProvider.escape(entity.tableName) + "(");
        for (Property property : entity.properties) {
            if (property.id && property.strategy == IdStrategy.AutoIncrement) {
                createTableBuilder.append(this.getAutoIncrementSQL(property));
            } else {
                createTableBuilder.append(this.quickDAOConfig.databaseProvider.escape(property.column) + " " + property.columnType + (null == property.length ? "" : "(" + property.length + ")"));
                if (property.notNull) {
                    createTableBuilder.append(" not null");
                }
                if (null != property.defaultValue) {
                    createTableBuilder.append(" default '" + property.defaultValue + "'");
                }
                if (null != property.comment) {
                    createTableBuilder.append(" " + this.quickDAOConfig.databaseProvider.comment(property.comment));
                }
                if (null != property.escapeCheck && !property.escapeCheck.isEmpty()) {
                    createTableBuilder.append(" check " + property.escapeCheck);
                }
            }
            createTableBuilder.append(",");
        }
        if (this.quickDAOConfig.databaseOption.openForeignKey && null != entity.foreignKeyProperties && entity.foreignKeyProperties.size() > 0) {
            for (Property property : entity.foreignKeyProperties) {
                createTableBuilder.append("foreign key(" + this.quickDAOConfig.databaseProvider.escape(property.column) + ") references ");
                String operation = property.foreignKey.foreignKeyOption().getOperation();
                createTableBuilder.append(this.quickDAOConfig.databaseProvider.escape(this.quickDAOConfig.getEntityByClassName((String)property.foreignKey.table().getName()).tableName) + "(" + this.quickDAOConfig.databaseProvider.escape(property.foreignKey.field()) + ") ON DELETE " + operation + " ON UPDATE " + operation);
                createTableBuilder.append(",");
            }
        }
        createTableBuilder.deleteCharAt(createTableBuilder.length() - 1);
        createTableBuilder.append(");");
        if (null != entity.comment) {
            createTableBuilder.append("EXEC sp_addextendedproperty 'MS_Description',N'" + entity.comment + "','SCHEMA','dbo','table',N'" + entity.tableName + "';");
        }
        for (Property property : entity.properties) {
            if (null == property.comment) continue;
            createTableBuilder.append("EXEC sp_addextendedproperty 'MS_Description',N'" + property.comment + "','SCHEMA','dbo','table',N'" + entity.tableName + "','column',N'" + property.column + "';");
        }
        for (IndexField indexField : entity.indexFieldList) {
            createTableBuilder.append(this.getCreateIndexStatement(indexField));
        }
        createTableBuilder.append(";");
        String createTableSQL = createTableBuilder.toString();
        this.connectionExecutor.name("\u751f\u6210\u65b0\u8868").sql(createTableSQL).executeUpdate();
        this.quickDAOConfig.getDatabaseEntityByTableName(entity.tableName);
    }

    @Override
    public boolean hasIndex(String tableName, String indexName) {
        String hasIndexSQL = "select name from sys.indexes WHERE object_id=OBJECT_ID(?, N'U') and name = ?;";
        List<String> parameters = Arrays.asList(tableName, indexName);
        return this.connectionExecutor.name("\u5224\u65ad\u7d22\u5f15\u662f\u5426\u5b58\u5728").sql(hasIndexSQL).parameters(parameters).executeAndCheckExists();
    }

    @Override
    public List<IndexField> getIndexField(String tableName) {
        String getIndexSQL = "select i.is_unique,i.name,col.name col_name from sys.indexes i left join sys.index_columns ic on ic.object_id = i.object_id and ic.index_id = i.index_id left join (select * from sys.all_columns where object_id = object_id(?, N'U' )) col on ic.column_id = col.column_id where i.object_id = object_id(?, N'U' ) and i.index_id > 0;";
        List<String> parameters = Arrays.asList(tableName, tableName);
        ArrayList<IndexField> indexFieldList = new ArrayList<IndexField>();
        this.connectionExecutor.name("\u83b7\u53d6\u7d22\u5f15\u4fe1\u606f").sql(getIndexSQL).parameters(parameters).executeQuery(resultSet -> {
            while (resultSet.next()) {
                IndexField indexField = new IndexField();
                indexField.indexType = resultSet.getBoolean("is_unique") ? IndexType.UNIQUE : IndexType.NORMAL;
                indexField.indexName = resultSet.getString("name");
                IndexField existIndexField = indexFieldList.stream().filter(indexField1 -> indexField1.indexName.equals(indexField.indexName)).findFirst().orElse(null);
                if (null != existIndexField) {
                    existIndexField.columns.add(resultSet.getNString("col_name"));
                    continue;
                }
                indexField.columns.add(resultSet.getNString("col_name"));
                indexFieldList.add(indexField);
            }
        });
        return indexFieldList;
    }

    @Override
    public void dropIndex(String tableName, String indexName) {
        String dropIndexSQL = "drop index " + this.quickDAOConfig.databaseProvider.escape(tableName) + "." + this.quickDAOConfig.databaseProvider.escape(indexName) + ";";
        this.connectionExecutor.name("\u5220\u9664\u7d22\u5f15").sql(dropIndexSQL).executeUpdate();
    }

    @Override
    protected String getAutoIncrementSQL(Property property) {
        return property.column + " " + property.columnType + (null == property.length ? "" : "(" + property.length + ")") + " identity(1,1) unique ";
    }

    @Override
    protected void getIndex(List<Entity> entityList) {
        for (Entity entity : entityList) {
            String getIndexSQL = "select i.is_unique,i.name,col.name col_name from sys.indexes i left join sys.index_columns ic on ic.object_id = i.object_id and ic.index_id = i.index_id left join (select * from sys.all_columns where object_id = object_id( '" + entity.tableName + "', N'U' )) col on ic.column_id = col.column_id where i.object_id = object_id('" + entity.tableName + "', N'U' ) and i.index_id > 0;";
            this.connectionExecutor.name("\u83b7\u53d6\u7d22\u5f15\u4fe1\u606f").sql(getIndexSQL).executeQuery(resultSet -> {
                while (resultSet.next()) {
                    IndexField indexField = new IndexField();
                    indexField.indexType = resultSet.getBoolean("is_unique") ? IndexType.UNIQUE : IndexType.NORMAL;
                    indexField.indexName = resultSet.getString("name");
                    IndexField existIndexField = entity.indexFieldList.stream().filter(indexField1 -> indexField1.indexName.equals(indexField.indexName)).findFirst().orElse(null);
                    if (null != existIndexField) {
                        existIndexField.columns.add(resultSet.getNString("col_name"));
                        continue;
                    }
                    indexField.columns.add(resultSet.getNString("col_name"));
                    entity.indexFieldList.add(indexField);
                }
            });
        }
    }
}

