/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao.dql.condition;

import cn.schoolwow.quickdao.dao.dql.condition.Condition;
import cn.schoolwow.quickdao.dao.dql.condition.LambdaCondition;
import cn.schoolwow.quickdao.dao.dql.condition.LambdaConditionInvocationHandler;
import cn.schoolwow.quickdao.dao.dql.response.AbstractResponse;
import cn.schoolwow.quickdao.dao.dql.response.OracleResponse;
import cn.schoolwow.quickdao.dao.dql.response.Response;
import cn.schoolwow.quickdao.dao.dql.subCondition.AbstractSubCondition;
import cn.schoolwow.quickdao.dao.dql.subCondition.SubCondition;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.PageVo;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.domain.external.UnionType;
import cn.schoolwow.quickdao.domain.internal.FieldFragmentEntry;
import cn.schoolwow.quickdao.domain.internal.Query;
import cn.schoolwow.quickdao.domain.internal.SubQuery;
import cn.schoolwow.quickdao.statement.dql.response.GetResponseArrayDatabaseStatement;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class AbstractCondition<T>
implements Condition<T>,
Serializable,
Cloneable {
    private static final transient String IGNORE = "##IGNORE##";
    private static final transient String OR = "##OR##";
    protected List<String> columnList = new ArrayList<String>();
    protected List<String> excludeColumnList = new ArrayList<String>();
    protected List<FieldFragmentEntry> whereList = new ArrayList<FieldFragmentEntry>();
    protected List<String> groupByList = new ArrayList<String>();
    protected List<FieldFragmentEntry> havingList = new ArrayList<FieldFragmentEntry>();
    protected List<FieldFragmentEntry> orderByList = new ArrayList<FieldFragmentEntry>();
    private StringBuilder builder = new StringBuilder();
    public transient Query query;
    private boolean hasExecute;

    public AbstractCondition(Query query) {
        this.query = query;
    }

    @Override
    public Condition<T> tableAliasName(String tableAliasName) {
        this.query.tableAliasName = tableAliasName;
        return this;
    }

    @Override
    public Condition<T> distinct() {
        this.query.distinct = "distinct";
        return this;
    }

    @Override
    public Condition<T> addNullQuery(String field) {
        this.whereList.add(new FieldFragmentEntry(field, "{} is null"));
        return this;
    }

    @Override
    public Condition<T> addNotNullQuery(String field) {
        this.whereList.add(new FieldFragmentEntry(field, "{} is not null"));
        return this;
    }

    @Override
    public Condition<T> addEmptyQuery(String field) {
        this.whereList.add(new FieldFragmentEntry(field, "{} is not null and {} = ''"));
        return this;
    }

    @Override
    public Condition<T> addNotEmptyQuery(String field) {
        this.whereList.add(new FieldFragmentEntry(field, "{} is not null and {} != ''"));
        return this;
    }

    @Override
    public Condition<T> addInQuery(String field, String inQuery) {
        if (null == inQuery || inQuery.isEmpty()) {
            this.whereList.add(new FieldFragmentEntry(field, "1 = 2"));
            return this;
        }
        this.whereList.add(new FieldFragmentEntry(field, "{} in (" + inQuery + ")"));
        return this;
    }

    @Override
    public Condition<T> addInQuery(String field, Object ... values) {
        this.addInQuery(field, values, "in");
        return this;
    }

    @Override
    public Condition<T> addInQuery(String field, Collection values) {
        return this.addInQuery(field, values.toArray(new Object[0]));
    }

    @Override
    public Condition<T> addNotInQuery(String field, String inQuery) {
        if (null == inQuery || inQuery.isEmpty()) {
            this.whereList.add(new FieldFragmentEntry(field, "1 = 2"));
            return this;
        }
        this.whereList.add(new FieldFragmentEntry(field, "{} not in (" + inQuery + ")"));
        return this;
    }

    @Override
    public Condition<T> addNotInQuery(String field, Object ... values) {
        this.addInQuery(field, values, "not in");
        return this;
    }

    @Override
    public Condition<T> addNotInQuery(String field, Collection values) {
        return this.addNotInQuery(field, values.toArray(new Object[0]));
    }

    @Override
    public Condition<T> addBetweenQuery(String field, Object start, Object end) {
        this.whereList.add(new FieldFragmentEntry(field, "{} between ? and ?"));
        this.query.parameterList.add(start);
        this.query.parameterList.add(end);
        return this;
    }

    @Override
    public Condition<T> addLikeQuery(String field, Object value) {
        if (value == null || value.toString().equals("")) {
            return this;
        }
        this.whereList.add(new FieldFragmentEntry(field, "{} like ?"));
        this.query.parameterList.add(value);
        return this;
    }

    @Override
    public Condition<T> addNotLikeQuery(String field, Object value) {
        if (value == null || value.toString().equals("")) {
            return this;
        }
        this.whereList.add(new FieldFragmentEntry(field, "{} not like ?"));
        this.query.parameterList.add(value);
        return this;
    }

    @Override
    public Condition<T> addQuery(String field, Object value) {
        this.addQuery(field, "=", value);
        return this;
    }

    @Override
    public Condition<T> addQuery(String field, String operator, Object value) {
        if (null == value) {
            this.addNullQuery(field);
        } else if (value.toString().isEmpty()) {
            this.addEmptyQuery(field);
        } else {
            Property property = this.query.entity.getPropertyByFieldName(field);
            this.whereList.add(new FieldFragmentEntry(field, "{} " + operator + " " + (null == property || null == property.function ? "?" : property.function)));
            this.query.parameterList.add(value);
        }
        return this;
    }

    @Override
    public Condition<T> addIntervalQuery(String field, String value) {
        if (!value.contains(",")) {
            return this;
        }
        Long priceStart = Long.parseLong(value.substring(1, value.indexOf(",")));
        Long priceEnd = Long.parseLong(value.substring(value.indexOf(",") + 1, value.length() - 1));
        if (priceEnd < priceStart) {
            throw new IllegalArgumentException("\u5f00\u95ed\u533a\u95f4\u4e0d\u5408\u6cd5!\u8bf7\u68c0\u67e5!\u5f00\u95ed\u533a\u95f4\u503c:" + value);
        }
        switch (value.charAt(0)) {
            case '(': {
                this.addQuery(field, ">", priceStart);
                break;
            }
            case '[': {
                this.addQuery(field, ">=", priceStart);
                break;
            }
            default: {
                throw new IllegalArgumentException("\u5f00\u95ed\u533a\u95f4\u5f00\u59cb\u503c\u5fc5\u987b\u4e3a'('\u6216\u8005'['!\u5f53\u524d\u503c:" + value.charAt(0));
            }
        }
        switch (value.charAt(value.length() - 1)) {
            case ')': {
                this.addQuery(field, "<", priceEnd);
                break;
            }
            case ']': {
                this.addQuery(field, "<=", priceEnd);
                break;
            }
            default: {
                throw new IllegalArgumentException("\u5f00\u95ed\u533a\u95f4\u7ed3\u675f\u503c\u5fc5\u987b\u4e3a')'\u6216\u8005']'!\u5f53\u524d\u503c:" + value.charAt(value.length() - 1));
            }
        }
        return this;
    }

    @Override
    public Condition<T> addRawQuery(String query, Object ... parameterList) {
        this.whereList.add(new FieldFragmentEntry(IGNORE, query));
        if (null != parameterList && parameterList.length > 0) {
            this.query.parameterList.addAll(Arrays.asList(parameterList));
        }
        return this;
    }

    @Override
    public Condition<T> addSubQuery(String field, String operator, Condition subQuery) {
        AbstractCondition abstractCondition = (AbstractCondition)subQuery;
        if (null == abstractCondition.query.tableAliasName) {
            subQuery.tableAliasName("t" + this.query.joinTableIndex++);
        }
        subQuery.execute();
        this.whereList.add(new FieldFragmentEntry(field, " {} " + operator + " (" + new GetResponseArrayDatabaseStatement(abstractCondition.query).getStatement() + ")"));
        this.query.parameterList.addAll(abstractCondition.query.parameterList);
        return this;
    }

    @Override
    public Condition<T> addExistSubQuery(Condition subQuery) {
        this.addExistSubQuery(subQuery, "exists");
        return this;
    }

    @Override
    public Condition<T> addNotExistSubQuery(Condition subQuery) {
        this.addExistSubQuery(subQuery, "not exists");
        return this;
    }

    @Override
    public Condition<T> addColumn(String ... fields) {
        for (String field : fields) {
            this.columnList.add(field);
        }
        return this;
    }

    @Override
    public Condition<T> addTableColumn() {
        for (Property property : this.query.entity.properties) {
            if (null == property.name || property.name.isEmpty()) {
                this.columnList.add(property.column);
                continue;
            }
            this.columnList.add(property.column + " " + property.name);
        }
        return this;
    }

    @Override
    public Condition<T> addExcludeColumn(String ... excludeFields) {
        for (String excludeField : excludeFields) {
            this.excludeColumnList.add(excludeField);
        }
        return this;
    }

    @Override
    public Condition<T> setColumnTypeMapping(Function<Property, Class> queryColumnTypeMapping) {
        this.query.columnTypeMapping = queryColumnTypeMapping;
        return this;
    }

    @Override
    public Condition<T> addColumn(Condition subQuery) {
        subQuery.execute();
        Query selectQuery = ((AbstractCondition)subQuery).query;
        this.columnList.add("( " + new GetResponseArrayDatabaseStatement(selectQuery).getStatement() + ")");
        this.query.parameterList.addAll(selectQuery.parameterList);
        return this;
    }

    @Override
    public Condition<T> addColumn(Condition subQuery, String columnNameAlias) {
        subQuery.execute();
        Query selectQuery = ((AbstractCondition)subQuery).query;
        if (null == selectQuery.tableAliasName) {
            subQuery.tableAliasName("t" + this.query.joinTableIndex++);
        }
        this.columnList.add("( " + new GetResponseArrayDatabaseStatement(selectQuery).getStatement() + ") " + columnNameAlias);
        this.query.selectQueryList.add(selectQuery);
        return this;
    }

    @Override
    public Condition<T> addUpdate(String field, Object value) {
        Property property = this.query.entity.getPropertyByFieldName(field);
        this.query.setBuilder.append(this.query.quickDAOConfig.databaseProvider.escape(null == property ? field : property.column) + " = ");
        if (null == property || null == property.function) {
            this.query.setBuilder.append("?");
        } else {
            this.query.setBuilder.append(property.function);
        }
        this.query.setBuilder.append(",");
        this.query.updateParameterList.add(value);
        return this;
    }

    @Override
    public Condition<T> addRawUpdate(String update, Object ... parameterList) {
        this.query.setBuilder.append(update);
        if (!update.endsWith(",")) {
            this.query.setBuilder.append(",");
        }
        this.query.updateParameterList.addAll(Arrays.asList(parameterList));
        return this;
    }

    @Override
    public Condition<T> union(Condition<T> condition) {
        return this.union(condition, UnionType.Union);
    }

    @Override
    public Condition<T> union(Condition<T> condition, UnionType unionType) {
        AbstractCondition abstractCondition = (AbstractCondition)condition;
        abstractCondition.query.unionType = unionType;
        this.query.unionList.add(abstractCondition);
        return this;
    }

    @Override
    public Condition<T> or() {
        AbstractCondition orCondition = null;
        orCondition = JSONObject.class.getName().equalsIgnoreCase(this.query.entity.clazz.getName()) ? (AbstractCondition)this.query.quickDAOConfig.dao.query(this.query.entity.tableName) : (AbstractCondition)this.query.quickDAOConfig.dao.query(this.query.entity.clazz);
        orCondition.tableAliasName(this.query.tableAliasName);
        orCondition.query.or = true;
        this.query.orList.add(orCondition);
        return orCondition;
    }

    @Override
    public Condition<T> or(String or, Object ... parameterList) {
        this.whereList.add(new FieldFragmentEntry(OR, or));
        if (null != parameterList && parameterList.length > 0) {
            this.query.parameterList.addAll(Arrays.asList(parameterList));
        }
        return this;
    }

    @Override
    public Condition<T> groupBy(String ... fields) {
        this.groupByList.addAll(Arrays.asList(fields));
        return this;
    }

    @Override
    public Condition<T> having(String having, Object ... parameterList) {
        this.havingList.add(new FieldFragmentEntry(IGNORE, having));
        if (null != parameterList && parameterList.length > 0) {
            this.query.havingParameterList.addAll(Arrays.asList(parameterList));
        }
        return this;
    }

    @Override
    public Condition<T> having(String field, String operator, Condition subQuery) {
        AbstractCondition abstractCondition = (AbstractCondition)subQuery;
        if (null == abstractCondition.query.tableAliasName) {
            subQuery.tableAliasName("t" + this.query.joinTableIndex++);
        }
        subQuery.execute();
        this.query.parameterList.addAll(abstractCondition.query.parameterList);
        this.havingList.add(new FieldFragmentEntry(field, "{}" + operator + " (" + new GetResponseArrayDatabaseStatement(abstractCondition.query).getStatement() + ")"));
        return this;
    }

    @Override
    public <E> SubCondition<E, T> crossJoinTable(Class<E> clazz) {
        AbstractSubCondition subCondition;
        this.checkOrCondition();
        SubQuery subQuery = new SubQuery();
        subQuery.entity = this.query.quickDAOConfig.getEntityByClassName(clazz.getName());
        subQuery.join = "cross join";
        subQuery.query = this.query;
        subQuery.condition = this;
        subQuery.subCondition = subCondition = (AbstractSubCondition)this.query.quickDAOConfig.databaseProvider.getSubConditionInstance(subQuery);
        this.query.subQueryList.add(subQuery);
        return subCondition;
    }

    @Override
    public SubCondition<?, T> crossJoinTable(String tableName) {
        AbstractSubCondition subCondition;
        Entity dbEntity;
        this.checkOrCondition();
        SubQuery subQuery = new SubQuery();
        subQuery.entity = dbEntity = this.query.quickDAOConfig.getDatabaseEntityByTableName(tableName);
        if (null == subQuery.entity) {
            throw new IllegalArgumentException("\u5173\u8054\u8868\u4e0d\u5b58\u5728!\u8868\u540d:" + tableName);
        }
        subQuery.join = "cross join";
        subQuery.query = this.query;
        subQuery.condition = this;
        subQuery.subCondition = subCondition = (AbstractSubCondition)this.query.quickDAOConfig.databaseProvider.getSubConditionInstance(subQuery);
        this.query.subQueryList.add(subQuery);
        return subCondition;
    }

    @Override
    public <E> SubCondition<E, T> joinTable(Class<E> clazz, String primaryField, String joinTableField) {
        return this.joinTable(clazz, primaryField, joinTableField, this.query.entity.getCompositeFieldName(clazz.getName()));
    }

    @Override
    public <E> SubCondition<E, T> joinTable(Class<E> clazz, String primaryField, String joinTableField, String compositField) {
        AbstractSubCondition subCondition;
        this.checkOrCondition();
        SubQuery subQuery = new SubQuery();
        subQuery.entity = this.query.quickDAOConfig.getEntityByClassName(clazz.getName());
        if (null == subQuery.entity) {
            throw new IllegalArgumentException("\u672a\u626b\u63cf\u6307\u5b9a\u7c7b\u4fe1\u606f!\u7c7b\u540d:" + clazz.getName());
        }
        subQuery.primaryField = this.query.entity.getColumnNameByFieldName(primaryField);
        subQuery.joinTableField = subQuery.entity.getColumnNameByFieldName(joinTableField);
        subQuery.compositField = compositField;
        subQuery.query = this.query;
        subQuery.condition = this;
        subQuery.subCondition = subCondition = (AbstractSubCondition)this.query.quickDAOConfig.databaseProvider.getSubConditionInstance(subQuery);
        this.query.subQueryList.add(subQuery);
        return subCondition;
    }

    @Override
    public <E> SubCondition<E, T> joinTable(Condition<E> joinCondition, String primaryField, String joinConditionField) {
        AbstractSubCondition subCondition;
        this.checkOrCondition();
        joinCondition.execute();
        Query joinQuery = ((AbstractCondition)joinCondition).query;
        SubQuery subQuery = new SubQuery();
        subQuery.entity = joinQuery.entity;
        subQuery.subQuerySQLBuilder = new StringBuilder(new GetResponseArrayDatabaseStatement(joinQuery).getStatement());
        subQuery.primaryField = this.query.entity.getColumnNameByFieldName(primaryField);
        subQuery.joinTableField = joinConditionField;
        subQuery.subQuery = joinQuery;
        subQuery.condition = this;
        subQuery.query = this.query;
        subQuery.subCondition = subCondition = (AbstractSubCondition)this.query.quickDAOConfig.databaseProvider.getSubConditionInstance(subQuery);
        this.query.subQueryList.add(subQuery);
        return subCondition;
    }

    @Override
    public SubCondition<?, T> joinTable(String tableName, String primaryField, String joinTableField) {
        AbstractSubCondition subCondition;
        Entity dbEntity;
        this.checkOrCondition();
        SubQuery subQuery = new SubQuery();
        subQuery.entity = dbEntity = this.query.quickDAOConfig.getDatabaseEntityByTableName(tableName);
        if (null == subQuery.entity) {
            throw new IllegalArgumentException("\u5173\u8054\u8868\u4e0d\u5b58\u5728!\u8868\u540d:" + tableName);
        }
        subQuery.primaryField = this.query.entity.getColumnNameByFieldName(primaryField);
        subQuery.joinTableField = joinTableField;
        subQuery.query = this.query;
        subQuery.condition = this;
        subQuery.subCondition = subCondition = (AbstractSubCondition)this.query.quickDAOConfig.databaseProvider.getSubConditionInstance(subQuery);
        this.query.subQueryList.add(subQuery);
        return subCondition;
    }

    @Override
    public Condition<T> order(String field, String asc) {
        this.orderByList.add(new FieldFragmentEntry(field, "{} " + asc));
        return this;
    }

    @Override
    public Condition<T> orderBy(String ... fields) {
        for (String field : fields) {
            this.orderByList.add(new FieldFragmentEntry(field, "{} asc"));
        }
        return this;
    }

    @Override
    public Condition<T> orderByDesc(String ... fields) {
        for (String field : fields) {
            this.orderByList.add(new FieldFragmentEntry(field, "{} desc"));
        }
        return this;
    }

    @Override
    public Condition<T> orderByRaw(String orderBy) {
        this.orderByList.add(new FieldFragmentEntry(IGNORE, orderBy));
        return this;
    }

    @Override
    public Condition<T> limit(long offset, long limit) {
        this.query.limit = "limit " + offset + "," + limit;
        return this;
    }

    @Override
    public Condition<T> page(int pageNum, int pageSize) {
        this.query.limit = "limit " + (pageNum - 1) * pageSize + "," + pageSize;
        this.query.pageVo = new PageVo();
        this.query.pageVo.setPageSize(pageSize);
        this.query.pageVo.setCurrentPage(pageNum);
        return this;
    }

    @Override
    public Condition<T> compositeField() {
        this.query.compositField = true;
        return this;
    }

    @Override
    public Condition<T> perBatchCommit(int perBatchCommit) {
        this.query.perBatchCommit = perBatchCommit;
        return this;
    }

    @Override
    public LambdaCondition<T> lambdaCondition() {
        LambdaConditionInvocationHandler invocationHandler = new LambdaConditionInvocationHandler(this);
        LambdaCondition lambdaCondition = (LambdaCondition)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{LambdaCondition.class}, invocationHandler);
        return lambdaCondition;
    }

    @Override
    public Response<T> execute() {
        if (this.hasExecute) {
            throw new IllegalArgumentException("\u8be5Condition\u5df2\u7ecf\u6267\u884c\u8fc7,\u4e0d\u80fd\u518d\u6b21\u6267\u884c!");
        }
        if (null == this.query.tableAliasName) {
            this.query.tableAliasName = "t";
        }
        this.handleExcludeColumnList(this.excludeColumnList, this.query.entity.properties, this.columnList);
        StringBuilder columnBuilder = new StringBuilder();
        StringBuilder whereBuilder = new StringBuilder();
        StringBuilder groupByBuilder = new StringBuilder();
        StringBuilder havingBuilder = new StringBuilder();
        StringBuilder orderByBuilder = new StringBuilder();
        columnBuilder.append(this.getSQLFragment(this.columnList, this.query.entity, this.query.tableAliasName));
        whereBuilder.append(this.getSQLFragment(this.whereList, this.query.entity, this.query.tableAliasName, " and "));
        groupByBuilder.append(this.getSQLFragment(this.groupByList, this.query.entity, this.query.tableAliasName));
        havingBuilder.append(this.getSQLFragment(this.havingList, this.query.entity, this.query.tableAliasName, " and "));
        orderByBuilder.append(this.getSQLFragment(this.orderByList, this.query.entity, this.query.tableAliasName, ","));
        for (SubQuery subQuery : this.query.subQueryList) {
            if (!this.query.compositField) {
                this.handleExcludeColumnList(subQuery.subCondition.excludeColumnList, subQuery.entity.properties, subQuery.subCondition.columnList);
            }
            if (null == subQuery.tableAliasName) {
                subQuery.tableAliasName = "t" + this.query.joinTableIndex++;
            }
            columnBuilder.append(this.getSQLFragment(subQuery.subCondition.columnList, subQuery.entity, subQuery.tableAliasName));
            whereBuilder.append(this.getSQLFragment(subQuery.subCondition.whereList, subQuery.entity, subQuery.tableAliasName, " and "));
            this.query.parameterList.addAll(subQuery.parameterList);
            groupByBuilder.append(this.getSQLFragment(subQuery.subCondition.groupByList, subQuery.entity, subQuery.tableAliasName));
            orderByBuilder.append(this.getSQLFragment(subQuery.subCondition.orderByList, subQuery.entity, subQuery.tableAliasName, ","));
        }
        for (AbstractCondition orCondition : this.query.orList) {
            orCondition.execute();
            if (whereBuilder.charAt(whereBuilder.length() - 2) == 'd') {
                whereBuilder.delete(whereBuilder.length() - 5, whereBuilder.length());
                whereBuilder.append(" or ");
            }
            whereBuilder.append(this.getSQLFragment(orCondition.whereList, orCondition.query.entity, orCondition.query.tableAliasName, " or "));
            this.query.parameterList.addAll(orCondition.query.parameterList);
        }
        if (this.query.setBuilder.length() > 0) {
            this.query.setBuilder.deleteCharAt(this.query.setBuilder.length() - 1);
            this.query.setBuilder.insert(0, "set ");
        }
        if (this.query.insertBuilder.length() > 0) {
            this.query.insertBuilder.deleteCharAt(this.query.insertBuilder.length() - 1);
        }
        if (columnBuilder.length() > 0) {
            columnBuilder.deleteCharAt(columnBuilder.length() - 1);
            this.query.column = columnBuilder.toString();
        }
        if (whereBuilder.length() > 0) {
            char ch = whereBuilder.charAt(whereBuilder.length() - 2);
            if (ch == 'r') {
                whereBuilder.delete(whereBuilder.length() - 4, whereBuilder.length());
            } else if (ch == 'd') {
                whereBuilder.delete(whereBuilder.length() - 5, whereBuilder.length());
            }
            whereBuilder.insert(0, "where ");
            this.query.where = whereBuilder.toString();
        }
        if (groupByBuilder.length() > 0) {
            groupByBuilder.deleteCharAt(groupByBuilder.length() - 1);
            groupByBuilder.insert(0, "group by ");
            this.query.groupBy = groupByBuilder.toString();
        }
        if (havingBuilder.length() > 0) {
            havingBuilder.delete(havingBuilder.length() - 5, havingBuilder.length());
            havingBuilder.insert(0, "having ");
            this.query.having = havingBuilder.toString();
        }
        if (orderByBuilder.length() > 0) {
            orderByBuilder.deleteCharAt(orderByBuilder.length() - 1);
            orderByBuilder.insert(0, "order by ");
            this.query.orderBy = orderByBuilder.toString();
        }
        for (AbstractCondition condition : this.query.unionList) {
            condition.execute();
        }
        this.hasExecute = true;
        AbstractResponse abstractResponse = null;
        switch (this.query.quickDAOConfig.databaseProvider.name()) {
            case "oracle": {
                abstractResponse = new OracleResponse(this.query);
                break;
            }
            default: {
                abstractResponse = new AbstractResponse(this.query.quickDAOConfig);
            }
        }
        abstractResponse.query = this.query;
        return abstractResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public AbstractCondition clone() {
        Query query = this.query.clone();
        ByteArrayInputStream bais = null;
        try {
            AbstractCondition abstractCondition;
            Throwable throwable;
            ByteArrayOutputStream baos;
            block25: {
                block26: {
                    baos = new ByteArrayOutputStream();
                    throwable = null;
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeObject(this);
                    oos.close();
                    bais = new ByteArrayInputStream(baos.toByteArray());
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    AbstractCondition abstractCondition2 = (AbstractCondition)ois.readObject();
                    abstractCondition2.query = query;
                    for (int i = 0; i < query.subQueryList.size(); ++i) {
                        query.subQueryList.get((int)i).condition = abstractCondition2;
                    }
                    bais.close();
                    abstractCondition = abstractCondition2;
                    if (baos == null) break block25;
                    if (throwable == null) break block26;
                    try {
                        baos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block25;
                }
                baos.close();
            }
            return abstractCondition;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (baos != null) {
                            if (throwable != null) {
                                try {
                                    baos.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                baos.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (IOException | ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            if (null != bais) {
                try {
                    bais.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    public String toString() {
        return this.query.toString();
    }

    private void addInQuery(String field, Object[] values, String in) {
        if (null == values || values.length == 0) {
            this.whereList.add(new FieldFragmentEntry(IGNORE, "1 = 2"));
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(" {} " + in + " (");
        for (int i = 0; i < values.length; ++i) {
            builder.append("?,");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(")");
        this.whereList.add(new FieldFragmentEntry(field, builder.toString()));
        this.query.parameterList.addAll(Arrays.asList(values));
    }

    private void addExistSubQuery(Condition subQuery, String exist) {
        AbstractCondition abstractCondition = (AbstractCondition)subQuery;
        if (null == abstractCondition.query.tableAliasName) {
            subQuery.tableAliasName("t" + this.query.joinTableIndex++);
        }
        subQuery.execute();
        this.whereList.add(new FieldFragmentEntry(IGNORE, exist + " (" + new GetResponseArrayDatabaseStatement(abstractCondition.query).getStatement() + ")"));
        this.query.parameterList.addAll(abstractCondition.query.parameterList);
    }

    private String getSQLFragment(List<String> fields, Entity entity, String tableAliasName) {
        this.builder.setLength(0);
        for (String field : fields) {
            Property property = entity.getPropertyByFieldName(field);
            if (null == property) {
                this.builder.append(field);
            } else {
                if (!this.query.unionList.isEmpty()) {
                    this.builder.append(this.query.quickDAOConfig.databaseProvider.escape(property.column));
                } else {
                    this.builder.append(tableAliasName + "." + this.query.quickDAOConfig.databaseProvider.escape(property.column));
                }
                if (field.contains(" ")) {
                    this.builder.append(field.substring(field.indexOf(" ")));
                }
            }
            this.builder.append(",");
        }
        return this.builder.toString();
    }

    private String getSQLFragment(List<FieldFragmentEntry> fragmentEntryList, Entity entity, String tableAliasName, String separator) {
        this.builder.setLength(0);
        for (FieldFragmentEntry fieldFragmentEntry : fragmentEntryList) {
            if (IGNORE.equals(fieldFragmentEntry.field)) {
                this.builder.append("( " + fieldFragmentEntry.fragment + " ) " + separator);
                continue;
            }
            if (OR.equals(fieldFragmentEntry.field)) {
                if (this.builder.length() > 3 && this.builder.charAt(this.builder.length() - 2) == 'd') {
                    this.builder.delete(this.builder.length() - 5, this.builder.length());
                    this.builder.append(" or ");
                }
                this.builder.append("( " + fieldFragmentEntry.fragment + " ) or ");
                continue;
            }
            Property property = entity.getPropertyByFieldName(fieldFragmentEntry.field);
            if (null == property) {
                this.builder.append(fieldFragmentEntry.fragment.replace("{}", fieldFragmentEntry.field));
            } else if (!this.query.unionList.isEmpty()) {
                this.builder.append(fieldFragmentEntry.fragment.replace("{}", this.query.quickDAOConfig.databaseProvider.escape(property.column)));
            } else {
                this.builder.append(fieldFragmentEntry.fragment.replace("{}", tableAliasName + "." + this.query.quickDAOConfig.databaseProvider.escape(property.column)));
            }
            this.builder.append(separator);
        }
        return this.builder.toString();
    }

    private void checkOrCondition() {
        if ("t_or".equals(this.query.tableAliasName)) {
            throw new IllegalArgumentException("or\u67e5\u8be2\u6761\u4ef6\u4e0d\u5141\u8bb8\u8fdb\u884cjoinTable\u64cd\u4f5c!");
        }
    }

    private void handleExcludeColumnList(List excludeColumnList, List<Property> propertyList, List<String> columnList) {
        if (!excludeColumnList.isEmpty()) {
            for (Property property : propertyList) {
                if (excludeColumnList.contains(property.name) || excludeColumnList.contains(property.column)) continue;
                if (null == property.name || property.name.isEmpty() || !property.column.contains("_")) {
                    columnList.add(property.column);
                    continue;
                }
                columnList.add(property.column + " " + property.name);
            }
        }
    }
}

