/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao.dql.response;

import cn.schoolwow.quickdao.dao.dql.response.Response;
import cn.schoolwow.quickdao.dao.sql.AbstractDatabaseDAO;
import cn.schoolwow.quickdao.domain.external.PageVo;
import cn.schoolwow.quickdao.domain.external.PagingHandler;
import cn.schoolwow.quickdao.domain.external.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.internal.Query;
import cn.schoolwow.quickdao.statement.dql.response.GetResponseArrayDatabaseStatement;
import cn.schoolwow.quickdao.statement.dql.response.ResponseCountDatabaseStatement;
import cn.schoolwow.quickdao.statement.dql.response.ResponseDeleteDatabaseStatement;
import cn.schoolwow.quickdao.statement.dql.response.ResponseUpdateDatabaseStatement;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractResponse<T>
extends AbstractDatabaseDAO
implements Response<T> {
    private Logger logger = LoggerFactory.getLogger(AbstractResponse.class);
    public Query query;

    public AbstractResponse(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
    }

    @Override
    public long count() {
        int count = new ResponseCountDatabaseStatement(this.query).getCount();
        return count;
    }

    @Override
    public int update() {
        int effect = new ResponseUpdateDatabaseStatement(this.query).executeUpdate();
        return effect;
    }

    @Override
    public int delete() {
        int effect = new ResponseDeleteDatabaseStatement(this.query).executeUpdate();
        return effect;
    }

    @Override
    public T getOne() {
        List list = this.getList();
        if (list == null || list.size() == 0) {
            return null;
        }
        return (T)list.get(0);
    }

    @Override
    public <E> E getOne(Class<E> clazz) {
        List<E> list = this.getList(clazz);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public <E> E getSingleColumn(Class<E> clazz) {
        List<E> list = this.getSingleColumnList(clazz);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public <E> List<E> getSingleColumnList(Class<E> clazz) {
        List<E> list = new GetResponseArrayDatabaseStatement(this.query).getSingleColumnList(clazz);
        return list;
    }

    @Override
    public List getList() {
        return this.getList(this.query.entity.clazz);
    }

    @Override
    public <E> List<E> getList(Class<E> clazz) {
        JSONArray array = this.getArray();
        return array.toJavaList(clazz);
    }

    @Override
    public PageVo<T> getPagingList() {
        return this.getPagingList(this.query.entity.clazz);
    }

    @Override
    public <E> PageVo<E> getPagingList(Class<E> clazz) {
        if (null == clazz) {
            clazz = JSONObject.class;
        }
        this.query.pageVo.setArray(this.getArray());
        this.query.pageVo.setList(this.query.pageVo.getArray().toJavaList(clazz));
        this.query.pageVo.setTotalSize(this.count());
        this.query.pageVo.setTotalPage((int)(this.query.pageVo.getTotalSize() / (long)this.query.pageVo.getPageSize() + (long)(this.query.pageVo.getTotalSize() % (long)this.query.pageVo.getPageSize() > 0L ? 1 : 0)));
        this.query.pageVo.setHasMore(this.query.pageVo.getCurrentPage() < this.query.pageVo.getTotalPage());
        return this.query.pageVo;
    }

    @Override
    public <E> PageVo<E> getSingleColumnPagingList(Class<E> clazz) {
        this.query.pageVo.setList(this.getSingleColumnList(clazz));
        this.query.pageVo.setTotalSize(this.count());
        this.query.pageVo.setTotalPage((int)(this.query.pageVo.getTotalSize() / (long)this.query.pageVo.getPageSize() + (long)(this.query.pageVo.getTotalSize() % (long)this.query.pageVo.getPageSize() > 0L ? 1 : 0)));
        this.query.pageVo.setHasMore(this.query.pageVo.getCurrentPage() < this.query.pageVo.getTotalPage());
        return this.query.pageVo;
    }

    @Override
    public JSONObject getObject() {
        JSONArray array = this.getArray();
        if (null == array || array.isEmpty()) {
            return null;
        }
        return array.getJSONObject(0);
    }

    @Override
    public JSONArray getArray() {
        JSONArray array = new GetResponseArrayDatabaseStatement(this.query).getArray();
        return array;
    }

    @Override
    public <K, V> Map<K, V> map(String key, String value, Class<K> keyClass, Class<V> valueClass) {
        JSONArray array = this.getArray();
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < array.size(); ++i) {
            Object valueObject;
            JSONObject o = array.getJSONObject(i);
            Object keyObject = o.getObject(key, keyClass);
            if (null == keyObject) {
                keyObject = o.getObject(this.query.entity.getColumnNameByFieldName(key), keyClass);
            }
            if (null == (valueObject = o.getObject(value, valueClass))) {
                valueObject = o.getObject(this.query.entity.getColumnNameByFieldName(value), valueClass);
            }
            map.put(keyObject, valueObject);
        }
        return map;
    }

    @Override
    public void paging(PagingHandler<T> pagingHandler) {
        if (null == this.query.pageVo) {
            throw new IllegalArgumentException("\u8bf7\u5148\u8c03\u7528page\u65b9\u6cd5\u6307\u5b9a\u9875\u7801\u548c\u6bcf\u9875\u4e2a\u6570!");
        }
        int currentPage = this.query.pageVo.getCurrentPage();
        this.query.limit = "limit " + (this.query.pageVo.getCurrentPage() - 1) * this.query.pageVo.getPageSize() + "," + this.query.pageVo.getPageSize();
        this.getPagingList();
        if (!pagingHandler.pagingHandle(this.query.pageVo)) {
            return;
        }
        int totalPage = this.query.pageVo.getTotalPage();
        for (int i = currentPage + 1; i <= totalPage; ++i) {
            this.query.pageVo.setCurrentPage(i);
            this.query.limit = "limit " + (this.query.pageVo.getCurrentPage() - 1) * this.query.pageVo.getPageSize() + "," + this.query.pageVo.getPageSize();
            this.getPagingList();
            if (pagingHandler.pagingHandle(this.query.pageVo)) continue;
            return;
        }
    }

    @Override
    public <E> void singleColumnPaging(Class<E> clazz, PagingHandler<E> pagingHandler) {
        if (null == this.query.pageVo) {
            throw new IllegalArgumentException("\u8bf7\u5148\u8c03\u7528page\u65b9\u6cd5\u6307\u5b9a\u9875\u7801\u548c\u6bcf\u9875\u4e2a\u6570!");
        }
        int currentPage = this.query.pageVo.getCurrentPage();
        this.query.limit = "limit " + (this.query.pageVo.getCurrentPage() - 1) * this.query.pageVo.getPageSize() + "," + this.query.pageVo.getPageSize();
        this.getSingleColumnPagingList(clazz);
        if (!pagingHandler.pagingHandle(this.query.pageVo)) {
            return;
        }
        int totalPage = this.query.pageVo.getTotalPage();
        for (int i = currentPage + 1; i <= totalPage; ++i) {
            this.query.pageVo.setCurrentPage(i);
            this.query.limit = "limit " + (this.query.pageVo.getCurrentPage() - 1) * this.query.pageVo.getPageSize() + "," + this.query.pageVo.getPageSize();
            this.getSingleColumnPagingList(clazz);
            if (pagingHandler.pagingHandle(this.query.pageVo)) continue;
            return;
        }
    }

    public String toString() {
        return this.query.toString();
    }
}

